/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.share.string;

import oracle.bali.xml.share.string.StringChange;

public final class StringChangeUtils {
    public static StringChange computeStringChange(String oldValue, String newValue) {
        int[] tmp = StringChangeUtils.getSameChars(oldValue, newValue);
        int startSameChars = tmp[0];
        int endSameChars = tmp[1];
        int oldLen = oldValue.length();
        int newLen = newValue.length();
        int endOldIdx = Math.max(oldLen - endSameChars, startSameChars);
        int endNewIdx = Math.max(newLen - endSameChars, startSameChars);
        int deletedCharCount = endOldIdx - startSameChars;
        int insertedCharCount = endNewIdx - startSameChars;
        String insertedChars = newValue.substring(startSameChars, startSameChars + insertedCharCount);
        return new StringChange(startSameChars, insertedChars, deletedCharCount);
    }

    public static int[] getSameChars(String one, String two) {
        int oneLen = one.length();
        int twoLen = two.length();
        int startChars = 0;
        while (startChars < oneLen && startChars < twoLen) {
            char t;
            char o = one.charAt(startChars);
            if (o != (t = two.charAt(startChars))) break;
            ++startChars;
        }
        int endChars = 0;
        while (endChars < oneLen && endChars < twoLen && oneLen - endChars > startChars && twoLen - endChars > startChars) {
            char t;
            char o = one.charAt(oneLen - endChars - 1);
            if (o != (t = two.charAt(twoLen - endChars - 1))) break;
            ++endChars;
        }
        return new int[]{startChars, endChars};
    }

    private StringChangeUtils() {
    }
}

