/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.util;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.Action;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.util.ContextualActionProvider;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ContextualActionProvider2
implements ContextualActionProvider {
    private static final Logger _LOGGER = Logger.getLogger(ContextualActionProvider2.class.getName());

    public static List<Action> invoke(ContextualActionProvider cap, XmlContext context, XmlKey ownerKey, Node ownerNode, XmlKey key, Node node) {
        Param param = Param.create(context, ownerNode, ownerKey, node, key);
        return ContextualActionProvider2.invoke(cap, param);
    }

    public static List<Action> invoke(ContextualActionProvider provider, Param param) {
        List<Action> ret;
        block7: {
            ret = null;
            if (provider != null) {
                try {
                    if (provider instanceof ContextualActionProvider2) {
                        ret = ((ContextualActionProvider2)provider).getContextualActions(param);
                    } else if (param.hasNode()) {
                        ret = provider.getContextualActions(param.getContext(), param.getKey(), param.getNode());
                    }
                }
                catch (Exception e) {
                    if (!_LOGGER.isLoggable(Level.WARNING)) break block7;
                    LogRecord lr = new LogRecord(Level.WARNING, "Exception calling contextual action provider {0} with param {1}");
                    lr.setParameters(new Object[]{provider, param});
                    lr.setThrown(e);
                    _LOGGER.log(lr);
                }
            }
        }
        if (ret == null) {
            ret = Collections.emptyList();
        }
        return ret;
    }

    public static List<Action> invokeAll(Iterable<ContextualActionProvider> providers, Param param) {
        LinkedList<Action> out = new LinkedList<Action>();
        for (ContextualActionProvider provider : providers) {
            out.addAll(ContextualActionProvider2.invoke(provider, param));
        }
        return out;
    }

    @Override
    public final List<Action> getContextualActions(XmlContext context, XmlKey key, Node node) {
        return this.getContextualActions(Param.createWithoutOwner(context, node, key));
    }

    public abstract List<? extends Action> getContextualActions(Param var1);

    public static final class Param {
        private final Node _ownerNode;
        private final XmlKey _ownerKey;
        private final Node _node;
        private final XmlKey _key;
        private final XmlContext _context;

        public static Param create(XmlContext context, Node ownerNode, XmlKey ownerKey, Node node, XmlKey key) {
            return new Param(context, ownerNode, ownerKey, node, key);
        }

        public static Param createWithoutOwner(XmlContext context, Node node, XmlKey key) {
            return new Param(context, null, null, node, key);
        }

        public static Param createWithoutNode(XmlContext context, Node ownerNode, XmlKey ownerKey, XmlKey key) {
            return new Param(context, ownerNode, ownerKey, null, key);
        }

        public static Param createWithoutNodes(XmlContext context, XmlKey ownerKey, XmlKey key) {
            return new Param(context, null, ownerKey, null, key);
        }

        private Param(XmlContext context, Node ownerNode, XmlKey ownerKey, Node node, XmlKey key) {
            this._context = context;
            this._ownerNode = ownerNode;
            this._ownerKey = ownerKey;
            this._node = node;
            this._key = key;
        }

        public Node getOwnerNode() {
            return this._ownerNode;
        }

        public XmlKey getOwnerKey() {
            return this._ownerKey;
        }

        public boolean hasNode() {
            return this._node != null;
        }

        public Node getNode() {
            return this._node;
        }

        public XmlKey getKey() {
            return this._key;
        }

        public XmlContext getContext() {
            return this._context;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("Param(");
            this._addToString(sb, true, "XmlContext", this._context);
            this._addToString(sb, false, "ownerKey", this._ownerKey);
            this._addToString(sb, false, "ownerNode", this._ownerNode);
            this._addToString(sb, false, "key", this._key);
            this._addToString(sb, false, "node", this._node);
            sb.append(")");
            return sb.toString();
        }

        private void _addToString(StringBuilder sb, boolean first, String name, Object o) {
            if (!first) {
                sb.append(", ");
            }
            sb.append(name);
            sb.append('=');
            sb.append(o);
        }
    }
}

