/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.util;

import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.position.DomRange;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.Selection;

public abstract class DomPositionMapper {
    private final AbstractModel _model;
    private final DomPosition _cursor;
    private final DomPosition _drop;
    private final DomRange _range;

    public DomPositionMapper(AbstractModel model) {
        this._model = model;
        Selection sel = this._model.getSelection();
        this._cursor = sel.getCursorLocation();
        this._drop = sel.getDropLocation();
        this._range = sel.getRangeSelection();
    }

    public void applyMappings() {
        Selection sel = this._model.getSelection();
        if (this._cursor != null) {
            sel.setCursorLocation(this.mapPosition(this._cursor));
        }
        if (this._drop != null) {
            sel.setDropLocation(this.mapPosition(this._drop));
        }
        if (this._range != null) {
            DomPosition startOld = this._range.getStart();
            DomPosition endOld = this._range.getEnd();
            DomPosition startNew = this.mapPosition(startOld);
            DomPosition endNew = this.mapPosition(endOld);
            if (startOld != startNew || endOld != endNew) {
                sel.setRangeSelection(sel.createDomRange(startNew, endNew));
            }
        }
    }

    protected abstract DomPosition mapPosition(DomPosition var1);

    protected final AbstractModel getModel() {
        return this._model;
    }
}

