/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.util;

import java.util.HashMap;
import java.util.Map;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.util.DefaultPrefixLookup;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.helpers.NamespaceSupport;

public class NamespaceUtils {
    private static final String _XML_NS = "xmlns";
    private static final String _XML_NS_COLON = "xmlns:";
    private static final String _XML_NAMESPACE = "http://www.w3.org/XML/1998/namespace";
    private static final String _XMLNS_NAMESPACE = "http://www.w3.org/2000/xmlns/";

    public static Map getPrefixesInScope(Node node) {
        HashMap map = new HashMap();
        NamespaceUtils._addPrefixesInScope(map, node);
        return map;
    }

    public static final void fixPrefixes(Node parent, Node subTree, DefaultPrefixLookup lookup) {
        NamespaceUtils.fixPrefixes(parent, subTree, lookup, true);
    }

    public static final void fixPrefixes(Node parent, Node subTree, DefaultPrefixLookup lookup, boolean declarePrefixesOnRoot) {
        Document ownerDoc;
        if (subTree == null) {
            throw new IllegalArgumentException("Node is null");
        }
        if (lookup == null) {
            throw new IllegalArgumentException("Prefix lookup is null");
        }
        if (subTree.getParentNode() == parent) {
            throw new IllegalArgumentException("subTree shouldn't already be in doc");
        }
        if (subTree.getNodeType() != 1 && subTree.getNodeType() != 2) {
            return;
        }
        if (subTree.getNodeType() == 2 && parent.getNodeType() != 1) {
            throw new IllegalArgumentException("can't add an attribute to a non-element parent");
        }
        NamespaceSupportAdapter ns = new NamespaceSupportAdapter(null);
        ns.pushContext();
        String defaultNamespace = null;
        Node current = parent;
        while (current != null) {
            NamedNodeMap attrs;
            if (current.getNodeType() == 1 && (attrs = current.getAttributes()) != null) {
                int i = 0;
                while (i < attrs.getLength()) {
                    Node attr = attrs.item(i);
                    String key = attr.getNodeName();
                    if (key.startsWith(_XML_NS_COLON) && !ns.containsURI(attr.getNodeValue()) && !ns.containsPrefix(key.substring(6))) {
                        String keyInsert = key.substring(6);
                        ns.declarePrefix(keyInsert, attr.getNodeValue());
                    } else if (_XML_NS.equals(key) && defaultNamespace == null) {
                        defaultNamespace = attr.getNodeValue();
                    }
                    ++i;
                }
            }
            current = current.getParentNode();
        }
        if (defaultNamespace != null) {
            ns.declarePrefix("", defaultNamespace);
        }
        if (parent != null && (ownerDoc = DomUtils.getOwnerDocument((Node)parent)) != null) {
            Element documentRoot = ownerDoc.getDocumentElement();
            if (documentRoot == null) {
                documentRoot = (Element)subTree;
            }
            Element elementForPrefixDeclarations = documentRoot;
            if (!declarePrefixesOnRoot) {
                elementForPrefixDeclarations = DomUtils.isElement((Node)subTree) ? (Element)subTree : (Element)parent;
            }
            NamespaceUtils._fixPrefixesRecursively(ns, parent, subTree, documentRoot, elementForPrefixDeclarations, lookup);
        }
    }

    private static final void _fixPrefixesRecursively(NamespaceSupportAdapter ns, Node parent, Node current, Element documentRoot, Element elementForPrefixDeclarations, DefaultPrefixLookup lookup) {
        NamedNodeMap attrs;
        boolean elemNode;
        String namespace = current.getNamespaceURI();
        String currentDefaultNamespace = ns.getURI("");
        ns.pushContext();
        if (current.getNodeType() == 2 && (_XMLNS_NAMESPACE.equals(namespace) || _XML_NAMESPACE.equals(namespace))) {
            return;
        }
        if (current.getPrefix() == null && namespace != null && !"".equals(namespace)) {
            ns.declarePrefix("", current.getNamespaceURI());
        }
        boolean bl = elemNode = current.getNodeType() == 1;
        if (namespace == null || currentDefaultNamespace == null || !namespace.equals(currentDefaultNamespace)) {
            String foundpfx = ns.getPrefix(namespace);
            String defpfx = namespace != null ? lookup.getDefaultPrefix(namespace) : null;
            String origPrefix = current.getPrefix();
            String newprefix = null;
            if (newprefix == null) {
                String foundConflictURI = ns.getURI(foundpfx);
                String origConflictURI = ns.getURI(origPrefix);
                String defConflictURI = ns.getURI(defpfx);
                if (foundpfx != null && (foundConflictURI == null || foundConflictURI.equals(namespace))) {
                    newprefix = foundpfx;
                } else if (origPrefix != null && (origConflictURI == null || origConflictURI.equals(namespace))) {
                    newprefix = origPrefix;
                } else if (defpfx != null && (defConflictURI == null || defConflictURI.equals(namespace))) {
                    newprefix = defpfx;
                }
            }
            boolean shouldAddPrefix = true;
            if (documentRoot == current) {
                shouldAddPrefix = false;
            }
            if (newprefix != null && shouldAddPrefix) {
                current.setPrefix(newprefix);
                if (elemNode) {
                    if (newprefix == origPrefix && ((Element)current).hasAttribute(_XML_NS + origPrefix)) {
                        ((Element)current).removeAttribute(_XML_NS_COLON + origPrefix);
                    } else if (((Element)current).hasAttribute(_XML_NS)) {
                        ((Element)current).removeAttribute(_XML_NS);
                    }
                }
                if (!newprefix.equals(foundpfx)) {
                    elementForPrefixDeclarations.setAttributeNS(_XMLNS_NAMESPACE, _XML_NS_COLON + newprefix, namespace);
                    ns.declarePrefix(newprefix, namespace);
                }
            } else if (elemNode) {
                String prefix = current.getPrefix();
                if (prefix != null) {
                    if (((Element)current).hasAttribute(_XML_NS_COLON + prefix)) {
                        ((Element)current).removeAttribute(_XML_NS_COLON + prefix);
                    }
                    current.setPrefix(null);
                }
                if (namespace != null || namespace == null && currentDefaultNamespace != null) {
                    String newNS = namespace == null ? "" : namespace;
                    ((Element)current).setAttributeNS(_XMLNS_NAMESPACE, _XML_NS, newNS);
                    ns.declarePrefix("", newNS);
                }
            }
        } else if (parent != null && namespace != null && namespace.equals(parent.getNamespaceURI())) {
            NamedNodeMap attrs2;
            String pPrefix;
            if (elemNode) {
                String origPrefix = current.getPrefix();
                if (origPrefix != null) {
                    if (((Element)current).hasAttribute(_XML_NS_COLON + origPrefix)) {
                        ((Element)current).removeAttribute(_XML_NS_COLON + origPrefix);
                    }
                    current.setPrefix(null);
                } else if (((Element)current).hasAttribute(_XML_NS)) {
                    ((Element)current).removeAttribute(_XML_NS);
                }
            }
            if ((pPrefix = parent.getPrefix()) != null) {
                current.setPrefix(pPrefix);
            }
            if (elemNode && (attrs2 = current.getAttributes()) != null) {
                int i = 0;
                while (i < attrs2.getLength()) {
                    Node a = attrs2.item(i);
                    String name = a.getNodeValue();
                    if (name.startsWith(_XML_NS_COLON) && name.equals(current.getNamespaceURI())) {
                        ((Element)current).removeAttributeNode((Attr)a);
                    }
                    ++i;
                }
            }
        } else {
            String oldPref = current.getPrefix();
            current.setPrefix(null);
            if (elemNode) {
                NamedNodeMap attrs3;
                if (((Element)current).hasAttribute(_XML_NS)) {
                    ((Element)current).removeAttribute(_XML_NS);
                }
                if (oldPref != null && (attrs3 = current.getAttributes()) != null) {
                    int i = 0;
                    while (i < attrs3.getLength()) {
                        Node a = attrs3.item(i);
                        String name = a.getNodeValue();
                        if (name.startsWith(_XML_NS) && name.equals(current.getNamespaceURI())) {
                            ((Element)current).removeAttributeNode((Attr)a);
                        }
                        ++i;
                    }
                }
            }
        }
        if (current.getNodeType() == 1 && (attrs = current.getAttributes()) != null) {
            int i = 0;
            while (i < attrs.getLength()) {
                Node a = attrs.item(i);
                String name = a.getNodeName();
                if (name.startsWith(_XML_NS_COLON)) {
                    String keyInsert = name.substring(6);
                    ns.declarePrefix(keyInsert, a.getNodeValue());
                } else if (_XML_NS.equals(name)) {
                    ns.declarePrefix("", a.getNodeValue());
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < attrs.getLength()) {
                int index;
                Node a = attrs.item(i2);
                String name = a.getNodeName();
                if (!(name.startsWith(_XML_NS_COLON) || _XML_NAMESPACE.equals(a.getNamespaceURI()) || _XMLNS_NAMESPACE.equals(a.getNamespaceURI()) || (index = name.indexOf(58)) == -1)) {
                    String ans = a.getNamespaceURI();
                    if (ans != null) {
                        String apfx = name.substring(0, index);
                        if (ns.containsURI(ans)) {
                            a.setPrefix(ns.getPrefix(ans));
                        } else {
                            Element attrParent = ((Attr)a).getOwnerElement();
                            attrParent.setAttributeNS(_XMLNS_NAMESPACE, _XML_NS_COLON + apfx, ans);
                            ns.declarePrefix(apfx, ans);
                        }
                    } else {
                        a.setPrefix(null);
                    }
                }
                ++i2;
            }
        }
        Node child = current.getFirstChild();
        while (child != null) {
            NamespaceUtils._fixPrefixesRecursively(ns, current, child, documentRoot, elementForPrefixDeclarations, lookup);
            child = child.getNextSibling();
        }
        ns.popContext();
    }

    private static void _addPrefixesInScope(Map map, Node node) {
        NamedNodeMap attrs;
        if (node == null) {
            return;
        }
        NamespaceUtils._addPrefixesInScope(map, node.getParentNode());
        if (DomUtils.isElement((Node)node) && (attrs = node.getAttributes()) != null) {
            int i = 0;
            while (i < attrs.getLength()) {
                Attr attr = (Attr)attrs.item(i);
                String qname = attr.getNodeName();
                if (qname != null) {
                    if (_XML_NS.equals(qname)) {
                        map.put("", attr.getValue());
                    } else if (qname.startsWith(_XML_NS_COLON)) {
                        String prefixName = DomUtils.getLocalName((Node)attr);
                        map.put(prefixName, attr.getValue());
                    }
                }
                ++i;
            }
        }
    }

    private static class NamespaceSupportAdapter
    extends NamespaceSupport {
        public String getPrefix(String uri) {
            if (uri == null) {
                return null;
            }
            return super.getPrefix(uri);
        }

        public String getURI(String pfx) {
            if (pfx == null) {
                return null;
            }
            return super.getURI(pfx);
        }

        public boolean containsPrefix(String pfx) {
            return this.getURI(pfx) != null;
        }

        public boolean containsURI(String uri) {
            return this.getPrefix(uri) != null;
        }

        private NamespaceSupportAdapter() {
        }

        NamespaceSupportAdapter(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }
}

