/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.util;

import java.awt.event.ActionEvent;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.position.DomPositionFactory;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.task.FixedNameTransactionTask;
import oracle.bali.xml.share.FastMessageFormat;
import org.w3c.dom.Node;

public class XmlCreationAction
extends AbstractAction {
    private static final String _CREATE_COMMAND = "create";
    private boolean _iconInitialized;
    private List _xmlKeys;
    private DomPosition _position;
    private AbstractModel _model;
    private static final Logger _LOGGER = Logger.getLogger(XmlCreationAction.class.getName());

    public XmlCreationAction(AbstractModel model, DomPosition position, XmlKey key) {
        this.$init$();
        this._init(model, position, Collections.singletonList(key));
    }

    public XmlCreationAction(AbstractModel model, DomPosition position, List xmlKeyList) {
        this.$init$();
        this._init(model, position, Collections.unmodifiableList(xmlKeyList));
    }

    public static List createActions(AbstractModel model, List creatableKeyLists, DomPosition position) {
        ArrayList<XmlCreationAction> actions = new ArrayList<XmlCreationAction>(creatableKeyLists.size());
        for (List childKeyList : creatableKeyLists) {
            actions.add(new XmlCreationAction(model, position, childKeyList));
        }
        return actions;
    }

    public static Collection createLazyActionCollectionFromKeyCollection(AbstractModel model, DomPosition position, Collection keyCollection) {
        return new 1(keyCollection, model, position);
    }

    public void actionPerformed(ActionEvent event) {
        if (this.getLastXmlKey() != null) {
            List xmlKeys = this.getXmlKeys();
            int keyCount = xmlKeys.size();
            String transDescFormat = this._model.getTranslatedString("INSERT_DESCRIPTION_FORMAT");
            String transDescription = FastMessageFormat.formatMessage(transDescFormat, this.getValue("Name").toString());
            new 2(this, transDescription, xmlKeys, keyCount).run(this._model);
        } else {
            _LOGGER.log(Level.WARNING, "Can't create element because no XmlKey for {0}", this);
        }
    }

    public List getXmlKeys() {
        return this._xmlKeys;
    }

    public XmlKey getLastXmlKey() {
        List xmlKeys = this.getXmlKeys();
        int size = xmlKeys.size();
        if (size == 0) {
            return null;
        }
        return (XmlKey)xmlKeys.get(size - 1);
    }

    public Object getValue(String key) {
        Object value = super.getValue(key);
        if ("SmallIcon".equals(key) && !this._iconInitialized) {
            value = this._createIcon();
            this._iconInitialized = true;
        }
        return value;
    }

    public String toString() {
        return (String)this.getValue("Name");
    }

    private Icon _createIcon() {
        XmlKey lastXmlKey = this.getLastXmlKey();
        if (lastXmlKey != null) {
            Icon smallIcon = this._model.getXmlMetadataResolver().getSmallIcon(lastXmlKey);
            if (smallIcon != null) {
                this.putValue("SmallIcon", smallIcon);
            }
            return smallIcon;
        }
        return null;
    }

    private void _init(AbstractModel model, DomPosition position, List xmlKeyList) {
        this.putValue("ActionCommandKey", _CREATE_COMMAND);
        this._model = model;
        this._position = position;
        this._xmlKeys = xmlKeyList;
        XmlKey lastKey = this.getLastXmlKey();
        this.setEnabled(lastKey != null);
        String name = model.getXmlMetadataResolver().getShortDisplayName(lastKey);
        this.putValue("Name", name);
        char mnemonic = Character.toUpperCase(name.charAt(0));
        this.putValue("MnemonicKey", new Integer(mnemonic));
    }

    private void $init$() {
        this._iconInitialized = false;
    }

    static DomPosition ra$_position(XmlCreationAction xmlCreationAction) {
        return xmlCreationAction._position;
    }

    static AbstractModel ra$_model(XmlCreationAction xmlCreationAction) {
        return xmlCreationAction._model;
    }

    static final class 1
    extends AbstractCollection {
        private final /* synthetic */ Collection v$keyCollection;
        private final /* synthetic */ AbstractModel v$model;
        private final /* synthetic */ DomPosition v$position;

        public int size() {
            return this.v$keyCollection.size();
        }

        public Iterator iterator() {
            return new Itor();
        }

        public 1(Collection collection, AbstractModel abstractModel, DomPosition domPosition) {
            this.v$position = domPosition;
            this.v$model = abstractModel;
            this.v$keyCollection = collection;
        }

        static Collection ra$v$keyCollection(1 var0) {
            return var0.v$keyCollection;
        }

        static AbstractModel ra$v$model(1 var0) {
            return var0.v$model;
        }

        static DomPosition ra$v$position(1 var0) {
            return var0.v$position;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class Itor
        implements Iterator {
            private final Iterator _realItor;

            @Override
            public boolean hasNext() {
                return this._realItor.hasNext();
            }

            public Object next() {
                XmlKey key = (XmlKey)this._realItor.next();
                return new XmlCreationAction(1.ra$v$model(1.this), 1.ra$v$position(1.this), key);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private void $init$() {
                this._realItor = 1.ra$v$keyCollection(1.this).iterator();
            }

            Itor() {
                this.$init$();
            }
        }
    }

    final class 2
    extends FixedNameTransactionTask {
        private final /* synthetic */ List v$xmlKeys;
        private final /* synthetic */ int v$keyCount;
        final /* synthetic */ XmlCreationAction this$0;

        protected void performTask(AbstractModel model) throws XmlCommitException {
            DomPosition position = XmlCreationAction.ra$_position(this.this$0);
            int i = 0;
            while (true) {
                XmlKey currKey = (XmlKey)this.v$xmlKeys.get(i);
                Node createdNode = XmlCreationAction.ra$_model(this.this$0).insertXmlKey(currKey, position);
                if (++i >= this.v$keyCount) break;
                if (createdNode == null) continue;
                position = DomPositionFactory.createInsideOrAfterPosition((Node)createdNode);
            }
        }

        public 2(XmlCreationAction xmlCreationAction, String string, List list, int n) {
            this.v$keyCount = n;
            this.v$xmlKeys = list;
            this.this$0 = xmlCreationAction;
            super(string);
        }
    }
}

