/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.util;

import java.text.Collator;
import java.util.Comparator;
import oracle.bali.xml.metadata.XmlKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlKeyComparator
implements Comparator {
    private Collator _collator;

    public XmlKeyComparator() {
        this(null);
    }

    public XmlKeyComparator(Collator c) {
        if (c == null) {
            c = Collator.getInstance();
        }
        this._collator = c;
    }

    public int compare(Object o1, Object o2) {
        if (o1 instanceof XmlKey && o2 instanceof XmlKey) {
            XmlKey k1 = (XmlKey)o1;
            XmlKey k2 = (XmlKey)o2;
            if (k1.getNodeType() == k2.getNodeType()) {
                String ns2;
                String ns1 = k1.getNamespace();
                if (ns1 == (ns2 = k2.getNamespace())) {
                    return this._collator.compare(k1.getLocalName(), k2.getLocalName());
                }
                if (ns1 != null && ns2 != null) {
                    int nsCompare = this._collator.compare(ns1, ns2);
                    if (nsCompare == 0) {
                        return this._collator.compare(k1.getLocalName(), k2.getLocalName());
                    }
                    return nsCompare;
                }
                if (ns1 != null) {
                    return 1;
                }
                return -1;
            }
            return k1.getNodeType() - k2.getNodeType();
        }
        if (o1 instanceof XmlKey) {
            return -1;
        }
        return 1;
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof XmlKeyComparator;
    }
}

