/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.validator;

import java.util.Map;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.validator.CachingValidatorCallback;
import oracle.bali.xml.validator.ValidationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class BaseValidatorCallback
extends CachingValidatorCallback {
    private XmlContext _context;

    public Map getCacheForThread() {
        return this.getCache();
    }

    public Map getCache() {
        Map cache = null;
        XmlContext context = this.getContext();
        if (context != null) {
            XmlModel model = context.getModel();
            model.acquireReadLock();
            try {
                Document document = context.getModel().getDocument();
                if (document != null) {
                    cache = BaseValidatorCallback.getCache((Document)document);
                }
            }
            finally {
                model.releaseReadLock();
            }
        }
        return cache;
    }

    protected final void warning(ErrorHandler eh, int type, String message, Node invalidNode) {
        try {
            eh.warning((SAXParseException)((Object)new ValidationException(type, message, invalidNode)));
        }
        catch (SAXException saxe) {
            // empty catch block
        }
    }

    protected final void warning(ErrorHandler eh, int type, String message, Node invalidNode, Object relatedObject) {
        try {
            ValidationException exception = new ValidationException(type, message, invalidNode);
            exception.setRelatedObject(relatedObject);
            eh.warning((SAXParseException)((Object)exception));
        }
        catch (SAXException saxe) {
            // empty catch block
        }
    }

    protected final void error(ErrorHandler eh, int type, String message, Node invalidNode) {
        try {
            eh.error((SAXParseException)((Object)new ValidationException(type, message, invalidNode)));
        }
        catch (SAXException saxe) {
            // empty catch block
        }
    }

    protected XmlContext getContext() {
        return this._context;
    }

    public void __ensureContextIsAttached(XmlContext context) {
        if (this._context == null) {
            this._context = context;
        }
    }
}

