/*
 * Decompiled with CFR 0.152.
 */
package oracle.xquery;

import java.io.FileReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.xml.scalable.PageManagerPool;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xqxp.functions.OXMLFunctionLibrary;
import oracle.xml.xqxp.functions.OXMLFunctionNSResolver;
import oracle.xml.xqxp.functions.OXMLFunctionNSResolverFactory;
import oracle.xml.xqxp.functions.builtIns.FNFunctionLibrary;
import oracle.xml.xqxp.functions.builtIns.XDTFunctionLibrary;
import oracle.xml.xqxp.functions.builtIns.XSFunctionLibrary;
import oracle.xquery.Configuration;
import oracle.xquery.PreparedXQuery;
import oracle.xquery.XDBPreparedXQuery;
import oracle.xquery.XMLDataSource;
import oracle.xquery.XQException;
import oracle.xquery.XQMesg;
import oracle.xquery.XQueryContextHandler;
import oracle.xquery.comp.DefaultURIResolver;
import oracle.xquery.comp.LibraryModule;
import oracle.xquery.exec.XQueryUtils;
import oracle.xquery.func.OraFunctionLibrary;
import oracle.xquery.parser.XPath;
import oracle.xquery.parser.XQXGen;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class XQueryContext {
    private Hashtable conntable = new Hashtable(5);
    private Hashtable dstable = new Hashtable(10);
    XQMesg msg = null;
    private Vector resolvers = new Vector();
    private PageManagerPool pgmPool = null;
    private XQueryContextHandler ctxHandler;
    private Hashtable modulesTable = new Hashtable(5);
    private EntityResolver moduleResolver;

    public XQueryContext() {
        this.msg = XQMesg.newInstance(null);
        this.init();
    }

    public XQueryContext(XQMesg xQMesg) {
        this.msg = xQMesg;
        this.init();
    }

    public XQueryContext(Connection connection) {
        this.setConnectionDesc("default-oracle-connection", connection);
        this.msg = XQMesg.newInstance(null);
        this.init();
    }

    private void init() {
        FNFunctionLibrary fNFunctionLibrary = FNFunctionLibrary.getInstance();
        XSFunctionLibrary xSFunctionLibrary = XSFunctionLibrary.getInstance();
        XDTFunctionLibrary xDTFunctionLibrary = XDTFunctionLibrary.getInstance();
        OraFunctionLibrary oraFunctionLibrary = OraFunctionLibrary.getInstance();
        this.registerLibrary((OXMLFunctionLibrary)fNFunctionLibrary);
        this.registerLibrary((OXMLFunctionLibrary)xSFunctionLibrary);
        this.registerLibrary((OXMLFunctionLibrary)xDTFunctionLibrary);
        this.registerLibrary(oraFunctionLibrary);
        this.initFnNSResolver();
        this.ctxHandler = new XQueryContextHandler();
    }

    private void initFnNSResolver() {
        String string = System.getProperty("oracle.xquery.OXMLFunctionNSResolverFactories");
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ", ;:");
            while (stringTokenizer.hasMoreTokens()) {
                try {
                    String string2 = stringTokenizer.nextToken();
                    Object obj = Thread.currentThread().getContextClassLoader().loadClass(string2).newInstance();
                    this.resolvers.add(((OXMLFunctionNSResolverFactory)obj).getResolver());
                }
                catch (Exception exception) {
                    throw new XQException(this.msg.getMessage0("OXQ501"));
                }
            }
        }
    }

    public void setFunctionNSResolver(OXMLFunctionNSResolver oXMLFunctionNSResolver) {
        this.resolvers.add(oXMLFunctionNSResolver);
    }

    Vector getNSResolvers() {
        return this.resolvers;
    }

    public void setConnectionDesc(String string, Connection connection) {
        this.conntable.put(string, connection);
    }

    public void setDefaultConnection(Connection connection) {
        this.setConnectionDesc("default-oracle-connection", connection);
    }

    Hashtable getConnectionTable() {
        return this.conntable;
    }

    public void registerDatasource(String string, XMLDataSource xMLDataSource) {
        this.dstable.put(string, xMLDataSource);
    }

    Hashtable getDatasourceTable() {
        return this.dstable;
    }

    public void registerLibrary(OXMLFunctionLibrary oXMLFunctionLibrary) {
        String string = oXMLFunctionLibrary.getNamespace();
        this.dstable.put(string, oXMLFunctionLibrary);
    }

    public PreparedXQuery prepareXQuery(String string, Configuration configuration) throws XQException {
        if (configuration.isFlagSet(128)) {
            return new XDBPreparedXQuery(string, this, configuration);
        }
        return new PreparedXQuery(string, this, configuration, false);
    }

    public PreparedXQuery prepareXQuery(String string) throws XQException {
        return new PreparedXQuery(string, this, false);
    }

    public PreparedXQuery prepareXQuery(Reader reader, Configuration configuration) throws XQException {
        if (configuration.isFlagSet(128)) {
            return new XDBPreparedXQuery(reader, this, configuration);
        }
        return new PreparedXQuery(reader, this, configuration, false);
    }

    public PreparedXQuery prepareXQuery(Reader reader) throws XQException {
        return new PreparedXQuery(reader, this, false);
    }

    PreparedXQuery prepareXQuery(Reader reader, Configuration configuration, String string, String string2, String string3) throws XQException {
        PreparedXQuery preparedXQuery = new PreparedXQuery(reader, this, configuration, false);
        preparedXQuery.setNLSParameters(string, string2, string3);
        return preparedXQuery;
    }

    public PreparedXQuery prepareXQueryX(String string, Configuration configuration) throws XQException {
        return new PreparedXQuery(string, this, configuration, true);
    }

    public PreparedXQuery prepareXQueryX(String string) throws XQException {
        return new PreparedXQuery(string, this, true);
    }

    public PreparedXQuery prepareXQueryX(Reader reader, Configuration configuration) throws XQException {
        return new PreparedXQuery(reader, this, configuration, true);
    }

    public PreparedXQuery prepareXQueryX(Reader reader) throws XQException {
        return new PreparedXQuery(reader, this, true);
    }

    public void getXQueryXRepresentation(String string, ContentHandler contentHandler, boolean bl) throws XQException {
        try {
            if (bl) {
                XPath.newXQueryXGrammar = true;
            }
            XQXGen xQXGen = new XQXGen(contentHandler, this.getMesg());
            XPath.generateXQX(new StringReader(string), xQXGen);
            XPath.newXQueryXGrammar = false;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            throw new XQException(exception);
        }
    }

    public synchronized void setPageManagerPool(PageManagerPool pageManagerPool) {
        this.pgmPool = pageManagerPool;
    }

    public synchronized PageManagerPool getPageManagerPool() {
        return this.pgmPool;
    }

    public XQueryContextHandler getHandler() {
        return this.ctxHandler;
    }

    public XQMesg getMesg() {
        return this.msg;
    }

    public void registerModule(String string) {
        EntityResolver entityResolver = this.getModuleResolver();
        if (entityResolver == null) {
            entityResolver = new DefaultURIResolver("XQST0059");
        }
        InputSource inputSource = null;
        try {
            inputSource = entityResolver.resolveEntity(null, string);
        }
        catch (XQException xQException) {
            throw xQException;
        }
        catch (Exception exception) {
            throw new XQException(this.msg.getMessage0("XQST0059"), exception);
        }
        Reader reader = inputSource.getCharacterStream();
        PreparedXQuery preparedXQuery = this.prepareXQuery(reader);
        LibraryModule libraryModule = preparedXQuery.prepareLibraryModule();
        libraryModule.setModuleId(string);
        this.addModuleToTable(libraryModule);
    }

    private synchronized void addModuleToTable(LibraryModule libraryModule) {
        String string = libraryModule.getTargetURI();
        if (this.modulesTable == null) {
            this.modulesTable = new Hashtable(5);
            this.modulesTable.put(string, libraryModule);
        } else {
            LibraryModule libraryModule2 = (LibraryModule)this.modulesTable.get(string);
            if (libraryModule2 != null) {
                libraryModule2.append(libraryModule);
            } else {
                this.modulesTable.put(string, libraryModule);
            }
        }
    }

    Hashtable getModulesTable() {
        return this.modulesTable;
    }

    public void setModuleResolver(EntityResolver entityResolver) {
        this.moduleResolver = entityResolver;
    }

    EntityResolver getModuleResolver() {
        return this.moduleResolver;
    }

    private static void printError(String string) {
        System.out.println(" Oracle's XQuery implementation  ");
        System.out.println(" ------------------------------- ");
        System.out.println(" XQuery-Error:" + string);
        System.out.println("  ");
        System.out.println(" Call with ");
        System.out.println(" java oracle.xquery.XQueryContext ");
        System.out.println("  [-xqfile <filename>]   -- the xquery file name ");
        System.out.println("  [-baseurl <url>]       -- base url to use for file ");
        System.out.println("  [-debug ]   -- print out debugging information ");
        System.exit(1);
    }

    public static void main(String[] stringArray) {
        int n = 0;
        boolean bl = false;
        String string = null;
        String string2 = null;
        Connection connection = null;
        String string3 = null;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        try {
            if (stringArray.length == 0) {
                XQueryContext.printError("Not enough arguments ");
            }
            while (n < stringArray.length) {
                if (stringArray[n].compareTo("-debug") == 0) {
                    bl = true;
                } else if (stringArray[n].compareTo("-plan") == 0) {
                    bl2 = true;
                } else if (stringArray[n].compareTo("-baseurl") == 0) {
                    if (n + 1 >= stringArray.length) {
                        XQueryContext.printError("baseurl missing");
                    }
                    string = stringArray[n + 1];
                    ++n;
                } else if (stringArray[n].compareTo("-xqfile") == 0) {
                    if (n + 1 >= stringArray.length) {
                        XQueryContext.printError("missing XQuery filename");
                    }
                    string2 = stringArray[n + 1];
                    ++n;
                } else if (stringArray[n].compareTo("-conn") == 0) {
                    if (n + 1 >= stringArray.length) {
                        XQueryContext.printError("missing Connection String filename");
                    }
                    string3 = stringArray[n + 1];
                    ++n;
                }
                ++n;
            }
            long l = 0L;
            long l2 = 0L;
            if (bl4) {
                l = System.currentTimeMillis();
            }
            if (string3 == null && bl3) {
                string3 = "jdbc:oracle:oci8:scott/tiger@";
                connection = XQueryUtils.getConnection(null, string3);
            }
            if (string2 == null) {
                XQueryContext.printError("Missing XQuery query file. Use -xqfile <xqfilename>");
            }
            FileReader fileReader = new FileReader(string2);
            XQueryContext xQueryContext = new XQueryContext(connection);
            if (bl) {
                System.out.println(" preparing query ");
            }
            PreparedXQuery preparedXQuery = xQueryContext.prepareXQuery(fileReader);
            if (bl) {
                System.out.println(" Executing Query ");
            }
            if (bl2) {
                preparedXQuery.printPlan();
            }
            OXMLSequence oXMLSequence = preparedXQuery.executeQuery(false);
            int n2 = 0;
            while (oXMLSequence.next()) {
                if (bl) {
                    System.out.println(" ---- Fetching Item[" + n2 + "] ---- ");
                }
                ++n2;
                XQueryUtils.printResult(oXMLSequence.getItem(), new PrintWriter(System.out), xQueryContext.msg);
            }
            if (bl4) {
                l2 = System.currentTimeMillis();
                System.out.println("Total time = " + (l2 - l) + "ms");
                System.out.println("");
            }
        }
        catch (Exception exception) {
            if (bl) {
                if (exception instanceof XQException) {
                    Exception exception2 = ((XQException)exception).getParentException();
                    if (exception2 != null) {
                        exception2.printStackTrace(System.out);
                    } else {
                        exception.printStackTrace(System.out);
                    }
                } else {
                    exception.printStackTrace(System.out);
                }
            }
            if (exception instanceof XQException) {
                throw (XQException)exception;
            }
            throw new XQException(exception);
        }
    }
}

