/*
 * Decompiled with CFR 0.152.
 */
package oracle.xquery.comp;

import java.io.Reader;
import java.net.URL;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Stack;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.xml.namespace.QName;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.schema.XSDBuilder;
import oracle.xml.parser.schema.XSDException;
import oracle.xml.parser.v2.XMLError;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.util.OraURIException;
import oracle.xml.util.QxName;
import oracle.xml.xqxp.datamodel.OXMLItem;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xqxp.datamodel.OXMLSequenceType;
import oracle.xml.xqxp.functions.OXMLFunction;
import oracle.xml.xqxp.functions.OXMLFunctionContext;
import oracle.xml.xqxp.functions.OXMLFunctionNSResolver;
import oracle.xml.xqxp.functions.builtIns.FNUtil;
import oracle.xquery.PreparedXQuery;
import oracle.xquery.XMLDataSource;
import oracle.xquery.XQException;
import oracle.xquery.XQMesg;
import oracle.xquery.comp.CompStack;
import oracle.xquery.comp.CompState;
import oracle.xquery.comp.DefaultURIResolver;
import oracle.xquery.comp.FnCallResolver;
import oracle.xquery.comp.ImportDecl;
import oracle.xquery.comp.LibraryModule;
import oracle.xquery.comp.ModuleHandler;
import oracle.xquery.comp.SymbolTable;
import oracle.xquery.exec.ArithOp;
import oracle.xquery.exec.BindExpr;
import oracle.xquery.exec.Case;
import oracle.xquery.exec.CircularityDetectionVisitor;
import oracle.xquery.exec.ConstantExpr;
import oracle.xquery.exec.Document;
import oracle.xquery.exec.Dot;
import oracle.xquery.exec.Exists;
import oracle.xquery.exec.Expr;
import oracle.xquery.exec.ExprSequence;
import oracle.xquery.exec.ExternalDataSrc;
import oracle.xquery.exec.FLWR;
import oracle.xquery.exec.FunctionCall;
import oracle.xquery.exec.GeneralComparison;
import oracle.xquery.exec.Identifier;
import oracle.xquery.exec.Join;
import oracle.xquery.exec.LetExpr;
import oracle.xquery.exec.LogicalOp;
import oracle.xquery.exec.NodeSource;
import oracle.xquery.exec.NodeTest;
import oracle.xquery.exec.OrderComparison;
import oracle.xquery.exec.PathStep;
import oracle.xquery.exec.Predicate;
import oracle.xquery.exec.PredicateSet;
import oracle.xquery.exec.PredicatedExpr;
import oracle.xquery.exec.QueryState;
import oracle.xquery.exec.RelOp;
import oracle.xquery.exec.SQLQuery;
import oracle.xquery.exec.Scan;
import oracle.xquery.exec.SeqOp;
import oracle.xquery.exec.ServerSchemaResolver;
import oracle.xquery.exec.SortNS;
import oracle.xquery.exec.TypeOp;
import oracle.xquery.exec.UnaryExpr;
import oracle.xquery.exec.Utils;
import oracle.xquery.exec.ValidateExpr;
import oracle.xquery.exec.VarExpr;
import oracle.xquery.exec.Variable;
import oracle.xquery.exec.XMLCons;
import oracle.xquery.exec.XMLElem;
import oracle.xquery.exec.XQRangeExpr;
import oracle.xquery.exec.XQueryConstants;
import oracle.xquery.exec.XQueryUtils;
import oracle.xquery.exec.XpathExpr;
import oracle.xquery.func.FunctionDefn;
import oracle.xquery.func.FunctionId;
import oracle.xquery.func.OXMLFunctionLibrary;
import oracle.xquery.parser.XPath;
import oracle.xquery.parser.XQXGen;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public final class SAXComp
extends DefaultHandler
implements XQueryConstants {
    private SymbolTable sym;
    private CompStack stk;
    private Expr retExpr = null;
    public boolean debug = false;
    private int lastdebugnode = 0;
    private int indent = 0;
    private int compIdenAsConstExpr = 0;
    private int compFuncAsConstExpr = 0;
    private HashMap bindHash = new HashMap(5);
    private ArrayList externalVarNameList = new ArrayList(5);
    private Connection conn = null;
    private XQMesg msg = null;
    private boolean prolog_exists = false;
    private QueryState qs;
    private CompState compState;
    private int prologFlag = 0;
    private static int xmlspaceDecl = 1;
    private static int copyNamespacesDecl = 2;
    private static int orderingDecl = 4;
    private static int constructDecl = 8;
    private static int defaultFuncNSDecl = 16;
    private int compilingFlag = 0;
    private static int compilingPragma = 1;
    private static int compilingSequenceType = 2;
    private static int compilingOption = 4;
    private int compilingComputedEC = 0;
    private HashMap targetNSMap;
    private HashMap importedModulesMap;
    private boolean emptyOrderGreatest = true;
    private boolean emptyOrderSet = false;
    private HashMap oraViewMap;
    private Stack elemDefNSStack = new Stack();
    private Stack elemNSStack = new Stack();
    private LibraryModule libModule;
    private LinkedList fcrList;
    private static Object NO_SCHEMA = new Object();

    private void initialize() {
        this.sym = new SymbolTable();
        this.stk = new CompStack();
    }

    public SAXComp(CompState compState, QueryState queryState) {
        this.initialize();
        this.compState = compState;
        this.conn = compState.getDefaultConnection();
        this.qs = queryState;
        this.msg = this.qs.getMesg();
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) {
        if (this.compState.xqxOut != null && XPath.newXQueryXGrammar) {
            int n;
            boolean bl = false;
            if (this.lastdebugnode == 1) {
                this.compState.xqxOut.println(">");
            }
            this.lastdebugnode = 1;
            for (n = 0; n < this.indent; ++n) {
                this.compState.xqxOut.print(" ");
            }
            ++this.indent;
            ++this.indent;
            this.compState.xqxOut.print("<" + string3);
            if (attributes != null) {
                for (n = 0; n < attributes.getLength(); ++n) {
                    this.compState.xqxOut.print(" " + attributes.getQName(n) + "=\"" + attributes.getValue(n) + "\"");
                }
            }
            return;
        }
        if (this.compState.xqxOut != null) {
            int n;
            boolean bl = false;
            if (this.lastdebugnode == 1) {
                this.compState.xqxOut.println("");
            }
            this.lastdebugnode = 1;
            for (n = 0; n < this.indent; ++n) {
                this.compState.xqxOut.print(" ");
            }
            ++this.indent;
            ++this.indent;
            this.compState.xqxOut.print("<" + string3);
            if (attributes != null) {
                for (n = 0; n < attributes.getLength(); ++n) {
                    this.compState.xqxOut.print(" " + attributes.getQName(n) + "=\"" + attributes.getValue(n) + "\"");
                }
            }
            this.compState.xqxOut.print(">");
            return;
        }
        String string4 = string2.intern();
        if (string4 == "elementConstructor") {
            this.stk.openNodeScope();
            this.elemNSStack.push(new Boolean("false"));
            this.elemDefNSStack.push(new Boolean("false"));
        } else if (string4 == "flwr") {
            this.stk.openNodeScope();
            this.sym.BeginScope();
        } else if (string4 == "ifThenElseExpr") {
            this.stk.openNodeScope();
        } else if (string4 == "variableInExpr") {
            this.stk.openNodeScope();
            this.stk.pushNode(XQXGen.getAttrValue(attributes, "variable").intern());
            String string5 = XQXGen.getAttrValue(attributes, "positionalVar");
            if (string5 != null && string5.length() > 0) {
                this.stk.pushNode(string5.intern());
            }
        } else if (string4 == "xpathStep") {
            this.stk.openNodeScope();
            this.stk.pushNode(XQXGen.getAttrValue(attributes, "step").intern());
        } else if (string4 == "nameWithAxis") {
            this.stk.openNodeScope();
        } else if (string4 == "function") {
            this.stk.openNodeScope();
            this.stk.pushNode(XQXGen.getAttrValue(attributes, "name").intern());
        } else if (string4 == "functionCall") {
            this.stk.openNodeScope();
            this.stk.pushNode(XQXGen.getAttrValue(attributes, "name").intern());
        } else if (string4 == "orderBy") {
            this.stk.openNodeScope();
        } else if (string4 == "predicatedExpr") {
            this.stk.openNodeScope();
            ++this.compIdenAsConstExpr;
            ++this.compFuncAsConstExpr;
        } else if (string4 == "letAssignment") {
            this.stk.pushNode(XQXGen.getAttrValue(attributes, "variable").intern());
        } else if (string4 == "constant") {
            this.stk.pushNode(XQXGen.getAttrValue(attributes, "datatype").intern());
        } else if (string4 == "xmlspaceDecl") {
            if (this.isPrologFlagSet(xmlspaceDecl)) {
                throw new XQException(this.qs.getMesg().getMessage0("XQST0068"));
            }
            this.setPrologFlag(xmlspaceDecl);
            String string6 = XQXGen.getAttrValue(attributes, "value").intern();
            if (string6 == "true") {
                this.qs.setWhiteSpacePreserve(true);
            }
        } else if (string4 == "copyNamespacesDecl") {
            if (this.isPrologFlagSet(copyNamespacesDecl)) {
                throw new XQException(this.qs.getMesg().getMessage0("XQST0055"));
            }
            this.setPrologFlag(copyNamespacesDecl);
            String string7 = XQXGen.getAttrValue(attributes, "value").intern();
            if (string7.startsWith("nopreserve") || string7.endsWith("noinherit")) {
                throw new XQException(this.qs.getMesg().getMessage0("XQE-0252"));
            }
        } else if (string4 == "nodeDecl") {
            String string8 = XQXGen.getAttrValue(attributes, "value").intern();
            if (string8 == "byvalue") {
                this.qs.setNodeByValue(true);
            } else {
                this.qs.setNodeByValue(false);
            }
        } else if (string4 == "orderingDecl") {
            if (this.isPrologFlagSet(orderingDecl)) {
                throw new XQException(this.msg.getMessage0("XQST0065"));
            }
            this.setPrologFlag(orderingDecl);
            String string9 = XQXGen.getAttrValue(attributes, "value").intern();
            if (string9 == "unordered") {
                this.qs.setIgnoreOrdering(true);
            } else {
                this.qs.setIgnoreOrdering(false);
            }
        } else if (string4 == "emptyOrderingDecl") {
            if (this.emptyOrderSet) {
                throw new XQException(this.msg.getMessage0("XQST0069"));
            }
            this.emptyOrderSet = true;
            String string10 = XQXGen.getAttrValue(attributes, "value").intern();
            if (string10 == "least") {
                this.emptyOrderGreatest = false;
            }
        } else if (string4 == "namespaceDecl") {
            String string11 = XQXGen.getAttrValue(attributes, "defaultElemNS");
            String string12 = XQXGen.getAttrValue(attributes, "defaultFuncNS");
            String string13 = XQXGen.getAttrValue(attributes, "value");
            if (string13 == null || string13.length() == 0) {
                string13 = null;
            }
            if (!XQueryUtils.validateURI(string13)) {
                throw new XQException(this.qs.getMesg().getMessage0("XQST0046"));
            }
            if (string11 == "true") {
                if (!this.qs.emptyDefaultElemNS()) {
                    throw new XQException(this.msg.getMessage0("XQST0066"));
                }
                if (string13 != null) {
                    this.qs.pushDefaultElemNS(string13);
                }
            } else if (string12 == "true") {
                if (this.isPrologFlagSet(defaultFuncNSDecl)) {
                    throw new XQException(this.msg.getMessage0("XQST0066"));
                }
                this.qs.setDefaultFuncNS(string13);
                this.setPrologFlag(defaultFuncNSDecl);
            } else {
                String string14 = XQXGen.getAttrValue(attributes, "prefix");
                if (string14.equals("xml") || string14.equals("xmlns")) {
                    throw new XQException(this.qs.getMesg().getMessage0("XQST0070"));
                }
                if (this.qs.isPrefixBoundCurrentScope(string14)) {
                    throw new XQException(this.qs.getMesg().getMessage0("XQST0033"), this.qs.getMesg().getMessage1("XQE-0226", string14));
                }
                this.qs.addNamespace(string14, string13);
            }
        } else if (string4 == "attributeConstructor") {
            this.stk.openNodeScope();
        } else if (string4 == "functionDefinition") {
            this.compileFunctionDefnStart(attributes);
        } else if (string4 == "paramList") {
            this.stk.openNodeScope();
        } else if (string4 == "param") {
            this.stk.pushNode(XQXGen.getAttrValue(attributes, "paramName").intern());
        } else if (string4 == "exprlist") {
            this.stk.openNodeScope();
        } else if (string4 == "unaryExpr") {
            this.stk.openNodeScope();
        } else if (string4 == "xmlPI") {
            this.stk.pushNode(XQXGen.getAttrValue(attributes, "target").intern());
        } else if (string4 == "computedXmlComment") {
            this.stk.openNodeScope();
        } else if (string4 == "computedElement") {
            ++this.compilingComputedEC;
            this.stk.openNodeScope();
        } else if (string4 == "computedAttribute") {
            this.stk.openNodeScope();
        } else if (string4 == "computedText") {
            this.stk.openNodeScope();
        } else if (string4 == "computedDocument") {
            this.stk.openNodeScope();
        } else if (string4 == "computedXmlPI") {
            this.stk.openNodeScope();
        } else if (string4 == "quantifiedExpr") {
            this.stk.openNodeScope();
            this.sym.BeginScope();
            this.stk.pushNode(XQXGen.getAttrValue(attributes, "quantifier").intern());
        } else if (string4 == "prolog") {
            this.sym.BeginScope();
            this.prolog_exists = true;
        } else if (string4 == "sequenceType" || string4 == "singleType" || string4 == "typeDeclaration") {
            this.compiling(compilingSequenceType);
            this.stk.openNodeScope();
        } else if (string4 == "elementTest") {
            this.stk.openNodeScope();
        } else if (string4 == "attributeTest") {
            this.stk.openNodeScope();
        } else if (string4 == "schemaElementTest") {
            this.stk.openNodeScope();
        } else if (string4 == "schemaAttributeTest") {
            this.stk.openNodeScope();
        } else if (string4 == "documentTest") {
            this.stk.openNodeScope();
        } else if (string4 == "piTest") {
            this.stk.openNodeScope();
        } else if (string4 == "anyKindTest") {
            this.stk.openNodeScope();
        } else if (string4 == "commentTest") {
            this.stk.openNodeScope();
        } else if (string4 == "textTest") {
            this.stk.openNodeScope();
        } else if (string4 == "nillable") {
            this.stk.pushNode("nillable");
        } else if (string4 == "type") {
            this.stk.pushNode("type");
        } else if (string4 == "anyItemType") {
            this.stk.pushNode("item");
        } else if (string4 == "emptySequenceType") {
            this.stk.pushNode("empty");
        } else if (string4 == "typeswitchExpr") {
            this.stk.openNodeScope();
        } else if (string4 == "typeswitchExprCaseClause") {
            this.sym.BeginScope();
        } else if (string4 == "typeswitchExprDefaultClause") {
            this.sym.BeginScope();
        } else if (string4 == "typeswitchCaseVariable") {
            this.stk.openNodeScope();
        } else if (string4 == "typeswitchDefaultVariable") {
            this.stk.openNodeScope();
        } else if (string4 == "externalDefinition") {
            this.stk.pushNode("externalFunctionDefinition");
        } else if (string4 == "external") {
            this.stk.pushNode("external");
        } else if (string4 == "schemaImport") {
            this.stk.pushNode(new ImportDecl(ImportDecl.SCHEMA_IMPORT));
        } else if (string4 == "validateExpr") {
            if (System.getProperty("java.vm.name").equals("JServer VM")) {
                throw new XQException(this.msg.getMessage0("XQST0075"));
            }
            this.stk.openNodeScope();
        } else if (string4 == "moduleImport") {
            if (System.getProperty("java.vm.name").equals("JServer VM")) {
                throw new XQException(this.msg.getMessage0("XQST0016"));
            }
            this.stk.pushNode(new ImportDecl(ImportDecl.MODULE_IMPORT));
        } else if (string4 == "libraryModule") {
            if (System.getProperty("java.vm.name").equals("JServer VM")) {
                throw new XQException(this.msg.getMessage0("XQST0016"));
            }
            this.libModule = new LibraryModule();
        } else {
            if (string4 == "encoding") {
                throw new XQException(this.qs.getMesg().getMessage0("XQE-0239"));
            }
            if (string4 != "orderedExpr" && string4 != "unorderedExpr" && string4 != "predicate" && string4 != "default_collation" && string4 != "emptyOrder") {
                if (string4 == "constructionDecl") {
                    if (this.isPrologFlagSet(constructDecl)) {
                        throw new XQException(this.msg.getMessage0("XQST0067"));
                    }
                    this.setPrologFlag(constructDecl);
                } else if (string4 == "pragma") {
                    this.compiling(compilingPragma);
                    this.stk.openNodeScope();
                } else if (string4 == "extensionExpr") {
                    this.stk.openNodeScope();
                } else if (string4 != "schemaElementTest" && string4 != "schemaAttributeTest" && string4 != "module" && string4 == "optionDecl") {
                    this.compiling(compilingOption);
                }
            }
        }
    }

    public void characters(char[] cArray, int n, int n2) {
        if (this.compState.xqxOut != null && XPath.newXQueryXGrammar) {
            if (this.compState.xqxOut != null) {
                if (this.lastdebugnode == 1) {
                    this.compState.xqxOut.print(">");
                }
                this.lastdebugnode = 2;
                String string = XQueryUtils.convertString(cArray, n, n2, false);
                this.compState.xqxOut.print(string);
                return;
            }
        } else if (this.compState.xqxOut != null) {
            this.lastdebugnode = 2;
            String string = XQueryUtils.convertString(cArray, n, n2, true);
            this.compState.xqxOut.print(string);
            return;
        }
        if (this.debug) {
            System.out.println(" Pushing string. (" + new String(cArray, n, n2) + ")");
        }
        this.stk.pushNode(new String(cArray, n, n2));
    }

    public void endElement(String string, String string2, String string3) {
        if (this.compState.xqxOut != null && XPath.newXQueryXGrammar) {
            --this.indent;
            --this.indent;
            if (this.lastdebugnode == 3) {
                for (int i = 0; i < this.indent; ++i) {
                    this.compState.xqxOut.print(" ");
                }
            }
            if (this.lastdebugnode == 1) {
                this.compState.xqxOut.println("/>");
                this.lastdebugnode = 3;
                this.compState.xqxOut.flush();
            } else {
                this.compState.xqxOut.println("</" + string3 + ">");
                this.lastdebugnode = 3;
                this.compState.xqxOut.flush();
            }
            return;
        }
        if (this.compState.xqxOut != null) {
            --this.indent;
            --this.indent;
            if (this.lastdebugnode != 2) {
                this.compState.xqxOut.println("");
                for (int i = 0; i < this.indent; ++i) {
                    this.compState.xqxOut.print(" ");
                }
            }
            this.lastdebugnode = 3;
            this.compState.xqxOut.println("</" + string3 + ">");
            this.compState.xqxOut.flush();
            return;
        }
        String string4 = string2.intern();
        if (string4 == "elementConstructor") {
            this.compileElement();
        } else if (string4 == "exprlist") {
            this.compileExprlist();
        } else if (string4 == "attributeConstructor") {
            this.compileAttribute();
        } else if (string4 == "ifThenElseExpr") {
            this.compileIfThenElse();
        } else if (string4 == "variableInExpr") {
            this.compileVariableInExpr();
        } else if (string4 == "variable") {
            this.compileVar();
        } else if (string4 == "constant") {
            this.compileConst();
        } else if (string4 == "xpathStep") {
            this.compileXpathStep();
        } else if (string4 == "nameWithAxis") {
            this.compileNameWithAxis();
        } else if (string4 == "identifier") {
            this.compileIdentifier();
        } else if (string4 == "dot") {
            this.compileDot();
        } else if (string4 == "dotdot") {
            this.compileDotDot();
        } else if (string4 == "function") {
            this.compileFunction();
        } else if (string4 == "functionCall") {
            this.compileFunctionCall();
        } else if (string4 == "predicate") {
            this.compilePredicate();
        } else if (string4 == "predicatedExpr") {
            this.compilePredicateExpr();
        } else if (string4 == "flwr") {
            this.compileFLWR();
        } else if (string4 == "where") {
            this.compileWhere();
        } else if (string4 == "return") {
            this.compileReturn();
        } else if (string4 == "letAssignment") {
            this.compileLet();
        } else if (string4 == "query") {
            this.compileQuery();
        } else if (string4 == "orderBy") {
            this.compileOrderBy();
        } else if (string4 == "functionDefinition") {
            this.compileFunctionDefinition();
        } else if (string4 == "paramList") {
            this.compileFunctionParameterList();
        } else if (string4 == "param") {
            this.compileFunctionParameter();
        } else if (string4 == "unaryExpr") {
            this.compileUnaryExpr();
        } else if (string4 == "computedElement") {
            this.compileComputedCons(string4);
            --this.compilingComputedEC;
        } else if (string4 == "computedAttribute") {
            this.compileComputedCons(string4);
        } else if (string4 == "xmlComment") {
            this.compileXmlComment();
        } else if (string4 == "xmlCDataSection") {
            this.compileXmlCdataSection();
        } else if (string4 == "xmlPI") {
            this.compileXmlPI();
        } else if (string4 == "computedXmlComment") {
            this.compileComputedComment();
        } else if (string4 == "computedXmlPI") {
            this.compileComputedCons(string4);
        } else if (string4 == "computedText") {
            this.compileComputedText();
        } else if (string4 == "computedDocument") {
            this.compileComputedDocument();
        } else if (string4 == "quantifiedExpr") {
            this.compileQuantifiedExpr();
        } else if (string4 == "prolog_variable") {
            this.compilePrologVariable();
        } else if (string4 == "default_collation") {
            if (this.qs.getDefaultCollation() != null) {
                throw new XQException(this.msg.getMessage0("XQST0038"));
            }
            String string5 = (String)this.stk.popNode();
            try {
                FNUtil.checkCollation((String)string5);
            }
            catch (Exception exception) {
                try {
                    string5 = XQueryUtils.resolveURI(string5, this.qs.getBaseURI());
                    FNUtil.checkCollation((String)string5);
                }
                catch (oracle.xml.xqxp.XQException xQException) {
                    throw new XQException(this.msg.getMessage0("XQST0038"), this.msg.getMessage0(xQException.getErrorCode()));
                }
                catch (OraURIException oraURIException) {
                    throw new XQException(this.msg.getMessage0("XQST0038"), (Exception)((Object)oraURIException));
                }
            }
            this.qs.setDefaultCollation(string5);
        } else if (string4 == "base_uri") {
            if (this.qs.getBaseURI() != null) {
                throw new XQException(this.msg.getMessage0("XQST0032"));
            }
            String string6 = ((String)this.stk.popNode()).trim();
            if (!XQueryUtils.validateURI(string6)) {
                throw new XQException(this.msg.getMessage0("XQST0046"));
            }
            this.qs.setBaseURI(string6);
        } else if (string4 == "constructionDecl") {
            this.qs.setConstructionMode(XQueryUtils.getConstructionMode((String)this.stk.popNode()));
        } else if (string4 == "version") {
            this.xqueryVersionCheck();
        } else if (string4 == "sequenceType" || string4 == "singleType" || string4 == "typeDeclaration") {
            this.compileSequenceType();
        } else if (string4 == "elementTest") {
            this.compileNodeTest(1, false);
        } else if (string4 == "attributeTest") {
            this.compileNodeTest(2, false);
        } else if (string4 == "schemaElementTest") {
            this.compileNodeTest(1, true);
        } else if (string4 == "schemaAttributeTest") {
            this.compileNodeTest(2, true);
        } else if (string4 == "documentTest") {
            this.compileNodeTest(9, false);
        } else if (string4 == "piTest") {
            this.compileNodeTest(7, false);
        } else if (string4 == "anyKindTest") {
            this.compileNodeTest(0, false);
        } else if (string4 == "textTest") {
            this.compileNodeTest(3, false);
        } else if (string4 == "commentTest") {
            this.compileNodeTest(8, false);
        } else if (string4 == "schemaElementTest") {
            this.compileNodeTest(1, true);
        } else if (string4 == "schemaAttributeTest") {
            this.compileNodeTest(2, true);
        } else if (string4 == "QName" || string4 == "atomicType" || string4 == "piTarget" || string4 == "piValue") {
            this.compileQName();
        } else if (string4 == "instanceOfExpr") {
            this.compileTypeOperator((byte)1);
        } else if (string4 == "treatExpr") {
            this.compileTypeOperator((byte)4);
        } else if (string4 == "castableExpr") {
            this.compileTypeOperator((byte)3);
        } else if (string4 == "castExpr") {
            this.compileTypeOperator((byte)2);
        } else if (string4 == "typeswitchExpr") {
            this.compileTypeOperator((byte)5);
        } else if (string4 == "typeswitchExprCaseClause") {
            this.compileTypeswitchCaseClause();
        } else if (string4 == "typeswitchExprDefaultClause") {
            this.compileTypeswitchDefaultClause();
        } else if (string4 == "typeswitchCaseVariable") {
            this.compileTypeswitchCaseVariable();
        } else if (string4 == "typeswitchDefaultVariable") {
            this.compileTypeswitchDefaultVariable();
        } else if (string4 == "namespacePrefix") {
            String string7 = (String)this.stk.popNode();
            ImportDecl importDecl = (ImportDecl)this.stk.popNode();
            importDecl.namespacePrefix = string7;
            this.stk.pushNode(importDecl);
        } else if (string4 == "defaultElementNamespace") {
            ImportDecl importDecl = (ImportDecl)this.stk.popNode();
            importDecl.isDefaultElementNS = true;
            this.stk.pushNode(importDecl);
        } else if (string4 == "targetNamespace") {
            String string8 = (String)this.stk.popNode();
            if (!XQueryUtils.validateURI(string8)) {
                throw new XQException(this.msg.getMessage0("XQST0046"));
            }
            ImportDecl importDecl = (ImportDecl)this.stk.popNode();
            importDecl.targetNS = string8;
            this.stk.pushNode(importDecl);
        } else if (string4 == "targetLocation") {
            String string9 = (String)this.stk.popNode();
            if (!XQueryUtils.validateURI(string9)) {
                throw new XQException(this.msg.getMessage0("XQST0046"));
            }
            ImportDecl importDecl = (ImportDecl)this.stk.popNode();
            if (importDecl.targetLoc == null) {
                importDecl.targetLoc = new ArrayList(5);
            }
            importDecl.targetLoc.add(string9);
            this.stk.pushNode(importDecl);
        } else if (string4 == "prefix") {
            String string10 = (String)this.stk.popNode();
            if (string10.equals("xml") || string10.equals("xmlns")) {
                throw new XQException(this.msg.getMessage0("XQST0070"));
            }
            this.libModule.setPrefix(string10);
        } else if (string4 == "uri") {
            String string11 = (String)this.stk.popNode();
            if (string11 == null || string11.length() == 0) {
                throw new XQException(this.msg.getMessage0("XQST0088"));
            }
            this.libModule.setTargetURI(string11);
        } else if (string4 == "schemaImport") {
            this.compileSchemaImport();
        } else if (string4 == "validateExpr") {
            this.compileValidateExpr();
        } else if (string4 == "optionDecl") {
            this.compileOptionDecl();
        } else if (string4 == "pragma") {
            this.compilePragma();
        } else if (string4 == "extensionExpr") {
            this.compileExtensionExpr();
        } else if (string4 == "moduleImport") {
            this.compileModuleImport();
        } else if (string4 == "moduleDecl") {
            this.qs.addNamespace(this.libModule.getPrefix(), this.libModule.getTargetURI());
        } else if (string4 == "libraryModule") {
            this.compileLibraryModule();
        } else if (string4 != "orderedExpr" && string4 != "unorderedExpr" && string4 != "validationMode" && string4 != "validationContext" && string4 != "tagName" && string4 != "identifier" && string4 != "attributeName" && string4 != "attributeValue" && string4 != "xmlspaceDecl" && string4 != "inheritnamespacesDecl" && string4 != "orderingDecl" && string4 != "emptyOrderingDecl" && string4 != "nodeDecl" && string4 != "namespaceDecl" && string4 != "unarySign" && string4 != "xpathAxis" && string4 != "order" && string4 != "emptyOrder" && string4 != "orderCollation" && string4 != "orderModifier" && string4 != "prolog" && string4 != "nillable" && string4 != "type" && string4 != "nodeName" && string4 != "typeName" && string4 != "occurrenceIndicator" && string4 != "anyItemType" && string4 != "emptySequenceType" && string4 != "variableBinding" && string4 != "externalDefinition" && string4 != "external" && string4 != "module" && string4 != "copyNamespacesDecl") {
            throw new XQException(this.msg.getMessage1("XQE-0202", string4));
        }
    }

    private void xqueryVersionCheck() {
        String string = (String)this.stk.popNode();
        if (!string.equals("1.0")) {
            throw new XQException(this.qs.getMesg().getMessage0("XQST0031"));
        }
    }

    private void compileIfThenElse() {
        int n = this.stk.nodeArity();
        Expr expr = null;
        if (n == 3) {
            expr = (Expr)this.stk.popNode();
        } else if (n != 2) {
            throw new XQException(this.msg.getMessage0("XQE-0203"));
        }
        Expr expr2 = (Expr)this.stk.popNode();
        Case case_ = new Case((Expr)this.stk.popNode(), expr2, expr);
        this.stk.closeNodeScope();
        this.stk.pushNode(case_);
    }

    private void compileLet() {
        LetExpr letExpr;
        QName qName;
        Expr expr = (Expr)this.stk.popNode();
        Object object = this.stk.popNode();
        if (object instanceof OXMLSequenceType) {
            String string = (String)this.stk.popNode();
            qName = XQueryUtils.createQNameFromString(this.qs, string);
            letExpr = new LetExpr(qName, expr, (OXMLSequenceType)object);
        } else {
            String string = (String)object;
            qName = XQueryUtils.createQNameFromString(this.qs, string);
            letExpr = new LetExpr(qName, expr);
        }
        this.sym.AddEntry(qName, letExpr);
        this.stk.pushNode(new VarExpr(letExpr));
    }

    private void compileReturn() {
        LetExpr letExpr = new LetExpr(this.qs.getUniqueVarName(), (Expr)this.stk.popNode());
        this.stk.pushNode(new VarExpr(letExpr));
    }

    private void compileWhere() {
    }

    private void compileQuantifiedExpr() {
        LetExpr letExpr = new LetExpr(this.qs.getUniqueVarName(), (Expr)new ConstantExpr(0));
        Expr expr = null;
        expr = (Expr)this.stk.popNode();
        int n = this.stk.nodeArity();
        Object[] objectArray = this.stk.closeNodeScope();
        if (objectArray.length != n) {
            throw new XQException(this.msg.getMessage2("XQE-0206", Integer.toString(n), Integer.toString(objectArray.length)));
        }
        if (objectArray[0].equals("every")) {
            expr = new LogicalOp(3, expr);
        }
        NodeSource nodeSource = null;
        int n2 = 0;
        NodeSource[] nodeSourceArray = new NodeSource[n - 1];
        for (int i = 1; i < n; ++i) {
            if (!(objectArray[i] instanceof NodeSource)) {
                throw new XQException(this.msg.getMessage1("XQE-0001", Integer.toString(i)));
            }
            nodeSource = (NodeSource)objectArray[i];
            nodeSourceArray[n2++] = nodeSource;
        }
        nodeSource = new Join(nodeSourceArray, null, expr, new VarExpr(letExpr));
        FLWR fLWR = new FLWR(nodeSource);
        Exists exists = new Exists(fLWR);
        if (objectArray[0].equals("every")) {
            LogicalOp logicalOp = new LogicalOp(3, (Expr)exists);
            this.stk.pushNode(logicalOp);
        } else {
            this.stk.pushNode(exists);
        }
        this.sym.EndScope();
    }

    private void compileQuery() {
        this.retExpr = (Expr)this.stk.popNode();
        if (!this.stk.empty()) {
            throw new XQException(this.msg.getMessage0("XQE-0204"));
        }
        if (this.prolog_exists) {
            this.sym.EndScope();
        }
        this.postProcess();
    }

    private void compileLibraryModule() {
        this.libModule.setPrologVars(this.qs.getPrologVariables());
        this.libModule.setFunctionDefns(this.qs.getFunctionDefns());
        this.libModule.setImportedModules(this.importedModulesMap);
        this.postProcess();
    }

    private void postProcess() {
        this.resolveFnCalls();
        this.normalizeFnExprs();
        this.detectCircularity();
    }

    private void compileOrderBy() {
        int n = this.stk.nodeArity();
        if (n % 4 != 0) {
            throw new XQException(this.msg.getMessage0("XQE-0205"));
        }
        int n2 = n / 4;
        BitSet bitSet = new BitSet(n2);
        BitSet bitSet2 = new BitSet(n2);
        String[] stringArray = new String[n2];
        Expr[] exprArray = new Expr[n2];
        for (int i = n - 4; i >= 0; i -= 4) {
            String string;
            int n3 = i / 4;
            stringArray[n3] = string = (String)this.stk.popNode();
            string = (String)this.stk.popNode();
            if (string.equals("EMPTY_GREATEST") || string.equals("DEFAULT") && this.emptyOrderGreatest) {
                bitSet2.set(n3);
            }
            if ((string = (String)this.stk.popNode()).equals("DESCENDING")) {
                bitSet.set(n3);
            }
            exprArray[n3] = (Expr)this.stk.popNode();
        }
        VarExpr varExpr = new VarExpr(new Variable(this.qs.getUniqueVarName()));
        SortNS sortNS = new SortNS(null, exprArray, null, bitSet, bitSet2, stringArray, false, varExpr);
        this.stk.closeNodeScope();
        this.stk.pushNode(sortNS);
    }

    private void compileFLWR() {
        Object object;
        NodeSource[] nodeSourceArray;
        VarExpr varExpr = (VarExpr)this.stk.popNode();
        Expr expr = null;
        SortNS sortNS = null;
        Object object2 = this.stk.peekNode();
        if (object2 instanceof SortNS) {
            sortNS = (SortNS)this.stk.popNode();
            object2 = this.stk.peekNode();
        }
        if (!(object2 instanceof NodeSource) && !(object2 instanceof VarExpr)) {
            expr = (Expr)this.stk.popNode();
        }
        int n = this.stk.nodeArity();
        Object[] objectArray = this.stk.closeNodeScope();
        if (objectArray.length != n) {
            throw new XQException(this.msg.getMessage2("XQE-0206", Integer.toString(n), Integer.toString(objectArray.length)));
        }
        int n2 = 0;
        Object object3 = null;
        int n3 = 0;
        NodeSource[] nodeSourceArray2 = new NodeSource[n];
        VarExpr[] varExprArray = new VarExpr[n];
        if (objectArray[0] instanceof VarExpr && ((VarExpr)objectArray[0]).containLetExpr()) {
            nodeSourceArray = new VarExpr(new Variable(this.qs.getUniqueVarName()));
            object = new Scan(new XMLElem(1, "dummy", null, null, null), (VarExpr)nodeSourceArray);
            object3 = object;
            nodeSourceArray2[n3++] = object3;
        }
        while (n2 < n) {
            if (objectArray[n2] instanceof NodeSource) {
                object3 = objectArray[n2];
                nodeSourceArray2[n3++] = object3;
                ++n2;
                continue;
            }
            int n4 = 0;
            while (n2 < n && objectArray[n2] instanceof VarExpr && ((VarExpr)objectArray[n2]).containLetExpr()) {
                varExprArray[n4] = (VarExpr)objectArray[n2];
                ++n2;
                ++n4;
            }
            object = new VarExpr[n4];
            for (int i = 0; i < ((VarExpr[])object).length; ++i) {
                object[i] = varExprArray[i];
            }
            ((NodeSource)object3).setLetExprs((VarExpr[])object);
        }
        nodeSourceArray = new NodeSource[n3];
        System.arraycopy(nodeSourceArray2, 0, nodeSourceArray, 0, n3);
        if (nodeSourceArray.length > 1) {
            // empty if block
        }
        object3 = new Join(nodeSourceArray, null, expr, varExpr);
        if (sortNS != null) {
            sortNS.setChildNodeSrc((NodeSource)object3);
            sortNS.setNonKeys(Expr.createArray(((NodeSource)object3).getOutVariable()));
            object3 = sortNS;
        }
        object = new FLWR((NodeSource)object3);
        this.stk.pushNode(object);
        this.sym.EndScope();
    }

    private void compileConst() {
        String string = (String)this.stk.popNode();
        String string2 = (String)this.stk.popNode();
        if (string2 != "CHARSTRING" && string2 != "INTEGER_LITERAL" && string2 != "DECIMAL_LITERAL" && string2 != "DOUBLE_LITERAL") {
            throw new XQException(this.msg.getMessage1("XQE-0208", string2));
        }
        if (string2 == "INTEGER_LITERAL") {
            this.stk.pushNode(new ConstantExpr(string, 22));
        } else if (string2 == "CHARSTRING") {
            this.stk.pushNode(new ConstantExpr(string));
        } else if (string2 == "DECIMAL_LITERAL") {
            this.stk.pushNode(new ConstantExpr(string, 5));
        } else {
            this.stk.pushNode(new ConstantExpr(string, 4));
        }
        if (this.debug) {
            System.out.println(" node arity" + this.stk.nodeArity());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void compileVar() {
        String string = (String)this.stk.popNode();
        QName qName = XQueryUtils.createQNameFromString(this.qs, string);
        Variable variable = this.getVariable(qName);
        if (variable == null) {
            if (!this.compState.isTreatUnknownVarsAsExternal()) throw new XQException(this.msg.getMessage0("XPST0008"), this.msg.getMessage1("XQE-0209", string));
            variable = new BindExpr(qName, null);
            this.sym.AddEntryToTopScope(qName, variable);
            this.bindHash.put(qName, variable);
            this.externalVarNameList.add(qName);
            this.qs.addPrologVariable(variable);
        } else {
            variable.incrementRefCount();
        }
        this.stk.pushNode(new VarExpr(variable));
    }

    private void compilePredicateExpr() {
        Object[] objectArray = this.stk.closeNodeScope();
        PredicateSet predicateSet = new PredicateSet();
        boolean bl = true;
        Expr expr = null;
        boolean bl2 = false;
        if (this.stk.nodeArity() == 0 && objectArray.length > 0 && objectArray[0] instanceof Identifier) {
            bl2 = true;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] instanceof Predicate) {
                predicateSet.addPredicate((Predicate)objectArray[i]);
                continue;
            }
            if (!bl2 && objectArray[i] instanceof Identifier || objectArray[i] instanceof NodeTest || objectArray[i] instanceof PathStep) {
                this.stk.pushNode(objectArray[i]);
                continue;
            }
            bl = false;
            expr = (Expr)objectArray[i];
        }
        if (bl) {
            this.stk.pushNode(predicateSet);
        } else {
            PredicatedExpr predicatedExpr = new PredicatedExpr(expr, predicateSet);
            this.stk.pushNode(predicatedExpr);
        }
    }

    private String[] tokenizeXpath(String string) {
        int n = string.length();
        boolean bl = false;
        int n2 = 0;
        this.stk.openNodeScope();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (bl && c == '\"') {
                bl = false;
                continue;
            }
            if (c == '\"') {
                bl = true;
                continue;
            }
            if (c != '$') continue;
            this.stk.pushNode(string.substring(n2, i));
            n2 = i;
            while (++i < n && Character.isLetterOrDigit(string.charAt(i))) {
            }
            this.stk.pushNode(string.substring(n2, i));
            n2 = i;
        }
        if (n2 < n) {
            this.stk.pushNode(string.substring(n2, n));
        }
        return this.stk.closeStrNodeScope();
    }

    private Identifier createIdentifierFromString(String string) {
        String string2 = XQueryUtils.getPrefix(string);
        String string3 = XQueryUtils.getLocalName(string);
        String string4 = this.resolveNamespace(string2, string3);
        return new Identifier(string, string4, string3);
    }

    private XpathExpr createXpathFromPath(XpathExpr xpathExpr, String string) {
        String[] stringArray = this.tokenizeXpath(string);
        if (xpathExpr.getPathExpr() == null) {
            Expr[] exprArray = xpathExpr.getKids();
            Expr[] exprArray2 = new Expr[exprArray.length + stringArray.length];
            System.arraycopy(exprArray, 0, exprArray2, 0, exprArray.length);
            for (int i = exprArray.length; i < exprArray2.length; ++i) {
                exprArray2[i] = this.createIdentifierFromString(stringArray[i - exprArray.length]);
            }
            return new XpathExpr(exprArray2);
        }
        if (stringArray.length > 1) {
            Expr[] exprArray = new Expr[stringArray.length + 2];
            exprArray[0] = xpathExpr.getKids()[0];
            exprArray[1] = new ConstantExpr(xpathExpr.getPathExpr());
            for (int i = 2; i < stringArray.length + 2; ++i) {
                string = stringArray[i - 2];
                if (string.charAt(0) == '$') {
                    QName qName = XQueryUtils.createQNameFromString(this.qs, string);
                    exprArray[i] = this.getVariable(qName);
                    continue;
                }
                exprArray[i] = new ConstantExpr(string);
            }
            return new XpathExpr(exprArray);
        }
        xpathExpr.setPathExpr(xpathExpr.getPathExpr() + stringArray[0]);
        return xpathExpr;
    }

    private XpathExpr processXPath(Expr expr, String[] stringArray, int n, int n2) {
        int n3 = 0;
        if (n - n2 == 0) {
            return new XpathExpr(stringArray[n], expr);
        }
        if (stringArray[n].charAt(0) == '$') {
            throw new XQException(this.msg.getMessage0("XQE-0210"));
        }
        this.stk.openNodeScope();
        this.stk.pushNode(expr);
        n3 = n;
        while (n3 <= n2) {
            Expr expr2;
            int n4;
            if (stringArray[n3].charAt(0) != '$') {
                n4 = ++n3;
                this.stk.pushNode(new ConstantExpr(stringArray[--n3]));
                ++n3;
                continue;
            }
            n4 = 0;
            int n5 = 0;
            QName qName = XQueryUtils.createQNameFromString(this.qs, stringArray[n3]);
            Variable variable = this.getVariable(qName);
            int n6 = 0;
            for (n4 = n3 + 1; n4 <= n2; n4 += 2) {
                for (n5 = 0; n5 < stringArray[n4].length(); ++n5) {
                    char c = stringArray[n4].charAt(n5);
                    if (c == '[' || c == '(') {
                        ++n6;
                        continue;
                    }
                    if (c != ']' && c != ')' && c != ' ') continue;
                    if (n6 == 0) break;
                    if (c == ' ') continue;
                    --n6;
                }
                if (n6 == 0 && n5 <= stringArray[n4].length()) break;
            }
            if (n4 == n3 + 1 && n5 == 0) {
                expr2 = variable;
                ++n3;
            } else if (n5 == 0) {
                expr2 = this.processXPath(variable, stringArray, n3 + 1, n4 - 1);
                n3 = n4;
            } else {
                String string = stringArray[n4].substring(0, n5);
                String string2 = stringArray[n4].substring(n5);
                stringArray[n4] = string;
                expr2 = this.processXPath(variable, stringArray, n3 + 1, n4);
                stringArray[n4] = string2;
                n3 = n4;
            }
            this.stk.pushNode(expr2);
        }
        Expr[] exprArray = this.stk.closeExprNodeScope();
        return new XpathExpr(exprArray);
    }

    private XpathExpr createXpathFromStr(Expr expr, String string) {
        String[] stringArray;
        if (this.debug) {
            System.out.println(" createXPathFromStr -- string is " + string);
        }
        if ((stringArray = this.tokenizeXpath(string)).length > 1) {
            return this.processXPath(expr, stringArray, 0, stringArray.length - 1);
        }
        return new XpathExpr(stringArray[0], expr);
    }

    private void compilePredicate() {
        Expr expr = (Expr)this.stk.popNode();
        Predicate predicate = new Predicate(expr);
        this.stk.pushNode(predicate);
    }

    private void compileIdentifier() {
        this.stk.pushNode(this.createIdentifierFromString((String)this.stk.popNode()));
    }

    private void compileDot() {
        this.stk.pushNode(new Dot());
    }

    private void compileDotDot() {
        PathStep pathStep = new PathStep(8, null, null, null);
        pathStep.setAnyNode(true);
        this.stk.pushNode(pathStep);
        this.compState.setHasRevAxis(true);
    }

    private void printI(int n) {
        System.out.println(" is is " + n);
    }

    private String resolveNamespacePrefix(String string) {
        String string2 = null;
        if (this.libModule != null) {
            string2 = this.libModule.getTargetURI();
        }
        return this.qs.resolveNamespacePrefix(string, string2);
    }

    private String resolveNamespace(String string, String string2) {
        return this.resolveNamespace(string, string2, false);
    }

    private String resolveNamespace(String string, String string2, boolean bl) {
        String string3 = null;
        if (string != null && !string.equals("") && !string.equals("*")) {
            string3 = this.qs.resolveNamespacePrefix(string);
            if (string3 == null) {
                throw new XQException(this.msg.getMessage0("XPST0081"), this.msg.getMessage1("XQE-0232", string));
            }
        } else if (string != null && string.equals("*")) {
            string3 = "*";
        } else if (string == null && "*".equals(string2)) {
            string3 = "*";
        } else if (string == null && !bl) {
            string3 = this.qs.getDefaultElemNS();
        }
        return string3;
    }

    private void compileXpathStep() {
        Object object;
        Object object2;
        PredicateSet predicateSet = null;
        Object object3 = this.stk.peekNode();
        if (object3 instanceof PredicateSet) {
            predicateSet = (PredicateSet)this.stk.popNode();
        }
        int n = this.stk.nodeArity() - 1;
        String string = null;
        object3 = this.stk.popNode();
        Object object4 = null;
        if (this.debug) {
            System.out.println(" compileStep: node arity ==" + n + "str = " + string);
        }
        if (n > 2 && (object4 = this.stk.peekNode()) instanceof PredicateSet) {
            predicateSet = (PredicateSet)this.stk.popNode();
            --n;
        }
        if (n != 2) {
            throw new XQException(this.msg.getMessage0("XQE-0213"));
        }
        object4 = this.stk.popNode();
        String string2 = (String)this.stk.popNode();
        this.stk.closeNodeScope();
        if (object4 instanceof String) {
            throw new XQException(this.msg.getMessage0("XQE-0214"));
        }
        Expr expr = (Expr)object4;
        Object object5 = null;
        Object object6 = null;
        PathStep pathStep = null;
        if (object3 instanceof NodeTest) {
            object2 = (NodeTest)object3;
            if (string2 == "SLASH") {
                object6 = new PathStep(3, ((NodeTest)object2).getLocalName(), ((NodeTest)object2).getNameSpace(), predicateSet);
                ((PathStep)object6).setReorder(false);
            } else if (string2 == "SLASHSLASH") {
                if (predicateSet != null) {
                    pathStep = new PathStep(5, null, null, null);
                    pathStep.setAnyNode(true);
                    object6 = new PathStep(3, ((NodeTest)object2).getLocalName(), ((NodeTest)object2).getNameSpace(), predicateSet);
                } else {
                    object6 = new PathStep(4, ((NodeTest)object2).getLocalName(), ((NodeTest)object2).getNameSpace(), predicateSet);
                }
            }
            int n2 = ((NodeTest)object2).getNodeType();
            if (n2 == 0) {
                ((PathStep)object6).setAnyNode(true);
            } else {
                ((PathStep)object6).setNodeType(n2);
                if (n2 == 9 || n2 == 2 || n2 == 1) {
                    ((PathStep)object6).setHasNodeTest();
                    object = ((NodeTest)object2).getSequenceType(this.qs);
                    ((PathStep)object6).setSequenceType((OXMLSequenceType)object);
                }
            }
        } else if (object3 instanceof Identifier || object3 instanceof String) {
            object2 = null;
            String string3 = null;
            if (object3 instanceof Identifier) {
                object = (Identifier)object3;
                string = ((Identifier)object).getName();
                object2 = ((Identifier)object).getNamespace();
                string3 = ((Identifier)object).getLocalName();
            } else {
                string = (String)object3;
                object = XQueryUtils.getPrefix(string);
                string3 = XQueryUtils.getLocalName(string);
                object2 = this.resolveNamespace((String)object, string3);
            }
            if (string2 == "SLASH") {
                object6 = new PathStep(3, string3, (String)object2, predicateSet);
                ((PathStep)object6).setReorder(false);
            } else if (string2 == "SLASHSLASH") {
                if (predicateSet != null) {
                    pathStep = new PathStep(5, null, null, null);
                    pathStep.setAnyNode(true);
                    object6 = new PathStep(3, string3, (String)object2, predicateSet);
                } else {
                    object6 = new PathStep(4, string3, (String)object2, predicateSet);
                }
            }
        } else if (object3 instanceof PathStep) {
            object2 = (PathStep)object3;
            ((PathStep)object2).setPredicateSet(predicateSet);
            if (string2 == "SLASHSLASH") {
                if (predicateSet == null && XQueryUtils.isForwardElementAxis((PathStep)object2)) {
                    object6 = ((PathStep)object2).getAxis() == 11 ? new PathStep(5, (PathStep)object2) : new PathStep(4, (PathStep)object2);
                } else {
                    pathStep = new PathStep(5, null, null, null);
                    pathStep.setAnyNode(true);
                    object6 = object2;
                }
            } else {
                object6 = object2;
            }
        } else if (object3 instanceof Expr) {
            if (string2 == "SLASHSLASH") {
                pathStep = new PathStep(5, null, null, null);
                pathStep.setAnyNode(true);
            }
            object6 = (Expr)object3;
        } else {
            throw new XQException(this.msg.getMessage0("XQE-0211"));
        }
        if (expr instanceof XpathExpr) {
            object2 = (XpathExpr)expr;
            if (pathStep != null) {
                ((XpathExpr)object2).addStep(pathStep);
            }
            ((XpathExpr)object2).addStep((Expr)object6);
            object5 = object2;
        } else if (expr instanceof Identifier) {
            object2 = (Identifier)expr;
            String string4 = ((Identifier)object2).getLocalName();
            object = ((Identifier)object2).getNamespace();
            PathStep pathStep2 = new PathStep(3, string4, (String)object, null);
            pathStep2.setReorder(false);
            object5 = new XpathExpr();
            ((XpathExpr)object5).addStep(pathStep2);
            ((XpathExpr)object5).addStep((Expr)object6);
        } else {
            object5 = new XpathExpr(expr);
            if (pathStep != null) {
                ((XpathExpr)object5).addStep(pathStep);
            }
            ((XpathExpr)object5).addStep((Expr)object6);
        }
        this.stk.pushNode(object5);
    }

    private void compileNameWithAxis() {
        String string;
        int n;
        PredicateSet predicateSet = null;
        Object object = this.stk.peekNode();
        if (object instanceof PredicateSet) {
            predicateSet = (PredicateSet)this.stk.popNode();
        }
        if ((n = this.stk.nodeArity()) != 2) {
            throw new XQException(this.msg.getMessage1("XQE-0001", "compileNameWithAxis()"));
        }
        NodeTest nodeTest = null;
        object = this.stk.popNode();
        if (object instanceof String) {
            string = (String)object;
        } else if (object instanceof Identifier) {
            string = ((Identifier)object).getName();
        } else if (object instanceof NodeTest) {
            nodeTest = (NodeTest)object;
            string = nodeTest.getLocalName();
        } else {
            throw new XQException(this.msg.getMessage0("XQE-0211"));
        }
        if (this.debug) {
            System.out.println(" compileNameWithAxis: str = " + string);
        }
        String string2 = (String)this.stk.popNode();
        this.stk.closeNodeScope();
        String string3 = XQueryUtils.getPrefix(string);
        String string4 = XQueryUtils.getLocalName(string);
        boolean bl = string2.equals("@") || string2.equals("attribute");
        String string5 = this.resolveNamespace(string3, string4, bl);
        PathStep pathStep = null;
        if (bl) {
            pathStep = new PathStep(2, string4, string5, predicateSet);
            pathStep.setNodeType(2);
        } else if (string2.equals("child::")) {
            pathStep = new PathStep(3, string4, string5, predicateSet);
            pathStep.setReorder(false);
        } else if (string2.equals("descendant::")) {
            pathStep = new PathStep(4, string4, string5, predicateSet);
        } else if (string2.equals("self::")) {
            pathStep = new PathStep(11, string4, string5, predicateSet);
        } else if (string2.equals("descendant-or-self::")) {
            pathStep = new PathStep(5, string4, string5, predicateSet);
        } else if (string2.equals("following::")) {
            pathStep = new PathStep(6, string4, string5, predicateSet);
        } else if (string2.equals("following-sibling::")) {
            pathStep = new PathStep(7, string4, string5, predicateSet);
        } else if (string2.equals("parent::")) {
            pathStep = new PathStep(8, string4, string5, predicateSet);
            this.compState.setHasRevAxis(true);
        } else if (string2.equals("ancestor::")) {
            pathStep = new PathStep(0, string4, string5, predicateSet);
            this.compState.setHasRevAxis(true);
        } else if (string2.equals("ancestor-or-self::")) {
            pathStep = new PathStep(1, string4, string5, predicateSet);
            this.compState.setHasRevAxis(true);
        } else if (string2.equals("preceding::")) {
            pathStep = new PathStep(9, string4, string5, predicateSet);
            this.compState.setHasRevAxis(true);
        } else if (string2.equals("preceding-sibling::")) {
            pathStep = new PathStep(10, string4, string5, predicateSet);
            this.compState.setHasRevAxis(true);
        } else {
            throw new XQException("axis not supportted.");
        }
        if (nodeTest != null) {
            int n2 = nodeTest.getNodeType();
            if (n2 == 0) {
                pathStep.setAnyNode(true);
            } else {
                pathStep.setNodeType(n2);
                if (n2 == 9 || n2 == 2 || n2 == 1) {
                    pathStep.setHasNodeTest();
                    OXMLSequenceType oXMLSequenceType = nodeTest.getSequenceType(this.qs);
                    pathStep.setSequenceType(oXMLSequenceType);
                }
            }
        }
        this.stk.pushNode(pathStep);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void compileAttribute() {
        Object[] objectArray = null;
        int n = this.stk.nodeArity();
        objectArray = this.stk.popNodes(n - 1);
        String string = (String)this.stk.popNode();
        this.stk.closeNodeScope();
        if (string.startsWith("xmlns:") || string.equals("xmlns")) {
            String string2 = null;
            if (n > 2) {
                throw new XQException(this.msg.getMessage0("XQST0022"));
            }
            if (objectArray == null) {
                string2 = "";
            } else if (objectArray[0] instanceof String) {
                string2 = (String)objectArray[0];
            } else {
                if (!(objectArray[0] instanceof ConstantExpr)) throw new XQException(this.msg.getMessage0("XQST0022"));
                string2 = ((ConstantExpr)objectArray[0]).getValue();
            }
            if (!XQueryUtils.validateURI(string2)) {
                throw new XQException(this.msg.getMessage0("XQST0046"));
            }
            if (string.startsWith("xmlns:")) {
                String string3 = string.substring("xmlns:".length());
                if (string3.equals("xml") || string3.equals("xmlns")) {
                    throw new XQException(this.msg.getMessage0("XQST0070"));
                }
                if (!((Boolean)this.elemNSStack.peek()).booleanValue()) {
                    this.elemNSStack.pop();
                    this.elemNSStack.push(Boolean.TRUE);
                    HashMap hashMap = new HashMap(5);
                    this.qs.pushNamespaceHT(hashMap);
                }
                try {
                    this.qs.addNamespace(string3.intern(), string2);
                    return;
                }
                catch (Exception exception) {
                    throw new XQException(this.msg.getMessage0("XQST0071"), exception);
                }
            } else {
                if (((Boolean)this.elemDefNSStack.peek()).booleanValue()) throw new XQException(this.msg.getMessage0("XQST0071"), this.msg.getMessage0("XQE-0227"));
                this.elemDefNSStack.pop();
                this.elemDefNSStack.push(Boolean.TRUE);
                this.qs.pushDefaultElemNS(string2);
            }
            return;
        } else {
            Expr[] exprArray = new Expr[n - 1];
            for (int i = 0; i < n - 1; ++i) {
                if (objectArray[i] instanceof String) {
                    exprArray[i] = new ConstantExpr((String)objectArray[i]);
                    continue;
                }
                if (!(objectArray[i] instanceof Expr)) throw new XQException(this.msg.getMessage1("XQE-0001", "compileAttribute()"));
                exprArray[i] = (Expr)objectArray[i];
            }
            XMLCons xMLCons = new XMLCons(1, string, null, null, exprArray);
            this.stk.pushNode(xMLCons);
        }
    }

    private void compileElement() {
        Expr[] exprArray = null;
        HashMap hashMap = null;
        String string = null;
        if (this.stk.nodeArity() > 1) {
            exprArray = this.stk.popExprNodes(this.stk.nodeArity() - 1);
        }
        Object object = this.stk.popNode();
        if (((Boolean)this.elemDefNSStack.pop()).booleanValue()) {
            string = this.qs.popDefaultElemNS();
        }
        if (((Boolean)this.elemNSStack.pop()).booleanValue()) {
            hashMap = this.qs.popNamespaceHT();
        }
        if (!(object instanceof String)) {
            throw new XQException(this.msg.getMessage0("XQE-0216"));
        }
        XMLElem xMLElem = new XMLElem(1, (String)object, exprArray, hashMap, string);
        this.stk.closeNodeScope();
        this.stk.pushNode(xMLElem);
    }

    private void compileXmlComment() {
        String string = (String)this.stk.popNode();
        int n = string.length();
        if (n != 0 && string.charAt(n - 1) == '-' || string.indexOf("--") != -1) {
            throw new XQException(this.msg.getMessage0("XPST0003"), this.msg.getMessage0("XQE-0101"));
        }
        this.stk.pushNode(new XMLCons(2, null, null, string, null));
    }

    private void compileXmlCdataSection() {
        String string = (String)this.stk.popNode();
        this.stk.pushNode(new XMLCons(3, null, null, string, null));
    }

    private void compileXmlPI() {
        String string = (String)this.stk.popNode();
        String string2 = (String)this.stk.popNode();
        this.stk.pushNode(new XMLCons(4, string2, null, string, null));
    }

    private void compileComputedComment() {
        Expr[] exprArray = this.stk.popExprNodes(this.stk.nodeArity());
        this.stk.closeNodeScope();
        this.stk.pushNode(new XMLCons(5, null, null, null, exprArray));
    }

    private void compileComputedCons(String string) {
        Object[] objectArray = this.stk.closeNodeScope();
        String string2 = null;
        Expr expr = null;
        Expr[] exprArray = null;
        if (objectArray[0] instanceof String) {
            string2 = (String)objectArray[0];
        } else {
            expr = (Expr)objectArray[0];
        }
        if (objectArray.length == 2) {
            exprArray = new Expr[]{(Expr)objectArray[1]};
        } else if (objectArray.length > 2) {
            throw new XQException(this.msg.getMessage1("XQE-0001", "compileComputedCons"));
        }
        if (string == "computedElement") {
            if (string2 != null) {
                this.stk.pushNode(new XMLElem(2, string2, exprArray, null, null));
            } else {
                this.stk.pushNode(new XMLElem(2, expr, exprArray, null, null));
            }
        } else if (string == "computedAttribute") {
            this.stk.pushNode(new XMLCons(10, string2, expr, null, exprArray));
        } else if (string == "computedXmlPI") {
            this.stk.pushNode(new XMLCons(6, string2, expr, null, exprArray));
        }
    }

    private void compileComputedText() {
        Expr[] exprArray = this.stk.closeExprNodeScope();
        this.stk.pushNode(new XMLCons(7, null, null, null, exprArray));
    }

    private void compileComputedDocument() {
        Expr[] exprArray = this.stk.closeExprNodeScope();
        this.stk.pushNode(new XMLCons(8, null, null, null, exprArray));
    }

    private void compileExprlist() {
        Expr[] exprArray = null;
        exprArray = this.stk.popExprNodes(this.stk.nodeArity());
        this.stk.closeNodeScope();
        if (exprArray != null && exprArray.length == 2 && exprArray[0] instanceof PathStep && exprArray[1] instanceof PredicateSet) {
            ((PathStep)exprArray[0]).setPredicateSet((PredicateSet)exprArray[1]);
            this.stk.pushNode(exprArray[0]);
        } else {
            this.stk.pushNode(new ExprSequence(exprArray));
        }
    }

    private final void compileVariableInExpr() {
        Object[] objectArray = this.stk.closeNodeScope();
        Object object = objectArray[objectArray.length - 1];
        String string = (String)objectArray[0];
        QName qName = XQueryUtils.createQNameFromString(this.qs, string);
        Variable variable = null;
        Variable variable2 = null;
        QName qName2 = null;
        switch (objectArray.length) {
            case 2: {
                variable = new Variable(qName);
                break;
            }
            case 3: {
                if (objectArray[1] instanceof OXMLSequenceType) {
                    variable = new Variable(qName, (OXMLSequenceType)objectArray[1]);
                    break;
                }
                variable = new Variable(qName);
                qName2 = XQueryUtils.createQNameFromString(this.qs, (String)objectArray[1]);
                if (qName2.equals(qName)) {
                    throw new XQException(this.qs.getMesg().getMessage0("XQST0089"));
                }
                variable2 = new Variable(qName2, OXMLSequenceType.TINTEGER);
                break;
            }
            case 4: {
                qName2 = XQueryUtils.createQNameFromString(this.qs, (String)objectArray[1]);
                if (qName2.equals(qName)) {
                    throw new XQException(this.qs.getMesg().getMessage0("XQST0089"));
                }
                variable2 = new Variable(qName2, OXMLSequenceType.TINTEGER);
                variable = new Variable(qName, (OXMLSequenceType)objectArray[2]);
            }
        }
        this.sym.AddEntry(qName, variable);
        if (variable2 != null) {
            this.sym.AddEntry(qName2, variable2);
        }
        if (object instanceof String) {
            object = new ConstantExpr((String)object);
        }
        Scan scan = variable2 == null ? new Scan((Expr)object, new VarExpr(variable)) : new Scan((Expr)object, new VarExpr(variable), new VarExpr(variable2));
        this.stk.pushNode(scan);
    }

    private boolean isXPathFunction(String string) {
        return string.equals("context-item") || string.equals("position") || string.equals("last");
    }

    private void compileFunction() {
        Expr[] exprArray = this.stk.popExprNodes(this.stk.nodeArity() - 1);
        String string = (String)this.stk.popNode();
        this.stk.closeNodeScope();
        if (exprArray.length > 2) {
            ArrayList<Expr> arrayList = new ArrayList<Expr>(exprArray.length);
            for (int i = exprArray.length - 1; i >= 0; --i) {
                if (exprArray[i] instanceof PredicateSet) {
                    arrayList.add(new PredicatedExpr(exprArray[i - 1], (PredicateSet)exprArray[i]));
                    --i;
                    continue;
                }
                arrayList.add(exprArray[i]);
            }
            Expr[] exprArray2 = new Expr[arrayList.size()];
            for (int i = 0; i < exprArray2.length; ++i) {
                exprArray2[i] = (Expr)arrayList.get(exprArray2.length - i - 1);
            }
            exprArray = exprArray2;
        }
        if (exprArray.length > 2) {
            throw new XQException(this.msg.getMessage1("XQE-0221", string));
        }
        if (string == "TO") {
            this.stk.pushNode(new XQRangeExpr(exprArray[0], exprArray[1]));
        } else if (string == "UNION") {
            this.stk.pushNode(new SeqOp(0, exprArray[0], exprArray[1]));
        } else if (string == "INTERSECT") {
            this.stk.pushNode(new SeqOp(1, exprArray[0], exprArray[1]));
        } else if (string == "EXCEPT") {
            this.stk.pushNode(new SeqOp(2, exprArray[0], exprArray[1]));
        } else if (string == "PLUS") {
            this.stk.pushNode(new ArithOp(200, exprArray));
        } else if (string == "MULTIPLY") {
            this.stk.pushNode(new ArithOp(202, exprArray));
        } else if (string == "DIVIDE") {
            this.stk.pushNode(new ArithOp(203, exprArray));
        } else if (string == "MINUS") {
            this.stk.pushNode(new ArithOp(201, exprArray));
        } else if (string == "MOD") {
            this.stk.pushNode(new ArithOp(205, exprArray));
        } else if (string == "IDIVIDE") {
            this.stk.pushNode(new ArithOp(204, exprArray));
        } else if (string == "AND") {
            this.stk.pushNode(new LogicalOp(1, exprArray));
        } else if (string == "OR") {
            this.stk.pushNode(new LogicalOp(2, exprArray));
        } else if (string == "NOT") {
            this.stk.pushNode(new LogicalOp(3, exprArray));
        } else if (string == "EQUALS") {
            this.stk.pushNode(new GeneralComparison(210, exprArray[0], exprArray[1]));
        } else if (string == "GREATER-THAN") {
            this.stk.pushNode(new GeneralComparison(214, exprArray[0], exprArray[1]));
        } else if (string == "LESSER-THAN") {
            this.stk.pushNode(new GeneralComparison(212, exprArray[0], exprArray[1]));
        } else if (string == "GREATER-THAN-EQUALS") {
            this.stk.pushNode(new GeneralComparison(215, exprArray[0], exprArray[1]));
        } else if (string == "LESSER-THAN-EQUALS") {
            this.stk.pushNode(new GeneralComparison(213, exprArray[0], exprArray[1]));
        } else if (string == "NOT-EQUALS") {
            this.stk.pushNode(new GeneralComparison(211, exprArray[0], exprArray[1]));
        } else if (string == "VALUE-COMPARISON-EQ") {
            this.stk.pushNode(new RelOp(210, exprArray[0], exprArray[1]));
        } else if (string == "VALUE-COMPARISON-NE") {
            this.stk.pushNode(new RelOp(211, exprArray[0], exprArray[1]));
        } else if (string == "VALUE-COMPARISON-LT") {
            this.stk.pushNode(new RelOp(212, exprArray[0], exprArray[1]));
        } else if (string == "VALUE-COMPARISON-LE") {
            this.stk.pushNode(new RelOp(213, exprArray[0], exprArray[1]));
        } else if (string == "VALUE-COMPARISON-GT") {
            this.stk.pushNode(new RelOp(214, exprArray[0], exprArray[1]));
        } else if (string == "VALUE-COMPARISON-GE") {
            this.stk.pushNode(new RelOp(215, exprArray[0], exprArray[1]));
        } else if (string == "ORDER-COMPARISON-PRE") {
            this.stk.pushNode(new OrderComparison(3, exprArray[0], exprArray[1]));
        } else if (string == "ORDER-COMPARISON-FOL") {
            this.stk.pushNode(new OrderComparison(4, exprArray[0], exprArray[1]));
        } else if (string == "ORDER-COMPARISON-LTLT") {
            this.stk.pushNode(new OrderComparison(1, exprArray[0], exprArray[1]));
        } else if (string == "ORDER-COMPARISON-GTGT") {
            this.stk.pushNode(new OrderComparison(2, exprArray[0], exprArray[1]));
        } else if (string == "NODE-COMPARISON-IS") {
            this.stk.pushNode(new OrderComparison(5, exprArray[0], exprArray[1]));
        } else if (string == "NODE-COMPARISON-ISNOT") {
            this.stk.pushNode(new OrderComparison(6, exprArray[0], exprArray[1]));
        } else {
            throw new XQException(this.msg.getMessage1("XQE-0221", string));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void compileFunctionInv(String string, String string2, String string3, Expr[] exprArray) {
        int n;
        XMLSchema xMLSchema;
        Object object;
        boolean bl = false;
        int n2 = exprArray == null ? 0 : exprArray.length;
        FunctionId functionId = new FunctionId(string, string2, n2);
        boolean bl2 = false;
        FunctionDefn functionDefn = this.getFunctionDefn(functionId);
        if (functionDefn != null) {
            bl2 = true;
            bl = functionDefn.isExternalFunction();
        } else if (XQueryUtils.fnEquals(string) || string.equals("http://www.w3.org/2001/XMLSchema") || string.equals("http://xmlns.oracle.com/xdb")) {
            bl2 = true;
            bl = true;
        } else {
            object = null;
            xMLSchema = this.qs.getSchema();
            if (xMLSchema != null && n2 == 1) {
                try {
                    object = OXMLSequenceType.createValueType((QName)new QxName(string, string2), (int)1, (XMLSchema)xMLSchema);
                    if (object.isSchemaValid(xMLSchema)) {
                        bl2 = true;
                    }
                }
                catch (oracle.xml.xqxp.XQException xQException) {
                    // empty catch block
                }
                if (bl2) {
                    this.stk.pushNode(new TypeOp(2, exprArray[0], (OXMLSequenceType)object));
                    return;
                }
            }
        }
        if (bl2 && !bl) {
            this.stk.pushNode(new FunctionCall(functionDefn, exprArray));
            return;
        }
        object = null;
        if (this.compState.dsTable != null) {
            object = this.compState.dsTable.get(string);
        }
        if (object == null) {
            n = this.compState.resolvers.size();
            for (int i = 0; i < n && (object = ((OXMLFunctionNSResolver)this.compState.resolvers.get(i)).getLibrary((OXMLFunctionContext)this.qs, string)) == null; ++i) {
            }
        }
        if (object == null) {
            try {
                InitialContext initialContext = new InitialContext();
                object = initialContext.lookup(string);
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
        if (object == null && bl2) {
            throw new XQException(this.msg.getMessage0("XPST0017"), this.msg.getMessage1("XQE-0221", string3));
        }
        if (object == null && !bl2) {
            FunctionCall functionCall = new FunctionCall(exprArray);
            this.stk.pushNode(functionCall);
            this.addToFnCallRslvrList(functionId, string3, functionCall);
            return;
        }
        if (!(object instanceof oracle.xml.xqxp.functions.OXMLFunctionLibrary)) throw new XQException("Function library has to be OXMLFunctionLibrary");
        xMLSchema = (oracle.xml.xqxp.functions.OXMLFunctionLibrary)object;
        n = xMLSchema.getLibObjType();
        if (n == 1) {
            OXMLFunction oXMLFunction = xMLSchema.getFunction(string2, n2);
            if (oXMLFunction == null) {
                if (bl2) {
                    throw new XQException(this.msg.getMessage0("XPST0017"), this.msg.getMessage1("XQE-0221", string3));
                }
                FunctionCall functionCall = new FunctionCall(exprArray);
                this.stk.pushNode(functionCall);
                this.addToFnCallRslvrList(functionId, string3, functionCall);
                return;
            }
            if (functionDefn != null) {
                SAXComp.typecheckFnArgs(functionDefn, oXMLFunction, this.msg, this.compState.isLaxExternalFunctionDecl());
            }
            if (this.qs.getDBCharSet() != null) {
                this.checkJavaImplConsistency(string, string2, string3);
            }
            if (functionDefn == null) {
                functionDefn = new FunctionDefn(string2, string, oXMLFunction);
            } else {
                functionDefn.setFunctionObj(oXMLFunction);
            }
            FunctionCall functionCall = new FunctionCall(functionDefn, exprArray);
            this.stk.pushNode(functionCall);
            if (bl2) return;
            this.addToFnCallRslvrList(functionId, string3, functionCall);
            return;
        }
        if (n != 2) throw new XQException("Invalid object in Function library");
        XMLDataSource xMLDataSource = ((OXMLFunctionLibrary)xMLSchema).getDataSource(string2, n2);
        if (xMLDataSource == null) {
            throw new XQException("Unable to find the data source");
        }
        if (exprArray != null) {
            this.stk.pushNode(new ExternalDataSrc(xMLDataSource, exprArray));
            return;
        } else {
            this.stk.pushNode(new ExternalDataSrc(xMLDataSource));
        }
    }

    public static void typecheckFnArgs(FunctionDefn functionDefn, OXMLFunction oXMLFunction, XQMesg xQMesg, boolean bl) {
        int n;
        int n2;
        String string = functionDefn.getNamespace() + ":" + functionDefn.getFunctionName();
        Variable[] variableArray = functionDefn.getParameters();
        int n3 = n2 = variableArray == null ? 0 : variableArray.length;
        if (n2 != oXMLFunction.getNumberArgs()) {
            throw new XQException(xQMesg.getMessage1("XQE-0236", string));
        }
        if (functionDefn.getReturnType() != null && (n = (int)((bl ? functionDefn.getReturnType().isOfType(oXMLFunction.getReturnType()) : functionDefn.getReturnType().exactlyMatches(oXMLFunction.getReturnType())) ? 1 : 0)) == 0) {
            throw new XQException(xQMesg.getMessage1("XQE-0236", string));
        }
        for (n = 0; n < n2; ++n) {
            boolean bl2;
            OXMLSequenceType oXMLSequenceType = variableArray[n].getDefinedType();
            if (oXMLSequenceType == null) continue;
            boolean bl3 = bl2 = bl ? oXMLSequenceType.isOfType(oXMLFunction.getArgType(n)) : oXMLSequenceType.exactlyMatches(oXMLFunction.getArgType(n));
            if (bl2) continue;
            throw new XQException(xQMesg.getMessage1("XQE-0236", string));
        }
    }

    private void checkJavaImplConsistency(String string, String string2, String string3) {
        String string4 = this.qs.getDBCharSet();
        if (string4 == null) {
            return;
        }
        if (XQueryUtils.fnEquals(string) && (string2.equals("contains") || string2.equals("substring-before") || string2.equals("substring-after") || string2.equals("starts-with") || string2.equals("ends-with") || string2.equals("index-of"))) {
            String string5 = this.qs.getSortCollation();
            String string6 = this.qs.getDefaultCollation();
            if (string4.equals("AL32UTF8") || string4.equals("US7ASCII") || string4.equals("WE8ISO8859P1") ? !string5.equals("BINARY") && !string5.equals("UNICODE_BINARY") : !string5.equals("UNICODE_BINARY") || string6.equals("BINARY")) {
                throw new XQException(this.msg.getMessage1("XQE-0235", string3));
            }
        }
    }

    private void compileOraView(Expr[] exprArray, String string, int n) {
        int n2;
        String string2 = null;
        ConstantExpr constantExpr = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        int n3 = 0;
        if (n == 1) {
            n3 = 3;
        } else if (n == 2) {
            n3 = 4;
        } else if (n == 3) {
            n3 = 4;
        } else if (n == 4) {
            n3 = 3;
        }
        if (exprArray.length < 1 || exprArray.length > n3) {
            throw new XQException(this.msg.getMessage1("XQE-0219", string));
        }
        for (n2 = 0; n2 < exprArray.length; ++n2) {
            if (exprArray[n2] instanceof ConstantExpr) continue;
            throw new XQException(this.msg.getMessage1("XQE-0218", string));
        }
        if (n == 1 || n == 4) {
            if (exprArray.length == 3) {
                constantExpr = (ConstantExpr)exprArray[2];
                string3 = constantExpr.getValue();
            }
            if (exprArray.length == 1) {
                string4 = ((ConstantExpr)exprArray[0]).getValue();
            } else {
                string5 = ((ConstantExpr)exprArray[0]).getValue();
                if (string5.length() == 0) {
                    string5 = null;
                }
                string4 = ((ConstantExpr)exprArray[1]).getValue();
            }
        } else if (n == 2 || n == 3) {
            if (exprArray.length == 4) {
                constantExpr = (ConstantExpr)exprArray[3];
                string3 = constantExpr.getValue();
                n2 = exprArray.length - 1;
            } else {
                n2 = exprArray.length;
            }
            if (n2 == 2) {
                string6 = ((ConstantExpr)exprArray[0]).getValue();
                string4 = ((ConstantExpr)exprArray[1]).getValue();
            } else {
                string6 = ((ConstantExpr)exprArray[0]).getValue();
                string5 = ((ConstantExpr)exprArray[1]).getValue();
                if (string5.length() == 0) {
                    string5 = null;
                }
                string4 = ((ConstantExpr)exprArray[2]).getValue();
            }
        }
        if (string5 != null) {
            string5 = string5.startsWith("\"") && string5.endsWith("\"") ? string5.substring(1, string5.length() - 1) : string5.toUpperCase();
        }
        if (this.debug) {
            System.out.println(" input tablename is " + string4);
        }
        if (string4.startsWith("\"") && string4.endsWith("\"")) {
            string4 = string4.substring(1, string4.length() - 1);
            if (this.debug) {
                System.out.println(" tablename is " + string4);
            }
        } else {
            string4 = string4.toUpperCase();
        }
        SQLQuery sQLQuery = null;
        Connection connection = null;
        if (string3 != null) {
            if (this.compState.connTable != null && this.compState.connTable.containsKey(string3)) {
                connection = (Connection)this.compState.connTable.get(string3);
                sQLQuery = new SQLQuery(connection, null);
            } else {
                sQLQuery = new SQLQuery(string3, null);
                connection = sQLQuery.getSQLConn();
            }
            sQLQuery.setHasConnStr(true);
        } else {
            if (this.conn == null) {
                throw new XQException(this.msg.getMessage1("XQE-0238", string));
            }
            sQLQuery = new SQLQuery(this.conn, null);
            connection = this.conn;
        }
        String string7 = string5 != null ? "\"" + string5.replaceAll("\"", "\"\"") + "\".\"" + string4.replaceAll("\"", "\"\"") + "\"" : "\"" + string4.replaceAll("\"", "\"\"") + "\"";
        if (this.debug) {
            System.out.println(" table name is " + string7);
        }
        if (this.isXMLType(connection, string7)) {
            if (this.debug) {
                System.out.println("xmltype table");
            }
            sQLQuery.setRowTag("");
            if (n == 1) {
                string2 = "select value(p).getclobval() as \"ROW\" from " + string7 + " p";
            } else if (n == 2) {
                string2 = "select value(p).getclobval() as \"ROW\" from " + string7 + " p where ref(p) " + " in (select extractValue(res, '/Resource/XMLRef')" + " from xdb.path_view res where equals_path (res, '" + string6 + "') = 1)";
            } else if (n == 3) {
                string2 = "select value(p).getclobval() as \"ROW\" from " + string7 + " p where ref(p) " + " in (select extractValue(res, '/Resource/XMLRef')" + " from xdb.path_view res where under_path (res, '" + string6 + "') = 1)";
            } else if (n == 4) {
                string2 = "select p.object_value.getclobval(), (select path from xdb.path_view res where extractValue(res, '/Resource/XMLRef') = ref(p))  from " + string7 + " p where ref(p) in " + " (select extractValue(res, '/Resource/XMLRef') from " + " xdb.path_view res) ";
            }
            sQLQuery.setXMLType(string5, string4);
            if (n != 4) {
                this.getXMLSchemaForOraView(string4, sQLQuery);
            }
        } else {
            if (n == 2 || n == 3 || n == 4) {
                throw new XQException(this.msg.getMessage1("XQE-0238", string));
            }
            string2 = "select * from " + string7;
            sQLQuery.setSchTabName(string5, string4);
        }
        if (this.debug) {
            System.out.println(" sqlQuery is " + string2);
        }
        sQLQuery.setSQLQuery(string2);
        sQLQuery.setQType(n);
        this.stk.pushNode(sQLQuery);
    }

    private void getXMLSchemaForOraView(String string, SQLQuery sQLQuery) {
        Object v;
        if (this.oraViewMap == null) {
            this.oraViewMap = new HashMap();
        }
        if ((v = this.oraViewMap.get(string)) != null) {
            if (v != NO_SCHEMA) {
                sQLQuery.setRootElement((QName)v);
            }
            return;
        }
        Statement statement = null;
        try {
            XSDBuilder xSDBuilder = this.compState.getXSDBuilder();
            statement = sQLQuery.getSQLConn().createStatement();
            ResultSet resultSet = statement.executeQuery("select extract(schema, '/').getclobval(), element_name from all_xml_schemas s, all_xml_views e where e.view_name = '" + string + "' " + "and e.xmlschema = s.schema_url");
            if (!resultSet.next() && !(resultSet = statement.executeQuery("select extract(schema, '/').getclobval(), element_name from all_xml_schemas s, all_xml_tables e where e.table_name = '" + string + "' " + "and e.xmlschema = s.schema_url")).next()) {
                this.oraViewMap.put(string, NO_SCHEMA);
                return;
            }
            Clob clob = resultSet.getClob(1);
            if (clob.length() != 0L) {
                Reader reader = clob.getCharacterStream();
                xSDBuilder.setEntityResolver((EntityResolver)new ServerSchemaResolver(this.conn));
                xSDBuilder.setError(new XMLError());
                XMLSchema xMLSchema = xSDBuilder.build(reader, null);
                this.qs.setSchema(xMLSchema);
                String string2 = resultSet.getString(2);
                String string3 = "*";
                QName qName = new QName(string3, string2);
                this.oraViewMap.put(string, qName);
                sQLQuery.setRootElement(qName);
            }
        }
        catch (Exception exception) {
            throw new XQException(exception);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void compileSQLQuery(Expr[] exprArray, String string) {
        if (exprArray.length < 1 || exprArray.length > 2) {
            throw new XQException(this.msg.getMessage1("XQE-0217", string));
        }
        if (exprArray.length == 2) {
            if (!(exprArray[0] instanceof ConstantExpr) || !(exprArray[1] instanceof ConstantExpr)) {
                throw new XQException(this.msg.getMessage1("XQE-0218", string));
            }
            ConstantExpr constantExpr = (ConstantExpr)exprArray[0];
            ConstantExpr constantExpr2 = (ConstantExpr)exprArray[1];
            String string2 = constantExpr2.getValue();
            if (this.compState.connTable != null && this.compState.connTable.containsKey(string2)) {
                this.stk.pushNode(new SQLQuery((Connection)this.compState.connTable.get(string2), constantExpr.getValue()));
            } else {
                this.stk.pushNode(new SQLQuery(string2, constantExpr.getValue()));
            }
        } else {
            if (!(exprArray[0] instanceof ConstantExpr)) {
                throw new XQException(this.msg.getMessage1("XQE-0218", string));
            }
            ConstantExpr constantExpr = (ConstantExpr)exprArray[0];
            this.stk.pushNode(new SQLQuery(this.conn, constantExpr.getValue()));
        }
    }

    private void compileFunctionCall() {
        String string;
        Expr[] exprArray = this.stk.popExprNodes(this.stk.nodeArity() - 1);
        String string2 = (String)this.stk.popNode();
        boolean bl = false;
        this.stk.closeNodeScope();
        int n = string2.indexOf(58);
        String string3 = null;
        String string4 = null;
        if (n != -1) {
            string = string2.substring(0, n);
            string4 = this.qs.resolveNamespacePrefix(string);
            string3 = string2.substring(n + 1).intern();
            if (string4 == null) {
                throw new XQException(this.msg.getMessage0("XPST0081"), this.msg.getMessage1("XQE-0232", string));
            }
        } else {
            string4 = this.qs.getDefaultFuncNS();
            string3 = string2;
            if (string4 == null) {
                throw new XQException(this.msg.getMessage0("XPST0008"));
            }
        }
        if (string4.equals("http://xmlns.oracle.com/xdb") && string3 == "view") {
            this.compileOraView(exprArray, string2, 1);
        } else if (string4.equals("http://xmlns.oracle.com/xdb") && string3 == "docRes") {
            this.compileOraView(exprArray, string2, 2);
        } else if (string4.equals("http://xmlns.oracle.com/xdb") && string3 == "collectionRes") {
            this.compileOraView(exprArray, string2, 3);
        } else if (string4.equals("http://xmlns.oracle.com/xdb") && string3 == "viewRes") {
            this.compileOraView(exprArray, string2, 4);
        } else {
            if (XQueryUtils.fnEquals(string4) && (string3 == "doc" || string3 == "collection" || string3 == "doc-available")) {
                if (exprArray == null || exprArray.length != 1) {
                    throw new XQException(this.msg.getMessage0("XPST0017"), this.msg.getMessage1("XQE-0219", string2));
                }
                string = this.qs.getBaseURI();
                this.stk.pushNode(new Document(string3, string, exprArray[0]));
                return;
            }
            if (XQueryUtils.fnEquals(string4) && (string3 == "id" || string3 == "idref")) {
                throw new XQException(this.msg.getMessage0("XPST0017"), this.msg.getMessage1("XQE-0221", string2));
            }
            if (string4.equals("http://xmlns.oracle.com/xdb") && (string3 == "contains" || string3 == "matches" || string3 == "replace")) {
                if (!System.getProperty("java.vm.name").equals("JServer VM")) {
                    throw new XQException(this.msg.getMessage0("XPST0017"), this.msg.getMessage1("XQE-0221", string2));
                }
            } else if (string4.equals("http://www.w3.org/2001/XMLSchema") && string3 == "QName") {
                if (exprArray == null || exprArray.length != 1) {
                    throw new XQException(this.msg.getMessage0("XPST0017"), this.msg.getMessage1("XQE-0219", string2));
                }
            } else {
                if (string4.equals("http://www.w3.org/2001/XMLSchema") && string3 == "NOTATION") {
                    throw new XQException(this.msg.getMessage0("XPST0017"), this.msg.getMessage1("XQE-0221", string2));
                }
                if (XQueryUtils.fnEquals(string4) && string3 == "error") {
                    this.compState.setOptimizerFlag(16);
                }
            }
            this.compileFunctionInv(string4, string3, string2, exprArray);
        }
    }

    private void compileFunctionDefnStart(Attributes attributes) {
        String string;
        String string2;
        String string3 = XQXGen.getAttrValue(attributes, "funcName");
        StringBuffer stringBuffer = new StringBuffer(100);
        int n = string3.indexOf(58);
        if (n == -1) {
            string2 = this.qs.getDefaultFuncNS();
            if (this.libModule != null && !this.libModule.getTargetURI().equals(string2)) {
                throw new XQException(this.msg.getMessage0("XQST0048"));
            }
            if (string2 == null) {
                throw new XQException(this.msg.getMessage0("XQST0060"));
            }
            string = string3;
        } else {
            String string4 = string3.substring(0, n);
            string = string3.substring(n + 1);
            string2 = this.resolveNamespacePrefix(string4);
            if (string2 == null) {
                throw new XQException(this.msg.getMessage0("XPST0008"), this.msg.getMessage1("XQE-0232", string4));
            }
        }
        if (string2.equals("http://www.w3.org/2001/XMLSchema") || string2.equals("http://www.w3.org/XML/1998/namespace") || string2.equals("http://xmlns.oracle.com/xdb") || XQueryUtils.fnEquals(string2) || string2.equals("http://www.w3.org/2001/XMLSchema-instance")) {
            throw new XQException(this.msg.getMessage0("XQST0045"), this.msg.getMessage1("XQE-0233", string3));
        }
        this.stk.pushNode(new FunctionId(string2, string));
        this.sym.BeginScope();
    }

    private void compileFunctionDefinition() {
        Expr expr = null;
        Object object = this.stk.popNode();
        OXMLSequenceType oXMLSequenceType = null;
        if (!(object instanceof String)) {
            expr = (Expr)object;
        }
        object = this.stk.popNode();
        if (object instanceof OXMLSequenceType) {
            oXMLSequenceType = (OXMLSequenceType)object;
            object = this.stk.popNode();
        }
        if (!(object instanceof FunctionId)) {
            throw new XQException(this.msg.getMessage1("XQE-0001", "compileFD2"));
        }
        FunctionId functionId = (FunctionId)object;
        FunctionDefn functionDefn = this.getFunctionDefn(functionId);
        if (functionDefn != null) {
            if (expr != null) {
                functionDefn.setFunctionExpr(expr);
            } else {
                functionDefn.setExternalFunction(true);
            }
            if (oXMLSequenceType != null) {
                functionDefn.setReturnType(oXMLSequenceType);
            }
        } else {
            throw new XQException(this.msg.getMessage1("XQE-0001", "compileFD3"));
        }
        this.sym.EndScope();
    }

    private void compileFunctionParameter() {
        QName qName;
        OXMLSequenceType oXMLSequenceType = null;
        Object object = this.stk.popNode();
        if (object instanceof OXMLSequenceType) {
            oXMLSequenceType = (OXMLSequenceType)object;
            String string = (String)this.stk.popNode();
            qName = XQueryUtils.createQNameFromString(this.qs, string);
        } else {
            String string = (String)object;
            qName = XQueryUtils.createQNameFromString(this.qs, string);
        }
        if (this.sym.GetEntryFromCurrentScope(qName) != null) {
            throw new XQException(this.msg.getMessage0("XQST0039"));
        }
        Variable variable = new Variable(qName, oXMLSequenceType);
        this.sym.AddEntry(qName, variable);
        this.stk.pushNode(new VarExpr(variable));
    }

    private void compileFunctionParameterList() {
        Variable[] variableArray = this.stk.closeVariableNodeScope();
        FunctionId functionId = (FunctionId)this.stk.popNode();
        int n = variableArray == null ? 0 : variableArray.length;
        functionId.setNumParams(n);
        FunctionDefn functionDefn = this.getFunctionDefn(functionId);
        if (functionDefn != null) {
            throw new XQException(this.msg.getMessage0("XQST0034"), this.msg.getMessage1("XQE-0230", functionId.toString()));
        }
        functionDefn = new FunctionDefn(functionId.getLocalName(), functionId.getNamespaceURI());
        functionDefn.setParameters(variableArray);
        this.qs.addFunctionDefn(functionId, functionDefn);
        this.stk.pushNode(functionId);
    }

    private void compileUnaryExpr() {
        int n;
        Expr expr = (Expr)this.stk.popNode();
        int n2 = this.stk.nodeArity();
        int n3 = 43;
        String[] stringArray = this.stk.popStrNodes(n2);
        this.stk.closeNodeScope();
        for (n = 0; n < n2; n += 1) {
            if (n3 == 43 && stringArray[n].equals("-")) {
                n3 = 45;
                continue;
            }
            if (n3 != 45 || !stringArray[n].equals("-")) continue;
            n3 = 43;
        }
        n = n3 == 45 ? 1 : 0;
        UnaryExpr unaryExpr = new UnaryExpr(n != 0, expr);
        this.stk.pushNode(unaryExpr);
    }

    private void compilePrologVariable() {
        Variable variable;
        QName qName;
        Expr expr = null;
        OXMLSequenceType oXMLSequenceType = null;
        boolean bl = false;
        Object object = this.stk.popNode();
        if (object instanceof String) {
            bl = true;
        } else {
            expr = (Expr)object;
        }
        object = this.stk.popNode();
        if (object instanceof OXMLSequenceType) {
            oXMLSequenceType = (OXMLSequenceType)object;
            object = this.stk.popNode();
        }
        if (this.getVariable(qName = this.resolvePrologVarQNameFromString((String)object)) != null) {
            throw new XQException(this.msg.getMessage0("XQST0049"));
        }
        if (bl) {
            variable = new BindExpr(qName, oXMLSequenceType);
            this.sym.AddEntry(qName, variable);
            this.bindHash.put(qName, variable);
            this.externalVarNameList.add(qName);
        } else {
            variable = new LetExpr(qName, expr, oXMLSequenceType);
            this.sym.AddEntry(qName, variable);
        }
        this.qs.addPrologVariable(variable);
    }

    private QName resolvePrologVarQNameFromString(String string) {
        QName qName;
        int n = string.indexOf(58);
        if (n == -1) {
            if (this.libModule != null) {
                throw new XQException(this.msg.getMessage0("XQST0048"));
            }
            qName = new QName(string);
        } else {
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            String string4 = this.resolveNamespacePrefix(string2);
            if (string4 == null) {
                throw new XQException(this.qs.getMesg().getMessage0("XPST0081"), this.qs.getMesg().getMessage1("XQE-0232", string2));
            }
            qName = new QName(string4, string3, string2);
        }
        return qName;
    }

    private void compileSequenceType() {
        Object object;
        Object[] objectArray = this.stk.closeNodeScope();
        Object object2 = objectArray[0];
        int n = 1;
        if (objectArray.length == 2) {
            object = (String)objectArray[1];
            if (((String)object).equals("*")) {
                n = 4;
            } else if (((String)object).equals("+")) {
                n = 3;
            } else if (((String)object).equals("?")) {
                n = 2;
            }
        }
        if (object2 instanceof QxName) {
            object = (QxName)object2;
            String string = object.getNamespaceURI();
            if (string == null || string.length() == 0) {
                throw new XQException(this.msg.getMessage0("XPST0051"));
            }
            OXMLSequenceType oXMLSequenceType = null;
            try {
                oXMLSequenceType = OXMLSequenceType.createValueType((QName)((QxName)object2), (int)n, (XMLSchema)this.qs.getSchema());
            }
            catch (oracle.xml.xqxp.XQException xQException) {
                throw new XQException(this.msg.getMessage0(xQException.getErrorCode()));
            }
            if (!oXMLSequenceType.isSchemaValid(this.qs.getSchema())) {
                throw new XQException(this.msg.getMessage0("XPST0051"), this.msg.getMessage1("XQE-0237", object.getQName()));
            }
            this.stk.pushNode(oXMLSequenceType);
        } else if (object2 instanceof String) {
            object = (String)object2;
            if (((String)object).equals("item")) {
                if (n == 1) {
                    this.stk.pushNode(OXMLSequenceType.ITEM_ONE);
                } else if (n == 4) {
                    this.stk.pushNode(OXMLSequenceType.ITEM_ZERO_OR_MORE);
                } else if (n == 3) {
                    this.stk.pushNode(OXMLSequenceType.ITEM_ONE_OR_MORE);
                } else if (n == 2) {
                    this.stk.pushNode(OXMLSequenceType.ITEM_ZERO_OR_ONE);
                }
            } else if (((String)object).equals("empty")) {
                this.stk.pushNode(OXMLSequenceType.EMPTY_SEQUENCE);
            }
        } else if (object2 instanceof NodeTest) {
            object = (NodeTest)object2;
            if (((NodeTest)object).getNodeType() == 0) {
                if (n == 1) {
                    this.stk.pushNode(OXMLSequenceType.NODE_ONE);
                } else if (n == 4) {
                    this.stk.pushNode(OXMLSequenceType.NODE_ZERO_OR_MORE);
                } else if (n == 3) {
                    this.stk.pushNode(OXMLSequenceType.NODE_ONE_OR_MORE);
                } else if (n == 2) {
                    this.stk.pushNode(OXMLSequenceType.NODE_ZERO_OR_ONE);
                }
            } else if (((NodeTest)object).getNodeType() == 3) {
                this.stk.pushNode(OXMLSequenceType.createNodeType((int)3, (int)n));
            } else if (((NodeTest)object).getNodeType() == 8) {
                this.stk.pushNode(OXMLSequenceType.createNodeType((int)8, (int)n));
            } else if (((NodeTest)object).getNodeType() == 7) {
                this.stk.pushNode(OXMLSequenceType.createNodeType((QName)((NodeTest)object).getNodeName(), null, (int)((NodeTest)object).getNodeType(), (boolean)false, (int)n));
            } else {
                OXMLSequenceType oXMLSequenceType = ((NodeTest)object).getSequenceType(this.qs, n);
                this.stk.pushNode(oXMLSequenceType);
            }
        } else {
            throw new XQException(this.msg.getMessage1("XQE-0001", "compileSequenceType2"));
        }
        this.endCompiling(compilingSequenceType);
    }

    private void compileQName() {
        String string = (String)this.stk.popNode();
        int n = string.indexOf(58);
        if (n == -1) {
            if (this.isCompiling(compilingPragma) || this.isCompiling(compilingOption)) {
                throw new XQException(this.msg.getMessage0("XPST0081"));
            }
            String string2 = this.qs.getDefaultElemNS();
            if (string2 == null) {
                string2 = "";
            }
            this.stk.pushNode(new QxName(string2, string));
        } else {
            String string3 = string.substring(0, n);
            String string4 = string.substring(n + 1);
            String string5 = this.qs.resolveNamespacePrefix(string3);
            if (string5 == null) {
                throw new XQException(this.msg.getMessage0("XPST0081"), this.msg.getMessage1("XQE-0232", string3));
            }
            this.stk.pushNode(new QxName(string5, string4, string3, string));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void compileNodeTest(int n, boolean bl) {
        NodeTest nodeTest;
        Object[] objectArray = this.stk.closeNodeScope();
        if (n == 9 && objectArray != null) {
            if (objectArray.length != 1) {
                throw new XQException(this.msg.getMessage1("XQE-0001", "compileNodeTest1"));
            }
            if (objectArray[0] instanceof NodeTest) {
                NodeTest nodeTest2 = (NodeTest)objectArray[0];
                nodeTest2.setNodeType(9);
                nodeTest2.setExactlyOneElement(true);
                nodeTest2.setSequenceType(this.qs);
            }
            this.stk.pushNode(objectArray[0]);
            return;
        }
        if (objectArray == null) {
            nodeTest = new NodeTest(n);
        } else if (objectArray.length == 1) {
            if (!(objectArray[0] instanceof QxName)) throw new XQException(this.msg.getMessage1("XQE-0001", "compileElementTest1"));
            nodeTest = new NodeTest(XQueryUtils.handleWildcardQName((QxName)objectArray[0]), n);
        } else if (objectArray.length == 2) {
            nodeTest = new NodeTest(XQueryUtils.handleWildcardQName((QxName)objectArray[0]), XQueryUtils.handleWildcardQName((QxName)objectArray[1]), false, n);
        } else {
            if (objectArray.length != 3) throw new XQException(this.msg.getMessage1("XQE-0001", "compileElementTest2"));
            nodeTest = new NodeTest(XQueryUtils.handleWildcardQName((QxName)objectArray[0]), XQueryUtils.handleWildcardQName((QxName)objectArray[1]), true, n);
        }
        if (bl) {
            nodeTest.setSchemaTest(bl);
        }
        nodeTest.setSequenceType(this.qs);
        this.stk.pushNode(nodeTest);
    }

    private void compileTypeOperator(byte by) {
        if (by == 5) {
            Expr[] exprArray = this.stk.closeExprNodeScope();
            this.stk.pushNode(new TypeOp(by, exprArray));
        } else {
            OXMLSequenceType oXMLSequenceType = (OXMLSequenceType)this.stk.popNode();
            Expr expr = (Expr)this.stk.popNode();
            if ((by == 2 || by == 3) && (oXMLSequenceType.isAnyAtomicType() || oXMLSequenceType.exactlyMatchesIgnoreOccurrence(OXMLSequenceType.TNOTATION))) {
                throw new XQException(this.msg.getMessage0("XPST0080"));
            }
            this.stk.pushNode(new TypeOp(by, expr, oXMLSequenceType));
        }
    }

    private void compileTypeswitchCaseClause() {
        this.sym.EndScope();
    }

    private void compileTypeswitchCaseVariable() {
        Variable variable;
        Object[] objectArray = this.stk.closeNodeScope();
        if (objectArray.length == 2) {
            QName qName = XQueryUtils.createQNameFromString(this.qs, (String)objectArray[0]);
            variable = new Variable(qName, (OXMLSequenceType)objectArray[1]);
            this.sym.AddEntry(qName, variable);
        } else {
            variable = new Variable(this.qs.getUniqueVarName(), (OXMLSequenceType)objectArray[0]);
        }
        this.stk.pushNode(new VarExpr(variable));
    }

    private void compileTypeswitchDefaultClause() {
        this.sym.EndScope();
    }

    private void compileTypeswitchDefaultVariable() {
        Object[] objectArray = this.stk.closeNodeScope();
        QName qName = XQueryUtils.createQNameFromString(this.qs, (String)objectArray[0]);
        Variable variable = new Variable(qName);
        this.stk.pushNode(new VarExpr(variable));
        this.sym.AddEntry(qName, variable);
    }

    private void compileModuleImport() {
        ImportDecl importDecl = (ImportDecl)this.stk.popNode();
        if (importDecl.namespacePrefix.equalsIgnoreCase("xml") || importDecl.namespacePrefix.equalsIgnoreCase("xmlns")) {
            throw new XQException(this.msg.getMessage0("XQST0070"));
        }
        if (importDecl.targetNS.length() == 0) {
            throw new XQException(this.msg.getMessage0("XQST0088"));
        }
        if (this.qs.isPrefixBoundCurrentScope(importDecl.namespacePrefix)) {
            throw new XQException(this.qs.getMesg().getMessage0("XQST0033"), this.qs.getMesg().getMessage1("XQE-0226", importDecl.namespacePrefix));
        }
        this.qs.addNamespace(importDecl.namespacePrefix, importDecl.targetNS);
        if (this.importedModulesMap != null) {
            if (this.importedModulesMap.containsKey(importDecl.targetNS)) {
                throw new XQException(this.msg.getMessage0("XQST0047"));
            }
        } else {
            this.importedModulesMap = new HashMap();
        }
        if (this.libModule == null) {
            if (this.compState.moduleHandler == null) {
                this.compState.moduleHandler = new ModuleHandler();
            } else {
                this.compState.moduleHandler.resetScopedModuleNS();
            }
        } else {
            if (this.compState.moduleHandler == null) {
                this.compState.moduleHandler = new ModuleHandler();
            }
            if (this.compState.moduleHandler.containsModuleNSInScope(importDecl.targetNS)) {
                throw new XQException(this.msg.getMessage0("XQST0073"), this.msg.getMessage1("XQE-0241", importDecl.targetNS));
            }
        }
        LibraryModule libraryModule = this.compState.moduleHandler.getModule(importDecl.targetNS);
        if (libraryModule != null) {
            if (this.libModule == null) {
                this.importedModulesMap.put(importDecl.targetNS, libraryModule);
            } else {
                this.libModule.addImportedModule(libraryModule);
            }
            return;
        }
        this.compState.moduleHandler.addModuleNS(importDecl.targetNS);
        libraryModule = this.compState.getLibraryModule(importDecl.targetNS);
        if (libraryModule == null && importDecl.targetLoc == null) {
            throw new XQException(this.msg.getMessage0("XQST0059"));
        }
        EntityResolver entityResolver = this.compState.getModuleResolver();
        if (entityResolver == null) {
            entityResolver = new DefaultURIResolver("XQST0059");
        }
        InputSource inputSource = null;
        int n = importDecl.targetLoc.size();
        for (int i = 0; i < n; ++i) {
            String string = (String)importDecl.targetLoc.get(i);
            if (libraryModule != null && string.equals(libraryModule.getModuleId())) continue;
            try {
                inputSource = entityResolver.resolveEntity(null, string);
            }
            catch (Exception exception) {
                continue;
            }
            Reader reader = inputSource.getCharacterStream();
            PreparedXQuery preparedXQuery = new PreparedXQuery(this.compState, this.qs, reader);
            LibraryModule libraryModule2 = preparedXQuery.prepareLibraryModule();
            libraryModule2.setModuleId(string);
            if (!importDecl.targetNS.equals(libraryModule2.getTargetURI())) continue;
            this.checkModule(libraryModule2);
            if (libraryModule == null) {
                libraryModule = libraryModule2;
                continue;
            }
            libraryModule.append(libraryModule2);
        }
        if (libraryModule == null) {
            throw new XQException(this.msg.getMessage0("XQST0059"));
        }
        this.compState.moduleHandler.removeModuleFromScope(importDecl.targetNS);
        this.compState.moduleHandler.addModule(libraryModule);
        if (this.libModule != null) {
            this.libModule.addImportedModule(libraryModule);
        }
        this.importedModulesMap.put(importDecl.targetNS, libraryModule);
    }

    private void checkModule(LibraryModule libraryModule) {
        FunctionDefn functionDefn;
        Object object;
        HashMap hashMap = libraryModule.getPrologVars();
        if (hashMap != null) {
            object = hashMap.keySet().iterator();
            while (object.hasNext()) {
                QName qName = (QName)object.next();
                if (this.getVariable(qName) != null) {
                    throw new XQException(this.msg.getMessage0("XQST0049"), this.msg.getMessage1("XQE-0242", qName.toString()));
                }
                Object object2 = (Variable)hashMap.get(qName);
                functionDefn = ((Variable)object2).getDefinedType();
                this.checkTypeError0036((OXMLSequenceType)functionDefn);
            }
        }
        if ((object = libraryModule.getFunctionDefns()) != null) {
            for (Object object2 : ((HashMap)object).keySet()) {
                functionDefn = this.getFunctionDefn((FunctionId)object2);
                if (functionDefn != null) {
                    throw new XQException(this.msg.getMessage0("XQST0034"), this.msg.getMessage1("XQE-0230", functionDefn.getFunctionName()));
                }
                functionDefn = (FunctionDefn)((HashMap)object).get(object2);
                Variable[] variableArray = functionDefn.getParameters();
                if (variableArray != null) {
                    for (int i = 0; i < variableArray.length; ++i) {
                        OXMLSequenceType oXMLSequenceType = variableArray[i].getDefinedType();
                        this.checkTypeError0036(oXMLSequenceType);
                    }
                }
                OXMLSequenceType oXMLSequenceType = functionDefn.getReturnType();
                this.checkTypeError0036(oXMLSequenceType);
            }
        }
    }

    private void checkTypeError0036(OXMLSequenceType oXMLSequenceType) {
        if (oXMLSequenceType != null && !oXMLSequenceType.isSchemaValid(this.qs.getSchema())) {
            StringBuffer stringBuffer = new StringBuffer();
            oXMLSequenceType.toString(stringBuffer);
            throw new XQException(this.msg.getMessage0("XQST0036"), this.msg.getMessage1("XQE-0237", stringBuffer.toString()));
        }
    }

    private void compileSchemaImport() {
        ImportDecl importDecl = (ImportDecl)this.stk.popNode();
        this.compState.setSchemaImp(true);
        if (importDecl.isDefaultElementNS) {
            if (!this.qs.emptyDefaultElemNS()) {
                throw new XQException(this.msg.getMessage0("XQST0058"), this.msg.getMessage0("XQE-0225"));
            }
            this.qs.pushDefaultElemNS(importDecl.targetNS);
        } else if (importDecl.namespacePrefix != null) {
            if (importDecl.namespacePrefix.equalsIgnoreCase("xml") || importDecl.namespacePrefix.equalsIgnoreCase("xmlns")) {
                throw new XQException(this.msg.getMessage0("XQST0070"));
            }
            if (importDecl.targetNS.length() == 0) {
                throw new XQException(this.msg.getMessage0("XQST0057"));
            }
            if (this.qs.isPrefixBoundCurrentScope(importDecl.namespacePrefix)) {
                throw new XQException(this.qs.getMesg().getMessage0("XQST0033"), this.qs.getMesg().getMessage1("XQE-0226", importDecl.namespacePrefix));
            }
            this.qs.addNamespace(importDecl.namespacePrefix, importDecl.targetNS);
        }
        if (importDecl.targetLoc == null) {
            throw new XQException(this.msg.getMessage0("XQST0059"));
        }
        if (this.targetNSMap != null) {
            if (this.targetNSMap.containsKey(importDecl.targetNS)) {
                throw new XQException(this.msg.getMessage0("XQST0058"));
            }
        } else {
            this.targetNSMap = new HashMap();
        }
        this.targetNSMap.put(importDecl.targetNS, importDecl.targetNS);
        if (System.getProperty("java.vm.name").equals("JServer VM")) {
            if (this.conn == null) {
                throw new XQException(this.qs.getMesg().getMessage0("XQE-0507"));
            }
            String string = (String)importDecl.targetLoc.get(0);
            try {
                ServerSchemaResolver serverSchemaResolver = new ServerSchemaResolver(this.conn);
                InputSource inputSource = serverSchemaResolver.resolveEntity(null, string);
                if (inputSource == null) {
                    throw new XQException(this.msg.getMessage0("XQST0059"));
                }
                XSDBuilder xSDBuilder = this.compState.getXSDBuilder();
                xSDBuilder.setEntityResolver((EntityResolver)serverSchemaResolver);
                xSDBuilder.setError(new XMLError());
                XMLSchema xMLSchema = xSDBuilder.build(inputSource);
                if (!importDecl.targetNS.equals(xMLSchema.getSchemaTargetNS())) {
                    throw new XQException(this.msg.getMessage0("XQST0059"));
                }
                this.qs.setSchema(xMLSchema);
            }
            catch (XQException xQException) {
                throw xQException;
            }
            catch (Exception exception) {
                throw new XQException(this.qs.getMesg().getMessage0("XQST0012"), exception);
            }
            return;
        }
        int n = importDecl.targetLoc.size();
        URL uRL = null;
        for (int i = 0; i < n; ++i) {
            try {
                uRL = Utils.getURL((String)importDecl.targetLoc.get(i));
            }
            catch (Exception exception) {
                continue;
            }
            if (uRL != null) break;
        }
        if (uRL == null) {
            throw new XQException(this.msg.getMessage0("XQST0059"));
        }
        try {
            XSDBuilder xSDBuilder = this.compState.getXSDBuilder();
            XMLSchema xMLSchema = xSDBuilder.build(importDecl.targetNS, uRL);
            this.qs.setSchema(xMLSchema);
        }
        catch (XSDException xSDException) {
            throw new XQException(this.qs.getMesg().getMessage0("XQST0012"), (Exception)((Object)xSDException));
        }
    }

    private void compileValidateExpr() {
        Object[] objectArray = this.stk.closeNodeScope();
        ValidateExpr validateExpr = null;
        if (objectArray.length == 1) {
            validateExpr = new ValidateExpr((Expr)objectArray[0]);
        } else if (objectArray.length == 2) {
            String string = (String)objectArray[0];
            validateExpr = new ValidateExpr(string, (Expr)objectArray[1]);
        }
        this.stk.pushNode(validateExpr);
        this.compState.setOptimizerFlag(16);
    }

    private void compileOptionDecl() {
        ConstantExpr constantExpr = (ConstantExpr)this.stk.popNode();
        QxName qxName = (QxName)this.stk.popNode();
        this.endCompiling(compilingOption);
    }

    private void compilePragma() {
        this.stk.closeNodeScope();
        this.endCompiling(compilingPragma);
    }

    private void compileExtensionExpr() {
        Object[] objectArray = this.stk.closeNodeScope();
        if (objectArray == null) {
            throw new XQException(this.qs.getMesg().getMessage0("XQST0079"));
        }
        this.stk.pushNode(objectArray[0]);
    }

    public void setFloat(int n, float f) {
        this.getBindExpr(n).setFloat(this.qs, f);
    }

    public void setFloat(QName qName, float f) {
        this.getBindExpr(qName).setFloat(this.qs, f);
    }

    public void setInt(int n, int n2) {
        this.getBindExpr(n).setInt(this.qs, n2);
    }

    public void setInt(QName qName, int n) {
        this.getBindExpr(qName).setInt(this.qs, n);
    }

    public void setString(int n, String string) {
        this.getBindExpr(n).setString(this.qs, string);
    }

    public void setString(QName qName, String string) {
        this.getBindExpr(qName).setString(this.qs, string);
    }

    public void setBoolean(int n, boolean bl) {
        this.getBindExpr(n).setBoolean(this.qs, bl);
    }

    public void setBoolean(QName qName, boolean bl) {
        this.getBindExpr(qName).setBoolean(this.qs, bl);
    }

    public void setNode(int n, XMLNode xMLNode) {
        this.getBindExpr(n).setNode(this.qs, xMLNode);
    }

    public void setNode(QName qName, XMLNode xMLNode) {
        this.getBindExpr(qName).setNode(this.qs, xMLNode);
    }

    public void setItem(QName qName, OXMLItem oXMLItem) {
        this.getBindExpr(qName).setItem(this.qs, oXMLItem);
    }

    public void setSequence(QName qName, OXMLSequence oXMLSequence) {
        this.getBindExpr(qName).setSequence(oXMLSequence);
    }

    private BindExpr getBindExpr(QName qName) {
        BindExpr bindExpr = (BindExpr)this.bindHash.get(qName);
        if (bindExpr == null) {
            throw new XQException(this.msg.getMessage1("XQE-0222", XQueryUtils.getQNameString(qName)));
        }
        return bindExpr;
    }

    private BindExpr getBindExpr(int n) {
        BindExpr bindExpr = (BindExpr)this.bindHash.get(new QName(Integer.toString(n)));
        if (bindExpr == null) {
            throw new XQException(this.msg.getMessage1("XQE-0223", Integer.toString(n)));
        }
        return bindExpr;
    }

    public Expr getExecTree() {
        return this.retExpr;
    }

    public LibraryModule getLibraryModule() {
        return this.libModule;
    }

    private FunctionDefn getFunctionDefn(FunctionId functionId) {
        LibraryModule libraryModule;
        FunctionDefn functionDefn = this.qs.getFunctionDefn(functionId);
        if (functionDefn != null) {
            return functionDefn;
        }
        if (this.libModule != null) {
            functionDefn = this.libModule.getFunctionDefn(functionId);
        } else if (this.importedModulesMap != null && (libraryModule = (LibraryModule)this.importedModulesMap.get(functionId.getNamespaceURI())) != null) {
            functionDefn = libraryModule.getOwnFuncDefn(functionId);
        }
        return functionDefn;
    }

    private Variable getVariable(QName qName) {
        LibraryModule libraryModule;
        Variable variable = (Variable)this.sym.GetEntry(qName);
        if (variable != null) {
            return variable;
        }
        if (this.libModule != null) {
            variable = this.libModule.getPrologVar(qName);
        } else if (this.importedModulesMap != null && (libraryModule = (LibraryModule)this.importedModulesMap.get(qName.getNamespaceURI())) != null) {
            variable = libraryModule.getOwnPrologVar(qName);
        }
        return variable;
    }

    private void resolveFnCalls() {
        if (this.fcrList == null) {
            return;
        }
        int n = this.fcrList.size();
        for (int i = 0; i < n; ++i) {
            FnCallResolver fnCallResolver = (FnCallResolver)this.fcrList.get(i);
            FunctionDefn functionDefn = this.getFunctionDefn(fnCallResolver.id);
            if (functionDefn == null) {
                throw new XQException(this.msg.getMessage0("XPST0017"), this.msg.getMessage2("XQE-0234", fnCallResolver.qname, String.valueOf(fnCallResolver.id.getNumArgs())));
            }
            if (!functionDefn.isExternalFunction()) {
                fnCallResolver.fc.setFunctionDefn(functionDefn);
                continue;
            }
            SAXComp.typecheckFnArgs(functionDefn, fnCallResolver.fc.getFunctionDefn().getFunctionObj(), this.msg, this.compState.isLaxExternalFunctionDecl());
        }
    }

    private void addToFnCallRslvrList(FunctionId functionId, String string, FunctionCall functionCall) {
        if (this.fcrList == null) {
            this.fcrList = new LinkedList();
        }
        FnCallResolver fnCallResolver = new FnCallResolver(functionId, string, functionCall);
        this.fcrList.add(fnCallResolver);
    }

    private void normalizeFnExprs() {
        for (FunctionDefn functionDefn : this.qs.getFunctionDefns().values()) {
            if (functionDefn.isExternalFunction()) continue;
            functionDefn.getFunctionExpr().normalize();
        }
    }

    private void detectCircularity() {
        ArrayList arrayList = this.qs.getPrologVariables();
        if (arrayList != null) {
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                Expr expr = (Expr)arrayList.get(i);
                if (!(expr instanceof LetExpr)) continue;
                LetExpr letExpr = (LetExpr)expr;
                Expr expr2 = letExpr.getBoundExpr();
                CircularityDetectionVisitor circularityDetectionVisitor = new CircularityDetectionVisitor(letExpr, this.qs);
                expr2.acceptVisitor(circularityDetectionVisitor);
            }
        }
    }

    private boolean isXMLType(Connection connection, String string) {
        boolean bl = false;
        String string2 = "select value(p) from " + string + " p ";
        ResultSet resultSet = null;
        PreparedStatement preparedStatement = null;
        try {
            if (connection == null) {
                throw new XQException(this.qs.getMesg().getMessage0("XQE-0507"));
            }
            preparedStatement = connection.prepareStatement(string2);
            resultSet = preparedStatement.executeQuery();
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            if (resultSetMetaData.getColumnType(1) == 2007 && resultSetMetaData.getColumnTypeName(1).equals("SYS.XMLTYPE")) {
                bl = true;
            }
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (SQLException sQLException2) {
                // empty catch block
            }
        }
        return bl;
    }

    public QName[] getAllExternalVariables() {
        int n = this.externalVarNameList.size();
        QName[] qNameArray = new QName[n];
        for (int i = 0; i < n; ++i) {
            qNameArray[i] = (QName)this.externalVarNameList.get(i);
        }
        return qNameArray;
    }

    public QName[] getAllUnboundExternalVariables() {
        QName[] qNameArray;
        int n;
        int n2 = this.externalVarNameList.size();
        ArrayList<QName[]> arrayList = new ArrayList<QName[]>(n2);
        for (n = 0; n < n2; ++n) {
            qNameArray = (QName[])this.externalVarNameList.get(n);
            BindExpr bindExpr = (BindExpr)this.bindHash.get(qNameArray);
            if (bindExpr.isBindValSet()) continue;
            arrayList.add(qNameArray);
        }
        n = arrayList.size();
        qNameArray = new QName[n];
        for (int i = 0; i < n; ++i) {
            qNameArray[i] = (QName)arrayList.get(i);
        }
        return qNameArray;
    }

    public BindExpr getStaticVariableExpr(QName qName) {
        return (BindExpr)this.bindHash.get(qName);
    }

    private boolean isPrologFlagSet(int n) {
        return (this.prologFlag & n) == n;
    }

    private void setPrologFlag(int n) {
        this.prologFlag |= n;
    }

    private boolean isCompiling(int n) {
        return this.compilingFlag == n;
    }

    private void compiling(int n) {
        this.compilingFlag = n;
    }

    private void endCompiling(int n) {
        this.compilingFlag = 0;
    }
}

