/*
 * Decompiled with CFR 0.152.
 */
package oracle.xquery.comp;

import java.io.PrintStream;
import java.util.Stack;
import oracle.xquery.XQException;
import oracle.xquery.comp.PageBuf;
import oracle.xquery.parser.XQXGen;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public final class SQLComp
extends DefaultHandler {
    private PageBuf pageBuf = new PageBuf();
    private Stack stk;
    boolean debug;

    private SqlSAXHdlr getHdlr(String string) {
        if (string.equals("subquery") || string.equals("scalarSubquery") || string.equals("fromSubquery")) {
            return new Query(this.pageBuf);
        }
        if (string.equals("existsSubquery")) {
            return new ExistsSubquery(this.pageBuf);
        }
        if (string.equals("multisetSubquery")) {
            return new MultisetQuery(this.pageBuf);
        }
        if (string.equals("lateralSubquery")) {
            return new LateralSubquery(this.pageBuf);
        }
        if (string.equals("setOperation")) {
            return new SetOperation(this.pageBuf);
        }
        if (string.equals("selectList")) {
            return new SelectList(this.pageBuf);
        }
        if (string.equals("fromList")) {
            return new FromList(this.pageBuf);
        }
        if (string.equals("where")) {
            return new Where(this.pageBuf);
        }
        if (string.equals("orderByList")) {
            return new OrderByList(this.pageBuf);
        }
        if (string.equals("orderByItem")) {
            return new OrderByItem(this.pageBuf);
        }
        if (string.equals("constant")) {
            return new Constant(this.pageBuf);
        }
        if (string.equals("function")) {
            return new Function(this.pageBuf);
        }
        if (string.equals("xmlElem")) {
            return new XMLElem(this.pageBuf);
        }
        if (string.equals("xmlAttributesList")) {
            return new XMLAttributes(this.pageBuf);
        }
        if (string.equals("alias") || string.equals("simpleIdentifier") || string.equals("xmlElemName")) {
            return new SimpleIdentifier(this.pageBuf);
        }
        if (string.equals("tableName") || string.equals("identifier") || string.equals("variable") || string.equals("castType")) {
            return new Identifier(this.pageBuf);
        }
        if (string.equals("tableExpr")) {
            return new TableExpr(this.pageBuf);
        }
        if (string.equals("cast")) {
            return new Cast(this.pageBuf);
        }
        if (string.equals("case")) {
            return new Case(this.pageBuf);
        }
        if (string.equals("when") || string.equals("then") || string.equals("else")) {
            return new WhenThenElse(this.pageBuf);
        }
        if (string.equals("selectItem") || string.equals("fromItem") || string.equals("simpleQuery") || string.equals("query") || string.equals("xmlAttribute")) {
            return new SqlSAXHdlr(this.pageBuf);
        }
        throw new XQException("Unknown tag: " + string);
    }

    private static String getAttributeValue(Attributes attributes, String string) {
        String string2 = XQXGen.getAttrValue(attributes, string);
        return string2 == null ? "" : string2;
    }

    public void display(PrintStream printStream) {
        this.pageBuf.display(printStream);
    }

    public SQLComp() {
        this.pageBuf.prettyPrintOff();
        this.stk = new Stack();
        this.debug = false;
    }

    public void setDebug() {
        this.debug = true;
    }

    public void reset() {
        this.pageBuf.reset();
        this.stk.clear();
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) {
        StackNode stackNode;
        int n = this.pageBuf.getIndentLevel();
        StackNode stackNode2 = stackNode = this.stk.empty() ? null : (StackNode)this.stk.peek();
        if (stackNode != null) {
            stackNode.getHdlr().startChild(string2, attributes);
        }
        if (this.debug) {
            System.out.println("<" + string2 + ">");
        }
        SqlSAXHdlr sqlSAXHdlr = this.getHdlr(string2);
        sqlSAXHdlr.startElement(string2, attributes);
        this.pageBuf.setIndentLevel();
        StackNode stackNode3 = new StackNode(sqlSAXHdlr, n, string2);
        this.stk.push(stackNode3);
    }

    public void characters(char[] cArray, int n, int n2) {
        StackNode stackNode = (StackNode)this.stk.peek();
        SqlSAXHdlr sqlSAXHdlr = stackNode.getHdlr();
        if (this.debug) {
            System.out.println(new String(cArray, n, n2));
        }
        sqlSAXHdlr.characters(cArray, n, n2);
    }

    public void endElement(String string, String string2, String string3) {
        StackNode stackNode;
        StackNode stackNode2 = (StackNode)this.stk.pop();
        SqlSAXHdlr sqlSAXHdlr = stackNode2.getHdlr();
        StackNode stackNode3 = stackNode = this.stk.empty() ? null : (StackNode)this.stk.peek();
        if (this.debug) {
            System.out.println("</" + string2 + ">");
            if (sqlSAXHdlr.getClass() != this.getHdlr(string2).getClass()) {
                throw new XQException("foo!");
            }
        }
        this.pageBuf.setIndentLevel(stackNode2.getIndentLevel());
        sqlSAXHdlr.endElement(string2);
        if (stackNode != null) {
            stackNode.getHdlr().endChild(string2);
        }
    }

    public void endDocument() {
        this.pageBuf.newline();
    }

    private static class StackNode {
        int indentLevel;
        String name;
        SqlSAXHdlr hdlr;

        StackNode(SqlSAXHdlr sqlSAXHdlr, int n, String string) {
            this.init(sqlSAXHdlr, n);
            this.name = string;
        }

        void init(SqlSAXHdlr sqlSAXHdlr, int n) {
            this.hdlr = sqlSAXHdlr;
            this.indentLevel = n;
        }

        SqlSAXHdlr getHdlr() {
            return this.hdlr;
        }

        void setHdlr(SqlSAXHdlr sqlSAXHdlr) {
            this.hdlr = sqlSAXHdlr;
        }

        int getIndentLevel() {
            return this.indentLevel;
        }
    }

    public static class WhenThenElse
    extends SqlSAXHdlr {
        public WhenThenElse(PageBuf pageBuf) {
            super(pageBuf);
        }

        public void startElement(String string, Attributes attributes) {
            if (string.equals("when")) {
                this.pageBuf.append(" when ");
            } else if (string.equals("then")) {
                this.pageBuf.append(" then ");
            } else if (string.equals(" else")) {
                this.pageBuf.append(" else ");
            }
        }
    }

    public static class Case
    extends SqlSAXHdlr {
        public Case(PageBuf pageBuf) {
            super(pageBuf);
        }

        public void startElement(String string, Attributes attributes) {
            this.pageBuf.append("case ");
        }

        public void endElement(String string) {
            this.pageBuf.append(" end");
        }
    }

    public static class TableExpr
    extends SqlSAXHdlr {
        public TableExpr(PageBuf pageBuf) {
            super(pageBuf);
        }

        public void startElement(String string, Attributes attributes) {
            this.pageBuf.append("table(");
        }

        public void endElement(String string) {
            this.pageBuf.append(")");
        }
    }

    public static class Cast
    extends SqlSAXHdlr {
        private int counter;

        public Cast(PageBuf pageBuf) {
            super(pageBuf);
        }

        public void startElement(String string, Attributes attributes) {
            this.pageBuf.append("cast(");
            this.counter = 0;
        }

        public void startChild(String string, Attributes attributes) {
            if (this.counter++ != 0) {
                this.pageBuf.append(" as ");
            }
        }

        public void endElement(String string) {
            this.pageBuf.append(")");
        }
    }

    public static class SetOperation
    extends SqlSAXHdlr {
        int counter = 0;
        String name;

        public SetOperation(PageBuf pageBuf) {
            super(pageBuf);
        }

        public void startElement(String string, Attributes attributes) {
            String string2 = SQLComp.getAttributeValue(attributes, "all");
            this.name = SQLComp.getAttributeValue(attributes, "name");
            if (string2 != null && string2.equals("true")) {
                this.name = this.name + " all";
            }
            this.pageBuf.append("(");
        }

        public void startChild(String string, Attributes attributes) {
            if (this.counter++ != 0) {
                this.pageBuf.newline();
                this.pageBuf.append(this.name);
                this.pageBuf.newline();
            }
        }

        public void endElement(String string) {
            this.pageBuf.append(")");
            this.pageBuf.newline();
        }
    }

    public static class ExistsSubquery
    extends Query {
        public ExistsSubquery(PageBuf pageBuf) {
            super(pageBuf, "exists");
        }
    }

    public static class LateralSubquery
    extends Query {
        public LateralSubquery(PageBuf pageBuf) {
            super(pageBuf, "lateral");
        }
    }

    public static class MultisetQuery
    extends Query {
        public MultisetQuery(PageBuf pageBuf) {
            super(pageBuf, "multiset");
        }
    }

    public static class Query
    extends SqlSAXHdlr {
        String queryType;

        public Query(PageBuf pageBuf) {
            super(pageBuf);
            this.queryType = null;
        }

        public Query(PageBuf pageBuf, String string) {
            super(pageBuf);
            this.queryType = string;
        }

        public void startElement(String string, Attributes attributes) {
            if (this.queryType != null) {
                this.pageBuf.append(this.queryType);
            }
            this.pageBuf.append("(");
        }

        public void endElement(String string) {
            this.pageBuf.append(")");
        }
    }

    public static class Identifier
    extends SqlSAXHdlr {
        int counter;

        public Identifier(PageBuf pageBuf) {
            super(pageBuf);
        }

        public void startElement(String string, Attributes attributes) {
            this.counter = 0;
        }

        public void startChild(String string) {
            if (this.counter++ != 0) {
                this.pageBuf.append(".");
            }
        }
    }

    public static class SimpleIdentifier
    extends SqlSAXHdlr {
        String name;

        public SimpleIdentifier(PageBuf pageBuf) {
            super(pageBuf);
        }

        public void startElement(String string, Attributes attributes) {
            this.name = new String();
        }

        public void characters(char[] cArray, int n, int n2) {
            this.name = this.name + new String(cArray, n, n2);
        }

        public void endElement(String string) {
            if (string.equals("alias")) {
                this.pageBuf.append(" ");
            }
            this.pageBuf.append('\"');
            this.pageBuf.append(this.name);
            this.pageBuf.append('\"');
        }
    }

    public static class Constant
    extends SqlSAXHdlr {
        String datatype;
        String value;

        public Constant(PageBuf pageBuf) {
            super(pageBuf);
        }

        public void startElement(String string, Attributes attributes) {
            this.datatype = SQLComp.getAttributeValue(attributes, "datatype");
            if (this.datatype == null || !this.datatype.equals("number") && !this.datatype.equals("varchar")) {
                throw new XQException("Unknown datatype " + this.datatype);
            }
            this.value = new String();
        }

        public void characters(char[] cArray, int n, int n2) {
            this.value = this.value + new String(cArray, n, n2);
        }

        public void endElement(String string) {
            if (this.datatype.equals("number")) {
                this.pageBuf.append(this.value);
            } else if (this.datatype.equals("varchar")) {
                this.pageBuf.append("'" + this.value + "'");
            }
        }
    }

    public static class XMLAttributes
    extends Function {
        public XMLAttributes(PageBuf pageBuf) {
            super(pageBuf);
        }

        public void startElement(String string, Attributes attributes) {
            this.pageBuf.append("xmlattributes(");
        }
    }

    public static class XMLElem
    extends Function {
        public XMLElem(PageBuf pageBuf) {
            super(pageBuf);
        }

        public void startElement(String string, Attributes attributes) {
            this.pageBuf.append("xmlelement(");
        }
    }

    public static class Function
    extends SqlSAXHdlr {
        private boolean infix = false;
        private String name = "";
        private int counter = 0;

        public Function(PageBuf pageBuf) {
            super(pageBuf);
        }

        public void startElement(String string, Attributes attributes) {
            this.infix = SQLComp.getAttributeValue(attributes, "infix").equals("true");
            this.name = SQLComp.getAttributeValue(attributes, "name");
            if (!this.infix) {
                this.pageBuf.append(this.name);
            }
            this.pageBuf.append("(");
        }

        public void startChild(String string, Attributes attributes) {
            if (this.counter++ != 0) {
                if (this.infix) {
                    this.pageBuf.append(" " + this.name + " ");
                } else {
                    this.pageBuf.append(", ");
                }
            }
        }

        public void endElement(String string) {
            this.pageBuf.append(")");
        }
    }

    public static class OrderByItem
    extends SqlSAXHdlr {
        boolean desc = false;

        public OrderByItem(PageBuf pageBuf) {
            super(pageBuf);
        }

        public void startElement(String string, Attributes attributes) {
            this.desc = SQLComp.getAttributeValue(attributes, "orderSpec").equals("descending");
        }

        public void endElement(String string) {
            if (this.desc) {
                this.pageBuf.append(" descending");
            }
        }
    }

    public static class OrderByList
    extends SqlSAXHdlr {
        private int counter;

        public OrderByList(PageBuf pageBuf) {
            super(pageBuf);
        }

        public void startElement(String string, Attributes attributes) {
            this.pageBuf.newline();
            this.pageBuf.append("order by ");
            this.pageBuf.setIndentLevel();
            this.counter = 0;
        }

        public void startChild(String string, Attributes attributes) {
            if (this.counter++ != 0) {
                this.pageBuf.append(", ");
            }
        }
    }

    public static class Where
    extends SqlSAXHdlr {
        public Where(PageBuf pageBuf) {
            super(pageBuf);
        }

        public void startElement(String string, Attributes attributes) {
            this.pageBuf.newline();
            this.pageBuf.append("where ");
            this.pageBuf.setIndentLevel();
        }
    }

    public static class FromList
    extends SqlSAXHdlr {
        private int counter;

        public FromList(PageBuf pageBuf) {
            super(pageBuf);
        }

        public void startElement(String string, Attributes attributes) {
            this.pageBuf.newline();
            this.pageBuf.append("from ");
            this.pageBuf.setIndentLevel();
            this.counter = 0;
        }

        public void startChild(String string, Attributes attributes) {
            if (this.counter++ != 0) {
                this.pageBuf.append(", ");
                this.pageBuf.newline();
            }
        }
    }

    public static class SelectList
    extends SqlSAXHdlr {
        private int counter;

        public SelectList(PageBuf pageBuf) {
            super(pageBuf);
        }

        public void startElement(String string, Attributes attributes) {
            this.pageBuf.append("select ");
            if (SQLComp.getAttributeValue(attributes, "selectQuantifier").equals("distinct-values")) {
                this.pageBuf.append("distinct-values ");
            }
            if (SQLComp.getAttributeValue(attributes, "selectStar").equals("true")) {
                this.pageBuf.append("* ");
            }
            this.pageBuf.setIndentLevel();
            this.counter = 0;
        }

        public void startChild(String string, Attributes attributes) {
            if (this.counter++ != 0) {
                this.pageBuf.append(", ");
            }
        }
    }

    public static class SqlSAXHdlr {
        PageBuf pageBuf;

        SqlSAXHdlr(PageBuf pageBuf) {
            this.pageBuf = pageBuf;
        }

        public void startElement(String string, Attributes attributes) {
        }

        public void endElement(String string) {
        }

        public void characters(char[] cArray, int n, int n2) {
        }

        public void startChild(String string, Attributes attributes) {
        }

        public void endChild(String string) {
        }
    }
}

