/*
 * Decompiled with CFR 0.152.
 */
package oracle.xquery.exec;

import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xquery.XQException;
import oracle.xquery.exec.Expr;
import oracle.xquery.exec.ExprResultIterator;
import oracle.xquery.exec.QueryState;
import oracle.xquery.exec.Visitor;
import oracle.xquery.exec.XQueryUtils;
import oracle.xquery.parser.XQXGen;

public class Case
extends Expr {
    public Case(Expr expr, Expr expr2, Expr expr3) {
        int n = expr3 == null ? 2 : 3;
        Expr[] exprArray = new Expr[n];
        exprArray[0] = expr;
        exprArray[1] = expr2;
        if (expr3 != null) {
            exprArray[2] = expr3;
        }
        this.setup(exprArray);
    }

    public Case() {
    }

    public void toSql(XQXGen xQXGen) {
        xQXGen.startElement("case", null);
        for (int i = 0; i < this.kids.length; i += 2) {
            xQXGen.startElement("when", null);
            this.kids[i].toSql(xQXGen);
            xQXGen.endElement("when");
            xQXGen.startElement("then", null);
            this.kids[i + 1].toSql(xQXGen);
            xQXGen.endElement("then");
        }
        if (this.kids.length % 2 == 1) {
            xQXGen.startElement("else", null);
            this.kids[this.kids.length - 1].toSql(xQXGen);
            xQXGen.endElement("else");
        }
        xQXGen.endElement("case");
    }

    public int getDatatype() {
        int n;
        int n2 = 0;
        for (n = 0; n < this.kids.length; n += 2) {
            n2 = XQueryUtils.getGeneralizedType(n2, this.kids[n].getDatatype());
        }
        if (n % 2 == 0) {
            n2 = XQueryUtils.getGeneralizedType(n2, this.kids[this.kids.length - 1].getDatatype());
        }
        return n2;
    }

    public XMLNode toXML() {
        XMLElement xMLElement = (XMLElement)Case.getDoc().createElement("Case");
        this.toXMLKids((XMLNode)xMLElement);
        return xMLElement;
    }

    private int findBranch(QueryState queryState) {
        int n;
        OXMLSequence oXMLSequence = this.kids[0].Evaluate(queryState);
        if (oXMLSequence.getEffectiveBooleanValue()) {
            n = 1;
        } else if (this.kids.length == 2) {
            n = -1;
        } else if (this.kids.length == 3) {
            n = 2;
        } else {
            throw new XQException(queryState.getMesg().getMessage1("XQE-0001", "Case-findBranch"));
        }
        return n;
    }

    public OXMLSequence Evaluate(QueryState queryState) {
        int n = this.findBranch(queryState);
        OXMLSequence oXMLSequence = n == -1 ? queryState.createSequence() : this.kids[n].Evaluate(queryState);
        return oXMLSequence;
    }

    public ExprResultIterator getIterator(QueryState queryState) {
        int n = this.findBranch(queryState);
        if (n == -1) {
            return null;
        }
        return this.kids[n].getIterator(queryState);
    }

    public void acceptVisitor(Visitor visitor) {
        visitor.visitConditionalExpr(this);
    }
}

