/*
 * Decompiled with CFR 0.152.
 */
package oracle.xquery.exec;

import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.xqxp.datamodel.OXMLItem;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xqxp.datamodel.OXMLSequenceType;
import oracle.xquery.exec.ConvertXML;
import oracle.xquery.exec.Expr;
import oracle.xquery.exec.OXQueryItem;
import oracle.xquery.exec.QueryState;
import oracle.xquery.exec.Visitor;
import oracle.xquery.exec.XQueryUtils;
import oracle.xquery.parser.XQXGen;

public class ConstantExpr
extends Expr {
    private OXMLItem value;
    private OXMLItem compValue = new OXQueryItem();

    public XMLNode toXML() {
        XMLElement xMLElement = (XMLElement)ConstantExpr.getDoc().createElement("ConstantExpr");
        xMLElement.setAttribute("ebv", this.getEBVString());
        xMLElement.setAttribute("value", this.compValue.getLexicalValue());
        return xMLElement;
    }

    public ConvertXML fromXML(XMLElement xMLElement) {
        this.compValue.setString(OXMLSequenceType.TSTRING, xMLElement.getAttribute("value"));
        return this;
    }

    public void getStrRep(StringBuffer stringBuffer) {
        if (this.compValue.getPrimitiveType() == 1) {
            stringBuffer.append("\"" + this.compValue.getLexicalValue() + "\"");
        } else {
            stringBuffer.append(this.compValue.getLexicalValue());
        }
    }

    public String getStrRep() {
        if (this.compValue.getPrimitiveType() == 1) {
            return "\"" + this.compValue.getLexicalValue() + "\"";
        }
        return this.compValue.getLexicalValue();
    }

    public static void toSql(XQXGen xQXGen, String string) {
        xQXGen.startElement("constant", XQXGen.createAttrs("datatype", "varchar"));
        xQXGen.characters(string);
        xQXGen.endElement("constant");
    }

    public static void toSql(XQXGen xQXGen, float f) {
        xQXGen.startElement("constant", XQXGen.createAttrs("datatype", "number"));
        xQXGen.characters(String.valueOf(f));
        xQXGen.endElement("constant");
    }

    public static void toSql(XQXGen xQXGen, int n) {
        xQXGen.startElement("constant", XQXGen.createAttrs("datatype", "number"));
        xQXGen.characters(String.valueOf(n));
        xQXGen.endElement("constant");
    }

    public void toSql(XQXGen xQXGen) {
        ((OXQueryItem)this.compValue).toSql(xQXGen);
    }

    public int getDatatype() {
        return this.compValue.getPrimitiveType();
    }

    public ConstantExpr() {
    }

    public ConstantExpr(String string) {
        this(string, 1);
        this.staticType = OXMLSequenceType.TSTRING;
        this.setEBV(string != null && string.length() != 0);
    }

    public ConstantExpr(int n) {
        this();
        this.compValue.setInt(OXMLSequenceType.TINTEGER, n);
        this.staticType = OXMLSequenceType.TINTEGER;
        this.setEBV(n != 0);
    }

    public ConstantExpr(String string, int n) {
        this();
        this.compValue.setString(OXMLSequenceType.TSTRING, string);
        switch (n) {
            case 22: {
                XQueryUtils.convert(this.compValue, OXMLSequenceType.TINTEGER);
                this.staticType = OXMLSequenceType.TINTEGER;
                this.setEBV(this.compValue.getInt() != 0);
                break;
            }
            case 5: {
                XQueryUtils.convert(this.compValue, OXMLSequenceType.TDECIMAL);
                this.staticType = OXMLSequenceType.TDECIMAL;
                this.setEBV(!this.compValue.isZero());
                break;
            }
            case 4: {
                XQueryUtils.convert(this.compValue, OXMLSequenceType.TDOUBLE);
                this.staticType = OXMLSequenceType.TDOUBLE;
                this.setEBV(!string.equals("NaN") && !this.compValue.isZero());
                break;
            }
            case 1: {
                this.staticType = OXMLSequenceType.TSTRING;
                this.setEBV(string != null && string.length() != 0);
            }
        }
    }

    public String getValue() {
        return this.compValue.getString();
    }

    public OXMLSequence Evaluate(QueryState queryState) {
        if (this.value == null) {
            this.value = queryState.createItem();
            this.value.copyItem(this.compValue);
        }
        return queryState.createSequence(this.value);
    }

    public int getPositionTest() {
        return XQueryUtils.getIntPositionValue(this.compValue);
    }

    int getPositionTestExact() {
        return this.getPositionTest();
    }

    public void acceptVisitor(Visitor visitor) {
        visitor.visitLiteral(this);
    }
}

