/*
 * Decompiled with CFR 0.152.
 */
package oracle.xquery.exec;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import oracle.jdbc.OracleDriver;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.schema.XSDBuilder;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.scalable.PageManager;
import oracle.xml.xqxp.datamodel.OXMLItem;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xqxp.datamodel.OXMLSequenceType;
import oracle.xquery.ThreadSerialNum;
import oracle.xquery.XQException;
import oracle.xquery.XQMesg;
import oracle.xquery.exec.ConvertXML;
import oracle.xquery.exec.Expr;
import oracle.xquery.exec.ExprResultIterator;
import oracle.xquery.exec.OptimizeContext;
import oracle.xquery.exec.QueryState;
import oracle.xquery.exec.ServerSchemaResolver;
import oracle.xquery.exec.Visitor;
import oracle.xquery.exec.XQueryUtils;
import oracle.xquery.parser.XQXGen;
import org.xml.sax.InputSource;

public class Document
extends Expr {
    private String funcName;
    private Connection dconn;
    private PreparedStatement stmt = null;
    private PreparedStatement stmt2 = null;
    private String localFileName;
    private File file;
    private String baseuri;

    String getFunctionName() {
        return this.funcName;
    }

    public XMLNode toXML() {
        XMLElement xMLElement = (XMLElement)Document.getDoc().createElement("Document");
        xMLElement.setAttribute("functionName", this.funcName);
        if (this.baseuri != null) {
            xMLElement.setAttribute("baseuri", this.baseuri);
        }
        this.toXMLKids((XMLNode)xMLElement);
        return xMLElement;
    }

    public ConvertXML fromXML(XMLElement xMLElement) {
        String string;
        this.funcName = string = xMLElement.getAttribute("functionName");
        String string2 = xMLElement.getAttribute("baseuri");
        if (string2 != null) {
            this.baseuri = string2;
        }
        this.fromXMLKids(xMLElement);
        return this;
    }

    public void toSql(XQXGen xQXGen) {
        xQXGen.startElement("function", XQXGen.createAttrs("name", "document"));
        xQXGen.endElement("function");
    }

    public Document(String string, String string2, Expr expr) {
        super(expr);
        this.funcName = string;
        this.baseuri = string2;
        if (System.getProperty("java.vm.name").equals("JServer VM")) {
            try {
                this.dconn = new OracleDriver().defaultConnection();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private XMLDocument getXDBDocument(XMLSchema xMLSchema, PageManager pageManager) throws Exception {
        this.stmt = this.dconn.prepareStatement("select SYS_XQGETCONTENT(res).getclobval()  from resource_view e where equals_path(res,?) = 1");
        this.stmt.setString(1, this.localFileName);
        ResultSet resultSet = this.stmt.executeQuery();
        if (!resultSet.next()) {
            return null;
        }
        Clob clob = resultSet.getClob(1);
        Reader reader = clob.getCharacterStream();
        XMLSchema xMLSchema2 = xMLSchema != null ? xMLSchema : null;
        InputSource inputSource = new InputSource(reader);
        inputSource.setSystemId(this.localFileName);
        return this.getDocument(inputSource, xMLSchema2, true, pageManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XMLSchema getXDBSchema(String string) throws Exception {
        XMLSchema xMLSchema = null;
        try {
            Clob clob;
            this.stmt2 = this.dconn.prepareStatement("select extract(schema, '/').getclobval() from all_xml_schemas s, resource_view e where instr(extractvalue(res, '/Resource/SchemaElement'), s.schema_url) = 1 and equals_path(e.res, ?) = 1");
            this.stmt2.setString(1, string);
            ResultSet resultSet = this.stmt2.executeQuery();
            Reader reader = null;
            if (resultSet.next() && (clob = resultSet.getClob(1)).length() != 0L) {
                reader = clob.getCharacterStream();
            }
            if (reader != null) {
                clob = new XSDBuilder();
                clob.setEntityResolver(new ServerSchemaResolver(this.dconn));
                xMLSchema = clob.build(reader, null);
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (this.stmt2 != null) {
                    this.stmt2.close();
                }
                this.stmt2 = null;
            }
            catch (Exception exception) {}
        }
        return xMLSchema;
    }

    public Document() {
    }

    public Expr optimize(OptimizeContext optimizeContext) {
        if (optimizeContext != null) {
            optimizeContext.setXqPushdown(false);
        }
        return super.optimize(optimizeContext);
    }

    public OXMLSequence Evaluate(QueryState queryState) {
        return this.EvaluateUsingIterator(queryState);
    }

    public ExprResultIterator getIterator(QueryState queryState) {
        if (this.funcName.equals("collection")) {
            return new CollectionIterator(this, queryState);
        }
        if (this.funcName.equals("doc")) {
            return new DocumentIterator(this, queryState);
        }
        return new DocAvailableIterator(this, queryState);
    }

    private void close() {
        try {
            if (this.stmt != null) {
                this.stmt.close();
            }
            if (this.stmt2 != null) {
                this.stmt2.close();
            }
            this.stmt = null;
            this.stmt2 = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initFileName(QueryState queryState) {
        OXMLSequence oXMLSequence = this.kids[0].Evaluate(queryState);
        OXMLItem oXMLItem = XQueryUtils.getEmptyOrSingleItem(oXMLSequence);
        if (oXMLItem == null) {
            if (this.funcName.equals("collection")) {
                throw new XQException(queryState.getMesg().getMessage0("FODC0002"));
            }
            return;
        }
        OXMLSequence oXMLSequence2 = oXMLItem.atomize();
        this.localFileName = XQueryUtils.getSingleItem(oXMLSequence2).getString();
        queryState.returnSequence(oXMLSequence2);
        if (this.localFileName == null || this.localFileName.length() == 0) {
            throw new XQException(queryState.getMesg().getMessage1("XQE-0231", this.funcName));
        }
        URI uRI = this.resolveURI(this.localFileName);
        String string = uRI.getScheme();
        if (string != null && !string.equals("file")) {
            this.localFileName = null;
            return;
        }
        this.localFileName = uRI.toString();
        this.file = string == null ? new File(this.localFileName) : new File(uRI);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XMLDocument evaluateDoc(QueryState queryState) throws Exception {
        Object object;
        if (this.localFileName == null) {
            return null;
        }
        XMLDocument xMLDocument = queryState.getDocument(this.localFileName);
        if (xMLDocument != null) {
            return xMLDocument;
        }
        PageManager pageManager = null;
        String string = null;
        if (queryState.getLazyDom()) {
            object = System.getProperty("file.separator");
            int n = this.localFileName.lastIndexOf((String)object);
            string = this.localFileName.substring(n + 1) + ThreadSerialNum.getNextNum();
            pageManager = queryState.getPageManagerPool().getPageManager(string);
        }
        if (this.dconn != null) {
            xMLDocument = this.getXDBDocument(queryState.getSchema(), pageManager);
        } else {
            if (!this.file.exists()) {
                throw new XQException(queryState.getMesg().getMessage0("FODC0002"), queryState.getMesg().getMessage1("XQE-0508", this.localFileName));
            }
            if (!this.file.isFile()) {
                throw new XQException(queryState.getMesg().getMessage0("FODC0002"), queryState.getMesg().getMessage1("XQE-0509", this.localFileName));
            }
            object = null;
            try {
                object = new FileInputStream(this.file);
                InputSource inputSource = new InputSource((InputStream)object);
                inputSource.setSystemId(this.file.getAbsolutePath());
                xMLDocument = this.getDocument(inputSource, queryState.getSchema(), false, pageManager);
            }
            finally {
                if (object != null) {
                    try {
                        ((InputStream)object).close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        if (xMLDocument != null) {
            queryState.addToDocumentHT(this.localFileName, xMLDocument);
            if (pageManager != null) {
                queryState.addToPgmHT(string, pageManager);
            }
        }
        return xMLDocument;
    }

    private ResultSet initEvaluateXDBCollection(QueryState queryState) throws Exception {
        if (this.localFileName == null) {
            return null;
        }
        this.stmt = this.dconn.prepareStatement("select SYS_XQGETCONTENT(res).getclobval(),  any_path  from resource_view e where under_path(res, 1, ?) = 1");
        this.stmt.setString(1, this.localFileName);
        ResultSet resultSet = this.stmt.executeQuery();
        return resultSet;
    }

    private File[] initEvaluateLocalCollection(QueryState queryState) {
        if (this.file == null) {
            return null;
        }
        if (!this.file.exists()) {
            throw new XQException(queryState.getMesg().getMessage0("FODC0004"), queryState.getMesg().getMessage1("XQE-0508", this.localFileName));
        }
        if (!this.file.isDirectory()) {
            throw new XQException(queryState.getMesg().getMessage0("FODC0004"), queryState.getMesg().getMessage1("XQE-0510", this.localFileName));
        }
        File[] fileArray = this.file.listFiles(new FileOnlyFilter());
        return fileArray;
    }

    private PageManager getPageManager(QueryState queryState) {
        PageManager pageManager = null;
        if (queryState.getLazyDom()) {
            String string = System.getProperty("file.separator");
            int n = this.localFileName.lastIndexOf(string);
            String string2 = this.localFileName.substring(n + 1) + "_file" + ThreadSerialNum.getNextNum();
            pageManager = queryState.getPageManagerPool().getPageManager(string2);
            queryState.addToPgmHT(string2, pageManager);
        }
        return pageManager;
    }

    private XMLDocument getDocument(InputSource inputSource, XMLSchema xMLSchema, boolean bl, PageManager pageManager) throws Exception {
        String string = inputSource.getSystemId();
        DOMParser dOMParser = new DOMParser();
        dOMParser.setPreserveWhitespace(false);
        if (pageManager != null) {
            dOMParser.setAttribute("oracle.xml.parser.DOMParser.PartialDOM", (Object)Boolean.TRUE);
            dOMParser.setAttribute("oracle.xml.parser.DOMParser.PageManager", (Object)pageManager);
        }
        if (xMLSchema != null) {
            dOMParser.setXMLSchema((Object)xMLSchema);
            dOMParser.setValidationMode(3);
            dOMParser.setAttribute("oracle.xml.parser.DOMParser.SchemaPSVI", (Object)Boolean.TRUE);
        }
        dOMParser.parse(inputSource);
        return dOMParser.getDocument();
    }

    private URI resolveURI(String string) {
        try {
            URI uRI = new URI(string);
            if (this.baseuri == null) {
                return uRI;
            }
            if (uRI.isAbsolute()) {
                return uRI;
            }
            URI uRI2 = new URI(this.baseuri);
            URI uRI3 = uRI2.resolve(uRI);
            return uRI3;
        }
        catch (URISyntaxException uRISyntaxException) {
            String string2 = this.funcName.equals("doc") ? "FODC0005" : "FODC0002";
            throw new XQException(XQMesg.getInstance().getMessage0(string2), uRISyntaxException);
        }
    }

    public void acceptVisitor(Visitor visitor) {
        visitor.visitDocument(this);
    }

    class CollectionIterator
    implements ExprResultIterator {
        Document myExpr;
        boolean eof;
        QueryState qryState;
        ResultSet rset;
        File[] cFiles;
        int pos;
        PageManager pgm;

        public CollectionIterator(Document document2, QueryState queryState) {
            this.myExpr = document2;
            this.eof = false;
            this.qryState = queryState;
            this.rset = null;
            this.cFiles = null;
            this.pos = 0;
            this.pgm = null;
        }

        public void Restart() {
            this.eof = false;
            this.pos = 0;
            this.myExpr.initFileName(this.qryState);
            if (this.myExpr.localFileName == null) {
                this.eof = true;
                return;
            }
            try {
                if (this.myExpr.dconn != null) {
                    this.rset = this.myExpr.initEvaluateXDBCollection(this.qryState);
                } else {
                    this.cFiles = this.myExpr.initEvaluateLocalCollection(this.qryState);
                }
            }
            catch (XQException xQException) {
                this.Close();
                throw xQException;
            }
            catch (Exception exception) {
                this.Close();
                exception.printStackTrace();
                throw new XQException(exception, "Document:Restart");
            }
        }

        private XMLDocument evaluateXDBCollection(Clob clob, String string) throws Exception {
            Reader reader = clob.getCharacterStream();
            XMLSchema xMLSchema = this.qryState.getSchema();
            if (xMLSchema == null && string != null && string.length() > 0) {
                xMLSchema = this.myExpr.getXDBSchema(string);
            }
            if (this.pgm == null) {
                this.pgm = this.myExpr.getPageManager(this.qryState);
            }
            InputSource inputSource = new InputSource(reader);
            inputSource.setSystemId(string);
            XMLDocument xMLDocument = this.myExpr.getDocument(inputSource, xMLSchema, true, this.pgm);
            return xMLDocument;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private XMLDocument evaluateLocalCollection() throws Exception {
            InputStream inputStream = null;
            try {
                XMLDocument xMLDocument;
                inputStream = new FileInputStream(this.cFiles[this.pos]);
                if (this.pgm == null) {
                    this.pgm = this.myExpr.getPageManager(this.qryState);
                }
                InputSource inputSource = new InputSource(inputStream);
                inputSource.setSystemId(this.cFiles[this.pos].getAbsolutePath());
                XMLDocument xMLDocument2 = xMLDocument = this.myExpr.getDocument(inputSource, this.qryState.getSchema(), false, this.pgm);
                return xMLDocument2;
            }
            finally {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (Exception exception) {}
            }
        }

        public OXMLItem Fetch() {
            if (this.eof) {
                return null;
            }
            try {
                if (this.myExpr.dconn != null) {
                    while (this.rset.next()) {
                        Clob clob = this.rset.getClob(1);
                        if (clob == null || clob.length() == 0L) continue;
                        String string = this.rset.getString(2);
                        XMLDocument xMLDocument = this.evaluateXDBCollection(clob, string);
                        OXMLItem oXMLItem = this.qryState.createItem();
                        oXMLItem.setNode((XMLNode)xMLDocument);
                        return oXMLItem;
                    }
                    this.eof = true;
                    this.Close();
                    return null;
                }
                if (this.pos == this.cFiles.length) {
                    this.eof = true;
                    this.Close();
                    return null;
                }
                XMLDocument xMLDocument = this.evaluateLocalCollection();
                OXMLItem oXMLItem = this.qryState.createItem();
                oXMLItem.setNode((XMLNode)xMLDocument);
                ++this.pos;
                return oXMLItem;
            }
            catch (XQException xQException) {
                this.Close();
                throw xQException;
            }
            catch (Exception exception) {
                this.Close();
                exception.printStackTrace();
                throw new XQException(exception, "Document:Fetch");
            }
        }

        public void Close() {
            this.myExpr.close();
            if (this.pgm != null) {
                this.pgm.close();
            }
            this.pgm = null;
        }
    }

    class DocAvailableIterator
    implements ExprResultIterator {
        Document myExpr;
        boolean eof;
        QueryState qryState;

        public DocAvailableIterator(Document document2, QueryState queryState) {
            this.myExpr = document2;
            this.eof = false;
            this.qryState = queryState;
        }

        public void Restart() {
            this.eof = false;
            this.myExpr.initFileName(this.qryState);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public OXMLItem Fetch() {
            if (this.eof) {
                return null;
            }
            this.eof = true;
            if (this.myExpr.localFileName == null) {
                OXMLItem oXMLItem = this.qryState.createItem();
                oXMLItem.setBoolean(OXMLSequenceType.TBOOLEAN, false);
                return oXMLItem;
            }
            XMLDocument xMLDocument = null;
            try {
                xMLDocument = this.myExpr.evaluateDoc(this.qryState);
            }
            catch (Exception exception) {
            }
            finally {
                this.Close();
            }
            OXMLItem oXMLItem = this.qryState.createItem();
            oXMLItem.setBoolean(OXMLSequenceType.TBOOLEAN, xMLDocument != null);
            return oXMLItem;
        }

        public void Close() {
            this.myExpr.close();
        }
    }

    class DocumentIterator
    implements ExprResultIterator {
        Document myExpr;
        boolean eof;
        QueryState qryState;

        public DocumentIterator(Document document2, QueryState queryState) {
            this.myExpr = document2;
            this.eof = false;
            this.qryState = queryState;
        }

        public void Restart() {
            this.eof = false;
            this.myExpr.initFileName(this.qryState);
            if (this.myExpr.localFileName == null) {
                this.eof = true;
            }
        }

        public OXMLItem Fetch() {
            if (this.eof) {
                return null;
            }
            this.eof = true;
            try {
                XMLDocument xMLDocument = this.myExpr.evaluateDoc(this.qryState);
                if (xMLDocument != null) {
                    OXMLItem oXMLItem = this.qryState.createItem();
                    oXMLItem.setNode((XMLNode)xMLDocument);
                    OXMLItem oXMLItem2 = oXMLItem;
                    return oXMLItem2;
                }
                OXMLItem oXMLItem = null;
                return oXMLItem;
            }
            catch (XQException xQException) {
                throw xQException;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new XQException(exception, "Document:Fetch");
            }
            finally {
                this.Close();
            }
        }

        public void Close() {
            this.myExpr.close();
        }
    }

    class FileOnlyFilter
    implements FileFilter {
        FileOnlyFilter() {
        }

        public boolean accept(File file) {
            return file.isFile();
        }
    }
}

