/*
 * Decompiled with CFR 0.152.
 */
package oracle.xquery.exec;

import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.xqxp.datamodel.OXMLItem;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xquery.exec.Expr;
import oracle.xquery.exec.ExprResultIterator;
import oracle.xquery.exec.QueryState;
import oracle.xquery.exec.Trace;
import oracle.xquery.exec.Visitor;
import org.w3c.dom.Node;

public class ExprSequence
extends Expr {
    public ExprSequence(Expr[] exprArray) {
        super(exprArray);
    }

    public ExprResultIterator getIterator(QueryState queryState) {
        return new ExprSequenceIterator(this, queryState);
    }

    public XMLNode toXML() {
        XMLElement xMLElement = (XMLElement)ExprSequence.getDoc().createElement("ExprSequence");
        if (this.kids != null) {
            for (int i = 0; i < this.kids.length; ++i) {
                xMLElement.appendChild((Node)this.kids[i].toXML());
            }
        }
        return xMLElement;
    }

    public OXMLSequence Evaluate(QueryState queryState) {
        return this.EvaluateUsingIterator(queryState);
    }

    public void getStrRep(StringBuffer stringBuffer) {
        stringBuffer.append("(");
        for (int i = 0; i < this.kids.length; ++i) {
            if (i > 0) {
                stringBuffer.append(" or ");
            }
            StringBuffer stringBuffer2 = new StringBuffer();
            this.kids[i].getStrRep(stringBuffer2);
            stringBuffer.append(stringBuffer2.toString());
        }
        stringBuffer.append(")");
    }

    public String getStrRep() {
        StringBuffer stringBuffer = new StringBuffer("");
        this.getStrRep(stringBuffer);
        return stringBuffer.toString();
    }

    public int getPositionTest() {
        if (this.kids == null || this.kids.length > 1) {
            return 0;
        }
        Expr expr = this.kids[0];
        return expr.getPositionTest();
    }

    int getPositionTestExact() {
        if (this.kids == null || this.kids.length > 1) {
            return 0;
        }
        Expr expr = this.kids[0];
        return expr.getPositionTestExact();
    }

    public void acceptVisitor(Visitor visitor) {
        visitor.visitExprSequence(this);
    }

    static class ExprSequenceIterator
    implements ExprResultIterator {
        ExprSequence parentExprSeq;
        int curridx;
        ExprResultIterator currIter;
        QueryState qryState;

        public ExprSequenceIterator(ExprSequence exprSequence, QueryState queryState) {
            this.parentExprSeq = exprSequence;
            this.curridx = 0;
            this.currIter = null;
            this.qryState = queryState;
        }

        public void Restart() {
            this.currIter = null;
            if (this.parentExprSeq.kids != null) {
                this.curridx = 0;
                this.currIter = this.parentExprSeq.kids[this.curridx].getIterator(this.qryState);
            }
            if (this.currIter == null) {
                this.curridx = -1;
            } else {
                this.currIter.Restart();
            }
        }

        public OXMLItem Fetch() {
            OXMLItem oXMLItem;
            while (true) {
                if (this.Eof()) {
                    return null;
                }
                if (this.currIter == null) {
                    return null;
                }
                oXMLItem = this.currIter.Fetch();
                if (oXMLItem != null) break;
                this.currIter.Close();
                this.currIter = null;
                ++this.curridx;
                if (this.curridx >= this.parentExprSeq.kids.length) {
                    return null;
                }
                this.currIter = this.parentExprSeq.kids[this.curridx].getIterator(this.qryState);
                this.currIter.Restart();
            }
            return oXMLItem;
        }

        public void Close() {
            Trace.trace(1, this, "Entering Close");
            if (this.curridx >= 0 && this.curridx < this.parentExprSeq.kids.length && this.currIter != null) {
                this.currIter.Close();
            }
            this.currIter = null;
        }

        private boolean Eof() {
            return this.curridx < 0 || this.curridx >= this.parentExprSeq.kids.length;
        }
    }
}

