/*
 * Decompiled with CFR 0.152.
 */
package oracle.xquery.exec;

import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.xqxp.datamodel.OXMLItem;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xquery.exec.ConvertXML;
import oracle.xquery.exec.ConvertXMLUtils;
import oracle.xquery.exec.Expr;
import oracle.xquery.exec.ExprResultIterator;
import oracle.xquery.exec.NodeSource;
import oracle.xquery.exec.NodeSourceIterator;
import oracle.xquery.exec.OptimizeContext;
import oracle.xquery.exec.QueryState;
import oracle.xquery.exec.Trace;
import oracle.xquery.exec.VarExpr;
import oracle.xquery.exec.Visitor;
import oracle.xquery.parser.XQXGen;
import org.w3c.dom.Node;

public class FLWR
extends Expr {
    NodeSource nsTree;
    private VarExpr var;

    public XMLNode toXML() {
        XMLElement xMLElement = (XMLElement)FLWR.getDoc().createElement("FLWR");
        xMLElement.appendChild((Node)this.nsTree.toXML());
        return xMLElement;
    }

    public ConvertXML fromXML(XMLElement xMLElement) {
        this.nsTree = (NodeSource)ConvertXMLUtils.createFromXML((XMLElement)xMLElement.getFirstChild(), false);
        this.var = this.nsTree.getOutVariable();
        return this;
    }

    public void toSqlAlternate(XQXGen xQXGen) {
        xQXGen.startElement("function", XQXGen.createAttrs("name", "xmlconcat"));
        xQXGen.startElement("cast");
        xQXGen.startElement("multisetSubquery", null);
        this.nsTree.toSql(xQXGen);
        xQXGen.endElement("multisetSubquery");
        xQXGen.startElement("castType");
        xQXGen.startElement("simpleIdentifier");
        xQXGen.characters("sys");
        xQXGen.endElement("simpleIdentifier");
        xQXGen.startElement("simpleIdentifier");
        xQXGen.characters("XMLSequenceType");
        xQXGen.endElement("simpleIdentifier");
        xQXGen.endElement("castType");
        xQXGen.endElement("function");
    }

    public void toSqlQuery(XQXGen xQXGen, String string) {
        if (string == null) {
            this.nsTree.toSql(xQXGen);
        } else {
            super.toSqlQuery(xQXGen, string);
        }
    }

    public void toSql(XQXGen xQXGen) {
        xQXGen.startElement("scalarSubquery");
        xQXGen.startElement("simpleQuery");
        xQXGen.startElement("selectList");
        xQXGen.startElement("selectItem");
        xQXGen.startElement("function", XQXGen.createAttrs("name", "xmlagg"));
        this.var.toSql(xQXGen);
        xQXGen.endElement("function");
        xQXGen.endElement("selectItem");
        xQXGen.endElement("selectList");
        xQXGen.startElement("fromList");
        xQXGen.startElement("fromItem");
        xQXGen.startElement("fromSubquery");
        this.nsTree.toSql(xQXGen);
        xQXGen.endElement("fromSubquery");
        xQXGen.endElement("fromItem");
        xQXGen.endElement("fromList");
        xQXGen.endElement("simpleQuery");
        xQXGen.endElement("scalarSubquery");
    }

    public FLWR(NodeSource nodeSource) {
        this.nsTree = nodeSource;
        this.var = this.nsTree.getOutVariable();
    }

    public FLWR() {
    }

    public VarExpr getOutVar() {
        return this.var;
    }

    public ExprResultIterator getIterator(QueryState queryState) {
        return new FLWRIterator(this, queryState);
    }

    public OXMLSequence Evaluate(QueryState queryState) {
        return this.EvaluateUsingIterator(queryState);
    }

    public Expr optimize(OptimizeContext optimizeContext) {
        this.nsTree = this.nsTree.optimize(optimizeContext);
        return this;
    }

    public Expr normalize() {
        this.nsTree = this.nsTree.normalize();
        return this;
    }

    public void acceptVisitor(Visitor visitor) {
        visitor.visitFlwor(this);
    }

    static class FLWRIterator
    implements ExprResultIterator {
        FLWR flwr;
        NodeSourceIterator nsIter;
        OXMLSequence currSeq;
        QueryState qryState;

        FLWRIterator(FLWR fLWR, QueryState queryState) {
            this.flwr = fLWR;
            this.qryState = queryState;
            this.nsIter = this.flwr.nsTree.getNSIterator(queryState);
            this.currSeq = null;
        }

        public void Restart() {
            this.nsIter.Start();
            this.currSeq = null;
        }

        public OXMLItem Fetch() {
            Trace.trace(1, this, "FLWRIterator Fetch\n");
            while (true) {
                if (this.currSeq == null) {
                    if (!this.nsIter.Fetch()) {
                        return null;
                    }
                    this.currSeq = this.flwr.var.Evaluate(this.qryState);
                }
                if (this.currSeq.next()) {
                    OXMLItem oXMLItem = this.currSeq.getItem();
                    return oXMLItem;
                }
                this.currSeq = null;
            }
        }

        public void Close() {
            Trace.trace(1, this, "Entering Close");
            this.nsIter.Close();
        }
    }
}

