/*
 * Decompiled with CFR 0.152.
 */
package oracle.xquery.exec;

import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.xqxp.datamodel.OXMLItem;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xqxp.datamodel.OXMLSequenceType;
import oracle.xquery.exec.ConvertXML;
import oracle.xquery.exec.Expr;
import oracle.xquery.exec.GeneralComparison;
import oracle.xquery.exec.QueryState;
import oracle.xquery.exec.RelOp;
import oracle.xquery.exec.Utils;
import oracle.xquery.exec.Visitor;
import oracle.xquery.parser.XQXGen;

public class LogicalOp
extends Expr {
    public static final int AND = 1;
    public static final int OR = 2;
    public static final int NOT = 3;
    public static final String[] strings = new String[]{"AND", "OR", "NOT"};
    public static final String[] xpath_strs = new String[]{"and", "or", "not"};
    private int type;

    public final String toXPathStr() {
        return xpath_strs[this.type - 1];
    }

    public final String toString() {
        return strings[this.type - 1];
    }

    public static final int fromString(String string) {
        return Utils.indexOf(strings, string) + 1;
    }

    int getLogicalOp() {
        return this.type;
    }

    public XMLNode toXML() {
        XMLElement xMLElement = (XMLElement)LogicalOp.getDoc().createElement("LogicalOp");
        xMLElement.setAttribute("type", this.toString());
        xMLElement.setAttribute("ebv", this.getEBVString());
        this.toXMLKids((XMLNode)xMLElement);
        return xMLElement;
    }

    public void getStrRep(StringBuffer stringBuffer) {
        this.toKidsStrRep(stringBuffer, this.toXPathStr());
    }

    public void toSql(XQXGen xQXGen) {
        if (this.type == 3) {
            xQXGen.startElement("function", XQXGen.createAttrs("name", "not"));
            this.kids[0].toSql(xQXGen);
            xQXGen.endElement("function");
        } else {
            xQXGen.startElement("function", XQXGen.createAttrs("name", this.toString(), "infix", "true"));
            this.toSqlDefault(xQXGen);
            xQXGen.endElement("function");
        }
    }

    public int getDatatype() {
        return 2;
    }

    public ConvertXML fromXML(XMLElement xMLElement) {
        this.type = LogicalOp.fromString(xMLElement.getAttribute("type"));
        this.fromXMLKids(xMLElement);
        return this;
    }

    public LogicalOp(int n, Expr[] exprArray) {
        super(exprArray);
        this.type = n;
    }

    public LogicalOp(int n, Expr expr) {
        super(expr);
        this.type = n;
    }

    public LogicalOp(int n, Expr expr, Expr expr2) {
        super(expr, expr2);
        this.type = n;
    }

    public LogicalOp() {
    }

    public OXMLSequence Evaluate(QueryState queryState) {
        if (!this.unknownEBV()) {
            OXMLItem oXMLItem = queryState.createItem();
            oXMLItem.setBoolean(OXMLSequenceType.TBOOLEAN, this.trueEBV());
            OXMLSequence oXMLSequence = queryState.createSequence(oXMLItem);
            oXMLSequence.setKnownType(OXMLSequenceType.TBOOLEAN);
            return oXMLSequence;
        }
        boolean bl = true;
        block0 : switch (this.type) {
            case 1: {
                for (int i = 0; i < this.kids.length; ++i) {
                    OXMLSequence oXMLSequence = this.kids[i].Evaluate(queryState);
                    boolean bl2 = oXMLSequence.getEffectiveBooleanValue();
                    if (bl2) continue;
                    bl = false;
                    break block0;
                }
                break;
            }
            case 2: {
                bl = false;
                for (int i = 0; i < this.kids.length; ++i) {
                    OXMLSequence oXMLSequence = this.kids[i].Evaluate(queryState);
                    boolean bl3 = oXMLSequence.getEffectiveBooleanValue();
                    if (!bl3) continue;
                    bl = true;
                    break block0;
                }
                break;
            }
            case 3: {
                OXMLSequence oXMLSequence = this.kids[0].Evaluate(queryState);
                boolean bl4 = oXMLSequence.getEffectiveBooleanValue();
                bl = !bl4;
            }
        }
        OXMLItem oXMLItem = queryState.createItem();
        oXMLItem.setBoolean(OXMLSequenceType.TBOOLEAN, bl);
        return queryState.createSequence(oXMLItem);
    }

    public int getPositionTest() {
        if (this.kids == null || this.kids.length < 2) {
            return 0;
        }
        Expr expr = this.kids[0];
        Expr expr2 = this.kids[1];
        if (this.type == 1 && (expr instanceof GeneralComparison || expr instanceof RelOp) && (expr2 instanceof GeneralComparison || expr2 instanceof RelOp)) {
            int n = expr.getPositionTest();
            int n2 = expr2.getPositionTest();
            if (n == 0 || n2 <= n) {
                return n2;
            }
            if (n2 == 0 || n <= n2) {
                return n;
            }
        }
        return 0;
    }

    public void acceptVisitor(Visitor visitor) {
        visitor.visitLogicalExpr(this);
    }
}

