/*
 * Decompiled with CFR 0.152.
 */
package oracle.xquery.exec;

import javax.xml.namespace.QName;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.util.QxName;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xqxp.datamodel.OXMLSequenceType;
import oracle.xquery.XQException;
import oracle.xquery.exec.Expr;
import oracle.xquery.exec.PathStep;
import oracle.xquery.exec.QueryState;
import oracle.xquery.exec.Visitor;
import oracle.xquery.exec.XpathExpr;

public class NodeTest
extends Expr {
    public static final int ANYNODE = 0;
    private QxName nodeName = null;
    private QxName typeName = null;
    private boolean nillable = false;
    private int nodeType;
    private boolean schemaTest = false;
    boolean exactlyOneElement = false;
    private OXMLSequenceType seqType;

    public NodeTest(QxName qxName, QxName qxName2, boolean bl, int n) {
        this(qxName, n);
        this.typeName = qxName2;
        this.nillable = bl;
    }

    public NodeTest(QxName qxName, int n) {
        this.nodeName = qxName;
        if (n == 2 && (qxName.getPrefix() == null || qxName.getPrefix().length() == 0) && qxName.getNamespaceURI() != null && qxName.getNamespaceURI().length() != 0) {
            this.nodeName = new QxName("", qxName.getLocalPart());
        }
        this.nodeType = n;
    }

    public NodeTest(int n) {
        this.nodeType = n;
    }

    public void setSchemaTest(boolean bl) {
        this.schemaTest = bl;
    }

    public int getNodeType() {
        return this.nodeType;
    }

    public QxName getTypeName() {
        return this.typeName;
    }

    public QxName getNodeName() {
        return this.nodeName;
    }

    public String getLocalName() {
        if (this.nodeName != null) {
            return this.nodeName.getLocalPart();
        }
        return null;
    }

    public String getNameSpace() {
        if (this.nodeName != null) {
            return this.nodeName.getNamespaceURI();
        }
        return null;
    }

    public boolean isNillable() {
        return this.nillable;
    }

    public void setNodeType(int n) {
        this.nodeType = n;
    }

    public void setExactlyOneElement(boolean bl) {
        this.exactlyOneElement = bl;
    }

    public void setSequenceType(QueryState queryState) {
        this.getSequenceType(queryState);
    }

    public XMLNode toXML() {
        XMLElement xMLElement = (XMLElement)NodeTest.getDoc().createElement("NodeTest");
        xMLElement.setAttribute("value", this.toString());
        return xMLElement;
    }

    public OXMLSequence Evaluate(QueryState queryState) {
        throw new XQException("Evaluate not implemented");
    }

    public OXMLSequenceType getSequenceType(QueryState queryState, int n) {
        if (this.nodeType == 0) {
            return OXMLSequenceType.createNodeType((int)n);
        }
        if (this.schemaTest && queryState.getSchema() == null) {
            throw new XQException(queryState.getMesg().getMessage0("XPST0008"), queryState.getMesg().getMessage1("XQE-0237", this.toString()));
        }
        OXMLSequenceType oXMLSequenceType = OXMLSequenceType.createNodeType((QName)this.nodeName, (QName)this.typeName, (int)this.nodeType, (boolean)this.nillable, (int)n, (XMLSchema)queryState.getSchema(), (boolean)this.exactlyOneElement, (boolean)this.schemaTest);
        if (!oXMLSequenceType.isSchemaValid(queryState.getSchema())) {
            throw new XQException(queryState.getMesg().getMessage0("XPST0008"), queryState.getMesg().getMessage1("XQE-0237", this.toString()));
        }
        return oXMLSequenceType;
    }

    public OXMLSequenceType getSequenceType(QueryState queryState) {
        this.seqType = this.getSequenceType(queryState, 1);
        return this.seqType;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        switch (this.nodeType) {
            case 3: {
                stringBuffer.append("text(");
                break;
            }
            case 8: {
                stringBuffer.append("comment(");
                break;
            }
            case 7: {
                stringBuffer.append("processing-instruction(");
                break;
            }
            case 2: {
                if (this.schemaTest) {
                    stringBuffer.append("schema-attribute(");
                    break;
                }
                stringBuffer.append("attribute(");
                break;
            }
            case 1: {
                if (this.schemaTest) {
                    stringBuffer.append("schema-element(");
                    break;
                }
                stringBuffer.append("element(");
                break;
            }
            case 9: {
                stringBuffer.append("document-node(");
                if (!this.exactlyOneElement && this.nodeName == null) break;
                if (this.schemaTest) {
                    stringBuffer.append("schema-element(");
                } else {
                    stringBuffer.append("element(");
                }
                bl = true;
            }
        }
        if (this.nodeName != null) {
            stringBuffer.append(this.nodeName.getQName());
        }
        if (this.typeName != null) {
            stringBuffer.append(", ").append(this.typeName.getQName());
        }
        if (this.nillable) {
            stringBuffer.append('?');
        }
        if (bl) {
            stringBuffer.append(')');
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public Expr normalize() {
        XpathExpr xpathExpr = new XpathExpr();
        PathStep pathStep = new PathStep(3, this.getLocalName(), this.getNameSpace(), null);
        if (this.nodeType == 0) {
            pathStep.setAnyNode(true);
        } else {
            pathStep.setNodeType(this.nodeType);
            if (this.nodeType == 9 || this.nodeType == 2 || this.nodeType == 1) {
                pathStep.setHasNodeTest();
                pathStep.setSequenceType(this.seqType);
            }
        }
        xpathExpr.addStep(pathStep);
        return xpathExpr;
    }

    public void acceptVisitor(Visitor visitor) {
    }
}

