/*
 * Decompiled with CFR 0.152.
 */
package oracle.xquery.exec;

import java.util.ArrayList;
import java.util.List;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.xqxp.datamodel.OXMLItem;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xqxp.datamodel.OXMLSequenceType;
import oracle.xml.xqxp.datamodel.XMLItem;
import oracle.xquery.exec.Expr;
import oracle.xquery.exec.Focus;
import oracle.xquery.exec.OXMLItemList;
import oracle.xquery.exec.OptimizeContext;
import oracle.xquery.exec.Predicate;
import oracle.xquery.exec.QueryState;
import oracle.xquery.exec.Visitor;
import oracle.xquery.exec.XQueryUtils;
import org.w3c.dom.Node;

public class PredicateSet
extends Expr {
    List predicates = new ArrayList();

    public void addPredicate(Predicate predicate) {
        this.predicates.add(predicate);
    }

    void setPredicates(ArrayList arrayList) {
        this.predicates = arrayList;
    }

    boolean emptyPredicates() {
        return this.predicates == null || this.predicates.size() == 0;
    }

    public void filter(OXMLItemList oXMLItemList, QueryState queryState) {
        this.filter(oXMLItemList, queryState, false);
    }

    public void filter(OXMLItemList oXMLItemList, QueryState queryState, boolean bl) {
        OXMLItemList oXMLItemList2 = new OXMLItemList();
        OXMLItemList oXMLItemList3 = new OXMLItemList();
        int n = queryState.getContextSize();
        int n2 = queryState.getContextPosition();
        OXMLItem oXMLItem = queryState.getContextItem();
        Focus focus = queryState.getFreeFocus();
        queryState.pushFocus(focus);
        queryState.setContextSize(oXMLItemList.getLength());
        for (int i = 0; i < this.predicates.size(); ++i) {
            Predicate predicate = (Predicate)this.predicates.get(i);
            int n3 = predicate.getPositionTest();
            if (n3 == -1) {
                oXMLItemList.reset();
                break;
            }
            int n4 = predicate.getPositionTestExact();
            boolean bl2 = n4 > 0 && n4 != Integer.MAX_VALUE;
            oXMLItemList2.reset();
            oXMLItemList3.reset();
            int n5 = oXMLItemList.getLength();
            int n6 = -1;
            n6 = bl ? n5 : 1;
            for (int j = 0; j < n5; ++j) {
                OXMLItem oXMLItem2 = oXMLItemList.getItem(queryState, j);
                if (bl2) {
                    if (n6 == n4) {
                        oXMLItemList2.addItem(oXMLItem2);
                        break;
                    }
                } else {
                    oXMLItemList3.addItem(oXMLItem2);
                    queryState.setContextItem((XMLItem)oXMLItem2);
                    queryState.setContextItemList(oXMLItemList3);
                    queryState.setContextPosition(n6);
                    OXMLSequence oXMLSequence = predicate.Evaluate(queryState);
                    if (oXMLSequence.isOfType(OXMLSequenceType.NUMERIC_ONE)) {
                        oXMLSequence.next();
                        int n7 = XQueryUtils.getIntPositionValue(oXMLSequence.getItem());
                        if (n7 == n6) {
                            oXMLItemList2.addItem(oXMLItem2);
                        }
                    } else if (oXMLSequence.getEffectiveBooleanValue()) {
                        oXMLItemList2.addItem(oXMLItem2);
                    }
                }
                n6 = bl ? --n6 : ++n6;
                oXMLItemList3.reset();
            }
            queryState.setContextSize(oXMLItemList2.getLength());
            oXMLItemList.reset();
            oXMLItemList.addAll(oXMLItemList2);
        }
        focus = queryState.popFocus();
        queryState.returnFocus(focus);
        queryState.setContextSize(n);
        queryState.setContextPosition(n2);
        queryState.setContextItem((XMLItem)oXMLItem);
    }

    public int getPositionTest() {
        if (this.predicates.size() > 0) {
            return ((Predicate)this.predicates.get(0)).getPositionTest();
        }
        return 0;
    }

    int getPositionTestExact() {
        if (this.predicates.size() > 0) {
            return ((Predicate)this.predicates.get(0)).getPositionTestExact();
        }
        return 0;
    }

    public XMLNode toXML() {
        XMLElement xMLElement = (XMLElement)PredicateSet.getDoc().createElement("PredicateSet");
        if (this.predicates != null) {
            int n = this.predicates.size();
            for (int i = 0; i < n; ++i) {
                xMLElement.appendChild((Node)((Predicate)this.predicates.get(i)).toXML());
            }
        }
        return xMLElement;
    }

    public OXMLSequence Evaluate(QueryState queryState) {
        OXMLItemList oXMLItemList = queryState.getContextItemList();
        this.filter(oXMLItemList, queryState);
        OXMLSequence oXMLSequence = queryState.createSequence();
        int n = oXMLItemList.getLength();
        for (int i = 0; i < n; ++i) {
            oXMLSequence.appendItem(oXMLItemList.getItem(queryState, i));
        }
        return oXMLSequence;
    }

    public Expr normalize() {
        if (this.predicates != null) {
            int n = this.predicates.size();
            for (int i = 0; i < n; ++i) {
                ((Expr)this.predicates.get(i)).normalize();
            }
        }
        return this;
    }

    public Expr optimize(OptimizeContext optimizeContext) {
        if (this.predicates != null) {
            int n = this.predicates.size();
            for (int i = 0; i < n; ++i) {
                ((Expr)this.predicates.get(i)).optimize(optimizeContext);
            }
        }
        return this;
    }

    public void acceptVisitor(Visitor visitor) {
        visitor.visitPredicateSet(this);
    }
}

