/*
 * Decompiled with CFR 0.152.
 */
package oracle.xquery.exec;

import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Stack;
import java.util.TimeZone;
import javax.xml.namespace.QName;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.schema.XSDDataValue;
import oracle.xml.parser.v2.NSResolver;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.scalable.PageManager;
import oracle.xml.scalable.PageManagerPool;
import oracle.xml.xqxp.datamodel.FSType;
import oracle.xml.xqxp.datamodel.OXMLItem;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xqxp.datamodel.XMLItem;
import oracle.xml.xqxp.functions.OXMLFunctionContext;
import oracle.xquery.XQException;
import oracle.xquery.XQMesg;
import oracle.xquery.XQueryContextHandler;
import oracle.xquery.exec.Expr;
import oracle.xquery.exec.ExprResultIterator;
import oracle.xquery.exec.Focus;
import oracle.xquery.exec.OXMLItemList;
import oracle.xquery.exec.OXQueryItem;
import oracle.xquery.exec.OXQueryItemFactory;
import oracle.xquery.exec.OXQuerySequence;
import oracle.xquery.exec.OXQuerySequenceFactory;
import oracle.xquery.exec.OptimizeContext;
import oracle.xquery.exec.RuntimeFrame;
import oracle.xquery.exec.StaticTypingVisitor;
import oracle.xquery.exec.TypeFactory;
import oracle.xquery.exec.Variable;
import oracle.xquery.exec.XQueryConstants;
import oracle.xquery.func.FunctionDefn;
import oracle.xquery.func.FunctionId;

public class QueryState
implements NSResolver,
XQueryConstants,
OXMLFunctionContext {
    static HashMap predefinedElemNSHT = new HashMap(10);
    private XQMesg msg;
    private boolean whiteSpacePreserve;
    private boolean ignoreOrdering = false;
    private boolean nodeByValue = false;
    private String defaultFuncNS;
    private Stack nameSpacesHTStack;
    private Stack defaultElemNSStack;
    private HashMap functionDefnsHM;
    private RuntimeFrame runtimeFrame;
    private ArrayList prologVariables;
    private HashMap documentHT;
    private Hashtable pgmHT;
    private Stack focusStack;
    private String defaultCollation = null;
    private String baseURI;
    private int constructionMode = 0;
    private boolean lazyDom = false;
    private boolean cloneDOM = false;
    private PageManagerPool pgmPool = null;
    private int inheritnamespacesMode = 0;
    private XMLSchema xmlSchema;
    private FSType staticType;
    private GregorianCalendar currentTime;
    private TimeZone implicitTimezone;
    private RuntimeFrame frameOutsideFunctionCall = null;
    private OXQuerySequenceFactory seqFactory;
    private OXQueryItemFactory itemFactory;
    private TypeFactory typeFactory;
    private Object extObj = null;
    private StaticTypingVisitor stv;
    private XQueryContextHandler ctxHandler;
    public static final boolean BASIC_EDITION = false;
    public static final long MAX_FILE_SIZE = 102400L;
    private String dbCharSet = null;
    private String sortCollation = null;
    private Stack freeFocus = new Stack();

    public QueryState(boolean bl) {
        this.whiteSpacePreserve = bl;
        this.defaultFuncNS = "http://www.w3.org/2005/xpath-functions";
        this.defaultElemNSStack = new Stack();
        this.nameSpacesHTStack = new Stack();
        this.focusStack = new Stack();
        Focus focus = this.getFreeFocus();
        this.focusStack.push(focus);
        this.seqFactory = new OXQuerySequenceFactory();
        this.itemFactory = new OXQueryItemFactory();
        this.typeFactory = new TypeFactory();
        this.nameSpacesHTStack.push(predefinedElemNSHT);
        this.nameSpacesHTStack.push(new HashMap(10));
        this.functionDefnsHM = new HashMap(5);
        this.documentHT = new HashMap(5);
        this.pgmHT = new Hashtable(5);
        this.implicitTimezone = XSDDataValue.UTC;
        this.currentTime = new GregorianCalendar();
        this.currentTime.setTimeZone(this.implicitTimezone);
        this.currentTime.getTime();
    }

    public void setSchema(XMLSchema xMLSchema) {
        this.xmlSchema = xMLSchema;
    }

    public XMLSchema getSchema() {
        return this.xmlSchema;
    }

    public void addToDocumentHT(String string, XMLDocument xMLDocument) {
        this.documentHT.put(string.intern(), xMLDocument);
    }

    public XMLDocument getDocument(String string) {
        return (XMLDocument)this.documentHT.get(string.intern());
    }

    public void addToPgmHT(String string, PageManager pageManager) {
        this.pgmHT.put(string.intern(), pageManager);
    }

    public PageManager getPageManager(String string) {
        return (PageManager)this.pgmHT.get(string.intern());
    }

    public void addFunctionDefn(FunctionId functionId, FunctionDefn functionDefn) {
        this.functionDefnsHM.put(functionId, functionDefn);
    }

    public FunctionDefn getFunctionDefn(FunctionId functionId) {
        return (FunctionDefn)this.functionDefnsHM.get(functionId);
    }

    public void setMessage(XQMesg xQMesg) {
        this.msg = xQMesg;
    }

    public void setWhiteSpacePreserve(boolean bl) {
        this.whiteSpacePreserve = bl;
    }

    public boolean getWhiteSpacePreserve() {
        return this.whiteSpacePreserve;
    }

    public void setIgnoreOrdering(boolean bl) {
        this.ignoreOrdering = bl;
    }

    public void setNodeByValue(boolean bl) {
        this.nodeByValue = bl;
    }

    public void pushNamespaceHT(HashMap hashMap) {
        this.nameSpacesHTStack.push(hashMap);
    }

    public HashMap popNamespaceHT() {
        if (this.nameSpacesHTStack.empty()) {
            throw new XQException(this.msg.getMessage1("XQE-0001", "popNamespaceHT - stack not empty"));
        }
        return (HashMap)this.nameSpacesHTStack.pop();
    }

    public boolean isPrefixBoundCurrentScope(String string) {
        HashMap hashMap = (HashMap)this.nameSpacesHTStack.peek();
        return hashMap.containsKey(string.intern());
    }

    public String resolveNamespacePrefix(String string) {
        return this.resolveNamespacePrefix(string, null);
    }

    public String resolveNamespacePrefix(String string, String string2) {
        String string3 = null;
        Stack stack = (Stack)this.nameSpacesHTStack.clone();
        while (!stack.empty()) {
            HashMap hashMap = (HashMap)stack.pop();
            if (!hashMap.containsKey(string.intern())) continue;
            string3 = (String)hashMap.get(string.intern());
            break;
        }
        if (string2 != null && !string2.equals(string3)) {
            throw new XQException(this.msg.getMessage0("XQST0048"));
        }
        return string3;
    }

    public void addNamespace(String string, String string2) {
        HashMap hashMap = (HashMap)this.nameSpacesHTStack.pop();
        if (hashMap.get(string.intern()) != null) {
            throw new XQException(this.msg.getMessage1("XQE-0226", string));
        }
        hashMap.put(string.intern(), string2);
        this.nameSpacesHTStack.push(hashMap);
    }

    public void pushDefaultElemNS(String string) {
        this.defaultElemNSStack.push(string);
    }

    public String popDefaultElemNS() {
        return (String)this.defaultElemNSStack.pop();
    }

    public boolean emptyDefaultElemNS() {
        return this.defaultElemNSStack.empty();
    }

    public String getDefaultElemNS() {
        if (this.defaultElemNSStack.isEmpty()) {
            return null;
        }
        return (String)this.defaultElemNSStack.peek();
    }

    public void setDefaultFuncNS(String string) {
        this.defaultFuncNS = string;
    }

    public String getDefaultFuncNS() {
        return this.defaultFuncNS;
    }

    public void setStaticTypingVisitor(StaticTypingVisitor staticTypingVisitor) {
        this.stv = staticTypingVisitor;
    }

    public StaticTypingVisitor getStaticTypingVisitor() {
        return this.stv;
    }

    public XQMesg getMesg() {
        return this.msg;
    }

    private int getNextFrameIndex() {
        return this.runtimeFrame.getNextFrameIndex();
    }

    private void initializeFrame(boolean bl) {
        if (this.runtimeFrame != null) {
            this.runtimeFrame.reset();
        }
        this.runtimeFrame = new RuntimeFrame();
        if (bl) {
            this.frameOutsideFunctionCall = null;
        }
    }

    public void initializeFrame() {
        this.initializeFrame(true);
    }

    void initializeFunctionFrame() {
        if (this.frameOutsideFunctionCall == null) {
            this.frameOutsideFunctionCall = this.runtimeFrame;
        }
        if (this.frameOutsideFunctionCall != null) {
            this.runtimeFrame = (RuntimeFrame)this.frameOutsideFunctionCall.clone();
        } else {
            this.initializeFrame(false);
        }
    }

    RuntimeFrame getRuntimeFrame() {
        return this.runtimeFrame;
    }

    void setRuntimeFrame(RuntimeFrame runtimeFrame) {
        if (this.runtimeFrame != null) {
            this.runtimeFrame.cleanup(runtimeFrame);
        }
        this.runtimeFrame = runtimeFrame;
    }

    OXMLSequence getRuntimeValue(Variable variable) {
        return this.runtimeFrame.getVarValue(variable);
    }

    void setRuntimeValue(Variable variable, OXMLSequence oXMLSequence) {
        if (variable.getValueIndex() < 0) {
            variable.setValueIndex(this.getNextFrameIndex());
        }
        this.runtimeFrame.setVarValue(variable, oXMLSequence);
    }

    public ArrayList getPrologVariables() {
        return this.prologVariables;
    }

    public HashMap getFunctionDefns() {
        return this.functionDefnsHM;
    }

    public void addPrologVariable(Expr expr) {
        if (this.prologVariables == null) {
            this.prologVariables = new ArrayList();
        }
        this.prologVariables.add(expr);
    }

    public void setDefaultCollation(String string) {
        this.defaultCollation = string;
    }

    public void setConstructionMode(int n) {
        this.constructionMode = n;
    }

    public int getConstructionMode() {
        return this.constructionMode;
    }

    public boolean isPreserveMode() {
        return this.constructionMode == 0;
    }

    public void setInheritnamespacesMode(int n) {
        this.inheritnamespacesMode = n;
    }

    public int getInheritnamespacesMode() {
        return this.inheritnamespacesMode;
    }

    public void setBaseURI(String string) {
        this.baseURI = string;
    }

    public void staticTypingPrologVars() {
        if (this.prologVariables != null) {
            int n = this.prologVariables.size();
            for (int i = 0; i < n; ++i) {
                Expr expr = (Expr)this.prologVariables.get(i);
                expr.acceptVisitor(this.stv);
            }
        }
    }

    public OXMLSequence createSequence() {
        OXQuerySequence oXQuerySequence = this.seqFactory.getOXQuerySequence(true);
        oXQuerySequence.setContext(this);
        return oXQuerySequence;
    }

    OXMLSequence createSequence(OXMLSequence oXMLSequence) {
        OXQuerySequence oXQuerySequence = (OXQuerySequence)oXMLSequence;
        oXQuerySequence.reset();
        oXQuerySequence.setMaterialized(true);
        oXQuerySequence.setContext(this);
        return oXQuerySequence;
    }

    public OXMLSequence createSequence(OXMLItem oXMLItem) {
        OXQuerySequence oXQuerySequence = this.seqFactory.getOXQuerySequence(true);
        oXQuerySequence.appendItem(oXMLItem);
        oXQuerySequence.setContext(this);
        return oXQuerySequence;
    }

    OXMLSequence createSequence(ExprResultIterator exprResultIterator) {
        OXQuerySequence oXQuerySequence = this.seqFactory.getOXQuerySequence(false);
        oXQuerySequence.setContext(this);
        oXQuerySequence.setExprIterator(exprResultIterator);
        return oXQuerySequence;
    }

    public OXMLItem createItem() {
        OXQueryItem oXQueryItem = this.itemFactory.getOXQueryItem();
        oXQueryItem.setContext(this);
        return oXQueryItem;
    }

    public void returnItem(OXMLItem oXMLItem) {
        this.itemFactory.returnOXQueryItem(oXMLItem);
    }

    public void returnSequence(OXMLSequence oXMLSequence) {
        this.seqFactory.returnOXQuerySequence(oXMLSequence);
    }

    public String getDBCharSet() {
        return this.dbCharSet;
    }

    public void setDBCharSet(String string) {
        this.dbCharSet = string;
    }

    public void setSortCollation(String string) {
        this.sortCollation = string;
    }

    public String getSortCollation() {
        if (this.sortCollation != null) {
            return this.sortCollation;
        }
        return this.defaultCollation;
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public String getDefaultCollation() {
        return this.defaultCollation;
    }

    public String getInScopeNamespace(String string) {
        return this.resolveNamespacePrefix(string);
    }

    public GregorianCalendar getDateTime() {
        return this.currentTime;
    }

    public TimeZone getImplicitTimezone() {
        return this.implicitTimezone;
    }

    void setContextItemStaticType(FSType fSType) {
        this.staticType = fSType;
    }

    FSType getContextItemStaticType() {
        OXMLItem oXMLItem;
        if (this.staticType == null && (oXMLItem = this.getContextItem()) != null) {
            this.staticType = oXMLItem.getItemType();
        }
        return this.staticType;
    }

    public void setContextItemList(OXMLItemList oXMLItemList) {
        Focus focus = this.currentFocus();
        focus.setContextItemList(oXMLItemList);
    }

    public OXMLItemList getContextItemList() {
        return this.currentFocus().getContextItemList();
    }

    public OXMLItem getContextItem() {
        return this.currentFocus().getContextItem();
    }

    public void setContextItem(XMLItem xMLItem) {
        OXMLItem oXMLItem = (OXMLItem)xMLItem;
        this.currentFocus().setContextItem(oXMLItem);
        if (xMLItem != null) {
            ((OXQueryItem)xMLItem).setContext(this);
            this.setContextItemStaticType((FSType)oXMLItem.getItemType());
        }
    }

    public int getContextPosition() {
        return this.currentFocus().getContextPosition();
    }

    public void setContextPosition(int n) {
        this.currentFocus().setContextPosition(n);
    }

    public int getContextSize() {
        return this.currentFocus().getContextSize();
    }

    public void setContextSize(int n) {
        this.currentFocus().setContextSize(n);
    }

    public void pushFocus(Focus focus) {
        this.focusStack.push(focus);
    }

    public Focus popFocus() {
        return (Focus)this.focusStack.pop();
    }

    public Focus currentFocus() {
        return (Focus)this.focusStack.peek();
    }

    public Focus getFreeFocus() {
        if (this.freeFocus.empty()) {
            return new Focus(this);
        }
        return (Focus)this.freeFocus.pop();
    }

    public void returnFocus(Focus focus) {
        focus.reset();
        this.freeFocus.push(focus);
    }

    public static String getPredefinedNamespaceURI(String string) {
        return (String)predefinedElemNSHT.get(string);
    }

    public static String[] getPredefinedNamespacePrefixes() {
        int n = predefinedElemNSHT.size();
        String[] stringArray = new String[n];
        Iterator iterator = predefinedElemNSHT.keySet().iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            stringArray[n2] = (String)iterator.next();
            ++n2;
        }
        return stringArray;
    }

    public void setLazyDom(boolean bl) {
        this.lazyDom = bl;
    }

    public boolean getLazyDom() {
        return this.lazyDom;
    }

    public boolean getCloneDOM() {
        return this.cloneDOM;
    }

    public void setCloneDOM(boolean bl) {
        this.cloneDOM = bl;
    }

    public void setPageManagerPool(PageManagerPool pageManagerPool) {
        this.pgmPool = pageManagerPool;
    }

    public PageManagerPool getPageManagerPool() {
        if (this.pgmPool != null) {
            return this.pgmPool;
        }
        throw new XQException(this.msg.getMessage0("XQE-0511"));
    }

    public void setXQueryContextHandler(XQueryContextHandler xQueryContextHandler) {
        this.ctxHandler = xQueryContextHandler;
    }

    public XQueryContextHandler getContextHandler() {
        return this.ctxHandler;
    }

    public QName getUniqueVarName() {
        return this.ctxHandler.getUniqueVarName();
    }

    TypeFactory getTypeFactory() {
        return this.typeFactory;
    }

    public void cleanup() {
        Enumeration enumeration = this.pgmHT.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            PageManager pageManager = (PageManager)this.pgmHT.get(string);
            if (pageManager != null) {
                pageManager.close();
            }
            File file = new File(string);
            file.delete();
        }
        this.pgmHT.clear();
    }

    public void close() {
        Enumeration enumeration = this.pgmHT.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            PageManager pageManager = (PageManager)this.pgmHT.get(string);
            if (pageManager == null) continue;
            pageManager.close();
        }
        this.pgmHT.clear();
    }

    public void attachExternalObject(Object object) {
        this.extObj = object;
    }

    public Object retrieveExternalObject() {
        return this.extObj;
    }

    public void staticTypingFnDecls() {
        for (FunctionDefn functionDefn : this.functionDefnsHM.values()) {
            functionDefn.staticTypeChecking(this.stv);
        }
    }

    public void optimizeFnExprs(OptimizeContext optimizeContext) {
        for (FunctionDefn functionDefn : this.functionDefnsHM.values()) {
            if (functionDefn.isExternalFunction()) continue;
            functionDefn.getFunctionExpr().optimize(optimizeContext);
        }
    }

    static {
        predefinedElemNSHT.put("xml", "http://www.w3.org/XML/1998/namespace");
        predefinedElemNSHT.put("xs", "http://www.w3.org/2001/XMLSchema");
        predefinedElemNSHT.put("xsd", "http://www.w3.org/2001/XMLSchema-datatypes");
        predefinedElemNSHT.put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        predefinedElemNSHT.put("fn", "http://www.w3.org/2005/xpath-functions");
        predefinedElemNSHT.put("local", "http://www.w3.org/2005/xquery-local-functions");
        predefinedElemNSHT.put("ora", "http://xmlns.oracle.com/xdb");
    }
}

