/*
 * Decompiled with CFR 0.152.
 */
package oracle.xquery.exec;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import javax.xml.namespace.QName;
import oracle.i18n.text.OraCollator;
import oracle.jdbc.pool.OracleDataSource;
import oracle.xml.parser.v2.XMLAttr;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.util.OraURI;
import oracle.xml.util.OraURIException;
import oracle.xml.util.QxName;
import oracle.xml.xqxp.datamodel.OXMLItem;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xqxp.datamodel.OXMLSequenceType;
import oracle.xml.xqxp.functions.builtIns.FNUtil;
import oracle.xquery.XQException;
import oracle.xquery.XQMesg;
import oracle.xquery.exec.Expr;
import oracle.xquery.exec.FunctionCall;
import oracle.xquery.exec.OXMLItemList;
import oracle.xquery.exec.OXQuerySequence;
import oracle.xquery.exec.PathStep;
import oracle.xquery.exec.QueryState;
import oracle.xquery.exec.XQPrintDriver;
import org.w3c.dom.Node;

public class XQueryUtils {
    private static final char[] LESS_THEN_REP = new char[]{'&', 'l', 't', ';'};
    private static final char[] GREATER_THEN_REP = new char[]{'&', 'g', 't', ';'};
    private static final char[] AMP_REP = new char[]{'&', 'a', 'm', 'p', ';'};
    private static final char[] QUOTE_REP = new char[]{'&', 'q', 'u', 'o', 't', ';'};

    static int getGeneralizedType(int n, int n2) {
        if (n < n2) {
            return n2;
        }
        return n;
    }

    static String typeToString(int n, boolean bl) {
        switch (n) {
            case 212: {
                if (bl) {
                    return "lt";
                }
                return "<";
            }
            case 213: {
                if (bl) {
                    return "le";
                }
                return "<=";
            }
            case 214: {
                if (bl) {
                    return "gt";
                }
                return ">";
            }
            case 215: {
                if (bl) {
                    return "ge";
                }
                return ">=";
            }
            case 210: {
                if (bl) {
                    return "eq";
                }
                return "=";
            }
            case 211: {
                if (bl) {
                    return "ne";
                }
                return "!=";
            }
        }
        throw new XQException("XQueryUtils:typeToString:" + n + "not supported");
    }

    static int typeFromString(String string) {
        if (string.compareTo("lt") == 0 || string.compareTo("<") == 0) {
            return 212;
        }
        if (string.compareTo("le") == 0 || string.compareTo("<=") == 0) {
            return 213;
        }
        if (string.compareTo("gt") == 0 || string.compareTo(">") == 0) {
            return 214;
        }
        if (string.compareTo("ge") == 0 || string.compareTo(">=") == 0) {
            return 215;
        }
        if (string.compareTo("eq") == 0 || string.compareTo("=") == 0) {
            return 210;
        }
        if (string.compareTo("ne") == 0 || string.compareTo("!=") == 0) {
            return 211;
        }
        throw new XQException("XQueryUtils:typeFromString:" + string + "not supported");
    }

    static XMLNode getNodeForce(QueryState queryState, OXMLItem oXMLItem) {
        if (oXMLItem.getPrimitiveType() == 90) {
            return oXMLItem.getNode();
        }
        OXMLItem oXMLItem2 = queryState.createItem();
        oXMLItem2.copyItem(oXMLItem);
        try {
            oXMLItem2.convert(OXMLSequenceType.TSTRING);
        }
        catch (oracle.xml.xqxp.XQException xQException) {
            String string = xQException.getMessage();
            String string2 = xQException.getErrorCode();
            if (string.equals("FORG0001")) {
                throw new XQException(XQMesg.getInstance().getMessage0("FORG0001"), XQMesg.getInstance().getMessage0(string2));
            }
            throw new XQException(XQMesg.getInstance().getMessage0(string2));
        }
        return (XMLNode)Expr.getDoc().createTextNode(oXMLItem2.getString());
    }

    private static String getStringForce(OXMLItem oXMLItem) {
        switch (oXMLItem.getPrimitiveType()) {
            case 0: 
            case 1: {
                return oXMLItem.getString();
            }
            case 90: {
                return oXMLItem.getNode().getText();
            }
            case 3: 
            case 4: {
                return String.valueOf(oXMLItem.getDouble());
            }
            case 5: 
            case 22: {
                if (oXMLItem.withinRange()) {
                    return String.valueOf(oXMLItem.getInt());
                }
                return oXMLItem.getDecimal().toString();
            }
            case 2: {
                return String.valueOf(oXMLItem.getBoolean());
            }
        }
        return oXMLItem.getLexicalValue();
    }

    public static float getFloatForce(OXMLItem oXMLItem) {
        int n = oXMLItem.getPrimitiveType();
        if (n == 22) {
            return oXMLItem.getInt();
        }
        if (n == 3) {
            return (float)oXMLItem.getDouble();
        }
        if (n == 90) {
            return Float.parseFloat(oXMLItem.getNode().getText());
        }
        if (n == 1) {
            return Float.parseFloat(oXMLItem.getString());
        }
        throw new XQException("XQueryUtils:getFloatForce()");
    }

    public static OXMLItemList getItemList(OXMLSequence oXMLSequence) {
        OXMLItemList oXMLItemList = new OXMLItemList();
        while (oXMLSequence.next()) {
            OXMLItem oXMLItem = oXMLSequence.getItem();
            oXMLItemList.addItem(oXMLItem);
        }
        return oXMLItemList;
    }

    public static void printResult(OXMLItem oXMLItem, PrintWriter printWriter, XQMesg xQMesg) throws Exception {
        XQueryUtils.printResult(oXMLItem, printWriter, xQMesg, false);
    }

    public static void printResult(OXMLItem oXMLItem, PrintWriter printWriter, XQMesg xQMesg, boolean bl) throws Exception {
        XQueryUtils.printResult(oXMLItem, printWriter, xQMesg, bl, true);
    }

    public static void printResult(OXMLItem oXMLItem, PrintWriter printWriter, XQMesg xQMesg, boolean bl, boolean bl2) throws Exception {
        int n = oXMLItem.getPrimitiveType();
        if (n == 90) {
            XMLNode xMLNode = oXMLItem.getNode();
            if (xMLNode.getNodeType() == 2 && System.getProperty("java.vm.name").equals("JServer VM")) {
                if (!((XMLAttr)xMLNode).getSpecified()) {
                    return;
                }
                String string = ((XMLAttr)xMLNode).getText();
                if (bl) {
                    string = XQueryUtils.convertString(string.toCharArray(), 0, string.length(), true);
                }
                printWriter.print(string);
            } else {
                XQPrintDriver xQPrintDriver = new XQPrintDriver(printWriter);
                xQPrintDriver.printNode(xMLNode);
                xQPrintDriver.flush();
            }
        } else if (n == 18) {
            QName qName = oXMLItem.getQName();
            printWriter.print('{' + qName.getNamespaceURI() + "}:" + qName.getLocalPart());
            if (bl2) {
                printWriter.println();
            }
        } else {
            String string = oXMLItem.getLexicalValue();
            if (bl) {
                string = XQueryUtils.convertString(string.toCharArray(), 0, string.length(), true);
            }
            printWriter.print(string);
            if (bl2 && !System.getProperty("java.vm.name").equals("JServer VM")) {
                printWriter.println();
            }
        }
        printWriter.flush();
    }

    public static boolean effectiveBoolValue(OXMLSequence oXMLSequence) {
        return oXMLSequence.getEffectiveBooleanValue();
    }

    private static boolean atomicValue(OXMLItem oXMLItem) {
        return oXMLItem.getPrimitiveType() != 90;
    }

    static OXMLItem getSingleItem(OXMLSequence oXMLSequence, String string) {
        if (!oXMLSequence.next()) {
            throw new XQException(XQMesg.getInstance().getMessage0(string), XQMesg.getInstance().getMessage0("XQE-0513"));
        }
        OXMLItem oXMLItem = oXMLSequence.getItem();
        if (oXMLSequence.next()) {
            throw new XQException(XQMesg.getInstance().getMessage0(string), XQMesg.getInstance().getMessage0("XQE-0514"));
        }
        return oXMLItem;
    }

    public static OXMLItem getSingleItem(OXMLSequence oXMLSequence) {
        return XQueryUtils.getSingleItem(oXMLSequence, "XPTY0004");
    }

    static OXMLItem getEmptyOrSingleItem(OXMLSequence oXMLSequence, String string) {
        if (!oXMLSequence.next()) {
            return null;
        }
        OXMLItem oXMLItem = oXMLSequence.getItem();
        if (oXMLSequence.next()) {
            throw new XQException(XQMesg.getInstance().getMessage0(string), XQMesg.getInstance().getMessage0("XQE-0514"));
        }
        return oXMLItem;
    }

    public static OXMLItem getEmptyOrSingleItem(OXMLSequence oXMLSequence) {
        return XQueryUtils.getEmptyOrSingleItem(oXMLSequence, "XPTY0004");
    }

    public static String getPrefix(String string) {
        String string2 = null;
        if (string == null) {
            return string2;
        }
        int n = string.indexOf(":");
        if (n == -1) {
            return string2;
        }
        string2 = string.substring(0, n);
        return string2;
    }

    public static String getLocalName(String string) {
        String string2 = null;
        if (string == null) {
            return string;
        }
        int n = string.indexOf(":");
        if (n == -1) {
            return string;
        }
        string2 = string.substring(n + 1);
        return string2;
    }

    static String getOperatorString(int n) {
        switch (n) {
            case 200: {
                return "+";
            }
            case 201: {
                return "-";
            }
            case 202: {
                return "*";
            }
            case 203: {
                return "div";
            }
            case 204: {
                return "idiv";
            }
            case 205: {
                return "mod";
            }
        }
        throw new XQException("Internal error in XQueryUtils:getOperatorString()");
    }

    static int getOperatorConstant(String string) {
        if (string.equals("+")) {
            return 200;
        }
        if (string.equals("-")) {
            return 201;
        }
        if (string.equals("*")) {
            return 202;
        }
        if (string.equals("div")) {
            return 203;
        }
        if (string.equals("idiv")) {
            return 204;
        }
        if (string.equals("mod")) {
            return 205;
        }
        throw new XQException("Internal error in XQueryUtils:getOperatorConstant()");
    }

    public static int getConstructionMode(String string) {
        if (string.equals("strip")) {
            return 1;
        }
        if (string.equals("preserve")) {
            return 0;
        }
        throw new XQException("Internal error in XQueryUtils:getConstructionMode()");
    }

    public static String getConstructionModeString(int n) {
        switch (n) {
            case 1: {
                return "strip";
            }
            case 0: {
                return "preserve";
            }
        }
        throw new XQException("Internal error in XQueryUtils:getConstructionModeString()");
    }

    public static String getXSDValidationMode(String string) {
        if (string.equals("strict")) {
            return "ORACLE_XSD_StrictValidation";
        }
        if (string.equals("lax")) {
            return "ORACLE_XSD_LaxValidation";
        }
        return null;
    }

    public static Connection getConnection(String string, String string2) throws SQLException {
        if (string2 == null) {
            string2 = "jdbc:oracle:oci8:@";
        }
        OracleDataSource oracleDataSource = new OracleDataSource();
        oracleDataSource.setURL(string2);
        if (string != null) {
            int n = string.indexOf(47);
            if (n == -1) {
                throw new XQException("Invalid Connection String");
            }
            String string3 = string.substring(0, n);
            String string4 = string.substring(n + 1);
            oracleDataSource.setUser(string3);
            oracleDataSource.setPassword(string4);
        }
        return oracleDataSource.getConnection();
    }

    public static String baseUriOf(String string) {
        if (string != null) {
            int n = string.lastIndexOf(47);
            if (n >= 0) {
                return string.substring(0, n + 1);
            }
            return null;
        }
        return null;
    }

    public static QName createQNameFromString(QueryState queryState, String string) {
        QName qName;
        int n = string.indexOf(58);
        if (n == -1) {
            qName = new QName(string);
        } else {
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            String string4 = queryState.resolveNamespacePrefix(string2);
            if (string4 == null) {
                throw new XQException(queryState.getMesg().getMessage0("XPST0081"), queryState.getMesg().getMessage1("XQE-0232", string2));
            }
            qName = new QName(string4, string3, string2);
        }
        return qName;
    }

    public static boolean validateURI(String string) {
        boolean bl = true;
        if (string == null || string.length() == 0) {
            return bl;
        }
        try {
            new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            bl = false;
        }
        return bl;
    }

    public static String resolveURI(String string, String string2) throws OraURIException {
        if (string2 == null) {
            return string;
        }
        OraURI oraURI = new OraURI(string);
        if (oraURI.isAbsolute()) {
            return string;
        }
        OraURI oraURI2 = new OraURI(string2);
        OraURI oraURI3 = oraURI2.resolve(oraURI);
        return oraURI3.toString();
    }

    public static void compareValue(OXMLItem oXMLItem, OXMLItem oXMLItem2, int n, OXMLItem oXMLItem3) {
        try {
            oXMLItem.compareValue(oXMLItem2, n, oXMLItem3);
        }
        catch (oracle.xml.xqxp.XQException xQException) {
            String string = xQException.getMessage();
            String string2 = xQException.getErrorCode();
            if (string.equals("FOTY0012")) {
                throw new XQException(XQMesg.getInstance().getMessage0("XPTY0004"), XQMesg.getInstance().getMessage0(string2));
            }
            throw new XQException(XQMesg.getInstance().getMessage0(string2));
        }
    }

    public static void arithmetic(OXMLItem oXMLItem, OXMLItem oXMLItem2, int n, OXMLItem oXMLItem3) {
        try {
            oXMLItem.arithmetic(oXMLItem2, n, oXMLItem3);
        }
        catch (oracle.xml.xqxp.XQException xQException) {
            throw new XQException(XQMesg.getInstance().getMessage0(xQException.getErrorCode()));
        }
    }

    public static int compareValue(OXMLItem oXMLItem, OXMLItem oXMLItem2, OraCollator oraCollator) {
        try {
            return oXMLItem.compareValue(oXMLItem2, oraCollator);
        }
        catch (oracle.xml.xqxp.XQException xQException) {
            String string = xQException.getMessage();
            String string2 = xQException.getErrorCode();
            if (string.equals("FOTY0012")) {
                throw new XQException(XQMesg.getInstance().getMessage0("XPTY0004"), XQMesg.getInstance().getMessage0(string2));
            }
            throw new XQException(XQMesg.getInstance().getMessage0(string2));
        }
    }

    public static void convert(OXMLItem oXMLItem, OXMLSequenceType oXMLSequenceType) {
        try {
            oXMLItem.convert(oXMLSequenceType);
        }
        catch (oracle.xml.xqxp.XQException xQException) {
            String string = xQException.getErrorCode();
            throw new XQException(XQMesg.getInstance().getMessage0(string));
        }
    }

    static OXMLItem convert(OXMLItem oXMLItem, OXMLSequenceType oXMLSequenceType, QueryState queryState) {
        OXMLItem oXMLItem2 = queryState.createItem();
        oXMLItem2.copyItem(oXMLItem);
        XQueryUtils.convert(oXMLItem2, oXMLSequenceType);
        return oXMLItem2;
    }

    public static Node getFirstElement(Node node) {
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (node2.getNodeType() != 1) continue;
            return node2;
        }
        return null;
    }

    public static Node getFirstElement(Node node, String string) {
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (node2.getNodeType() != 1 || !node2.getNodeName().equals(string)) continue;
            return node2;
        }
        return null;
    }

    public static QxName handleWildcardQName(QxName qxName) {
        String string = qxName.getPrefix();
        String string2 = qxName.getLocalPart();
        QxName qxName2 = qxName;
        if (string != null && string.equals("*")) {
            qxName2 = new QxName("*", string2);
        } else if (string == null && string2.equals("*")) {
            qxName2 = new QxName("*", "*");
        }
        return qxName2;
    }

    public static String getQNameString(QName qName) {
        String string = qName.getPrefix();
        String string2 = qName.getLocalPart();
        if (string == null || string.equals("")) {
            return string2;
        }
        return string + ":" + string2;
    }

    public static int compareNodeOrder(XMLNode xMLNode, XMLNode xMLNode2) {
        return FNUtil.compareNodeOrder((XMLNode)xMLNode, (XMLNode)xMLNode2);
    }

    public static OXMLSequence normalizeParameter(QueryState queryState, OXMLSequenceType oXMLSequenceType, OXMLSequence oXMLSequence, int n) {
        if (oXMLSequenceType == null || oXMLSequenceType == OXMLSequenceType.ITEM_ZERO_OR_MORE) {
            return oXMLSequence;
        }
        if (oXMLSequenceType.isOfType(OXMLSequenceType.ANYATOMIC_ZERO_OR_MORE)) {
            boolean bl = XQueryUtils.needAtomization(n);
            if (bl) {
                oXMLSequence = oXMLSequence.atomize();
            }
            if (oXMLSequenceType != OXMLSequenceType.ANYATOMIC_ZERO_OR_MORE && oXMLSequenceType != OXMLSequenceType.ANYATOMIC_ONE && oXMLSequenceType != OXMLSequenceType.ANYATOMIC_ZERO_OR_ONE) {
                OXMLSequence oXMLSequence2 = queryState.createSequence();
                boolean bl2 = XQueryUtils.needCast(n);
                boolean bl3 = XQueryUtils.needTypePromotion(n);
                try {
                    while (oXMLSequence.next()) {
                        OXMLItem oXMLItem = oXMLSequence.getItem();
                        if (bl2 && oXMLItem.matchesType(OXMLSequenceType.TUNTYPED)) {
                            if (oXMLSequenceType == OXMLSequenceType.NUMERIC_ZERO_OR_ONE) {
                                oXMLItem.convert(OXMLSequenceType.TDOUBLE);
                            } else {
                                oXMLItem.convert(oXMLSequenceType);
                            }
                        } else if (bl3 && oXMLSequenceType.isOfType(OXMLSequenceType.NUMERIC_ZERO_OR_MORE)) {
                            if (oXMLSequenceType.isOfTypeIgnoreOccurence(OXMLSequenceType.TDOUBLE)) {
                                if (oXMLItem.matchesType(OXMLSequenceType.TFLOAT) || oXMLItem.matchesType(OXMLSequenceType.TDECIMAL)) {
                                    oXMLItem.convert(OXMLSequenceType.TDOUBLE);
                                }
                            } else if (oXMLSequenceType.isOfTypeIgnoreOccurence(OXMLSequenceType.TFLOAT) && oXMLItem.matchesType(OXMLSequenceType.TDECIMAL)) {
                                oXMLItem.convert(OXMLSequenceType.TFLOAT);
                            }
                        } else if (bl3 && oXMLSequenceType.isOfTypeIgnoreOccurence(OXMLSequenceType.TSTRING) && oXMLItem.matchesType(OXMLSequenceType.TANYURI)) {
                            oXMLItem.convert(OXMLSequenceType.TSTRING);
                        }
                        oXMLSequence2.appendItem(oXMLItem);
                    }
                    if (bl) {
                        queryState.returnSequence(oXMLSequence);
                    }
                }
                catch (oracle.xml.xqxp.XQException xQException) {
                    String string = xQException.getMessage();
                    String string2 = xQException.getErrorCode();
                    if (string.equals("FORG0001")) {
                        throw new XQException(queryState.getMesg().getMessage0("FORG0001"), queryState.getMesg().getMessage0(string2));
                    }
                    if (string.equals("FOTY0001")) {
                        throw new XQException(queryState.getMesg().getMessage0("XPTY0004"), queryState.getMesg().getMessage0(string2));
                    }
                    throw new XQException(queryState.getMesg().getMessage0(string2));
                }
                oXMLSequence = oXMLSequence2;
                ((OXQuerySequence)oXMLSequence).restart();
            }
        }
        return oXMLSequence;
    }

    static boolean isBuiltIn(String string) {
        return XQueryUtils.fnEquals(string) || string.equals("http://www.w3.org/2001/XMLSchema") || string.equals("http://xmlns.oracle.com/xdb");
    }

    public static boolean fnEquals(String string) {
        return string.equals("http://www.w3.org/2005/xpath-functions");
    }

    public static boolean lcEquals(String string) {
        return string.equals("http://www.w3.org/2005/xquery-local-functions");
    }

    public static String convertString(char[] cArray, int n, int n2, boolean bl) {
        int n3 = n;
        StringBuffer stringBuffer = new StringBuffer(n2 + 10);
        int n4 = n2;
        block6: for (int i = 0; i < n2; ++i) {
            char c = cArray[i + n];
            if ((c != '&' || c == '&' && !bl) && c != '<' && c != '>' && c != '\"') continue;
            if (i - n3 > 0) {
                stringBuffer.append(cArray, n3, i - n3);
            }
            n3 = i + 1;
            switch (c) {
                case '<': {
                    stringBuffer.append(LESS_THEN_REP);
                    continue block6;
                }
                case '>': {
                    stringBuffer.append(GREATER_THEN_REP);
                    continue block6;
                }
                case '&': {
                    stringBuffer.append(AMP_REP);
                    continue block6;
                }
                case '\"': {
                    stringBuffer.append(QUOTE_REP);
                }
            }
        }
        if (n3 < n2) {
            stringBuffer.append(cArray, n3, n2 - n3);
        }
        return stringBuffer.toString();
    }

    static boolean validateNCName(String string) {
        return FNUtil.validateNCName((String)string);
    }

    static void normalizeText(XMLNode xMLNode) {
        XMLNode xMLNode2 = null;
        for (XMLNode xMLNode3 = (XMLNode)xMLNode.getFirstChild(); xMLNode3 != null; xMLNode3 = (XMLNode)xMLNode3.getNextSibling()) {
            if (xMLNode3.getNodeType() == 3) {
                xMLNode2 = (XMLNode)xMLNode3.getNextSibling();
                while (xMLNode2 != null && xMLNode2.getNodeType() == 3) {
                    xMLNode3.setNodeValue(xMLNode3.getNodeValue() + xMLNode2.getNodeValue());
                    xMLNode.removeChild((Node)xMLNode2);
                    xMLNode2 = (XMLNode)xMLNode3.getNextSibling();
                }
                if (xMLNode3.getNodeValue().length() == 0) {
                    xMLNode.removeChild((Node)xMLNode3);
                }
                if (xMLNode2 == null) {
                    return;
                }
                xMLNode3 = xMLNode2;
            }
            if (xMLNode3.getNodeType() != 1 || !xMLNode3.hasChildNodes()) continue;
            XQueryUtils.normalizeText(xMLNode3);
        }
    }

    static boolean needAtomization(int n) {
        return (n & 2) == 2;
    }

    static boolean needCast(int n) {
        return (n & 4) == 4;
    }

    static boolean needTypePromotion(int n) {
        return (n & 8) == 8;
    }

    static boolean unknownStaticType(int n) {
        return (n & 1) == 1;
    }

    private static void validateXMLChar(char c, boolean bl, String string) throws XQException {
        if (!(c == '\t' || c == '\n' || c == '\r' || c >= ' ' && c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd')) {
            String string2 = bl ? "&#x" : "&#";
            throw new XQException(XQMesg.getInstance().getMessage0("XQST0090"), "Lexical error. Encountered: \"" + string + "\", after: \"" + string2 + "\", which is an invalid XML character.");
        }
    }

    public static int getIntPositionValue(OXMLItem oXMLItem) {
        int n = oXMLItem.getPrimitiveType();
        int n2 = 0;
        switch (n) {
            case 22: {
                n2 = oXMLItem.getInt();
                break;
            }
            case 5: {
                if (oXMLItem.intFormat()) {
                    n2 = oXMLItem.getInt();
                    break;
                }
                BigDecimal bigDecimal = oXMLItem.getDecimal();
                n2 = bigDecimal.intValue();
                double d = bigDecimal.doubleValue();
                if (d == (double)n2) break;
                n2 = -1;
                break;
            }
            case 3: {
                float f = oXMLItem.getFloat();
                n2 = (int)f;
                if (f == (float)n2) break;
                n2 = -1;
                break;
            }
            case 4: {
                double d = oXMLItem.getDouble();
                n2 = (int)d;
                if (d == (double)n2) break;
                n2 = -1;
            }
        }
        return n2;
    }

    static int getIntPositionValue(String string, int n) {
        int n2 = 0;
        switch (n) {
            case 22: {
                n2 = Integer.parseInt(string);
                break;
            }
            case 5: {
                BigDecimal bigDecimal = new BigDecimal(string);
                n2 = bigDecimal.intValue();
                double d = bigDecimal.doubleValue();
                if (d == (double)n2) break;
                n2 = -1;
                break;
            }
            case 3: {
                float f = Float.parseFloat(string);
                n2 = (int)f;
                if (f == (float)n2) break;
                n2 = -1;
                break;
            }
            case 4: {
                double d = Double.parseDouble(string);
                n2 = (int)d;
                if (d == (double)n2) break;
                n2 = -1;
            }
        }
        return n2;
    }

    static boolean isBuiltInFunction(Expr expr, String string) {
        if (expr instanceof FunctionCall) {
            return XQueryUtils.isBuiltInFunction((FunctionCall)expr, string);
        }
        return false;
    }

    static boolean isBuiltInFunction(FunctionCall functionCall, String string) {
        return XQueryUtils.fnEquals(functionCall.fd.getNamespace()) && functionCall.fd.getFunctionName().equals(string);
    }

    static boolean isForwardElementAxis(int n) {
        return n == 11 || n == 3 || n == 4 || n == 5;
    }

    public static boolean isForwardElementAxis(PathStep pathStep) {
        int n = pathStep.getAxis();
        return XQueryUtils.isForwardElementAxis(n);
    }

    static QName convertString2QName(String string, QueryState queryState, XMLNode xMLNode) {
        QName qName = null;
        if (string.length() == 0) {
            throw new XQException(XQMesg.getInstance().getMessage0("FORG0001"));
        }
        int n = string.indexOf(58);
        if (n == -1) {
            String string2 = XQueryUtils.getNamespaceURI(null, queryState, xMLNode);
            if (!XQueryUtils.validateNCName(string)) {
                throw new XQException(XQMesg.getInstance().getMessage0("FORG0001"));
            }
            qName = string2 == null ? new QName(string) : new QName(string2, string, "");
        } else {
            String string3 = string.substring(0, n);
            if (!XQueryUtils.validateNCName(string3)) {
                throw new XQException(XQMesg.getInstance().getMessage0("FORG0001"));
            }
            String string4 = XQueryUtils.getNamespaceURI(string3, queryState, xMLNode);
            if (string4 == null) {
                throw new XQException(XQMesg.getInstance().getMessage0("FONS0004"), string);
            }
            if (string4 == "") {
                throw new XQException(XQMesg.getInstance().getMessage0("FOCA0002"));
            }
            String string5 = string.substring(n + 1);
            if (!XQueryUtils.validateNCName(string5)) {
                throw new XQException(XQMesg.getInstance().getMessage0("FORG0001"));
            }
            qName = new QName(string4, string5, string3);
        }
        return qName;
    }

    private static String getNamespaceURI(String string, QueryState queryState, XMLNode xMLNode) {
        String string2 = null;
        if (queryState != null) {
            String string3 = string2 = string == null ? queryState.getDefaultElemNS() : queryState.getInScopeNamespace(string);
        }
        if (string2 == null && xMLNode != null) {
            string2 = xMLNode.lookupNamespaceURI(string);
        }
        return string2;
    }

    static XMLNode copyNode(XMLNode xMLNode, XMLNode xMLNode2, XMLDocument xMLDocument, boolean bl, boolean bl2) {
        XMLNode xMLNode3 = xMLNode2.copyNode(xMLDocument, bl);
        if (xMLNode2.getNodeType() == 1) {
            XMLElement xMLElement = (XMLElement)xMLNode3;
            XMLElement xMLElement2 = (XMLElement)xMLNode2;
            if (bl2) {
                HashMap hashMap = new HashMap();
                XQueryUtils.getNSDecls(xMLNode, xMLElement2, hashMap);
                for (String string : hashMap.keySet()) {
                    String string2 = (String)hashMap.get(string);
                    if (string.equals("")) {
                        xMLElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", string2);
                        continue;
                    }
                    xMLElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + string, string2);
                }
            }
        }
        return xMLNode3;
    }

    private static void getNSDecls(XMLNode xMLNode, XMLElement xMLElement, HashMap hashMap) {
        Object object;
        HashMap hashMap2 = new HashMap();
        if (xMLNode.getNodeType() == 1) {
            XQueryUtils.scanNSDecls((XMLElement)xMLNode, hashMap2, null, true);
            object = new HashMap();
            XQueryUtils.scanNSDecls(xMLElement, hashMap2, (HashMap)object, false);
            hashMap2.putAll(object);
        } else {
            XQueryUtils.scanNSDecls(xMLElement, hashMap2, null, false);
        }
        for (object = xMLElement.getParentNode(); object != null; object = object.getParentNode()) {
            if (object.getNodeType() != 1) continue;
            XQueryUtils.scanNSDecls((XMLElement)object, hashMap, hashMap2, false);
        }
    }

    private static void scanNSDecls(XMLElement xMLElement, HashMap hashMap, HashMap hashMap2, boolean bl) {
        String string;
        String string2;
        if (bl) {
            string2 = xMLElement.getPrefix();
            string = xMLElement.getNamespaceURI();
            if (string != null && !string.equals("")) {
                hashMap.put(string2 == null ? "" : string2, string);
            }
        }
        for (string2 = (XMLAttr)xMLElement.getFirstAttribute(); string2 != null; string2 = string2.getNextAttribute()) {
            if (!string2.isNodeFlag(262144)) continue;
            string = string2.getNodePrefix();
            String string3 = string2.getLocalName();
            if ("xmlns".equals(string)) {
                if (hashMap2 != null && hashMap2.containsKey(string3) && string2.getNodeValue().equals(hashMap2.get(string3))) continue;
                hashMap.put(string3, string2.getNodeValue());
                continue;
            }
            if (hashMap2 != null && hashMap2.containsKey("") && string2.getNodeValue().equals(hashMap2.get(""))) continue;
            hashMap.put("", string2.getNodeValue());
        }
    }

    public static String read2String(Reader reader) {
        StringBuffer stringBuffer = new StringBuffer();
        BufferedReader bufferedReader = new BufferedReader(reader);
        char[] cArray = new char[1024];
        try {
            int n = bufferedReader.read(cArray);
            while (n > 0) {
                stringBuffer.append(cArray, 0, n);
                n = bufferedReader.read(cArray);
            }
        }
        catch (IOException iOException) {
            throw new XQException(iOException);
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (Exception exception) {}
        }
        return stringBuffer.toString();
    }

    public static void printBytes(byte[] byArray, PrintStream printStream) {
        for (int i = 0; i < byArray.length; ++i) {
            printStream.print(byArray[i]);
            printStream.print(' ');
        }
    }

    public static int fourBytesToInt(byte[] byArray, int n) {
        int n2 = 0;
        n2 += XQueryUtils.unsignedByteToInt(byArray[n++]) << 24;
        n2 += XQueryUtils.unsignedByteToInt(byArray[n++]) << 16;
        n2 += XQueryUtils.unsignedByteToInt(byArray[n++]) << 8;
        return n2 += XQueryUtils.unsignedByteToInt(byArray[n++]);
    }

    public static int fourBytesToIntReverse(byte[] byArray, int n) {
        int n2 = 0;
        n2 += XQueryUtils.unsignedByteToInt(byArray[n++]);
        n2 += XQueryUtils.unsignedByteToInt(byArray[n++]) << 8;
        n2 += XQueryUtils.unsignedByteToInt(byArray[n++]) << 16;
        return n2 += XQueryUtils.unsignedByteToInt(byArray[n++]) << 24;
    }

    public static int twoBytesToInt(byte[] byArray, int n) {
        int n2 = 0;
        n2 += XQueryUtils.unsignedByteToInt(byArray[n++]) << 8;
        return n2 += XQueryUtils.unsignedByteToInt(byArray[n++]);
    }

    public static int twoBytesToIntReverse(byte[] byArray, int n) {
        int n2 = 0;
        n2 += XQueryUtils.unsignedByteToInt(byArray[n++]);
        return n2 += XQueryUtils.unsignedByteToInt(byArray[n++]) << 8;
    }

    public static int unsignedByteToInt(byte by) {
        return by & 0xFF;
    }
}

