/*
 * Decompiled with CFR 0.152.
 */
package oracle.xquery.parser;

import java.util.StringTokenizer;
import oracle.xquery.XQException;
import oracle.xquery.parser.ParseException;
import oracle.xquery.parser.ParserUtil;
import oracle.xquery.parser.SplNode;
import oracle.xquery.parser.XPath;
import oracle.xquery.parser.XPathTreeConstants;
import oracle.xquery.parser.XQXGen;
import oracle.xquery.parser.XQueryXUtils;

public class NamedSplNode
extends SplNode {
    protected String name;
    public static final byte PROLOG_VARIABLE = 1;
    public static final byte DEFAULT_COLLATION = 2;
    public static final byte XQUERY_VERSION = 3;
    public static final byte BASE_URI = 4;
    public static final byte CONSTRUCTION_DECL = 5;
    public static final byte VARIABLE_BINDING = 6;
    public static final byte VALIDATE_MODE = 7;
    public static final byte NAMESPACE_PREFIX = 8;
    public static final byte TARGET_NS = 9;
    public static final byte TARGET_LOC = 10;
    public static final byte XQUERY_VERSION_ENCODING = 11;

    public void setName(String string) {
        this.name = string;
    }

    public void setAndNormalizeName(String string) throws ParseException {
        this.name = ParserUtil.normalize(string);
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(String string) {
        String string2 = string + XPathTreeConstants.jjtNodeName[this.id];
        string2 = string2 + " nodeType = " + this.nodeType;
        if (this.name != null) {
            string2 = string2 + " : name = " + this.name;
        }
        return string2;
    }

    public NamedSplNode(int n) {
        super(n);
    }

    public NamedSplNode(XPath xPath, int n) {
        super(xPath, n);
    }

    public void dumpSAX(XQXGen xQXGen) {
        if (XPath.newXQueryXGrammar) {
            switch (this.nodeType) {
                case 1: {
                    int n;
                    xQXGen.startElement("varDecl");
                    XQueryXUtils.printQName(xQXGen, this.getName(), "varName");
                    if (this.children.length > 1) {
                        this.children[0].dumpSAX(xQXGen);
                        n = 1;
                    } else {
                        n = 0;
                    }
                    if (this.children[n] instanceof SplNode && ((SplNode)this.children[n]).getNodeType() == 4) {
                        this.children[n].dumpSAX(xQXGen);
                    } else {
                        xQXGen.startElement("varValue");
                        this.children[n].dumpSAX(xQXGen);
                        xQXGen.endElement("varValue");
                    }
                    xQXGen.endElement("varDecl");
                    break;
                }
                case 2: {
                    xQXGen.startElement("defaultCollationDecl");
                    xQXGen.characters(this.name);
                    xQXGen.endElement("defaultCollationDecl");
                    break;
                }
                case 3: {
                    int n = 0;
                    int n2 = 0;
                    n = this.name.indexOf(34);
                    if (n != -1) {
                        n2 = this.name.lastIndexOf(34);
                    } else {
                        n = this.name.indexOf("'");
                        n2 = this.name.lastIndexOf("'");
                    }
                    this.name = this.name.substring(n + 1, n2);
                    xQXGen.startElement("versionDecl");
                    xQXGen.startElement("version");
                    xQXGen.characters(this.getName());
                    xQXGen.endElement("version");
                    xQXGen.endElement("versionDecl");
                    this.dumpSAXChildren(xQXGen);
                    break;
                }
                case 4: {
                    xQXGen.startElement("baseUriDecl");
                    xQXGen.characters(this.name);
                    xQXGen.endElement("baseUriDecl");
                    break;
                }
                case 5: {
                    xQXGen.startElement("constructionDecl");
                    xQXGen.characters(this.getName());
                    xQXGen.endElement("constructionDecl");
                    break;
                }
                case 6: {
                    XQueryXUtils.printQName(xQXGen, this.getName(), "variableBinding");
                    break;
                }
                case 7: {
                    StringTokenizer stringTokenizer = new StringTokenizer(this.name);
                    stringTokenizer.nextToken();
                    this.name = stringTokenizer.nextToken();
                    xQXGen.startElement("validationMode");
                    xQXGen.characters(this.name);
                    xQXGen.endElement("validationMode");
                    break;
                }
                case 8: {
                    xQXGen.startElement("namespacePrefix");
                    xQXGen.characters(this.getName());
                    xQXGen.endElement("namespacePrefix");
                    break;
                }
                case 9: {
                    xQXGen.startElement("targetNamespace");
                    xQXGen.characters(this.getName());
                    xQXGen.endElement("targetNamespace");
                    break;
                }
                case 10: {
                    xQXGen.startElement("targetLocation");
                    xQXGen.characters(this.name);
                    xQXGen.endElement("targetLocation");
                    break;
                }
                case 11: {
                    break;
                }
                default: {
                    throw new XQException(xQXGen.msg.getMessage1("XQE-0001", "NamedSplNode: unknown type"));
                }
            }
        } else {
            switch (this.nodeType) {
                case 1: {
                    xQXGen.startElement("prolog_variable");
                    xQXGen.characters(this.getName());
                    this.dumpSAXChildren(xQXGen);
                    xQXGen.endElement("prolog_variable");
                    break;
                }
                case 2: {
                    xQXGen.startElement("default_collation");
                    xQXGen.characters(this.name);
                    xQXGen.endElement("default_collation");
                    break;
                }
                case 3: {
                    int n = 0;
                    int n3 = 0;
                    n = this.name.indexOf(34);
                    if (n != -1) {
                        n3 = this.name.lastIndexOf(34);
                    } else {
                        n = this.name.indexOf("'");
                        n3 = this.name.lastIndexOf("'");
                    }
                    this.name = this.name.substring(n + 1, n3);
                    xQXGen.startElement("version");
                    xQXGen.characters(this.getName());
                    xQXGen.endElement("version");
                    this.dumpSAXChildren(xQXGen);
                    break;
                }
                case 4: {
                    xQXGen.startElement("base_uri");
                    xQXGen.characters(this.name);
                    xQXGen.endElement("base_uri");
                    break;
                }
                case 5: {
                    xQXGen.startElement("constructionDecl");
                    xQXGen.characters(this.getName());
                    xQXGen.endElement("constructionDecl");
                    break;
                }
                case 6: {
                    xQXGen.startElement("variableBinding");
                    xQXGen.characters(this.getName());
                    xQXGen.endElement("variableBinding");
                    break;
                }
                case 7: {
                    StringTokenizer stringTokenizer = new StringTokenizer(this.name);
                    stringTokenizer.nextToken();
                    this.name = stringTokenizer.nextToken();
                    xQXGen.startElement("validationMode");
                    xQXGen.characters(this.name);
                    xQXGen.endElement("validationMode");
                    break;
                }
                case 8: {
                    xQXGen.startElement("namespacePrefix");
                    xQXGen.characters(this.getName());
                    xQXGen.endElement("namespacePrefix");
                    break;
                }
                case 9: {
                    xQXGen.startElement("targetNamespace");
                    xQXGen.characters(this.getName());
                    xQXGen.endElement("targetNamespace");
                    break;
                }
                case 10: {
                    xQXGen.startElement("targetLocation");
                    xQXGen.characters(this.name);
                    xQXGen.endElement("targetLocation");
                    break;
                }
                case 11: {
                    xQXGen.startElement("encoding");
                    this.name = this.name.substring(1, this.name.length() - 1);
                    xQXGen.characters(this.name);
                    xQXGen.endElement("encoding");
                    break;
                }
                default: {
                    throw new XQException(xQXGen.msg.getMessage1("XQE-0001", "NamedSplNode: unknown type"));
                }
            }
        }
    }
}

