/*
 * Decompiled with CFR 0.152.
 */
package oracle.xquery.parser;

import oracle.xquery.XQException;
import oracle.xquery.exec.XQueryUtils;
import oracle.xquery.parser.AttributeList;
import oracle.xquery.parser.ExprSingle;
import oracle.xquery.parser.ParseException;
import oracle.xquery.parser.ParserUtil;
import oracle.xquery.parser.XPath;
import oracle.xquery.parser.XPathStringValue;
import oracle.xquery.parser.XPathTreeConstants;
import oracle.xquery.parser.XQXGen;
import oracle.xquery.parser.XQueryXUtils;
import org.xml.sax.helpers.AttributesImpl;

public class PrimaryExpr
extends ExprSingle {
    protected String name;
    public static final byte QNAME = 1;
    public static final byte STRING_LITERAL = 2;
    public static final byte INTEGER_LITERAL = 3;
    public static final byte DECIMAL_LITERAL = 4;
    public static final byte DOUBLE_LITERAL = 5;
    public static final byte FUNCTION_CALL = 6;
    public static final byte ATTR_VALUE = 7;
    public static final byte ELEMENT_CONSTRUCTOR = 8;
    public static final byte DOT = 9;
    public static final byte DOT_DOT = 10;
    public static final byte VARIABLE = 11;
    public static final byte NAME = 12;
    public static final byte SIMPLE_NAME = 1;
    public static final byte WILDCARD = 2;
    public static final byte XML_PI = 13;
    public static final byte COMPUTED_XML_PI = 14;
    public static final byte COMPUTED_ELEMENT = 15;
    public static final byte COMPUTED_ATTRIBUTE = 16;
    public static final byte COMPUTED_NAMESPACE = 17;
    public static final byte POS_VARIABLE = 18;

    public void setName(String string) {
        this.name = string;
    }

    public void setAndNormalizeName(String string) throws ParseException {
        this.name = ParserUtil.normalize(string);
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(String string) {
        String string2 = string + XPathTreeConstants.jjtNodeName[this.id];
        if (this.name != null) {
            string2 = string2 + " : name = " + this.name;
        }
        if (this.exprType != 0) {
            string2 = string2 + " : exprType = " + this.exprType;
        }
        if (this.exprSubType != 0) {
            string2 = string2 + " : exprSubtype = " + this.exprSubType;
        }
        return string2;
    }

    public PrimaryExpr(int n) {
        super(n);
    }

    public PrimaryExpr(XPath xPath, int n) {
        super(xPath, n);
    }

    public void dumpSAX(XQXGen xQXGen) {
        if (XPath.newXQueryXGrammar) {
            block0 : switch (this.exprType) {
                case 2: {
                    String string = this.getName();
                    xQXGen.startElement("stringConstantExpr");
                    xQXGen.startElement("value");
                    xQXGen.characters(this.getName());
                    xQXGen.endElement("value");
                    xQXGen.endElement("stringConstantExpr");
                    break;
                }
                case 3: {
                    xQXGen.startElement("integerConstantExpr");
                    xQXGen.startElement("value");
                    xQXGen.characters(this.getName());
                    xQXGen.endElement("value");
                    xQXGen.endElement("integerConstantExpr");
                    break;
                }
                case 4: {
                    xQXGen.startElement("decimalConstantExpr");
                    xQXGen.startElement("value");
                    xQXGen.characters(this.getName());
                    xQXGen.endElement("value");
                    xQXGen.endElement("decimalConstantExpr");
                    break;
                }
                case 5: {
                    xQXGen.startElement("doubleConstantExpr");
                    xQXGen.startElement("value");
                    xQXGen.characters(this.getName());
                    xQXGen.endElement("value");
                    xQXGen.endElement("doubleConstantExpr");
                    break;
                }
                case 6: {
                    xQXGen.startElement("functionCallExpr");
                    XQueryXUtils.printQName(xQXGen, this.getName(), "functionName");
                    xQXGen.startElement("arguments");
                    for (int i = 0; i < this.jjtGetNumChildren(); ++i) {
                        this.jjtGetChild(i).dumpSAX(xQXGen);
                    }
                    xQXGen.endElement("arguments");
                    xQXGen.endElement("functionCallExpr");
                    break;
                }
                case 8: {
                    int n;
                    xQXGen.startElement("elementConstructor");
                    XQueryXUtils.printQName(xQXGen, this.getName(), "tagName");
                    if (this.jjtGetChild(0) instanceof AttributeList) {
                        this.jjtGetChild(0).dumpSAX(xQXGen);
                        n = 1;
                    } else {
                        n = 0;
                    }
                    xQXGen.startElement("elementContent");
                    while (n < this.jjtGetNumChildren()) {
                        this.jjtGetChild(n).dumpSAX(xQXGen);
                        ++n;
                    }
                    xQXGen.endElement("elementContent");
                    xQXGen.endElement("elementConstructor");
                    break;
                }
                case 11: {
                    xQXGen.startElement("varRef");
                    XQueryXUtils.printQName(xQXGen, this.getName(), "name");
                    xQXGen.endElement("varRef");
                    break;
                }
                case 18: {
                    XQueryXUtils.printQName(xQXGen, this.getName(), "positionalVariableBinding");
                    break;
                }
                case 9: {
                    xQXGen.startElement("contextItemExpr");
                    xQXGen.endElement("contextItemExpr");
                    break;
                }
                case 10: {
                    xQXGen.startElement("xpathAxis");
                    xQXGen.characters("parent");
                    xQXGen.endElement("xpathAxis");
                    xQXGen.startElement("anyKindTest");
                    xQXGen.endElement("anyKindTest");
                    break;
                }
                case 12: {
                    switch (this.getExprSubType()) {
                        case 2: {
                            String string;
                            xQXGen.startElement("Wildcard");
                            String string2 = XQueryUtils.getPrefix(this.getName());
                            if (string2 != null) {
                                if (string2.equals("*")) {
                                    xQXGen.startElement("star");
                                    xQXGen.endElement("star");
                                } else {
                                    xQXGen.startElement("NCName");
                                    xQXGen.characters(string2);
                                    xQXGen.endElement("NCName");
                                }
                            }
                            if ((string = XQueryUtils.getLocalName(this.getName())) != null) {
                                if (string.equals("*")) {
                                    xQXGen.startElement("star");
                                    xQXGen.endElement("star");
                                } else {
                                    xQXGen.startElement("NCName");
                                    xQXGen.characters(string);
                                    xQXGen.endElement("NCName");
                                }
                            }
                            xQXGen.endElement("Wildcard");
                            break block0;
                        }
                        case 1: {
                            XQueryXUtils.printQName(xQXGen, this.getName(), "nameTest");
                        }
                    }
                    break;
                }
                case 13: {
                    xQXGen.startElement("computedPIConstructor");
                    xQXGen.startElement("piTarget");
                    xQXGen.characters(this.getName());
                    xQXGen.endElement("piTarget");
                    xQXGen.startElement("piValueExpr");
                    xQXGen.startElement("computedTextConstructor");
                    xQXGen.startElement("argExpr");
                    xQXGen.startElement("stringConstantExpr");
                    xQXGen.startElement("value");
                    if (this.children == null) {
                        xQXGen.characters("");
                    } else {
                        char[] cArray = ((XPathStringValue)this.children[0]).getStringValue().toCharArray();
                        xQXGen.characters(XQueryUtils.convertString(cArray, 0, cArray.length, true));
                    }
                    xQXGen.endElement("value");
                    xQXGen.endElement("stringConstantExpr");
                    xQXGen.endElement("argExpr");
                    xQXGen.endElement("computedTextConstructor");
                    xQXGen.endElement("piValueExpr");
                    xQXGen.endElement("computedPIConstructor");
                    break;
                }
                case 14: {
                    xQXGen.startElement("computedPIConstructor");
                    if (this.name != null) {
                        xQXGen.startElement("piTarget");
                        this.name = this.name.substring(22, this.name.length() - 1);
                        xQXGen.characters(PrimaryExpr.trimXmlWhiteSpace(this.name));
                        xQXGen.endElement("piTarget");
                        if (this.children != null && this.children.length > 0) {
                            xQXGen.startElement("piValueExpr");
                            this.children[0].dumpSAX(xQXGen);
                            xQXGen.endElement("piValueExpr");
                        }
                    } else {
                        xQXGen.startElement("piTargetExpr");
                        this.children[0].dumpSAX(xQXGen);
                        xQXGen.endElement("piTargetExpr");
                        if (this.children.length > 1) {
                            xQXGen.startElement("piValueExpr");
                            this.children[1].dumpSAX(xQXGen);
                            xQXGen.endElement("piValueExpr");
                        }
                    }
                    xQXGen.endElement("computedPIConstructor");
                    break;
                }
                case 15: {
                    xQXGen.startElement("computedElementConstructor");
                    if (this.name != null) {
                        this.name = this.name.substring(7, this.name.length() - 1);
                        XQueryXUtils.printQName(xQXGen, PrimaryExpr.trimXmlWhiteSpace(this.name), "tagName");
                        if (this.children != null && this.children.length > 0) {
                            xQXGen.startElement("contentExpr");
                            this.children[0].dumpSAX(xQXGen);
                            xQXGen.endElement("contentExpr");
                        }
                    } else {
                        xQXGen.startElement("tagNameExpr");
                        this.children[0].dumpSAX(xQXGen);
                        xQXGen.endElement("tagNameExpr");
                        if (this.children.length > 1) {
                            xQXGen.startElement("contentExpr");
                            this.children[1].dumpSAX(xQXGen);
                            xQXGen.endElement("contentExpr");
                        }
                    }
                    xQXGen.endElement("computedElementConstructor");
                    break;
                }
                case 16: {
                    xQXGen.startElement("computedAttributeConstructor");
                    if (this.name != null) {
                        this.name = this.name.substring(9, this.name.length() - 1);
                        XQueryXUtils.printQName(xQXGen, PrimaryExpr.trimXmlWhiteSpace(this.name), "tagName");
                        if (this.children != null && this.children.length > 0) {
                            xQXGen.startElement("valueExpr");
                            this.children[0].dumpSAX(xQXGen);
                            xQXGen.endElement("valueExpr");
                        }
                    } else {
                        xQXGen.startElement("tagNameExpr");
                        this.children[0].dumpSAX(xQXGen);
                        xQXGen.endElement("tagNameExpr");
                        if (this.children.length > 1) {
                            xQXGen.startElement("valueExpr");
                            this.children[1].dumpSAX(xQXGen);
                            xQXGen.endElement("valueExpr");
                        }
                    }
                    xQXGen.endElement("computedAttributeConstructor");
                    break;
                }
                default: {
                    throw new XQException(xQXGen.msg.getMessage1("XQE-0007", Integer.toString(this.exprType)));
                }
            }
        } else {
            switch (this.exprType) {
                case 2: {
                    String string = this.getName();
                    AttributesImpl attributesImpl = XQXGen.getAttrs("datatype", "CHARSTRING");
                    if (string.trim().length() == 0) {
                        attributesImpl = XQXGen.addAttr(attributesImpl, "spaceOnly", string);
                    }
                    xQXGen.startElement("constant", attributesImpl);
                    xQXGen.characters(string);
                    xQXGen.endElement("constant");
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    AttributesImpl attributesImpl = this.exprType == 3 ? XQXGen.getAttrs("datatype", "INTEGER_LITERAL") : (this.exprType == 4 ? XQXGen.getAttrs("datatype", "DECIMAL_LITERAL") : XQXGen.getAttrs("datatype", "DOUBLE_LITERAL"));
                    xQXGen.startElement("constant", attributesImpl);
                    xQXGen.characters(this.getName());
                    xQXGen.endElement("constant");
                    break;
                }
                case 6: {
                    AttributesImpl attributesImpl = XQXGen.getAttrs("name", this.getName());
                    xQXGen.startElement("functionCall", attributesImpl);
                    for (int i = 0; i < this.jjtGetNumChildren(); ++i) {
                        this.jjtGetChild(i).dumpSAX(xQXGen);
                    }
                    xQXGen.endElement("functionCall");
                    break;
                }
                case 8: {
                    xQXGen.startElement("elementConstructor");
                    xQXGen.startElement("tagName");
                    xQXGen.characters(this.getName());
                    xQXGen.endElement("tagName");
                    this.dumpSAXChildren(xQXGen);
                    xQXGen.endElement("elementConstructor");
                    break;
                }
                case 11: {
                    xQXGen.startElement("variable");
                    xQXGen.characters(this.getName());
                    xQXGen.endElement("variable");
                    break;
                }
                case 18: {
                    xQXGen.startElement("positionalVar");
                    xQXGen.characters(this.getName());
                    xQXGen.endElement("positionalVar");
                    break;
                }
                case 9: {
                    xQXGen.startElement("dot");
                    xQXGen.endElement("dot");
                    break;
                }
                case 10: {
                    xQXGen.startElement("dotdot");
                    xQXGen.endElement("dotdot");
                    break;
                }
                case 12: {
                    switch (this.getExprSubType()) {
                        case 2: {
                            xQXGen.startElement("identifier");
                            xQXGen.characters(this.getName());
                            xQXGen.endElement("identifier");
                            break;
                        }
                        case 1: {
                            xQXGen.startElement("identifier");
                            xQXGen.characters(this.getName());
                            xQXGen.endElement("identifier");
                        }
                    }
                    break;
                }
                case 13: {
                    AttributesImpl attributesImpl = XQXGen.getAttrs("target", this.getName());
                    xQXGen.startElement("xmlPI", attributesImpl);
                    if (this.children == null) {
                        xQXGen.characters("");
                    } else {
                        xQXGen.characters(((XPathStringValue)this.children[0]).getStringValue());
                    }
                    xQXGen.endElement("xmlPI");
                    break;
                }
                case 14: {
                    xQXGen.startElement("computedXmlPI");
                    if (this.name != null) {
                        this.name = this.name.substring(22, this.name.length() - 1);
                        xQXGen.characters(PrimaryExpr.trimXmlWhiteSpace(this.name));
                    }
                    this.dumpSAXChildren(xQXGen);
                    xQXGen.endElement("computedXmlPI");
                    break;
                }
                case 15: {
                    xQXGen.startElement("computedElement");
                    if (this.name != null) {
                        this.name = this.name.substring(7, this.name.length() - 1);
                        xQXGen.characters(PrimaryExpr.trimXmlWhiteSpace(this.name));
                    }
                    this.dumpSAXChildren(xQXGen);
                    xQXGen.endElement("computedElement");
                    break;
                }
                case 16: {
                    xQXGen.startElement("computedAttribute");
                    if (this.name != null) {
                        this.name = this.name.substring(9, this.name.length() - 1);
                        xQXGen.characters(PrimaryExpr.trimXmlWhiteSpace(this.name));
                    }
                    this.dumpSAXChildren(xQXGen);
                    xQXGen.endElement("computedAttribute");
                    break;
                }
                default: {
                    throw new XQException(xQXGen.msg.getMessage1("XQE-0007", Integer.toString(this.exprType)));
                }
            }
        }
    }

    public static String trimXmlWhiteSpace(String string) {
        StringBuffer stringBuffer = new StringBuffer(200);
        for (int i = 0; i < string.length(); ++i) {
            if (PrimaryExpr.isXmlWhiteSpace(string.charAt(i))) continue;
            stringBuffer.append(string.charAt(i));
        }
        return stringBuffer.toString();
    }

    private static boolean isXmlWhiteSpace(char c) {
        return c == '\t' || c == '\r' || c == '\n' || c == ' ';
    }

    public boolean isAxis() {
        return this.exprType == 10;
    }
}

