/*
 * Decompiled with CFR 0.152.
 */
package oracle.xquery.servlet;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.URL;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xquery.Configuration;
import oracle.xquery.PreparedXQuery;
import oracle.xquery.XQMesg;
import oracle.xquery.XQueryContext;
import oracle.xquery.exec.XQueryUtils;

public class XQServlet
extends HttpServlet {
    private String pageurl;
    private String baseuri;
    private static boolean inJServ = false;
    private HttpServletRequest req;
    private HttpServletResponse res;
    private OutputStream out;
    private ServletContext myContext = null;
    static final String INCLUDED_SERVLET_PATH = "javax.servlet.include.servlet_path";

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.myContext = servletConfig.getServletContext();
        String string = this.myContext.getServerInfo();
        inJServ = string != null && string.indexOf("JServ") >= 0;
    }

    public static boolean inJServ() {
        return inJServ;
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        this.process(httpServletRequest, httpServletResponse, null);
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        this.process(httpServletRequest, httpServletResponse, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) {
        this.req = httpServletRequest;
        this.res = httpServletResponse;
        InputStream inputStream = null;
        try {
            this.out = httpServletResponse.getOutputStream();
            this.setupPageURL(string);
            URL uRL = new URL(string);
            inputStream = uRL.openStream();
            XQueryContext xQueryContext = new XQueryContext();
            Configuration configuration = new Configuration();
            configuration.setBaseURI(this.baseuri);
            PreparedXQuery preparedXQuery = xQueryContext.prepareXQuery(new BufferedReader(new InputStreamReader(inputStream)));
            OXMLSequence oXMLSequence = (OXMLSequence)preparedXQuery.executeQuery();
            XQMesg xQMesg = xQueryContext.getMesg();
            PrintWriter printWriter = new PrintWriter(this.out);
            while (oXMLSequence.next()) {
                XQueryUtils.printResult(oXMLSequence.getItem(), printWriter, xQMesg);
            }
        }
        catch (Exception exception) {
            PrintStream printStream = new PrintStream(this.out);
            printStream.println(" THere was an exception generated");
            exception.printStackTrace(printStream);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                this.out.close();
            }
            catch (Exception exception) {}
        }
    }

    private void setupPageURL(String string) {
        String string2 = null;
        if (string != null) {
            this.pageurl = string.replace('\\', '/');
            this.baseuri = XQueryUtils.baseUriOf(this.req.getRequestURI());
            return;
        }
        if (XQServlet.inJServ()) {
            this.pageurl = this.req.getPathTranslated();
            this.pageurl = this.pageurl != null ? this.pageurl.replace('\\', '/') : null;
            this.baseuri = XQueryUtils.baseUriOf(this.req.getRequestURI());
        } else {
            string2 = (String)this.req.getAttribute(INCLUDED_SERVLET_PATH);
            if (string2 != null) {
                this.pageurl = this.req.getRealPath(string2);
                this.pageurl = this.pageurl != null ? this.pageurl.replace('\\', '/') : null;
                this.baseuri = XQueryUtils.baseUriOf(string2);
            } else {
                this.baseuri = this.req.getServletPath();
                this.pageurl = this.baseuri != null ? this.req.getRealPath(this.baseuri) : null;
                this.pageurl = this.pageurl != null ? this.pageurl.replace('\\', '/') : null;
                this.baseuri = XQueryUtils.baseUriOf(this.baseuri);
                if (this.pageurl == null) {
                    this.pageurl = this.req.getPathTranslated();
                    this.pageurl = this.pageurl != null ? this.pageurl.replace('\\', '/') : null;
                    this.baseuri = XQueryUtils.baseUriOf(this.req.getRequestURI());
                }
            }
        }
    }
}

