/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.metadata.persistence.ClobHelper;
import oracle.dbtools.metadata.persistence.CloseableResultSet;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdCatalog;
import oracle.dbtools.metadata.persistence.MdColumn;
import oracle.dbtools.metadata.persistence.MdConstraint;
import oracle.dbtools.metadata.persistence.MdConstraintDetail;
import oracle.dbtools.metadata.persistence.MdIndexDetail;
import oracle.dbtools.metadata.persistence.MdIndexe;
import oracle.dbtools.metadata.persistence.MdSchema;
import oracle.dbtools.metadata.persistence.MdStoredProgram;
import oracle.dbtools.metadata.persistence.MdTrigger;
import oracle.dbtools.metadata.persistence.MdUser;
import oracle.dbtools.metadata.persistence.MdView;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceUtility;
import oracle.dbtools.metadata.persistence.PrepareClobHelper;
import oracle.dbtools.migration.capture.CaptureAudience;
import oracle.dbtools.migration.capture.CaptureContext;
import oracle.dbtools.migration.capture.CaptureEvent;
import oracle.dbtools.migration.capture.CaptureException;
import oracle.dbtools.migration.capture.QueryCapture;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilter;
import oracle.dbtools.migration.workbench.core.MigrationStorer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Sybase12AbstractCapturer {
    protected boolean m_online = true;
    protected boolean Flag15 = false;
    protected Connection m_sourceConnection = null;
    protected MigrationStorer m_storer = null;
    public static final String MY_LANGUAGE_ID = "STSQL";
    public static int OfflineDbId;
    public static final String DDL_NOT_ACCESSIBLE = "/* ddl not accessible */";

    public void setStorer(MigrationStorer storer) {
        this.m_storer = storer;
    }

    public MigrationStorer getStorer() {
        return this.m_storer;
    }

    public Connection getRepositoryConnection() {
        return this.m_sourceConnection;
    }

    public void setRepositoryConnection(Connection repositoryConnection) {
        this.m_sourceConnection = repositoryConnection;
    }

    protected abstract String getCAPTURE_CATALOGS_QUERY();

    protected abstract String getCAPTURE_SCHEMAS_QUERY();

    protected abstract String getCAPTURE_TABLES_QUERY();

    protected abstract String getCAPTURE_STORED_PROGRAMS_INNER_QUERY();

    protected abstract String getCAPTURE_STORED_PROGRAMS_OUTER_QUERY();

    protected abstract String getCAPTURE_VIEW_INNER_QUERY();

    protected abstract String getCAPTURE_VIEW_OUTER_QUERY();

    protected abstract String getCAPTURE_TRIGGER_INNER_QUERY();

    protected abstract String getCAPTURE_TRIGGER_OUTER_QUERY();

    protected abstract String getCAPTURE_PRIMARY_AND_FOREIGN_KEY_QUERY();

    protected abstract String getCAPTURE_CONSTRAINTS_QUERY();

    protected abstract String getCAPTURE_COLUMNSDESCRIPTION_QUERY();

    protected abstract String getCAPTURE_COLUMNDEFAULT_QUERY();

    protected abstract String getCAPTURE_COLUMN_USER_TYPE();

    protected abstract String getCAPTURE_INDEXESDESCRIPTION_QUERY();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void captureObjects(String objType, CaptureContext context, MigrationObjectFilter filter) throws PersistenceException, CaptureException {
        try {
            int noop = 0;
            if (objType.equals("MD_CATALOGS")) {
                this.captureCatalogs(context, filter);
                return;
            }
            if (objType.equals("MD_SCHEMAS")) {
                this.captureSchemas(context, filter);
                return;
            }
            if (objType.equals("MD_USERS")) {
                this.captureUsers(context, filter);
                return;
            }
            if (objType.equals("MD_TABLES")) {
                this.captureTables(context, filter);
                return;
            }
            if (objType.equals("MD_COLUMNS")) {
                this.captureColumns(context, filter);
                return;
            }
            if (objType.equals("MD_INDEXES")) {
                this.captureIndexes(context, filter);
                return;
            }
            if (objType.equals("MD_INDEX_DETAILS")) {
                ++noop;
                return;
            }
            if (objType.equals("MD_CONSTRAINTS")) {
                this.captureConstraints(context);
                return;
            }
            if (objType.equals("MD_CONSTRAINT_DETAILS")) {
                ++noop;
                return;
            }
            if (objType.equals("MD_VIEWS")) {
                this.captureViews(context, filter);
                return;
            }
            if (objType.equals("MD_STORED_PROGRAMS")) {
                this.captureStoredPrograms(context, filter);
                return;
            }
            if (objType.equals("MD_TRIGGERS")) {
                this.captureTriggers(context, filter);
                return;
            }
            if (!objType.equals("MD_GROUPS")) return;
        }
        catch (SQLException e) {
            throw new CaptureException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void captureCatalogs(CaptureContext context, MigrationObjectFilter filter) throws SQLException, PersistenceException {
        Object crs = null;
        String query = this.getCAPTURE_CATALOGS_QUERY();
        PreparedStatement stmt = this.getRepositoryConnection().prepareStatement(query);
        if (!this.m_online) {
            stmt.setInt(1, OfflineDbId);
        }
        try {
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                if (filter == null || filter.getFilterType() == 1) {
                    // empty if block
                }
                this.ProcessCatalogRow(rs, this.getStorer(), context);
            }
        }
        catch (Exception e) {
        }
        finally {
            if (crs != null) {
                crs.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void captureSchemas(CaptureContext context, MigrationObjectFilter filter) throws SQLException, PersistenceException {
        HashSet<String> nameFilter = new HashSet<String>();
        CloseableResultSet crs = null;
        StringBuffer query = new StringBuffer(this.getCAPTURE_SCHEMAS_QUERY());
        this.processFilter(filter, query, nameFilter, "MD_SCHEMAS");
        try {
            crs = QueryCapture.issueSQL((String)query.toString(), (Connection)this.m_sourceConnection, (CaptureContext)context);
            ResultSet rs = crs.getResultSet();
            while (rs.next()) {
                String schemaName;
                if (filter != null && filter.getFilterType() == 1 && !nameFilter.contains(schemaName = rs.getString(1)) || rs.getString(1).equalsIgnoreCase("information_schema") || rs.getString(1).equalsIgnoreCase("mysql")) continue;
                QueryCapture.processSchemaRow((ResultSet)rs, (MigrationStorer)this.getStorer(), (CaptureContext)context);
            }
        }
        catch (Exception e) {
        }
        finally {
            if (crs != null) {
                crs.close();
            }
        }
    }

    protected void captureUsers(CaptureContext context, MigrationObjectFilter filter) throws SQLException, PersistenceException {
        MdSchema schema = (MdSchema)context.getContextVariable("SCHEMAOBJ");
        MdUser user = new MdUser(schema.getKey(), schema.getName());
        CaptureEvent event = new CaptureEvent(3, MigrationAddinArb.getString((int)144), schema.getName());
        context.getAudience().fireListeners(event);
        user = (MdUser)this.getStorer().storeObject((PersistableObject)user);
        event.setEventId(4);
        context.getAudience().fireListeners(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void captureConstraints(CaptureContext context) throws SQLException, PersistenceException {
        CloseableResultSet crs = null;
        StringBuffer query = new StringBuffer(this.getCAPTURE_CONSTRAINTS_QUERY());
        String tableName = (String)context.getContextVariable("TABLE");
        DBObjectId schemaid = (DBObjectId)context.getContextVariable("SCHEMAID");
        try {
            crs = QueryCapture.issueSQL((String)query.toString(), (Connection)this.m_sourceConnection, (CaptureContext)context);
            ResultSet rs = crs.getResultSet();
            while (rs.next()) {
                String name = rs.getString(1);
                name = name.trim();
                String definition = rs.getString(2);
                if (this.findMatch(definition = definition.trim(), " CHECK ", true) && this.findMatch(definition, "CONSTRAINT ", true)) {
                    this.processCheckConstraint(context, name, definition);
                    continue;
                }
                if (this.findMatch(definition, "PRIMARY KEY ", true)) {
                    this.processPrimaryKeyConstraint(context, name, definition);
                    continue;
                }
                if (this.findMatch(definition, "UNIQUE ", true)) {
                    this.processUniqueKeyConstraint(context, name, definition);
                    continue;
                }
                if (!this.findMatch(definition, " FOREIGN KEY ", true)) continue;
                this.processForeignKeyConstraint(context, name, definition, tableName);
            }
        }
        catch (SQLException e) {
            if (crs == null) {
                Logger.getLogger("oracle.dbtools.migration").log(Level.INFO, "Capture.NO_CONSTRAINTS", tableName);
            } else {
                Logger.getLogger("oracle.dbtools.migration").log(Level.INFO, "Capture.EXCEPTION", "In Constraints for " + tableName);
            }
        }
    }

    private boolean processForeignKeyConstraint(CaptureContext context, String name, String definition, String tableName) {
        String[] Check = definition.split(" ");
        String table = Check[0].trim();
        if (!table.equals(tableName)) {
            return false;
        }
        try {
            String[] relObjectColumns = definition.split("REFERENCES");
            String relObject = relObjectColumns[1].substring(0, relObjectColumns[1].indexOf(40));
            relObject = relObject.trim();
            PersistenceUtility util = this.getStorer().getPersistenceUtility();
            DBObjectId schemaid = (DBObjectId)context.getContextVariable("SCHEMAID");
            DBObjectId refTableId = util.getIdForTable(schemaid, relObject);
            MdConstraint constraint1 = new MdConstraint((DBObjectId)context.getContextVariable("TABLEID"), MY_LANGUAGE_ID);
            String xtype = "FOREIGN KEY";
            constraint1.setConstraintType(xtype);
            constraint1.setName(name);
            constraint1.setReftableId(refTableId);
            CaptureEvent event = new CaptureEvent(3, MigrationAddinArb.getString((int)139), constraint1.getName());
            context.getAudience().fireListeners(event);
            constraint1 = (MdConstraint)this.getStorer().storeObject((PersistableObject)constraint1);
            event.setEventId(4);
            context.getAudience().fireListeners(event);
            String columnNames = relObjectColumns[0].substring(relObjectColumns[0].indexOf(40) + 1, relObjectColumns[0].indexOf(41));
            String[] Columns = columnNames.split(",");
            int i = 0;
            while (i < Columns.length) {
                String columnName = Columns[i].trim();
                MdConstraintDetail constraintdetail = new MdConstraintDetail(constraint1.getKey(), Integer.valueOf(++i));
                constraintdetail.setColumnId(util.getIdForColumn(constraint1.getTableId(), columnName));
                CaptureEvent event2 = new CaptureEvent(3, MigrationAddinArb.getString((int)147), constraint1.getName());
                context.getAudience().fireListeners(event2);
                constraintdetail = (MdConstraintDetail)this.getStorer().storeObject((PersistableObject)constraintdetail);
                event2.setEventId(4);
                context.getAudience().fireListeners(event2);
            }
            String refColumnNames = relObjectColumns[1].substring(relObjectColumns[1].indexOf(40) + 1, relObjectColumns[1].indexOf(41));
            String[] refColumns = refColumnNames.split(",");
            int j = 0;
            while (j < refColumns.length) {
                String columnName = refColumns[j].trim();
                MdConstraintDetail constraintdetail = new MdConstraintDetail(constraint1.getKey(), Integer.valueOf(++j));
                constraintdetail.setColumnId(util.getIdForColumn(refTableId, columnName));
                constraintdetail.setRefFlag("Y");
                CaptureEvent event2 = new CaptureEvent(3, MigrationAddinArb.getString((int)147), constraint1.getName());
                context.getAudience().fireListeners(event2);
                constraintdetail = (MdConstraintDetail)this.getStorer().storeObject((PersistableObject)constraintdetail);
                event2.setEventId(4);
                context.getAudience().fireListeners(event2);
            }
        }
        catch (PersistenceException e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
        return true;
    }

    private void processUniqueKeyConstraint(CaptureContext context, String name, String definition) {
        try {
            PersistenceUtility util = this.getStorer().getPersistenceUtility();
            MdConstraint constraint = new MdConstraint((DBObjectId)context.getContextVariable("TABLEID"), MY_LANGUAGE_ID);
            String xtype = "UNIQUE";
            constraint.setConstraintType(xtype);
            constraint.setName(name);
            CaptureEvent event = new CaptureEvent(3, MigrationAddinArb.getString((int)139), constraint.getName());
            context.getAudience().fireListeners(event);
            constraint = (MdConstraint)this.getStorer().storeObject((PersistableObject)constraint);
            event.setEventId(4);
            context.getAudience().fireListeners(event);
            String columnNames = definition.substring(definition.indexOf(40) + 1, definition.indexOf(41));
            String[] Columns = columnNames.split(",");
            int i = 0;
            while (i < Columns.length) {
                String columnName = Columns[i].trim();
                MdConstraintDetail constraintdetail = new MdConstraintDetail(constraint.getKey(), Integer.valueOf(++i));
                constraintdetail.setColumnId(util.getIdForColumn(constraint.getTableId(), columnName));
                CaptureEvent event2 = new CaptureEvent(3, MigrationAddinArb.getString((int)147), constraint.getName());
                context.getAudience().fireListeners(event2);
                constraintdetail = (MdConstraintDetail)this.getStorer().storeObject((PersistableObject)constraintdetail);
                event2.setEventId(4);
                context.getAudience().fireListeners(event2);
            }
        }
        catch (PersistenceException e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
    }

    private void processCheckConstraint(CaptureContext context, String name, String definition) {
        try {
            PersistenceUtility util = this.getStorer().getPersistenceUtility();
            MdConstraint constraint = new MdConstraint((DBObjectId)context.getContextVariable("TABLEID"), MY_LANGUAGE_ID);
            String xtype = "CHECK";
            constraint.setConstraintType(xtype);
            constraint.setName(name);
            String result = definition.substring(definition.indexOf(40) + 1, definition.length() - 1);
            constraint.setConstraintText(result);
            CaptureEvent event = new CaptureEvent(3, MigrationAddinArb.getString((int)139), constraint.getName());
            context.getAudience().fireListeners(event);
            constraint = (MdConstraint)this.getStorer().storeObject((PersistableObject)constraint);
            event.setEventId(4);
            context.getAudience().fireListeners(event);
        }
        catch (PersistenceException e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
    }

    public void processPrimaryKeyConstraint(CaptureContext context, String name, String definition) {
        try {
            PersistenceUtility util = this.getStorer().getPersistenceUtility();
            MdConstraint constraint = new MdConstraint((DBObjectId)context.getContextVariable("TABLEID"), MY_LANGUAGE_ID);
            String xtype = "PK";
            constraint.setConstraintType(xtype);
            constraint.setName(name);
            CaptureEvent event = new CaptureEvent(3, MigrationAddinArb.getString((int)139), constraint.getName());
            context.getAudience().fireListeners(event);
            constraint = (MdConstraint)this.getStorer().storeObject((PersistableObject)constraint);
            event.setEventId(4);
            context.getAudience().fireListeners(event);
            String columnNames = definition.substring(definition.indexOf(40) + 1, definition.indexOf(41));
            String[] Columns = columnNames.split(",");
            int i = 0;
            while (i < Columns.length) {
                String columnName = Columns[i].trim();
                MdConstraintDetail constraintdetail = new MdConstraintDetail(constraint.getKey(), Integer.valueOf(++i));
                constraintdetail.setColumnId(util.getIdForColumn(constraint.getTableId(), columnName));
                CaptureEvent event2 = new CaptureEvent(3, MigrationAddinArb.getString((int)147), constraint.getName());
                context.getAudience().fireListeners(event2);
                constraintdetail = (MdConstraintDetail)this.getStorer().storeObject((PersistableObject)constraintdetail);
                event2.setEventId(4);
                context.getAudience().fireListeners(event2);
            }
        }
        catch (PersistenceException e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void captureStoredPrograms(CaptureContext context, MigrationObjectFilter filter) throws SQLException, PersistenceException {
        HashSet<String> nameFilter = new HashSet<String>();
        CloseableResultSet crs = null;
        StringBuffer query = new StringBuffer(this.getCAPTURE_STORED_PROGRAMS_OUTER_QUERY());
        this.processFilter(filter, query, nameFilter, "MD_STORED_PROGRAMS");
        String schemaName = (String)context.getContextVariable("SCHEMA");
        try {
            crs = QueryCapture.issueSQL((String)query.toString(), (Connection)this.m_sourceConnection, (CaptureContext)context);
            ResultSet rs = crs.getResultSet();
            while (rs.next()) {
                String Name;
                if (filter != null && filter.getFilterType() == 1 && !nameFilter.contains(Name = rs.getString(1))) continue;
                int id = rs.getInt(3);
                PrepareClobHelper pch = new PrepareClobHelper();
                MdStoredProgram storedProgram = new MdStoredProgram((DBObjectId)context.getContextVariable("SCHEMAID"), MY_LANGUAGE_ID);
                String query2 = this.getCAPTURE_STORED_PROGRAMS_INNER_QUERY();
                PreparedStatement stmt = this.getRepositoryConnection().prepareStatement(query2);
                stmt.setInt(1, id);
                ResultSet rs2 = stmt.executeQuery();
                while (rs2.next()) {
                    String procBody = null;
                    try {
                        procBody = rs2.getString(2);
                    }
                    catch (Exception e) {
                        procBody = "";
                    }
                    pch.append(procBody);
                }
                String storedProgramType = rs.getString(2);
                String storedProgramName = rs.getString(1);
                ClobHelper ch = pch.getClobHelper();
                if (ch == null || ch.getLength() == 0L) {
                    pch = new PrepareClobHelper();
                    pch.append(DDL_NOT_ACCESSIBLE);
                    ch = pch.getClobHelper();
                }
                storedProgram.setName(storedProgramName);
                storedProgram.setNativeSql(ch);
                String additionalProperty = storedProgramType;
                if (storedProgramType.trim().equals("P")) {
                    additionalProperty = "PROCEDURE";
                    storedProgramType = "PROCEDURE";
                } else if (storedProgramType.equals("FN")) {
                    additionalProperty = "SCALAR FUNCTION";
                    storedProgramType = "FUNCTION";
                } else if (storedProgramType.equals("TF")) {
                    additionalProperty = "TABLE FUNCTION";
                    storedProgramType = "FUNCTION";
                } else if (storedProgramType.equals("IF")) {
                    additionalProperty = "INLINED T. FUNCTION";
                    storedProgramType = "FUNCTION";
                } else {
                    storedProgramType = "PROCEDURE";
                }
                DBObjectId connectionId = (DBObjectId)context.getContextVariable("CONNECTIONID");
                storedProgram.addProperty("TYPE", additionalProperty, connectionId);
                storedProgram.setProgramtype(storedProgramType);
                CaptureEvent event = new CaptureEvent(3, MigrationAddinArb.getString((int)136), storedProgramName);
                context.getAudience().fireListeners(event);
                storedProgram = (MdStoredProgram)this.getStorer().storeObject((PersistableObject)storedProgram);
                event.setEventId(4);
                context.getAudience().fireListeners(event);
                if (pch == null) continue;
                pch.close();
            }
        }
        catch (IOException e) {
        }
        catch (SQLException e) {
            Logger.getLogger("oracle.dbtools.migration").log(Level.INFO, "Capture.EXCEPTION", "In Stored Programs for " + schemaName);
        }
        finally {
            if (crs != null) {
                crs.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void captureViews(CaptureContext context, MigrationObjectFilter filter) throws SQLException, PersistenceException {
        HashSet<String> nameFilter = new HashSet<String>();
        CloseableResultSet crs = null;
        StringBuffer query = new StringBuffer(this.getCAPTURE_VIEW_OUTER_QUERY());
        this.processFilter(filter, query, nameFilter, "MD_VIEWS");
        String schemaName = (String)context.getContextVariable("SCHEMA");
        try {
            crs = QueryCapture.issueSQL((String)query.toString(), (Connection)this.m_sourceConnection, (CaptureContext)context);
            ResultSet rs = crs.getResultSet();
            while (rs.next()) {
                String Name;
                if (filter != null && filter.getFilterType() == 1 && !nameFilter.contains(Name = rs.getString(1))) continue;
                int id = rs.getInt(2);
                PrepareClobHelper pch = new PrepareClobHelper();
                MdView view = new MdView((DBObjectId)context.getContextVariable("SCHEMAID"), MY_LANGUAGE_ID);
                String query2 = this.getCAPTURE_VIEW_INNER_QUERY();
                PreparedStatement stmt = this.getRepositoryConnection().prepareStatement(query2);
                stmt.setInt(1, id);
                ResultSet rs2 = stmt.executeQuery();
                while (rs2.next()) {
                    String procBody = null;
                    try {
                        procBody = rs2.getString(1);
                    }
                    catch (Exception e) {
                        procBody = "";
                    }
                    pch.append(procBody);
                }
                String viewName = rs.getString(1);
                ClobHelper ch = pch.getClobHelper();
                if (ch == null || ch.getLength() == 0L) {
                    pch = new PrepareClobHelper();
                    pch.append(DDL_NOT_ACCESSIBLE);
                    ch = pch.getClobHelper();
                }
                view.setViewName(viewName);
                view.setNativeSql(ch);
                DBObjectId connectionId = (DBObjectId)context.getContextVariable("CONNECTIONID");
                CaptureEvent event = new CaptureEvent(3, MigrationAddinArb.getString((int)137), viewName);
                context.getAudience().fireListeners(event);
                view = (MdView)this.getStorer().storeObject((PersistableObject)view);
                event.setEventId(4);
                context.getAudience().fireListeners(event);
                if (pch == null) continue;
                pch.close();
            }
        }
        catch (IOException e) {
        }
        catch (SQLException e) {
            Logger.getLogger("oracle.dbtools.migration").log(Level.INFO, "Capture.EXCEPTION", "In Views for " + schemaName);
        }
        finally {
            if (crs != null) {
                crs.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void captureTriggers(CaptureContext context, MigrationObjectFilter filter) throws SQLException, PersistenceException {
        DBObjectId tableOrViewId;
        String sTriggerOn;
        Object crs = null;
        String query = this.getCAPTURE_TRIGGER_OUTER_QUERY();
        PreparedStatement stmt = this.getRepositoryConnection().prepareStatement(query);
        String userName = (String)context.getContextVariable("SCHEMA");
        String s = (String)context.getContextVariable("PER_CONTEXT");
        String tableOrView = null;
        if (s.equals("MD_TABLES")) {
            sTriggerOn = "T";
            tableOrViewId = (DBObjectId)context.getContextVariable("TABLEID");
            tableOrView = (String)context.getContextVariable("TABLE");
        } else {
            sTriggerOn = "V";
            tableOrViewId = (DBObjectId)context.getContextVariable("VIEWID");
            tableOrView = (String)context.getContextVariable("VIEW");
        }
        stmt.setString(1, userName);
        stmt.setString(2, tableOrView);
        try {
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                String triggerName = rs.getString(1);
                int id = rs.getInt(2);
                PrepareClobHelper pch = new PrepareClobHelper();
                MdTrigger trigger = new MdTrigger(tableOrViewId, sTriggerOn, MY_LANGUAGE_ID);
                String query2 = this.getCAPTURE_TRIGGER_INNER_QUERY();
                PreparedStatement stmt2 = this.getRepositoryConnection().prepareStatement(query2);
                stmt2.setInt(1, id);
                ResultSet rs2 = stmt2.executeQuery();
                while (rs2.next()) {
                    String procBody = null;
                    try {
                        procBody = rs2.getString(1);
                    }
                    catch (Exception e) {
                        procBody = "";
                    }
                    pch.append(procBody);
                }
                ClobHelper ch = pch.getClobHelper();
                if (ch == null || ch.getLength() == 0L) {
                    pch = new PrepareClobHelper();
                    pch.append(DDL_NOT_ACCESSIBLE);
                    ch = pch.getClobHelper();
                }
                trigger.setTriggerName(triggerName);
                trigger.setNativeSql(ch);
                DBObjectId connectionId = (DBObjectId)context.getContextVariable("CONNECTIONID");
                CaptureEvent event = new CaptureEvent(3, MigrationAddinArb.getString((int)135), triggerName);
                context.getAudience().fireListeners(event);
                trigger = (MdTrigger)this.getStorer().storeObject((PersistableObject)trigger);
                event.setEventId(4);
                context.getAudience().fireListeners(event);
                if (pch == null) continue;
                pch.close();
            }
        }
        catch (IOException e) {
        }
        catch (SQLException e) {
            Logger.getLogger("oracle.dbtools.migration").log(Level.INFO, "Capture.EXCEPTION", "In Triggers for " + sTriggerOn);
        }
        finally {
            if (crs != null) {
                crs.close();
            }
        }
    }

    protected void processFilter(MigrationObjectFilter filter, StringBuffer query, HashSet<String> nameFilter, String objType) {
        if (filter != null && !filter.getObjectType().equals(objType)) {
            throw new IllegalArgumentException("Filter is of incorrect type " + filter.getObjectType());
        }
        if (filter != null && filter.getFilterType() == 2) {
            query = query.append(" ").append(filter.getWhereClause());
        }
        if (filter != null && filter.getFilterType() == 1) {
            for (String name : filter.getObjectNames()) {
                nameFilter.add(name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void captureTables(CaptureContext context, MigrationObjectFilter filter) throws SQLException, PersistenceException {
        HashSet<String> nameFilter = new HashSet<String>();
        CloseableResultSet crs = null;
        StringBuffer query = new StringBuffer(this.getCAPTURE_TABLES_QUERY());
        this.processFilter(filter, query, nameFilter, "MD_TABLES");
        String schemaName = (String)context.getContextVariable("SCHEMA");
        try {
            crs = QueryCapture.issueSQL((String)query.toString(), (Connection)this.m_sourceConnection, (CaptureContext)context);
            ResultSet rs = crs.getResultSet();
            while (rs.next()) {
                String tableName;
                if (filter != null && filter.getFilterType() == 1 && !nameFilter.contains(tableName = rs.getString(1))) continue;
                QueryCapture.processTableRow((ResultSet)rs, (MigrationStorer)this.getStorer(), (CaptureContext)context);
            }
        }
        catch (SQLException e) {
            Logger.getLogger("oracle.dbtools.migration").log(Level.INFO, "Capture.EXCEPTION", "In Indexes for " + schemaName);
        }
        finally {
            if (crs != null) {
                crs.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void captureColumns(CaptureContext context, MigrationObjectFilter filter) throws SQLException, PersistenceException {
        String tableName = (String)context.getContextVariable("TABLE");
        CloseableResultSet crs = null;
        StringBuffer query = new StringBuffer(this.getCAPTURE_COLUMNSDESCRIPTION_QUERY());
        int columnOrder = 0;
        try {
            crs = QueryCapture.issueSQL((String)query.toString(), (Connection)this.m_sourceConnection, (CaptureContext)context);
            ResultSet rs = crs.getResultSet();
            while (rs.next()) {
                this.ProcessColumnRow(rs, this.getStorer(), context, ++columnOrder);
            }
        }
        catch (SQLException e) {
            Logger.getLogger("oracle.dbtools.migration").log(Level.INFO, "Capture.EXCEPTION", "In Columns for " + tableName);
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
        finally {
            if (crs != null) {
                crs.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void captureIndexes(CaptureContext context, MigrationObjectFilter filter) throws SQLException, PersistenceException {
        CloseableResultSet crs = null;
        String tableName = (String)context.getContextVariable("TABLE");
        StringBuffer query = new StringBuffer(this.getCAPTURE_INDEXESDESCRIPTION_QUERY());
        try {
            crs = QueryCapture.issueSQL((String)query.toString(), (Connection)this.m_sourceConnection, (CaptureContext)context);
            ResultSet rs = crs.getResultSet();
            while (rs.next()) {
                if (filter == null || filter.getFilterType() == 1) {
                    // empty if block
                }
                String indexName = null;
                String indexKeys = null;
                String indexDesc = null;
                if (this.Flag15 && this.m_online) {
                    indexName = rs.getString(1).trim();
                    indexKeys = rs.getString(2).trim();
                    indexDesc = rs.getString(3).trim();
                } else {
                    indexName = rs.getString(1).trim();
                    indexDesc = rs.getString(2).trim();
                    indexKeys = rs.getString(3).trim();
                }
                this.ProcessIndexRow(indexName, indexDesc, indexKeys, this.getStorer(), context);
            }
        }
        catch (SQLException e) {
            if (crs == null) {
                Logger.getLogger("oracle.dbtools.migration").log(Level.INFO, "Capture.NO_INDEXES", tableName);
            } else {
                Logger.getLogger("oracle.dbtools.migration").log(Level.INFO, "Capture.EXCEPTION", "In Indexes for " + tableName);
            }
        }
        finally {
            if (crs != null) {
                crs.close();
            }
        }
    }

    private void ProcessColumnRow(ResultSet rs, MigrationStorer storer, CaptureContext context, int order) throws PersistenceException, SQLException {
        DBObjectId tableId = (DBObjectId)context.getContextVariable("TABLEID");
        MdColumn column = new MdColumn(tableId, rs.getString(1), Integer.valueOf(order));
        CaptureAudience audience = context.getAudience();
        column.setColumnType(rs.getString(2));
        int length = rs.getInt(3);
        int precision = rs.getInt(4);
        if (rs.wasNull() && this.m_online || precision == 0 && !this.m_online) {
            column.setPrecision(Integer.valueOf(length));
        } else {
            column.setPrecision(Integer.valueOf(precision));
        }
        column.setScale(Integer.valueOf(rs.getInt(5)));
        int intNullable = rs.getInt(6);
        String nullable = "";
        nullable = (intNullable & 8) == 8 ? "Y" : "N";
        column.setNullable(nullable);
        int cdefault = rs.getInt(7);
        if (cdefault != 0) {
            this.setColumnDefault(column, cdefault);
        }
        int userType = rs.getInt(8);
        int originalType = rs.getInt(9);
        if (userType > 100) {
            this.setUserDefinedType(column, userType, originalType);
        }
        CaptureEvent event = new CaptureEvent(3, "COLUMN", column.getColumnName());
        audience.fireListeners(event);
        storer.storeObject((PersistableObject)column);
        event.setEventId(4);
        audience.fireListeners(event);
    }

    protected void setColumnDefault(MdColumn column, int cdefault) {
        try {
            PreparedStatement stmt = this.getRepositoryConnection().prepareStatement(this.getCAPTURE_COLUMNDEFAULT_QUERY());
            stmt.setInt(1, cdefault);
            ResultSet rs = stmt.executeQuery();
            if (rs.next()) {
                String DefaultText;
                String CommentText = rs.getString(1);
                if (CommentText.indexOf("\"") > 0) {
                    DefaultText = CommentText.substring(CommentText.indexOf("\"") + 1, CommentText.lastIndexOf("\""));
                } else if (CommentText.indexOf("'") > 0) {
                    DefaultText = CommentText.substring(CommentText.indexOf("'") + 1, CommentText.lastIndexOf("'"));
                } else {
                    String[] DefaultStrings = CommentText.split(" ");
                    DefaultText = DefaultStrings[DefaultStrings.length - 1];
                }
                column.setDefaultValue(DefaultText.trim());
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected void setUserDefinedType(MdColumn column, int uType, int oType) {
        try {
            PreparedStatement stmt = this.getRepositoryConnection().prepareStatement(this.getCAPTURE_COLUMN_USER_TYPE());
            stmt.setInt(1, oType);
            ResultSet rs = stmt.executeQuery();
            if (rs.next()) {
                column.setColumnType(rs.getString(1));
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException e) {
            // empty catch block
        }
    }

    protected void ProcessCatalogRow(ResultSet rs, MigrationStorer storer, CaptureContext context) throws SQLException, PersistenceException {
        DBObjectId connectionId = (DBObjectId)context.getContextVariable("CONNECTIONID");
        MdCatalog catalog = new MdCatalog(connectionId);
        String catalogName = rs.getString(1);
        catalog.setCatalogName(catalogName);
        CaptureEvent event = new CaptureEvent(3, MigrationAddinArb.getString((int)142), catalogName);
        context.getAudience().fireListeners(event);
        storer.storeObject((PersistableObject)catalog);
        event.setEventId(4);
        context.getAudience().fireListeners(event);
    }

    protected void ProcessIndexRow(String indexName, String indexDesc, String indexKeys, MigrationStorer storer, CaptureContext context) throws SQLException, PersistenceException {
        DBObjectId tableId = (DBObjectId)context.getContextVariable("TABLEID");
        MdIndexe index = new MdIndexe(tableId);
        String name = indexName.trim();
        if (this.findMatch(indexDesc, " unique", true)) {
            index.setIndexType("UNIQUE");
        } else {
            index.setIndexType("NON_UNIQUE");
        }
        index.setIndexName(name);
        CaptureEvent event = new CaptureEvent(3, MigrationAddinArb.getString((int)140), name);
        context.getAudience().fireListeners(event);
        index = (MdIndexe)storer.storeObject((PersistableObject)index);
        event.setEventId(4);
        context.getAudience().fireListeners(event);
        String columns = indexKeys;
        String[] individualColumns = columns.split(",");
        for (int i = 0; i < individualColumns.length; ++i) {
            String column = individualColumns[i].trim();
            PersistenceUtility util = storer.getPersistenceUtility();
            DBObjectId colid = util.getIdForColumn(index.getTableId(), column);
            MdIndexDetail detail = new MdIndexDetail(index.getKey(), colid, Integer.valueOf(i + 1));
            CaptureEvent event2 = new CaptureEvent(3, MigrationAddinArb.getString((int)143), name);
            context.getAudience().fireListeners(event2);
            detail = (MdIndexDetail)storer.storeObject((PersistableObject)detail);
            event.setEventId(4);
            context.getAudience().fireListeners(event);
        }
    }

    protected boolean findMatch(String subject, String regex, boolean Case) {
        Pattern myPattern = Case ? Pattern.compile(regex) : Pattern.compile(regex, 2);
        Matcher myMatcher = myPattern.matcher(subject);
        return myMatcher.find();
    }
}

