/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin.sybaseofflinecapture;

import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.migration.capture.offline.OfflineCaptureException;
import oracle.dbtools.migration.workbench.plugin.sybaseofflinecapture.GeneratePreparedStatement;
import oracle.xml.parser.v2.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class MetadataFileParser
extends DefaultHandler {
    private XMLReader s_parser = null;
    private Locator _locator;
    public StringBuffer sbCurrValue = new StringBuffer();
    private List _fieldDataList = new ArrayList();
    private int _currentDbId;
    private String _currentDbIdAsStr = null;
    private String _currentTableName;
    private URL _currentFile;
    private int _currUnqIndexId = 1000;
    private GeneratePreparedStatement _genPrepStmt = null;
    private int _numRecordsInserted = 0;
    private boolean _bSS2K_SYSLOGINS_table = false;

    public MetadataFileParser(int dbId, URL file, String currentTableName) {
        this._currentDbId = dbId;
        this._currentDbIdAsStr = new String("" + this._currentDbId);
        this._currentFile = file;
        this._currentTableName = currentTableName;
        this._numRecordsInserted = 0;
        if (this._currentTableName.equalsIgnoreCase("SS2K_SYSLOGINS")) {
            this._bSS2K_SYSLOGINS_table = true;
        }
    }

    public void setDocumentLocator(Locator locator) {
        this._locator = locator;
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (localName.equalsIgnoreCase("er")) {
            this._fieldDataList.clear();
            this._fieldDataList.add(this._currentDbIdAsStr);
        } else if (localName.equalsIgnoreCase("ec")) {
            this.sbCurrValue.setLength(0);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (localName.equalsIgnoreCase("er")) {
            if (this._fieldDataList.size() > 1) {
                this._executePreparedStatement();
            }
        } else if (localName.equalsIgnoreCase("ec")) {
            this._fieldDataList.add(this.sbCurrValue.toString());
        }
    }

    public void characters(char[] cbuf, int start, int len) {
        this.sbCurrValue.append(cbuf, start, len);
    }

    public void error(SAXParseException e) throws SAXException {
        throw new SAXException(e.getMessage());
    }

    public void fatalError(SAXParseException e) throws SAXException {
        throw new SAXException(e.getMessage());
    }

    public int loadData() throws OfflineCaptureException {
        try {
            this.s_parser = new SAXParser();
            this.s_parser.setContentHandler(this);
            this.s_parser.setEntityResolver(this);
            this.s_parser.setDTDHandler(this);
            this.s_parser.setErrorHandler(this);
            this.s_parser.parse(this._currentFile.toString());
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            throw new OfflineCaptureException(e);
        }
        finally {
            this.cleanUp();
        }
        return this._numRecordsInserted;
    }

    public void createPrepardStatement(Connection repConnection, String[] fieldTypes) throws SQLException {
        this._genPrepStmt = new GeneratePreparedStatement(repConnection, this._currentDbId, fieldTypes, this._currentTableName);
    }

    private void _executePreparedStatement() {
        try {
            if (this._bSS2K_SYSLOGINS_table) {
                this._fieldDataList.add("" + this._numRecordsInserted + 1);
            }
            this._genPrepStmt.setPreparedStatementValues(this._fieldDataList);
            this._genPrepStmt.executeUpdate();
            ++this._numRecordsInserted;
        }
        catch (SQLException e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
    }

    public void cleanUp() {
        this._genPrepStmt.cleanUp();
    }
}

