/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import oracle.ide.Context;
import oracle.ide.controller.IdeAction;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.jdeveloper.vcs.changelist.ChangeListWindow;
import oracle.jdeveloper.vcs.spi.VCSCommand;
import oracle.jdeveloper.vcs.spi.VCSCommandStyle;
import oracle.jdeveloper.vcs.spi.VCSDirectoryInvokableState;
import oracle.jdeveloper.vcs.spi.VCSExceptionHandler;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdeveloper.vcs.spi.VCSStatusCache;
import oracle.jdeveloper.vcs.util.VCSCommandUtils;
import oracle.jdeveloper.vcs.util.VCSContextUtils;
import oracle.jdeveloper.vcs.util.VCSFileSystemUtils;
import oracle.jdeveloper.vcs.util.VCSModelUtils;
import oracle.jdevimpl.vcs.cvs.CVSClient;
import oracle.jdevimpl.vcs.cvs.CVSFolderOperationUtil;
import oracle.jdevimpl.vcs.cvs.CVSRootCache;
import oracle.jdevimpl.vcs.cvs.CVSUtil;
import oracle.jdevimpl.vcs.cvs.client.CVSRootString;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionListAPI;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionNode;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionNodeUtils;
import oracle.jdevimpl.vcs.cvs.options.CVSOptionId;

public abstract class CVSAbstractCommand
extends VCSCommand {
    private IdeAction _action;

    protected CVSAbstractCommand(int cmdId) {
        super(cmdId, 1);
    }

    protected CVSAbstractCommand(int cmdId, VCSCommandStyle commandStyle) {
        super(cmdId, 1);
        this.initializeCommandStyle(commandStyle);
    }

    protected CVSAbstractCommand(int cmdId, int type) {
        super(cmdId, type);
    }

    protected CVSAbstractCommand(int cmdId, int type, String name) {
        super(cmdId, type, name);
    }

    public void setAction(IdeAction action) {
        this._action = action;
    }

    public IdeAction getAction() {
        return this._action;
    }

    protected final Collection getFilteredSelection(VCSStatus[] statuses) throws Exception {
        return this.getFilteredSelection(this.getContextLocatables(), statuses);
    }

    protected final Collection getFilteredSelection(Locatable[] locatables, VCSStatus[] statuses) throws Exception {
        return VCSCommandUtils.getFilteredSelection((Locatable[])locatables, (VCSStatusCache)CVSClient.getInstance().getStatusCache(), (VCSStatus[])statuses);
    }

    protected final boolean isOpenSessionSelection(Locatable[] locatables) {
        return locatables.length > 0 && CVSUtil.isOpenSessionFile(locatables[0].getURL());
    }

    protected final boolean containsDirectoryNodes(Collection nodes) {
        Iterator itr = nodes.iterator();
        while (itr.hasNext()) {
            if (!URLFileSystem.isDirectoryPath((URL)((Locatable)itr.next()).getURL())) continue;
            return true;
        }
        return false;
    }

    protected final CVSRootString getContextRoot() throws IOException {
        URL url;
        CVSConnectionNode node = CVSConnectionNodeUtils.getContextConnectionNode(this.getContext());
        if (node != null) {
            return new CVSRootString(node.getConnection().getRoot());
        }
        Locatable[] selection = VCSContextUtils.getContextLocatables((Context)this.getContext(), (URLFilter)this.getURLFilter());
        if (selection.length <= 0) {
            return null;
        }
        URL uRL = url = selection[0] == null ? null : selection[0].getURL();
        if (url == null || !this.getURLFilter().accept(url)) {
            return null;
        }
        URL parentUrl = CVSUtil.locateParentSandbox(url);
        if (parentUrl != null) {
            return CVSRootCache.getInstance().getRoot(parentUrl);
        }
        return null;
    }

    protected final URL[] getProjectSourcePathURLs(Project project) {
        return CVSFolderOperationUtil.getProjectSourcePathURLs(project);
    }

    protected Workspace getContextWorkspace() {
        return CVSFolderOperationUtil.getContextWorkspace(this.getContext());
    }

    protected Project getContextProject() {
        return CVSFolderOperationUtil.getContextProject(this.getContext());
    }

    protected final Locatable[] getWorkspaceFolderNodes(Workspace workspace) {
        URL[] urls = CVSFolderOperationUtil.getWorkspaceFolderURLs(workspace);
        return VCSModelUtils.findOrCreateNodes((URL[])urls);
    }

    protected final Locatable[] getProjectFolderNodes(Project project) {
        URL[] urls = CVSFolderOperationUtil.getProjectFolderURLs(project);
        return new LinkedHashSet<Locatable>(Arrays.asList(VCSModelUtils.findOrCreateNodes((URL[])urls))).toArray(new Locatable[0]);
    }

    protected final boolean isOpenSessionWorkspace(Workspace workspace) {
        return workspace != null && this.isOpenSessionURLs(CVSFolderOperationUtil.getWorkspaceFolderURLs(workspace));
    }

    protected final boolean isOpenSessionProject(Project project) {
        return project != null && this.isOpenSessionURLs(CVSFolderOperationUtil.getProjectFolderURLs(project));
    }

    protected final Locatable[] getChangeListLocatables() {
        if (this.getContext().getView() instanceof ChangeListWindow) {
            Element[] elements = ((ChangeListWindow)this.getContext().getView()).getContextChangeList().getElements();
            return VCSContextUtils.getExpandedLocatables((Element[])elements, (URLFilter)this.getURLFilter());
        }
        return this.getContextLocatables();
    }

    protected final boolean isActionLocal() {
        return this._action != null && this._action.isLocalAction();
    }

    protected final boolean isContextConnectionAndNotSupported() {
        CVSConnectionNode connectionNode = CVSConnectionNodeUtils.getContextConnectionNode(this.getContext());
        return connectionNode != null && !CVSConnectionListAPI.isSupportedConnection(connectionNode.getConnection());
    }

    protected VCSExceptionHandler getExceptionHandler() {
        return CVSClient.getInstance().getExceptionHandler();
    }

    protected URLFilter getURLFilter() {
        return CVSClient.getInstance().getURLFilter();
    }

    protected VCSStatusCache getStatusCache() {
        return CVSClient.getInstance().getStatusCache();
    }

    private final boolean isOpenSessionURLs(URL[] urls) {
        int i = 0;
        while (i < urls.length) {
            if (CVSUtil.isOpenSessionFile(urls[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected Collection coalesceNodesForFolderOperation(Collection nodes) {
        return this.coalesceNodesForFolderOperation(nodes, false);
    }

    protected Collection coalesceNodesForFolderOperation(Collection nodes, boolean recursive) {
        LinkedHashMap<URL, Locatable> nodesByUrl = new LinkedHashMap<URL, Locatable>();
        for (Locatable node : nodes) {
            nodesByUrl.put(node.getURL(), node);
        }
        if (recursive) {
            nodesByUrl.keySet().retainAll(Arrays.asList(VCSFileSystemUtils.coalesceURLs((URL[])nodesByUrl.keySet().toArray(new URL[0]))));
        } else {
            this.retainURLsForLocalFolderOperation(nodesByUrl.keySet());
        }
        return new ArrayList(nodesByUrl.values());
    }

    protected VCSDirectoryInvokableState coalesceStateForFolderOperation(Map optionsMap, VCSDirectoryInvokableState state) {
        Object value = optionsMap != null ? optionsMap.get((Object)CVSOptionId.COMMON_LOCAL_FOLDER_ONLY) : null;
        boolean localFolderOnly = value != null ? (Boolean)value : false;
        URL[] urls = state.getURLs();
        if (localFolderOnly) {
            ArrayList<URL> urls0 = new ArrayList<URL>(Arrays.asList(urls));
            this.retainURLsForLocalFolderOperation(urls0);
            return new VCSDirectoryInvokableState(urls0.toArray(new URL[0]));
        }
        return new VCSDirectoryInvokableState(VCSFileSystemUtils.coalesceURLs((URL[])urls));
    }

    private void retainURLsForLocalFolderOperation(Collection urls) {
        Iterator itr = urls.iterator();
        while (itr.hasNext()) {
            URL url = (URL)itr.next();
            if (URLFileSystem.isDirectoryPath((URL)url) || !this.containsURL(urls, URLFileSystem.getParent((URL)url))) continue;
            itr.remove();
        }
    }

    private boolean containsURL(Collection urls, URL url) {
        Iterator itr = urls.iterator();
        while (itr.hasNext()) {
            if (!URLFileSystem.equals((URL)((URL)itr.next()), (URL)url)) continue;
            return true;
        }
        return false;
    }
}

