/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.URL;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.GlobalIgnoreList;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.FocusableLabel;
import oracle.ide.controls.MenuToolButton;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.ToggleToolButton;
import oracle.ide.controls.Toolbar;
import oracle.ide.docking.DockStation;
import oracle.ide.help.HelpInfo;
import oracle.ide.layout.ViewId;
import oracle.ide.model.Observer;
import oracle.ide.model.Project;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.replace.ReplaceMenuManager;
import oracle.ide.util.Assert;
import oracle.ide.util.Enum;
import oracle.javatools.controls.HyperlinkButton;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.Copyable;
import oracle.jdeveloper.compare.CompareViewer;
import oracle.jdeveloper.vcs.changelist.AsynchronousChangeList;
import oracle.jdeveloper.vcs.changelist.AsynchronousStatusCache;
import oracle.jdeveloper.vcs.changelist.AsynchronousStatusTask;
import oracle.jdeveloper.vcs.changelist.ChangeList;
import oracle.jdeveloper.vcs.changelist.ChangeListCommentsCustomizer;
import oracle.jdeveloper.vcs.changelist.ChangeListContextMenuListener;
import oracle.jdeveloper.vcs.changelist.ChangeListEvent;
import oracle.jdeveloper.vcs.changelist.ChangeListEventListener;
import oracle.jdeveloper.vcs.changelist.ChangeListEventQueue;
import oracle.jdeveloper.vcs.changelist.ChangeListLocalStatusCache;
import oracle.jdeveloper.vcs.changelist.ChangeListProjectContent;
import oracle.jdeveloper.vcs.changelist.ChangeListStatus;
import oracle.jdeveloper.vcs.changelist.ChangeListStatusCache;
import oracle.jdeveloper.vcs.changelist.ChangeListWindow;
import oracle.jdeveloper.vcs.changelist.OpenCommand;
import oracle.jdeveloper.vcs.icons.VCSIconArb;
import oracle.jdeveloper.vcs.spi.VCSCancellable;
import oracle.jdeveloper.vcs.spi.VCSDirectoryInvokable;
import oracle.jdeveloper.vcs.spi.VCSDirectoryInvokableState;
import oracle.jdeveloper.vcs.spi.VCSInvokableState;
import oracle.jdeveloper.vcs.spi.VCSPropertyMap;
import oracle.jdeveloper.vcs.spi.VCSStatusCache;
import oracle.jdeveloper.vcs.spi.VCSThreadPool;
import oracle.jdeveloper.vcs.spi.VCSURLBasedCache;
import oracle.jdeveloper.vcs.util.VCSFileSystemUtils;
import oracle.jdeveloper.vcs.util.VCSNavigableUtils;
import oracle.jdeveloper.vcs.vop.DisplayProperty;
import oracle.jdevimpl.vcs.cvs.CVSClient;
import oracle.jdevimpl.vcs.cvs.CVSCommandConstants;
import oracle.jdevimpl.vcs.cvs.CVSEntriesCache;
import oracle.jdevimpl.vcs.cvs.CVSFileStatus;
import oracle.jdevimpl.vcs.cvs.CVSFileURLFileSystemHelper;
import oracle.jdevimpl.vcs.cvs.CVSIgnorePatternList;
import oracle.jdevimpl.vcs.cvs.CVSLoginCache;
import oracle.jdevimpl.vcs.cvs.CVSPropertyKey;
import oracle.jdevimpl.vcs.cvs.CVSRootContext;
import oracle.jdevimpl.vcs.cvs.CVSUtil;
import oracle.jdevimpl.vcs.cvs.client.CVSEntry;
import oracle.jdevimpl.vcs.cvs.client.CVSRootString;
import oracle.jdevimpl.vcs.cvs.login.CVSLogin;
import oracle.jdevimpl.vcs.cvs.login.CVSLoginEvent;
import oracle.jdevimpl.vcs.cvs.login.CVSLoginListener;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionData;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionNodes;
import oracle.jdevimpl.vcs.cvs.options.CVSOptionId;
import oracle.jdevimpl.vcs.cvs.resource.CVSArb;
import oracle.jdevimpl.vcs.cvs.resource.Resource;
import oracle.jdevimpl.vcs.cvs.runner.CVSInternalClientRunner;
import oracle.jdevimpl.vcs.cvs.runner.CVSProcess;
import oracle.jdevimpl.vcs.cvs.runner.CVSProcessStreamMonitor;
import oracle.jdevimpl.vcs.cvs.runner.CVSRunner;
import oracle.jdevimpl.vcs.cvs.runner.CVSRunnerFactory;
import oracle.jdevimpl.vcs.cvs.util.CVSListFilesUtil;
import oracle.jdevimpl.vcs.util.ActionUtil;
import oracle.jdevimpl.vcs.util.DelimitedStrings;
import oracle.jdevimpl.vcs.vop.ClientDisplayProperty;
import oracle.ocvs.OCVSPrompter;
import oracle.ocvs.OCVSRoot;

public class CVSChangeListWindow
extends ChangeListWindow {
    public static final String OPEN_INCOMING_CMD = OpenIncomingCommand.class.getName();
    public static final int OPEN_INCOMING_CMD_ID = Ide.findOrCreateCmdID((String)OPEN_INCOMING_CMD);
    private static final String FORCE_COMMIT_CMD = "CVSChangeListWindow.ForceCommit";
    public static final int FORCE_COMMIT_CMD_ID = Ide.findOrCreateCmdID((String)"CVSChangeListWindow.ForceCommit");
    private static final String MODE_PERSISTENCE_KEY = "CVS.PendingChangesWindow.Mode";
    private static final String CANDIDATES_VISIBLE_PERSISTENCE_KEY = "CVS.PendingChangesWindow.CandidatesVisible";
    private static final String INCOMING_VISIBLE_PERSISTENCE_KEY = "CVS.PendingChangesWindow.IncomingVisible";
    private static final String WATCHERS_VISIBLE_PERSISTENCE_KEY = "CVS.PendingChangesWindow.WatchersVisible";
    private OptionsStateListener _optionsStateListener;
    private ChangeListener _preferencesListener;
    private static VCSThreadPool _threadPool;
    private static ToggleAction _displayConflictsAction;
    private JComponent _gui;
    private CardLayout _guiCardLayout;
    private JComponent _conflictsFilterPanel;
    private static final String GUI_CHANGELISTWINDOW = "changeListWindow";
    private static final String GUI_NO_CONNECTION = "noConnection";
    private static final HelpInfo F1_HELP_INFO;

    public HelpInfo getHelpInfo() {
        return F1_HELP_INFO;
    }

    public Component getGUI() {
        if (this._gui == null) {
            this._guiCardLayout = new CardLayout();
            this._gui = new JPanel(this._guiCardLayout);
            this._gui.add(super.getGUI(), GUI_CHANGELISTWINDOW);
            FocusableLabel defaultLabel = new FocusableLabel(CVSArb.getString(51));
            defaultLabel.setOpaque(true);
            defaultLabel.setBackground(UIManager.getColor("window"));
            this._gui.add((Component)defaultLabel, GUI_NO_CONNECTION);
            this.updateGUICardLayout();
        }
        return this._gui;
    }

    private void updateGUICardLayout() {
        if (this._gui == null) {
            return;
        }
        if (CVSLoginCache.getInstance().isLoggedIn()) {
            this._guiCardLayout.show(this._gui, GUI_CHANGELISTWINDOW);
        } else {
            this._guiCardLayout.show(this._gui, GUI_NO_CONNECTION);
        }
    }

    private JComponent getConflictsFilterPanel() {
        if (this._conflictsFilterPanel == null) {
            JLabel removeFilterLabel = new JLabel(CVSArb.getString(293) + " ");
            removeFilterLabel.setIcon(OracleIcons.getIcon((String)"info.png"));
            HyperlinkButton removeFilterButton = new HyperlinkButton(CVSArb.getString(726));
            removeFilterButton.addActionListener((ActionListener)new 1());
            this._conflictsFilterPanel = Box.createHorizontalBox();
            this._conflictsFilterPanel.add(this.getToolbar().newSeparator());
            this._conflictsFilterPanel.add(removeFilterLabel);
            this._conflictsFilterPanel.add((Component)removeFilterButton);
            this._conflictsFilterPanel.setVisible(false);
        }
        return this._conflictsFilterPanel;
    }

    public CVSChangeListWindow(String windowID) {
        super(CVSChangeListWindow._createChangeLists(), windowID);
        this.getChangeList().addPropertyChangeListener((PropertyChangeListener)new 2());
        IdeAction.get((int)OPEN_INCOMING_CMD_ID, (String)OPEN_INCOMING_CMD, (String)"");
        CVSLogin.addLoginListener(new 3());
        CVSConnectionNodes.getConnectionListNode().attach(new 4());
    }

    private static final ChangeList[] _createChangeLists() {
        return new ChangeList[]{new OutgoingChangeList(), new CandidatesChangeList(), new IncomingChangeList(), new WatchersChangeList()};
    }

    public static final CVSChangeListWindow getChangeListWindow() {
        return (CVSChangeListWindow)DockStation.getDockStation().getDockable(new ViewId(CVSClient.CHANGE_LIST_ID));
    }

    public static final synchronized ToggleAction getDisplayConflictsAction() {
        if (_displayConflictsAction != null) {
            return _displayConflictsAction;
        }
        _displayConflictsAction = new 5(CVSArb.getString(285), CVSArb.getIcon(74));
        return _displayConflictsAction;
    }

    public void activateOutgoingChanges() {
        if (this.getModeId() != Mode.OUTGOING) {
            this.setModeId((Object)Mode.OUTGOING);
        }
    }

    public void displayOutgoingConflicts() {
        this.setDisplayOutgoingConflicts(true);
        this.setDisplayConflictsPanel(true);
    }

    private void setDisplayOutgoingConflicts(boolean displayOutgoingConflicts) {
        CVSFileStatus[] cVSFileStatusArray;
        if (!displayOutgoingConflicts) {
            this.setDisplayConflictsPanel(false);
        }
        CVSChangeListWindow.getDisplayConflictsAction().setState(displayOutgoingConflicts);
        ChangeList changeList = this.getOutgoingChangeList();
        if (CVSChangeListWindow.getDisplayConflictsAction().getState()) {
            CVSFileStatus[] cVSFileStatusArray2 = new CVSFileStatus[1];
            cVSFileStatusArray = cVSFileStatusArray2;
            cVSFileStatusArray2[0] = CVSFileStatus.STATUS_CONFLICTS;
        } else {
            cVSFileStatusArray = null;
        }
        changeList.setFilterStatuses(cVSFileStatusArray);
    }

    private void setDisplayConflictsPanel(boolean displayConflictsPanel) {
        this.getConflictsFilterPanel().setVisible(displayConflictsPanel);
        this.getToolbar().revalidate();
    }

    protected boolean authenticate() {
        if (Boolean.getBoolean("jdev.cvs.stopbugfix4751159")) {
            return true;
        }
        Iterator<String> itr = CVSConnectionNodes.getConnectionListAPI().getConnectionNames().iterator();
        while (itr.hasNext()) {
            CVSConnectionData connection = CVSConnectionNodes.getConnectionListAPI().getConnectionAPI(itr.next());
            CVSRootString root = new CVSRootString(connection.getRoot());
            if (!root.isAccessSsh2()) continue;
            CVSRunner runner = CVSRunnerFactory.getInstance().createRunner();
            runner.getParameters().setQuiet(Boolean.getBoolean("jdev.cvs.debugincomingchanges") ^ true);
            runner.getParameters().setContext(new CVSRootContext(root));
            runner.setCmdArray(new String[]{"-nq", "rtag", "-d", "bogus_tag", "bogus_module"});
            boolean[] success = new boolean[1];
            runner.addErrorMonitor(new 6(this, success));
            try {
                runner.exec();
                if (success[0]) continue;
                boolean bl = false;
                return bl;
            }
            catch (Exception e) {
                Assert.printStackTrace((Throwable)e);
            }
        }
        return true;
    }

    protected String createDisplayPersistenceKey(Object modeId) {
        return "CVS.PendingChangesWindow." + this.getDisplayPersistenceValue(modeId) + ".DisplaySettings";
    }

    private String getDisplayPersistenceValue(Object modeId) {
        if (modeId == Mode.OUTGOING) {
            return "Outgoing";
        }
        if (modeId == Mode.INCOMING) {
            return "Incoming";
        }
        if (modeId == Mode.CANDIDATES) {
            return "Candidates";
        }
        if (modeId == Mode.WATCHERS) {
            return "Watchers";
        }
        return null;
    }

    public String getTitleName() {
        return CVSArb.getString(697);
    }

    public Icon getTabIcon() {
        return VCSIconArb.getIcon((int)18);
    }

    protected String getModePersistenceKey() {
        return MODE_PERSISTENCE_KEY;
    }

    protected String getModePersistenceValue(Object modeId) {
        return ((Mode)((Object)modeId)).name();
    }

    protected Object getModePersistenceObject(String value) {
        return Mode.valueOf(value);
    }

    public ChangeList getOutgoingChangeList() {
        return this.getChangeList((Object)Mode.OUTGOING);
    }

    public ChangeList getIncomingChangeList() {
        return this.getChangeList((Object)Mode.INCOMING);
    }

    public ChangeList getCandidatesChangeList() {
        return this.getChangeList((Object)Mode.CANDIDATES);
    }

    public ChangeList getWatchersChangeList() {
        return this.getChangeList((Object)Mode.WATCHERS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void delayedInitialization() {
        Class<CVSChangeListWindow> clazz = CVSChangeListWindow.class;
        synchronized (CVSChangeListWindow.class) {
            if (_threadPool == null) {
                _threadPool = new VCSThreadPool(10, "Pending Changes Worker");
                Assert.println((String)"CVS: Pending Changes: Created thread pool.");
            }
            // ** MonitorExit[var7_1] (shouldn't be in output)
            VCSPropertyMap customizerSettings = (VCSPropertyMap)Ide.getDTCache().getData("CVS.ChangeListWindow.OptionsMap");
            if (customizerSettings != null) {
                HashMap customizerOptionsMap = new HashMap();
                for (Map.Entry entry : customizerSettings.getMap().entrySet()) {
                    CVSOptionId optionId = CVSOptionId.valueOf(entry.getKey().toString());
                    if (optionId == CVSOptionId.UPDATE_CLEAN_UPDATE) continue;
                    Object value = entry.getValue();
                    if (value instanceof Boolean) {
                        Boolean bl = value = (Boolean)value != false ? Boolean.TRUE : Boolean.FALSE;
                    }
                    if (optionId == null) continue;
                    customizerOptionsMap.put(optionId, value);
                }
                customizerOptionsMap.remove((Object)CVSOptionId.UPDATE_CLEAN_UPDATE);
                CVSClient.getInstance().getChangeListOptionsCustomizer().setOptions(customizerOptionsMap);
            }
            this._preferencesListener = new 7();
            CVSClient.getInstance().getVersionToolsPropertyData().addChangeListener(this._preferencesListener);
            super.delayedInitialization();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void postDeinitialization() {
        super.postDeinitialization();
        if (this._preferencesListener != null) {
            CVSClient.getInstance().getVersionToolsPropertyData().removeChangeListener(this._preferencesListener);
            this._preferencesListener = null;
        }
        Class<CVSChangeListWindow> clazz = CVSChangeListWindow.class;
        synchronized (CVSChangeListWindow.class) {
            if (_threadPool != null) {
                _threadPool.destroy();
                Assert.println((String)"CVS: Pending Changes: Destroyed thread pool.");
            }
            _threadPool = null;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected void preferencesChanged() {
        super.preferencesChanged();
        ((IncomingChangeList)this.getIncomingChangeList()).timerIntervalChanged();
    }

    public boolean isUsingCommitDialog() {
        String pref = (String)CVSClient.getInstance().getProperties().get("changelist_commit_dialog");
        if ("changelist_commit_dialog_always".equals(pref)) {
            return true;
        }
        if ("changelist_commit_dialog_never".equals(pref)) {
            return false;
        }
        return this.getChangeList().isOptionsVisible() ^ true;
    }

    protected void updateEllipsisItems() {
        boolean showEllipsis = this.isUsingCommitDialog();
        this.setEllipsisVisible(this.getLocalAction(CVSCommandConstants.OPERATION_COMMIT_CMD_ID), showEllipsis);
    }

    protected void setCommentsVisible(boolean visible) {
        super.setCommentsVisible(visible);
        this.updateEllipsisItems();
    }

    protected void addToolbarActions(Toolbar toolbar) {
        super.addToolbarActions(toolbar);
        this.setEllipsisVisible(this.getLocalAction(CVSCommandConstants.OPERATION_UNEDIT_CMD_ID), false);
        this.setEllipsisVisible(this.getLocalAction(CVSCommandConstants.OPERATION_UPDATE_CMD_ID), false);
        this.setEllipsisVisible(this.getLocalAction(CVSCommandConstants.OPERATION_ADD_CMD_ID), false);
    }

    protected void updateVisibleToolbarActions(Toolbar toolbar) {
        toolbar.removeAll();
        toolbar.add((ToggleAction)this.getLocalAction(51));
        if (this.getModeId() == Mode.OUTGOING) {
            toolbar.addSeparator();
            toolbar.add((ToggleAction)this.getLocalAction(CVSCommandConstants.OPERATION_COMMIT_CMD_ID));
            toolbar.add((ToggleAction)this.getLocalAction(CVSCommandConstants.OPERATION_UNDO_CHANGES_CMD_ID));
            toolbar.add((ToggleAction)this.getLocalAction(CVSCommandConstants.OPERATION_MERGE_CMD_ID));
        }
        if (this.getModeId() == Mode.INCOMING) {
            toolbar.addSeparator();
            toolbar.add((ToggleAction)this.getLocalAction(CVSCommandConstants.OPERATION_UPDATE_CMD_ID));
        }
        if (this.getModeId() == Mode.CANDIDATES) {
            toolbar.addSeparator();
            toolbar.add((ToggleAction)this.getLocalAction(CVSCommandConstants.OPERATION_ADD_CMD_ID));
        }
        if (this.getModeId() == Mode.OUTGOING) {
            toolbar.addSeparator();
            toolbar.add((ToggleAction)this.getLocalAction(CVSCommandConstants.OPERATION_DIFF_CMD_ID));
            toolbar.addSeparator();
            super.addCommentsToolbarAction(toolbar);
            toolbar.add((Component)new ToggleToolButton(CVSChangeListWindow.getDisplayConflictsAction()));
            toolbar.add(this.createCommitOptionsDropDown());
            toolbar.add((Component)this.getConflictsFilterPanel());
        }
        if (this.getModeId() == Mode.INCOMING) {
            // empty if block
        }
        if (this.getModeId() == Mode.CANDIDATES) {
            // empty if block
        }
        if (this.getModeId() == Mode.WATCHERS) {
            toolbar.add(Box.createGlue());
            toolbar.add((Component)WatchersChangeList.mav$getLastUpdatedLabel((WatchersChangeList)this.getWatchersChangeList()));
        }
        toolbar.validate();
        toolbar.invalidate();
        toolbar.repaint();
    }

    protected void updateBusyTickerVisible() {
        if (this.getModeId() == Mode.WATCHERS) {
            WatchersChangeList watchersChangeList = (WatchersChangeList)this.getWatchersChangeList();
            WatchersChangeList.mav$getLastUpdatedLabel(watchersChangeList).setVisible(watchersChangeList.isBusy() ^ true);
        }
        super.updateBusyTickerVisible();
    }

    private Component createCommitOptionsDropDown() {
        IdeAction optionsAction = ActionUtil.getAction(Resource.class, (int)Ide.findOrCreateCmdID((String)"CVSChangeListWindow.Options"), null, (String)"CHANGELIST_OPTIONS", (int)0);
        IdeAction forceCommitAction = IdeAction.get((int)FORCE_COMMIT_CMD_ID, null, (String)CVSArb.getString(65), (String)"", (Integer)new Integer(0), null, null, (boolean)true);
        forceCommitAction.putValue("Check", (Object)Boolean.TRUE);
        Action[] operationActions = this.getLocalOperationActions();
        if (this._optionsStateListener == null) {
            this._optionsStateListener = new OptionsStateListener((Action)optionsAction, operationActions);
        }
        this.addPropertyChangeListeners(operationActions, this._optionsStateListener);
        OptionsStateListener.mav$updateOptionsState(this._optionsStateListener);
        Map options = CVSClient.getInstance().getChangeListOptionsCustomizer().getOptions();
        Boolean currentValue = (Boolean)options.get((Object)CVSOptionId.COMMIT_FORCE_COMMIT);
        forceCommitAction.setState(currentValue == null ? false : currentValue);
        forceCommitAction.addPropertyChangeListener((PropertyChangeListener)new 8());
        MenuToolButton popupButton = new MenuToolButton(new ToggleAction[0], (ToggleAction)optionsAction);
        popupButton.addPopupItem((ToggleAction)forceCommitAction);
        return popupButton;
    }

    private Action[] getLocalOperationActions() {
        int[] cmdIds = new int[]{CVSCommandConstants.OPERATION_COMMIT_CMD_ID, CVSCommandConstants.OPERATION_COMMIT_ALL_CMD_ID};
        return this.getLocalActions(cmdIds);
    }

    private Action[] getLocalActions(int[] cmdIds) {
        Action[] actions = new Action[cmdIds.length];
        int i = 0;
        while (i < actions.length) {
            actions[i] = this.getLocalAction(cmdIds[i]);
            ++i;
        }
        return actions;
    }

    private void addPropertyChangeListeners(Action[] actions, PropertyChangeListener l) {
        int i = 0;
        while (i < actions.length) {
            actions[i].removePropertyChangeListener(l);
            actions[i].addPropertyChangeListener(l);
            ++i;
        }
    }

    protected String[] getPreferencesPath() {
        return VCSNavigableUtils.getSystemNavigablePath((String)CVSArb.getString(9), (String[])new String[]{CVSArb.getString(298)});
    }

    static {
        F1_HELP_INFO = new HelpInfo("f1_cvspendingchanges_html");
    }

    static VCSThreadPool ra$_threadPool() {
        return _threadPool;
    }

    static void mav$setDisplayOutgoingConflicts(CVSChangeListWindow cVSChangeListWindow, boolean bl) {
        cVSChangeListWindow.setDisplayOutgoingConflicts(bl);
    }

    static void mav$updateGUICardLayout(CVSChangeListWindow cVSChangeListWindow) {
        cVSChangeListWindow.updateGUICardLayout();
    }

    final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent ae) {
            CVSChangeListWindow.mav$setDisplayOutgoingConflicts(CVSChangeListWindow.getChangeListWindow(), false);
        }
    }

    final class 2
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent pce) {
            if ("optionsVisible".equals(pce.getPropertyName())) {
                Ide.getDTCache().putBoolean("CVS.ChangeListWindow.CommentsVisible", (Boolean)pce.getNewValue());
            }
        }
    }

    final class 3
    implements CVSLoginListener {
        public void loginPerformed(CVSLoginEvent le) {
            CVSChangeListWindow.mav$updateGUICardLayout(CVSChangeListWindow.this);
        }

        public void logoutPerformed(CVSLoginEvent le) {
            CVSChangeListWindow.mav$updateGUICardLayout(CVSChangeListWindow.this);
        }
    }

    final class 4
    implements Observer {
        public void update(Object observed, UpdateMessage change) {
            if (change.getMessageID() == UpdateMessage.CHILD_ADDED || change.getMessageID() == UpdateMessage.CHILD_REMOVED) {
                CVSChangeListWindow.mav$updateGUICardLayout(CVSChangeListWindow.this);
            }
        }
    }

    static final class 5
    extends ToggleAction {
        private void $init$() {
            this.setBooleanValue("Check", true);
        }

        public void actionPerformed(ActionEvent ae) {
            CVSChangeListWindow.mav$setDisplayOutgoingConflicts(CVSChangeListWindow.getChangeListWindow(), this.getState());
        }

        public void itemStateChanged(ItemEvent ie) {
        }

        public 5(String string, Icon icon) {
            super(string, icon);
            this.$init$();
        }
    }

    final class 6
    extends CVSProcessStreamMonitor {
        private final /* synthetic */ boolean[] v$success;
        final /* synthetic */ CVSChangeListWindow this$0;

        public void streamLine(String line, CVSProcess process) {
            if (line.indexOf("cannot find module") >= 0) {
                this.v$success[0] = true;
            }
        }

        public 6(CVSChangeListWindow cVSChangeListWindow, boolean[] blArray) {
            this.v$success = blArray;
            this.this$0 = cVSChangeListWindow;
        }
    }

    final class 7
    implements ChangeListener {
        public void stateChanged(ChangeEvent ce) {
            if (CVSClient.getInstance() != null) {
                CVSChangeListWindow.this.prefsChanged();
            }
        }
    }

    final class 8
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent pce) {
            if (pce.getPropertyName().equals("State")) {
                Map options = CVSClient.getInstance().getChangeListOptionsCustomizer().getOptions();
                options.put(CVSOptionId.COMMIT_FORCE_COMMIT, pce.getNewValue());
                HashMap persistedOptionsMap = new HashMap();
                for (Map.Entry entry : options.entrySet()) {
                    if (!(entry.getKey() instanceof CVSOptionId)) continue;
                    persistedOptionsMap.put(((CVSOptionId)((Object)entry.getKey())).name(), entry.getValue());
                }
                Ide.getDTCache().putData("CVS.ChangeListWindow.OptionsMap", (Copyable)new VCSPropertyMap(persistedOptionsMap));
                CVSClient.getInstance().getChangeListOptionsCustomizer().setOptions(options);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Mode
    extends Enum {
        public static final Mode OUTGOING = new Mode("OUTGOING");
        public static final Mode INCOMING = new Mode("INCOMING");
        public static final Mode CANDIDATES = new Mode("CANDIDATES");
        public static final Mode WATCHERS = new Mode("WATCHERS");
        private static final Mode[] PRIVATE_VALUES = new Mode[]{OUTGOING, INCOMING, CANDIDATES, WATCHERS};
        private static int _nextOrdinal = 0;

        private Mode(String name) {
            super(name, _nextOrdinal++);
        }

        public static final Mode valueOf(String name) {
            return (Mode)Enum.valueOf((Enum[])PRIVATE_VALUES, (String)name);
        }

        public static final Mode[] values() {
            return (Mode[])PRIVATE_VALUES.clone();
        }
    }

    private static class OutgoingContextMenuListener
    extends ChangeListContextMenuListener {
        OutgoingContextMenuListener(ChangeList changeList) {
            super(changeList);
        }

        protected IdeAction getDefaultAction(Context context) {
            IdeAction mergeAction = this.getContextualMergeAction(context);
            return mergeAction.isEnabled() ? mergeAction : super.getDefaultAction(context);
        }

        public void menuWillShowImpl(ContextMenu popup) {
            if (popup.getContext().getSelection().length > 0 && !this.getChangeList().isFocusInOptions()) {
                ReplaceMenuManager replaceMenuMgr;
                IdeAction mergeAction = this.getContextualMergeAction(popup.getContext());
                if (mergeAction.isEnabled()) {
                    popup.add((Component)popup.createMenuItem((ToggleAction)mergeAction), 1.9f);
                }
                popup.add((Component)popup.createMenuItem((ToggleAction)this.getLocalAction(popup, CVSCommandConstants.OPERATION_COMMIT_CMD_ID)), 2.0f);
                popup.add((Component)popup.createMenuItem((ToggleAction)this.getLocalAction(popup, CVSCommandConstants.OPERATION_COMMIT_ALL_CMD_ID)), 2.0f);
                popup.add((Component)popup.createMenuItem((ToggleAction)this.getLocalAction(popup, CVSCommandConstants.OPERATION_UNEDIT_CMD_ID)), 2.0f);
                popup.add((Component)popup.createMenuItem((ToggleAction)this.getLocalAction(popup, CVSCommandConstants.OPERATION_ADD_CMD_ID)), 2.0f);
                popup.add((Component)popup.createMenuItem((ToggleAction)this.getLocalAction(popup, CVSCommandConstants.OPERATION_UNDO_CHANGES_CMD_ID)), 2.0f);
                CompareViewer cv = CompareViewer.get();
                if (cv != null) {
                    popup.add((Component)cv.getContextCompareMenu(), 4.0f);
                }
                if ((replaceMenuMgr = ReplaceMenuManager.getInstance()) != null) {
                    popup.add((Component)replaceMenuMgr.getContextReplaceMenu(), 4.0f);
                }
            }
            popup.add((Component)Ide.getMenubar().createMenuItem(CVSChangeListWindow.getDisplayConflictsAction()), 4.9f);
            popup.add((Component)Ide.getMenubar().createMenuItem((ToggleAction)IdeAction.get((int)FORCE_COMMIT_CMD_ID)), 4.9f);
            this.addMenuItemRefresh(popup);
            this.addMenuItemPreferences(popup);
        }

        private IdeAction getContextualMergeAction(Context context) {
            IdeAction mergeAction = this.getLocalAction(context, CVSCommandConstants.OPERATION_MERGE_CMD_ID);
            mergeAction.updateAction(context);
            return mergeAction;
        }
    }

    private static class IncomingContextMenuListener
    extends ChangeListContextMenuListener {
        IncomingContextMenuListener(ChangeList changeList) {
            super(changeList);
        }

        protected IdeAction getDefaultAction() {
            return IdeAction.find((int)OPEN_INCOMING_CMD_ID);
        }

        public void menuWillShowImpl(ContextMenu popup) {
            if (popup.getContext().getSelection().length > 0) {
                popup.add((Component)popup.createMenuItem((ToggleAction)IdeAction.find((int)ChangeListWindow.OPEN_CMD_ID)), 1.9f);
                popup.add((Component)popup.createMenuItem((ToggleAction)this.getLocalAction(popup, CVSCommandConstants.OPERATION_UPDATE_CMD_ID)), 2.0f);
                popup.add((Component)popup.createMenuItem((ToggleAction)this.getLocalAction(popup, CVSCommandConstants.OPERATION_UPDATE_ALL_CMD_ID)), 2.0f);
                popup.add((Component)popup.createMenuItem((ToggleAction)this.getLocalAction(popup, CVSCommandConstants.OPERATION_OPEN_HEAD_REVISION_CMD_ID)), 1.9f);
                CompareViewer cv = CompareViewer.get();
                if (cv != null) {
                    popup.add((Component)cv.getContextCompareMenu(), 4.0f);
                }
            }
            this.addMenuItemCopyFileList(popup);
            this.addMenuItemRefresh(popup);
            this.addMenuItemSelectInNavigator(popup);
            this.addMenuItemPreferences(popup);
        }
    }

    private static class CandidatesContextMenuListener
    extends ChangeListContextMenuListener {
        CandidatesContextMenuListener(ChangeList changeList) {
            super(changeList);
        }

        public void menuWillShowImpl(ContextMenu popup) {
            if (popup.getContext().getSelection().length > 0) {
                popup.add((Component)popup.createMenuItem((ToggleAction)this.getLocalAction(popup, CVSCommandConstants.OPERATION_ADD_CMD_ID)), 2.0f);
                popup.add((Component)popup.createMenuItem((ToggleAction)this.getLocalAction(popup, CVSCommandConstants.OPERATION_ADD_BINARY_CMD_ID)), 2.0f);
                popup.add((Component)popup.createMenuItem((ToggleAction)this.getLocalAction(popup, CVSCommandConstants.OPERATION_ADD_ALL_CMD_ID)), 2.0f);
                popup.add((Component)popup.createMenuItem((ToggleAction)this.getLocalAction(popup, CVSCommandConstants.OPERATION_IGNORE_FILE_CMD_ID)), 2.1f);
                popup.add((Component)popup.createMenuItem((ToggleAction)this.getLocalAction(popup, CVSCommandConstants.OPERATION_IGNORE_FILE_TYPE_CMD_ID)), 2.1f);
            }
            this.addMenuItemRefresh(popup);
            this.addMenuItemCopyFileList(popup);
            this.addMenuItemSelectInNavigator(popup);
            this.addMenuItemPreferences(popup);
        }
    }

    private class OptionsStateListener
    implements PropertyChangeListener {
        private final Action _optionsAction;
        private final Action[] _operationActions;

        OptionsStateListener(Action optionsAction, Action[] operationActions) {
            this._optionsAction = optionsAction;
            this._operationActions = operationActions;
        }

        public void propertyChange(PropertyChangeEvent pce) {
            if (pce.getPropertyName().equals("enabled")) {
                this.updateOptionsState();
            }
        }

        private void updateOptionsState() {
            this._optionsAction.setEnabled(this.getState());
        }

        private boolean getState() {
            int i = 0;
            while (i < this._operationActions.length) {
                if (this._operationActions[i].isEnabled()) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        static void mav$updateOptionsState(OptionsStateListener optionsStateListener) {
            optionsStateListener.updateOptionsState();
        }
    }

    public static class OutgoingChangeList
    extends ChangeList {
        private ContextMenuListener _outgoingContextMenuListener;
        private ResetFilterEventListener _resetFilterEventListener;

        OutgoingChangeList() {
            super((Object)Mode.OUTGOING);
            this.setExcludeDirectories(true);
        }

        protected Icon getModeIcon() {
            return null;
        }

        protected String getModeLabel() {
            return CVSArb.getString(116);
        }

        protected String getModeLongLabel() {
            return CVSArb.getString(696);
        }

        protected void initializeChangeList() {
            this.setStatusCache((VCSURLBasedCache)new ChangeListLocalStatusCache((VCSURLBasedCache)CVSClient.getInstance().getStatusCache()));
            this.setOverlayItemProducer(CVSClient.getInstance().getChangeListOverlayItemProducer());
            this.setVisibleStatuses(new CVSFileStatus[]{CVSFileStatus.STATUS_ADDED, CVSFileStatus.STATUS_REMOVED, CVSFileStatus.STATUS_LOCALLY_CHANGED, CVSFileStatus.STATUS_CONFLICTS});
            this.setOptionsCustomizer(CVSClient.getInstance().getChangeListOptionsCustomizer());
            boolean showComments = Ide.getDTCache().getBoolean("CVS.ChangeListWindow.CommentsVisible", false);
            this.setOptionsVisible(showComments);
        }

        protected DisplayProperty[] createDisplayProperties() {
            return new ClientDisplayProperty[]{new ClientDisplayProperty(CVSArb.getString(109), (Object)CVSArb.getString(309), ChangeListStatus.class)};
        }

        protected void defaultOptionsOnInitialInsert() {
            super.defaultOptionsOnInitialInsert();
            String currentComments = this.getCommentsCustomizer().getCommentText();
            String defaultTemplate = CVSUtil.readCommentsTemplate(Arrays.asList(this.getElements()));
            if (currentComments == null || defaultTemplate == null) {
                return;
            }
            if (currentComments.equals("") && this.isUseCommentTemplatesSet()) {
                this.getCommentsCustomizer().setCommentText(defaultTemplate);
                return;
            }
            if (currentComments.equals(defaultTemplate) && !this.isUseCommentTemplatesSet()) {
                this.getCommentsCustomizer().setCommentText("");
                return;
            }
        }

        protected ChangeListEventQueue createEventQueue() {
            OutgoingChangeListEventQueue eventQueue = new OutgoingChangeListEventQueue(this);
            this._resetFilterEventListener = new ResetFilterEventListener(eventQueue);
            eventQueue.addEventListener(this._resetFilterEventListener);
            return eventQueue;
        }

        protected void startImpl() {
            super.startImpl();
            ChangeListEvent cle = new ChangeListEvent(2);
            cle.setRunnable((Runnable)new 1());
            this.getEventQueue().enqueue(cle);
        }

        protected String getBusyStatusMessage() {
            return CVSArb.getString(488);
        }

        protected void addContextMenuListeners(ContextMenu contextMenu) {
            this._outgoingContextMenuListener = new OutgoingContextMenuListener(this);
            contextMenu.addContextMenuListener(this._outgoingContextMenuListener);
        }

        protected void removeContextMenuListeners(ContextMenu contextMenu) {
            contextMenu.removeContextMenuListener(this._outgoingContextMenuListener);
            this._outgoingContextMenuListener = null;
        }

        private boolean isUseCommentTemplatesSet() {
            return CVSClient.getInstance().getBooleanProperty("property_use_comment_templates", Boolean.TRUE);
        }

        private ChangeListCommentsCustomizer getCommentsCustomizer() {
            return (ChangeListCommentsCustomizer)CVSClient.getInstance().getChangeListOptionsCustomizer();
        }

        static ResetFilterEventListener ra$_resetFilterEventListener(OutgoingChangeList outgoingChangeList) {
            return outgoingChangeList._resetFilterEventListener;
        }

        class ResetFilterEventListener
        extends ChangeListEventListener {
            private final ChangeListEventQueue _eventQueue;
            private ChangeListEvent _cle;
            private Object _filterStatuses;
            private boolean _enabled;

            private void $init$() {
                this._cle = null;
                this._filterStatuses = null;
            }

            ResetFilterEventListener(ChangeListEventQueue eventQueue) {
                this.$init$();
                this._eventQueue = eventQueue;
            }

            void setEnabled(boolean enabled) {
                this._enabled = enabled;
            }

            public void eventDispatched(ChangeListEvent cle) {
                if (!this._enabled) {
                    return;
                }
                this._cle = cle;
                this._filterStatuses = OutgoingChangeList.this.getFilterStatuses();
            }

            public void eventProcessed(ChangeListEvent cle) {
                if (!this._enabled) {
                    return;
                }
                if (this._cle != cle) {
                    return;
                }
                if (OutgoingChangeList.this.getFilterStatuses() != this._filterStatuses) {
                    this._eventQueue.removeEventListener((ChangeListEventListener)this);
                    cle = new ChangeListEvent(2);
                    cle.setRunnable((Runnable)new 1());
                    this._eventQueue.enqueue(cle);
                    return;
                }
                EventQueue.invokeLater(new 2());
            }

            static ChangeListEventQueue ra$_eventQueue(ResetFilterEventListener resetFilterEventListener) {
                return resetFilterEventListener._eventQueue;
            }

            final class 1
            implements Runnable {
                public void run() {
                    ResetFilterEventListener.ra$_eventQueue(ResetFilterEventListener.this).addEventListener((ChangeListEventListener)ResetFilterEventListener.this);
                }
            }

            final class 2
            implements Runnable {
                public void run() {
                    if (CVSChangeListWindow.getDisplayConflictsAction().getState() && OutgoingChangeList.this.getElements().length <= 0) {
                        CVSChangeListWindow.mav$setDisplayOutgoingConflicts(CVSChangeListWindow.getChangeListWindow(), false);
                    }
                }
            }
        }

        final class 1
        implements Runnable {
            public void run() {
                OutgoingChangeList.ra$_resetFilterEventListener(OutgoingChangeList.this).setEnabled(true);
            }
        }
    }

    public static class IncomingChangeList
    extends AsynchronousChangeListImpl {
        private ContextMenuListener _incomingContextMenuListener;

        IncomingChangeList() {
            super((Object)Mode.INCOMING);
            this.setExcludeDirectories(false);
        }

        protected Icon getModeIcon() {
            return null;
        }

        protected String getModeLabel() {
            return CVSArb.getString(395);
        }

        protected String getModeLongLabel() {
            return CVSArb.getString(473);
        }

        protected void initializeChangeList() {
            this.setStatusCache((ChangeListStatusCache)new UpdateStatusCache(null));
            this.setOverlayItemProducer(CVSClient.getInstance().getChangeListOverlayItemProducer());
            this.setVisibleStatuses(new UpdateStatus[]{UpdateStatus.REMOTELY_UPDATED, UpdateStatus.REMOTELY_UPDATED_NEW, UpdateStatus.REMOTELY_REMOVED, UpdateStatus.CONFLICTS_ON_MERGE});
        }

        protected DisplayProperty[] createDisplayProperties() {
            return new ClientDisplayProperty[]{new ClientDisplayProperty(CVSArb.getString(72), (Object)CVSArb.getString(339), ChangeListStatus.class)};
        }

        protected Integer getTimerIntervalImpl() {
            long timerMillis;
            Integer timer = (Integer)CVSClient.getInstance().getProperties().get("changelist_timer");
            if (timer == null) {
                timer = CVSPropertyKey.DEF_PROPERTY_CHANGELIST_TIMER;
            }
            if ((timerMillis = (long)(timer * 1000)) <= 0L) {
                timerMillis = Integer.MAX_VALUE;
            }
            return new Integer((int)timerMillis);
        }

        protected TimerTask createStatusTask(VCSThreadPool threadPool) {
            return new UpdateStatusTask((ChangeList)this, threadPool);
        }

        protected String getBusyStatusMessage() {
            return CVSArb.getString(649);
        }

        protected void addContextMenuListeners(ContextMenu contextMenu) {
            this._incomingContextMenuListener = new IncomingContextMenuListener((ChangeList)this);
            contextMenu.addContextMenuListener(this._incomingContextMenuListener);
        }

        protected void removeContextMenuListeners(ContextMenu contextMenu) {
            contextMenu.removeContextMenuListener(this._incomingContextMenuListener);
            this._incomingContextMenuListener = null;
        }

        protected String getTabToggleKey() {
            return CVSChangeListWindow.INCOMING_VISIBLE_PERSISTENCE_KEY;
        }
    }

    public static class CandidatesChangeList
    extends ChangeList {
        private ContextMenuListener _candidatesContextMenuListener;

        CandidatesChangeList() {
            super((Object)Mode.CANDIDATES);
            this.setExcludeDirectories(true);
        }

        protected Icon getModeIcon() {
            return null;
        }

        protected String getModeLabel() {
            return CVSArb.getString(33);
        }

        protected String getModeLongLabel() {
            return CVSArb.getString(41);
        }

        protected void initializeChangeList() {
            this.setStatusCache((VCSURLBasedCache)new ChangeListLocalStatusCache((VCSURLBasedCache)CVSClient.getInstance().getStatusCache()));
            this.setOverlayItemProducer(CVSClient.getInstance().getChangeListOverlayItemProducer());
            this.setVisibleStatuses(new CVSFileStatus[]{CVSFileStatus.STATUS_UNADDED});
        }

        protected ChangeListEventQueue createEventQueue() {
            return new CandidatesChangeListEventQueue(this);
        }

        protected String getBusyStatusMessage() {
            return CVSArb.getString(48);
        }

        protected String getTabToggleKey() {
            return CVSChangeListWindow.CANDIDATES_VISIBLE_PERSISTENCE_KEY;
        }

        protected void addContextMenuListeners(ContextMenu contextMenu) {
            this._candidatesContextMenuListener = new CandidatesContextMenuListener(this);
            contextMenu.addContextMenuListener(this._candidatesContextMenuListener);
        }

        protected void removeContextMenuListeners(ContextMenu contextMenu) {
            contextMenu.removeContextMenuListener(this._candidatesContextMenuListener);
            this._candidatesContextMenuListener = null;
        }
    }

    private static class OutgoingChangeListEventQueue
    extends ChangeListEventQueue {
        OutgoingChangeListEventQueue(ChangeList changeList) {
            super(changeList);
        }

        protected Collection listProjectURLs(Project project, ChangeListProjectContent projectContent, VCSCancellable cancellable) throws Exception {
            HashSet urls = new HashSet(super.listProjectURLs(project, projectContent, cancellable));
            ArrayList<URL> directoryUrls = new ArrayList<URL>();
            URL[] baseDirectoryUrls = projectContent.getBaseDirectoryURLs();
            directoryUrls.addAll(Arrays.asList(baseDirectoryUrls));
            int i = 0;
            while (i < baseDirectoryUrls.length) {
                if (CVSUtil.isOpenSessionSandbox(baseDirectoryUrls[i])) {
                    directoryUrls.addAll(CVSListFilesUtil.listFiles(baseDirectoryUrls[i], 6));
                }
                ++i;
            }
            for (URL directoryUrl : directoryUrls) {
                if (directoryUrl == null) continue;
                this.addRemovedEntryURLs(urls, directoryUrl, cancellable);
            }
            return new ArrayList(urls);
        }

        private void addRemovedEntryURLs(Collection urls, URL directoryUrl, VCSCancellable cancellable) {
            List entries = null;
            try {
                if (!this.isAlive()) {
                    return;
                }
                entries = CVSEntriesCache.getInstance().getEntries(directoryUrl);
            }
            catch (IOException ioe) {
                Assert.printStackTrace((Throwable)ioe);
            }
            if (entries == null) {
                return;
            }
            Iterator itr = entries.iterator();
            while (itr.hasNext() && !cancellable.isCancelled()) {
                URL url;
                CVSEntry entry = (CVSEntry)itr.next();
                if (entry.isDirectory() || !entry.isRemoved() || GlobalIgnoreList.isGloballyIgnored((URL)(url = URLFactory.newURL((URL)directoryUrl, (String)entry.getName()))) || URLFileSystem.exists((URL)url)) continue;
                urls.add(url);
            }
        }
    }

    private static class CandidatesChangeListEventQueue
    extends ChangeListEventQueue {
        CandidatesChangeListEventQueue(ChangeList changeList) {
            super(changeList);
        }

        protected void filterByStatus(Collection urls) throws Exception {
            CVSIgnorePatternList.filterIgnored(urls);
            super.filterByStatus(urls);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UpdateStatus
    extends Enum
    implements ChangeListStatus {
        public static final UpdateStatus REMOTELY_UPDATED = new UpdateStatus("REMOTELY_UPDATED", 277);
        public static final UpdateStatus REMOTELY_UPDATED_NEW = new UpdateStatus("REMOTELY_UPDATED_NEW", 727);
        public static final UpdateStatus REMOTELY_REMOVED = new UpdateStatus("REMOTELY_REMOVED", 301);
        public static final UpdateStatus CONFLICTS_ON_MERGE = new UpdateStatus("CONFLICTS_ON_MERGE", 339);
        public static final UpdateStatus LOCALLY_MODIFIED = new UpdateStatus("LOCALLY_MODIFIED", 23);
        public static final UpdateStatus LOCALLY_ADDED = new UpdateStatus("LOCALLY_ADDED", 154);
        public static final UpdateStatus LOCALLY_REMOVED = new UpdateStatus("LOCALLY_REMOVED", 364);
        public static final UpdateStatus QUESTIONABLE_FILE = new UpdateStatus("QUESTIONABLE_FILE");
        public static final UpdateStatus STATUS_NOT_KNOWN = new UpdateStatus("STATUS_NOT_KNOWN");
        private static final UpdateStatus[] PRIVATE_VALUES = new UpdateStatus[]{REMOTELY_UPDATED, REMOTELY_UPDATED_NEW, REMOTELY_REMOVED, CONFLICTS_ON_MERGE, LOCALLY_MODIFIED, LOCALLY_ADDED, LOCALLY_REMOVED, QUESTIONABLE_FILE, STATUS_NOT_KNOWN};
        private static int _nextOrdinal = 0;
        private final String _label;

        private UpdateStatus(String name) {
            this(name, -1);
        }

        private UpdateStatus(String name, int labelResourceIndex) {
            super(name, _nextOrdinal++);
            this._label = labelResourceIndex >= 0 ? CVSArb.getString(labelResourceIndex) : null;
        }

        public static final UpdateStatus valueOf(String name) {
            return (UpdateStatus)Enum.valueOf((Enum[])PRIVATE_VALUES, (String)name);
        }

        public static final UpdateStatus[] values() {
            return (UpdateStatus[])PRIVATE_VALUES.clone();
        }

        public String getChangeListLabel() {
            return this._label;
        }

        public boolean isChangeListCellHighlighted() {
            return this.equals((Object)CONFLICTS_ON_MERGE);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UpdateStatusTask
    extends AsynchronousStatusTaskImpl {
        UpdateStatusTask(ChangeList changeList, VCSThreadPool threadPool) {
            super(changeList, threadPool);
        }

        protected boolean isChangeListVisible() {
            return CVSChangeListWindow.getChangeListWindow().isChangeListVisible(CVSChangeListWindow.getChangeListWindow().getIncomingChangeList());
        }

        protected void populateStatusCacheMap(Map<URL, Object> updateStatusCacheMap, Collection<URL> directoriesToQuery) throws Exception {
            for (URL directoryUrl : directoriesToQuery) {
                CVSRunner runner = this.createRunner();
                runner.getParameters().setKeepCachedFiles(true);
                runner.setCmdList(Arrays.asList("-nq", "update", "-d"));
                runner.setDirURL(directoryUrl);
                runner.addOutputMonitor(new 1(this, directoryUrl, updateStatusCacheMap));
                runner.addErrorMonitor(new 2(this, directoryUrl, updateStatusCacheMap));
                if (this.canExit()) {
                    return;
                }
                runner.exec();
            }
            if (this.canExit()) {
                return;
            }
            CVSClient client = CVSClient.getInstance();
            Iterator<Map.Entry<URL, Object>> itr = updateStatusCacheMap.entrySet().iterator();
            while (client != null && itr.hasNext()) {
                Map.Entry<URL, Object> entry = itr.next();
                if (entry.getValue() != UpdateStatus.CONFLICTS_ON_MERGE) continue;
                URL url = entry.getKey();
                VCSStatusCache statusCache = client.getStatusCache();
                if (statusCache == null || statusCache.get(url) != CVSFileStatus.STATUS_CONFLICTS) continue;
                itr.remove();
            }
            if (updateStatusCacheMap.values().contains((Object)UpdateStatus.LOCALLY_MODIFIED)) {
                CVSRunner runner = this.createRunner();
                runner.getParameters().setKeepCachedFiles(true);
                ArrayList<String> cmd = new ArrayList<String>();
                cmd.add("-nq");
                cmd.add("diff");
                if (!(runner instanceof CVSInternalClientRunner)) {
                    cmd.add("--brief");
                }
                cmd.add("-rHEAD");
                cmd.add("-rBASE");
                runner.setCmdList(cmd);
                ArrayList<URL> urls = new ArrayList<URL>();
                for (Map.Entry<URL, Object> entry : updateStatusCacheMap.entrySet()) {
                    if (entry.getValue() != UpdateStatus.LOCALLY_MODIFIED) continue;
                    urls.add(entry.getKey());
                }
                3 invokable = new 3(this, (VCSInvokableState)new VCSDirectoryInvokableState(urls.toArray(new URL[0])), 10, runner, updateStatusCacheMap);
                if (!invokable.runInvokable()) {
                    return;
                }
            }
        }

        static boolean mav$canExit(UpdateStatusTask updateStatusTask) {
            return updateStatusTask.canExit();
        }

        final class 1
        extends CVSProcessStreamMonitor {
            private final Pattern _pattern;
            private final /* synthetic */ URL v$directoryUrl;
            private final /* synthetic */ Map v$updateStatusCacheMap;
            final /* synthetic */ UpdateStatusTask this$0;

            private void $init$() {
                this._pattern = Pattern.compile("^([\\p{Upper}\\?]) (.*)");
            }

            protected void streamLine(String line, CVSProcess process) throws Exception {
                Matcher matcher = this._pattern.matcher(line);
                if (!matcher.matches()) {
                    return;
                }
                char updateCode = matcher.group(1).charAt(0);
                URL url = URLFileSystem.canonicalize((URL)URLFactory.newURL((URL)this.v$directoryUrl, (String)matcher.group(2)));
                if (GlobalIgnoreList.isGloballyIgnored((URL)url)) {
                    return;
                }
                this.v$updateStatusCacheMap.put(url, UpdateStatus.STATUS_NOT_KNOWN);
                if (updateCode == 'U' || updateCode == 'P') {
                    UpdateStatus status = URLFileSystem.exists((URL)url) ? UpdateStatus.REMOTELY_UPDATED : UpdateStatus.REMOTELY_UPDATED_NEW;
                    this.v$updateStatusCacheMap.put(url, status);
                }
                if (updateCode == 'C') {
                    this.v$updateStatusCacheMap.put(url, UpdateStatus.CONFLICTS_ON_MERGE);
                }
                if (updateCode == 'M') {
                    this.v$updateStatusCacheMap.put(url, UpdateStatus.LOCALLY_MODIFIED);
                }
                if (updateCode == 'A') {
                    this.v$updateStatusCacheMap.put(url, UpdateStatus.LOCALLY_ADDED);
                }
                if (updateCode == 'R') {
                    this.v$updateStatusCacheMap.put(url, UpdateStatus.LOCALLY_REMOVED);
                }
                if (updateCode == 'D') {
                    this.v$updateStatusCacheMap.put(url, UpdateStatus.LOCALLY_REMOVED);
                }
                if (updateCode == '?') {
                    if (URLFileSystem.isDirectory((URL)url)) {
                        this.v$updateStatusCacheMap.remove(url);
                        return;
                    }
                    this.v$updateStatusCacheMap.put(url, UpdateStatus.QUESTIONABLE_FILE);
                }
            }

            public 1(UpdateStatusTask updateStatusTask, URL uRL, Map map) {
                this.v$updateStatusCacheMap = map;
                this.v$directoryUrl = uRL;
                this.this$0 = updateStatusTask;
                this.$init$();
            }
        }

        final class 2
        extends CVSProcessStreamMonitor {
            private final Pattern _pattern1;
            private final Pattern _pattern2;
            private final /* synthetic */ URL v$directoryUrl;
            private final /* synthetic */ Map v$updateStatusCacheMap;
            final /* synthetic */ UpdateStatusTask this$0;

            private void $init$() {
                this._pattern1 = Pattern.compile(".*: (.*) is no longer in the repository.*");
                this._pattern2 = Pattern.compile(".*: New directory `(.*)' -- ignored.*");
            }

            protected void streamLine(String line, CVSProcess process) throws Exception {
                URL url;
                URL url2;
                Matcher matcher1 = this._pattern1.matcher(line);
                Matcher matcher2 = this._pattern2.matcher(line);
                if (matcher1.matches() && !GlobalIgnoreList.isGloballyIgnored((URL)(url2 = URLFactory.newURL((URL)this.v$directoryUrl, (String)matcher1.group(1))))) {
                    this.v$updateStatusCacheMap.put(url2, UpdateStatus.REMOTELY_REMOVED);
                }
                if (matcher2.matches() && !GlobalIgnoreList.isGloballyIgnored((URL)(url = URLFactory.newDirURL((URL)this.v$directoryUrl, (String)matcher2.group(1))))) {
                    this.v$updateStatusCacheMap.put(url, UpdateStatus.REMOTELY_UPDATED_NEW);
                }
            }

            public 2(UpdateStatusTask updateStatusTask, URL uRL, Map map) {
                this.v$updateStatusCacheMap = map;
                this.v$directoryUrl = uRL;
                this.this$0 = updateStatusTask;
                this.$init$();
            }
        }

        final class 3
        extends VCSDirectoryInvokable {
            private final /* synthetic */ CVSRunner v$runner;
            private final /* synthetic */ Map v$updateStatusCacheMap;
            final /* synthetic */ UpdateStatusTask this$0;

            protected boolean doInvocation(URL parent, URL[] invokeUrlArgs) throws Exception {
                String[] filenames = VCSFileSystemUtils.getURLFileNames((URL[])invokeUrlArgs);
                this.v$runner.setDirURL(parent);
                this.v$runner.getParameters().setFiles(Arrays.asList(filenames));
                if (UpdateStatusTask.mav$canExit(this.this$0)) {
                    return false;
                }
                this.v$runner.exec();
                String output = this.v$runner.getOutputText();
                int i = 0;
                while (i < invokeUrlArgs.length) {
                    if (output.indexOf("Index: " + URLFileSystem.getFileName((URL)invokeUrlArgs[i])) >= 0) {
                        this.v$updateStatusCacheMap.put(invokeUrlArgs[i], UpdateStatus.REMOTELY_UPDATED);
                    }
                    ++i;
                }
                return true;
            }

            public 3(UpdateStatusTask updateStatusTask, VCSInvokableState vCSInvokableState, int n, CVSRunner cVSRunner, Map map) {
                this.v$updateStatusCacheMap = map;
                this.v$runner = cVSRunner;
                this.this$0 = updateStatusTask;
                super(vCSInvokableState, n);
            }
        }
    }

    private static class UpdateStatusCache
    extends AsynchronousStatusCache {
        protected final void getImpl(URL[] urls, ChangeListStatus[] statuses) throws Exception {
            int i = 0;
            while (i < statuses.length) {
                statuses[i] = UpdateStatus.STATUS_NOT_KNOWN;
                ++i;
            }
        }

        private UpdateStatusCache() {
        }

        UpdateStatusCache(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    public static class OpenIncomingCommand
    extends OpenCommand {
        public OpenIncomingCommand() {
            super(OPEN_INCOMING_CMD_ID);
        }

        protected void openDefaultEditorInFrame(Context context) {
            try {
                IdeAction.find((int)CVSCommandConstants.OPERATION_DIFF_HEAD_CMD_ID).performAction(context);
            }
            catch (Exception e) {
                Assert.printStackTrace((Throwable)e);
            }
        }
    }

    public static class WatchersChangeList
    extends AsynchronousChangeListImpl {
        private static final DisplayProperty DISPLAY_PROPERTY_EDITOR = new ClientDisplayProperty(CVSArb.getString(50), (Object)"(3) example,user,list", Collection.class);
        private static final DisplayProperty DISPLAY_PROPERTY_WATCHER = new ClientDisplayProperty(CVSArb.getString(335), (Object)"(3) example,user,list", Collection.class);
        private final JLabel _lastUpdatedLabel;

        private void $init$() {
            this._lastUpdatedLabel = new JLabel(" ");
        }

        WatchersChangeList() {
            super((Object)Mode.WATCHERS);
            this.$init$();
        }

        protected TimerTask createStatusTask(VCSThreadPool threadPool) {
            return new WatchersStatusTask((ChangeList)this, threadPool);
        }

        protected ChangeListEventQueue createEventQueue() {
            ChangeListEventQueue eventQueue = super.createEventQueue();
            eventQueue.addEventListener((ChangeListEventListener)new 1());
            return eventQueue;
        }

        protected Icon getModeIcon() {
            return null;
        }

        protected String getModeLabel() {
            return CVSArb.getString(230);
        }

        protected String getModeLongLabel() {
            return CVSArb.getString(57);
        }

        protected void initializeChangeList() {
            this.setStatusCache((ChangeListStatusCache)new WatchersStatusCache(null));
            this.setOverlayItemProducer(CVSClient.getInstance().getChangeListOverlayItemProducer());
            this.setVisibleStatuses(new WatchersStatus[]{WatchersStatus.WATCHER});
        }

        protected DisplayProperty[] createDisplayProperties() {
            return new DisplayProperty[]{DISPLAY_PROPERTY_WATCHER, DISPLAY_PROPERTY_EDITOR};
        }

        protected Object getModelValue(URL url, DisplayProperty displayProperty) throws Exception {
            if (displayProperty == DISPLAY_PROPERTY_WATCHER) {
                WatchersStatus status = this.getStatusCache() != null && url != null ? (WatchersStatus)((Object)this.getStatusCache().getValue(url)) : WatchersStatus.NO_WATCHER;
                return status.getWatchers();
            }
            if (displayProperty == DISPLAY_PROPERTY_EDITOR) {
                WatchersStatus status = this.getStatusCache() != null && url != null ? (WatchersStatus)((Object)this.getStatusCache().getValue(url)) : WatchersStatus.NO_WATCHER;
                return status.getEditors();
            }
            return super.getModelValue(url, displayProperty);
        }

        protected String getBusyStatusMessage() {
            return CVSArb.getString(260);
        }

        protected String getTabToggleKey() {
            return CVSChangeListWindow.WATCHERS_VISIBLE_PERSISTENCE_KEY;
        }

        private JLabel getLastUpdatedLabel() {
            return this._lastUpdatedLabel;
        }

        static JLabel mav$getLastUpdatedLabel(WatchersChangeList watchersChangeList) {
            return watchersChangeList.getLastUpdatedLabel();
        }

        static JLabel ra$_lastUpdatedLabel(WatchersChangeList watchersChangeList) {
            return watchersChangeList._lastUpdatedLabel;
        }

        final class 1
        extends ChangeListEventListener {
            public void eventProcessed(ChangeListEvent cle) {
                if (cle.getKind() == 0) {
                    WatchersChangeList.ra$_lastUpdatedLabel(WatchersChangeList.this).setText(CVSArb.format(155, DateFormat.getDateTimeInstance().format(System.currentTimeMillis())));
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WatchersStatus
    extends Enum
    implements ChangeListStatus {
        public static final WatchersStatus NO_WATCHER = new WatchersStatus("NO_WATCHER");
        public static final WatchersStatus WATCHER = new WatchersStatus("WATCHER");
        private static final WatchersStatus[] PRIVATE_VALUES = new WatchersStatus[]{NO_WATCHER};
        private static int _nextOrdinal = 0;
        private final Collection<String> _editors;
        private final Collection<String> _watchers;

        private void $init$() {
            this._editors = new HashSet<String>();
            this._watchers = new HashSet<String>();
        }

        private WatchersStatus(String name) {
            super(name, _nextOrdinal++);
            this.$init$();
        }

        public static final WatchersStatus valueOf(String name) {
            return (WatchersStatus)Enum.valueOf((Enum[])PRIVATE_VALUES, (String)name);
        }

        public static final WatchersStatus[] values() throws CloneNotSupportedException {
            return (WatchersStatus[])PRIVATE_VALUES.clone();
        }

        public String getChangeListLabel() {
            return this.toString();
        }

        public boolean isChangeListCellHighlighted() {
            return false;
        }

        public Collection getEditors() {
            return this._editors;
        }

        public Collection getWatchers() {
            return this._watchers;
        }

        public boolean equals(Object o) {
            return o instanceof WatchersStatus && this.name().equals(((WatchersStatus)((Object)o)).name());
        }

        static final WatchersStatus createWatchersStatus() {
            return new WatchersStatus(WATCHER.name());
        }
    }

    private static abstract class AsynchronousStatusTaskImpl
    extends AsynchronousStatusTask {
        protected AsynchronousStatusTaskImpl(ChangeList changeList, VCSThreadPool threadPool) {
            super(changeList, threadPool);
        }

        protected boolean isClientReady() {
            return CVSFileURLFileSystemHelper.checkForCVS();
        }

        protected boolean isControlled(URL directoryUrl) {
            return CVSUtil.isOpenSessionSandbox(directoryUrl);
        }

        protected String getViewId() {
            return CVSClient.CHANGE_LIST_ID;
        }

        protected CVSRunner createRunner() {
            CVSRunner runner = CVSRunnerFactory.getInstance().createRunner();
            runner.getParameters().setQuiet(Boolean.getBoolean("jdev.cvs.debugincomingchanges") ^ true);
            if (runner instanceof CVSInternalClientRunner) {
                ((CVSInternalClientRunner)runner).setPrompter(new CancelPrompter(null));
            }
            runner.setThreadPool(this.getThreadPool());
            return runner;
        }

        private class CancelPrompter
        extends OCVSPrompter {
            public String promptPassword(OCVSRoot root, String message) {
                return null;
            }

            public boolean promptSsh2YesNo(String message) {
                return false;
            }

            public String promptSsh2Passphrase(String message) {
                return null;
            }

            public String promptSsh2Password(String message) {
                return null;
            }

            private CancelPrompter() {
            }

            CancelPrompter(1 var2_2) {
                this();
            }

            public final class 1 {
            }
        }
    }

    private static abstract class AsynchronousChangeListImpl
    extends AsynchronousChangeList {
        protected AsynchronousChangeListImpl(Object modeId) {
            super(modeId);
        }

        protected void clearPerformanceCache() {
            CVSUtil.clearPerformanceCaches();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected VCSThreadPool getThreadPool() {
            Class<CVSChangeListWindow> clazz = CVSChangeListWindow.class;
            synchronized (CVSChangeListWindow.class) {
                VCSThreadPool vCSThreadPool = CVSChangeListWindow.ra$_threadPool();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return vCSThreadPool;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WatchersStatusTask
    extends AsynchronousStatusTaskImpl {
        WatchersStatusTask(ChangeList changeList, VCSThreadPool threadPool) {
            super(changeList, threadPool);
        }

        protected boolean isChangeListVisible() {
            return CVSChangeListWindow.getChangeListWindow().isChangeListVisible(CVSChangeListWindow.getChangeListWindow().getWatchersChangeList());
        }

        protected void populateStatusCacheMap(Map<URL, Object> statusCacheMap, Collection<URL> directoriesToQuery) throws Exception {
            for (URL directoryUrl : directoriesToQuery) {
                CVSRunner runner = this.createRunner();
                runner.setCmdArray(new String[]{"watchers"});
                runner.setDirURL(directoryUrl);
                runner.addOutputMonitor(new 1(this, directoryUrl, statusCacheMap));
                runner.exec();
            }
        }

        final class 1
        extends CVSProcessStreamMonitor {
            private URL _currentUrl;
            private final /* synthetic */ URL v$directoryUrl;
            private final /* synthetic */ Map v$statusCacheMap;
            final /* synthetic */ WatchersStatusTask this$0;

            private void $init$() {
                this._currentUrl = null;
            }

            protected void streamLine(String line, CVSProcess process) throws Exception {
                String[] values = DelimitedStrings.getTabSeparatedInstance().parse(line);
                if (values.length < 2) {
                    return;
                }
                if (!values[0].equals("")) {
                    this._currentUrl = URLFileSystem.canonicalize((URL)URLFactory.newURL((URL)this.v$directoryUrl, (String)values[0]));
                }
                if (values[0].equals("") && this._currentUrl == null) {
                    return;
                }
                if (line.indexOf("tedit") >= 0) {
                    this.getCachedStatus().getEditors().add(values[1]);
                } else {
                    this.getCachedStatus().getWatchers().add(values[1]);
                }
            }

            private WatchersStatus getCachedStatus() {
                WatchersStatus status = (WatchersStatus)((Object)this.v$statusCacheMap.get(this._currentUrl));
                if (status == null) {
                    status = WatchersStatus.createWatchersStatus();
                    this.v$statusCacheMap.put(this._currentUrl, status);
                }
                return status;
            }

            public 1(WatchersStatusTask watchersStatusTask, URL uRL, Map map) {
                this.v$statusCacheMap = map;
                this.v$directoryUrl = uRL;
                this.this$0 = watchersStatusTask;
                this.$init$();
            }
        }
    }

    private static class WatchersStatusCache
    extends AsynchronousStatusCache {
        protected final void getImpl(URL[] urls, ChangeListStatus[] statuses) throws Exception {
            int i = 0;
            while (i < statuses.length) {
                statuses[i] = WatchersStatus.NO_WATCHER;
                ++i;
            }
        }

        private WatchersStatusCache() {
        }

        WatchersStatusCache(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }
}

