/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Assert;
import oracle.jdeveloper.vcs.util.VCSFileSystemUtils;
import oracle.jdevimpl.vcs.cvs.CVSClientInfo;
import oracle.jdevimpl.vcs.cvs.util.CVSVersionNumber;

public class CVSClientVerification {
    static final String REQUISITE_VERSION = "1.11";
    private static final String VERSION_NUMBER_DELIMITERS = ".p";
    private static final CVSVersionNumber REQUISITE_VERSION_NUMBER = CVSVersionNumber.createVersionNumber("1.11", ".p");
    private static CVSClientInfo[] _systemPathClientInfo;

    private CVSClientVerification() {
    }

    public static final CVSClientInfo[] searchSystemPath() {
        if (_systemPathClientInfo != null) {
            return _systemPathClientInfo;
        }
        URL[] urls = VCSFileSystemUtils.searchSystemPathFully((String)"cvs");
        ArrayList<CVSClientInfo> systemPathClientInfo = new ArrayList<CVSClientInfo>();
        try {
            int i = 0;
            while (i < urls.length) {
                block7: {
                    CVSClientInfo clientInfo = null;
                    try {
                        clientInfo = CVSClientVerification.verifyExecutableVersion(URLFileSystem.getPlatformPathName((URL)urls[i]));
                    }
                    catch (IOException ioe) {
                        break block7;
                    }
                    if (clientInfo != null) {
                        systemPathClientInfo.add(clientInfo);
                    }
                }
                ++i;
            }
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
        }
        _systemPathClientInfo = systemPathClientInfo.toArray(new CVSClientInfo[0]);
        return _systemPathClientInfo;
    }

    public static final CVSClientInfo verifyExecutableVersion(String path) throws IOException, InterruptedException {
        Matcher matcher;
        String s;
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(path);
        cmd.add("-v");
        Process process = Runtime.getRuntime().exec(cmd.toArray(new String[0]));
        StringBuffer outputBuffer = new StringBuffer();
        CVSClientInfo clientInfo = new CVSClientInfo();
        clientInfo.setPath(path);
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        while ((s = reader.readLine()) != null) {
            outputBuffer.append(s);
            outputBuffer.append('\n');
        }
        String out = outputBuffer.toString();
        String versionExpression = System.getProperty("jdev.cvs.versionexpression");
        Pattern pattern = null;
        try {
            if (versionExpression != null) {
                pattern = Pattern.compile(versionExpression);
            }
        }
        catch (PatternSyntaxException pse) {
            pse.printStackTrace();
        }
        if (pattern == null) {
            pattern = Pattern.compile("Concurrent\\sVersions\\sSystem\\s(\\(CVS\\)\\s(NT\\s)?|\\(CVSNT\\)\\s)([^\\s\\p{Alpha}]+)");
        }
        if (!(matcher = pattern.matcher(out)).find()) {
            process.waitFor();
            if (out.equals("") && process.exitValue() != 0) {
                throw new IOException();
            }
            return null;
        }
        if (matcher.groupCount() >= 1 && matcher.group(1) != null && matcher.group(1).indexOf("CVSNT") >= 0) {
            clientInfo.setCVSNT(true);
        }
        if (matcher.groupCount() >= 2 && matcher.group(2) != null) {
            clientInfo.setCVSNT(true);
        }
        CVSVersionNumber versionNumber = REQUISITE_VERSION_NUMBER;
        try {
            if (matcher.groupCount() >= 3) {
                versionNumber = CVSVersionNumber.createVersionNumber(matcher.group(3), VERSION_NUMBER_DELIMITERS);
            }
        }
        catch (NumberFormatException nfe) {
            Assert.printStackTrace((Throwable)nfe);
        }
        clientInfo.setVersion(versionNumber);
        clientInfo.setSupported(versionNumber.compareTo(REQUISITE_VERSION_NUMBER) >= 0);
        clientInfo.setResponse(out);
        return clientInfo.isSupported() ? clientInfo : null;
    }
}

