/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSlider;
import oracle.ide.Ide;
import oracle.ide.controls.SortedComboBoxModel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.columnlayout.LayoutBuilder;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.vcs.spi.VCSPropertyMap;
import oracle.jdeveloper.vcs.spi.VCSPropertyTraversable;
import oracle.jdevimpl.vcs.cvs.CVSClient;
import oracle.jdevimpl.vcs.cvs.CVSGlobalOptionId;
import oracle.jdevimpl.vcs.cvs.CVSInternalClientSupport;
import oracle.jdevimpl.vcs.cvs.CVSKeywordSubtitutionMode;
import oracle.jdevimpl.vcs.cvs.CVSPropertyKey;
import oracle.jdevimpl.vcs.cvs.resource.CVSArb;

public class CVSCommandOptionsTraversable
extends VCSPropertyTraversable {
    private Component _component;
    private JLabel _globalOptionsLabel;
    private JLabel _onCommitLabel;
    private JCheckBox _runQuietlyCheckBox;
    private JCheckBox _doNotLogCommandsCheckBox;
    private JCheckBox _encryptCheckBox;
    private JCheckBox _setCompressionLevelCheckBox;
    private JSlider _compressionLevelSlider;
    private JLabel _keywordSubstitutionLabel;
    private JComboBox _keywordSubstitutionComboBox;
    private boolean _encryptionWarningFlag;
    private JCheckBox _useCommentTemplatesCheckBox;
    private JCheckBox _renameOnRemoveCheckBox;
    private JCheckBox _autoAddOnCommitCheckBox;
    private JCheckBox _showAdvancedControlsCheckBox;
    private boolean _externalClientSelected;

    public CVSCommandOptionsTraversable() {
        this.setHelpID("f1_cvspreferencescommands_html");
    }

    public static final Map createDefaultProperties() {
        HashMap<String, Boolean> properties = new HashMap<String, Boolean>();
        properties.put("property_use_comment_templates", CVSPropertyKey.DEFAULT_PROPERTY_USE_COMMENT_TEMPLATES);
        properties.put("rename_on_remove", CVSPropertyKey.DEFAULT_PROPERTY_RENAME_ON_REMOVE);
        properties.put("automatically_add_on_commit", CVSPropertyKey.DEFAULT_PROPERTY_AUTO_ADD_ON_COMMIT);
        return properties;
    }

    public void onEntry(TraversableContext dataContext) {
        Boolean externalClient = null;
        VCSPropertyMap propertyMap = (VCSPropertyMap)dataContext.get("cvs_system_properties");
        if (propertyMap != null) {
            externalClient = (Boolean)propertyMap.getMap().get("cvs_external_client");
        }
        if (externalClient == null) {
            externalClient = CVSPropertyKey.DEF_PROPERTY_CVS_EXTERNAL_CLIENT;
        }
        this._externalClientSelected = externalClient;
        super.onEntry(dataContext);
        this.updateSlaveComponentsEnabled();
        this._showAdvancedControlsCheckBox.setSelected(Ide.getDTCache().getBoolean("CVS.AdvancedMode", false));
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        super.onExit(dataContext);
        Ide.getDTCache().putBoolean("CVS.AdvancedMode", this._showAdvancedControlsCheckBox.isSelected());
    }

    protected String getDataKey() {
        return "cvs_command_options";
    }

    protected Component getPropertyPage() {
        if (this._component == null) {
            this._component = this.createComponent();
        }
        return this._component;
    }

    protected void setProperties(Map m) {
        Boolean autoAddOnCommit;
        Boolean renameOnRemove;
        Map globalOptions = (Map)m.get("property_global_options");
        if (globalOptions != null) {
            Integer compressionLevel;
            Boolean setCompressionLevel;
            Boolean encrypt;
            Boolean doNotLogCommands;
            Boolean runQuietly;
            if (this.isGlobalSupported(CVSGlobalOptionId.Q_BE_QUIET) && (runQuietly = (Boolean)globalOptions.get(CVSPropertyKey.KEY_GLOBAL_Q)) != null) {
                this._runQuietlyCheckBox.setSelected(runQuietly);
            }
            if (this.isGlobalSupported(CVSGlobalOptionId.L_NO_HISTORY_LOGGING) && (doNotLogCommands = (Boolean)globalOptions.get(CVSPropertyKey.KEY_GLOBAL_L)) != null) {
                this._doNotLogCommandsCheckBox.setSelected(doNotLogCommands);
            }
            if (this.isGlobalSupported(CVSGlobalOptionId.X_ENCRYPT) && (encrypt = (Boolean)globalOptions.get(CVSPropertyKey.KEY_GLOBAL_X)) != null) {
                this._encryptCheckBox.setSelected(encrypt);
            }
            if (this.isGlobalSupported(CVSGlobalOptionId.Z_GZIP_LEVEL) && (setCompressionLevel = (Boolean)globalOptions.get(CVSPropertyKey.KEY_GLOBAL_Z)) != null) {
                this._setCompressionLevelCheckBox.setSelected(setCompressionLevel);
            }
            if (this.isGlobalSupported(CVSGlobalOptionId.Z_GZIP_LEVEL) && (compressionLevel = (Integer)globalOptions.get(CVSPropertyKey.KEY_GLOBAL_Z_LEVEL)) != null) {
                this._compressionLevelSlider.setValue(compressionLevel);
            }
        }
        String keywordSubstitutionMode = (String)m.get("keyword_substitution_mode");
        CVSKeywordSubtitutionMode keywordSubstitutionValue = null;
        if (keywordSubstitutionMode != null) {
            keywordSubstitutionValue = CVSKeywordSubtitutionMode.valueOf(keywordSubstitutionMode);
        }
        if (keywordSubstitutionValue != null) {
            this._keywordSubstitutionComboBox.setSelectedItem((Object)keywordSubstitutionValue);
        }
        this.updateSlaveComponentsEnabled();
        Boolean useCommentTemplates = (Boolean)m.get("property_use_comment_templates");
        if (useCommentTemplates != null) {
            this._useCommentTemplatesCheckBox.setSelected(useCommentTemplates);
        }
        if ((renameOnRemove = (Boolean)m.get("rename_on_remove")) != null) {
            this._renameOnRemoveCheckBox.setSelected(renameOnRemove);
        }
        if ((autoAddOnCommit = (Boolean)m.get("automatically_add_on_commit")) != null) {
            this._autoAddOnCommitCheckBox.setSelected(autoAddOnCommit);
        }
    }

    protected Map getProperties() {
        HashMap<String, Object> m = new HashMap<String, Object>();
        HashMap<Object, Comparable<Boolean>> globalOptions = new HashMap<Object, Comparable<Boolean>>();
        globalOptions.put(CVSPropertyKey.KEY_GLOBAL_Q, new Boolean(this.isGlobalSupported(CVSGlobalOptionId.Q_BE_QUIET) && this._runQuietlyCheckBox.isSelected()));
        globalOptions.put(CVSPropertyKey.KEY_GLOBAL_L, new Boolean(this.isGlobalSupported(CVSGlobalOptionId.L_NO_HISTORY_LOGGING) && this._doNotLogCommandsCheckBox.isSelected()));
        globalOptions.put(CVSPropertyKey.KEY_GLOBAL_X, new Boolean(this.isGlobalSupported(CVSGlobalOptionId.X_ENCRYPT) && this._encryptCheckBox.isSelected()));
        globalOptions.put(CVSPropertyKey.KEY_GLOBAL_Z, new Boolean(this.isGlobalSupported(CVSGlobalOptionId.Z_SET_GZIP_LEVEL) && this._setCompressionLevelCheckBox.isSelected()));
        globalOptions.put(CVSPropertyKey.KEY_GLOBAL_Z_LEVEL, new Integer(this._compressionLevelSlider.getValue()));
        m.put("property_global_options", globalOptions);
        Object keywordSubstitutionValue = this._keywordSubstitutionComboBox.getSelectedItem();
        if (keywordSubstitutionValue != null) {
            m.put("keyword_substitution_mode", ((CVSKeywordSubtitutionMode)((Object)keywordSubstitutionValue)).name());
        }
        m.put("property_use_comment_templates", new Boolean(this._useCommentTemplatesCheckBox.isSelected()));
        m.put("rename_on_remove", new Boolean(this._renameOnRemoveCheckBox.isSelected()));
        m.put("automatically_add_on_commit", new Boolean(this._autoAddOnCommitCheckBox.isSelected()));
        return m;
    }

    protected void validateProperties() throws TraversalException {
    }

    public static final Map createGlobalOptionsMap(CVSClient client) {
        Map globalOptions = (Map)client.getProperties().get("property_global_options");
        HashMap globalOptionsMap = new HashMap();
        if (globalOptions != null) {
            globalOptionsMap.put(CVSGlobalOptionId.L_NO_HISTORY_LOGGING, globalOptions.get(CVSPropertyKey.KEY_GLOBAL_L));
            globalOptionsMap.put(CVSGlobalOptionId.Q_BE_QUIET, globalOptions.get(CVSPropertyKey.KEY_GLOBAL_Q));
            globalOptionsMap.put(CVSGlobalOptionId.X_ENCRYPT, globalOptions.get(CVSPropertyKey.KEY_GLOBAL_X));
            globalOptionsMap.put(CVSGlobalOptionId.Z_SET_GZIP_LEVEL, globalOptions.get(CVSPropertyKey.KEY_GLOBAL_Z));
            globalOptionsMap.put(CVSGlobalOptionId.Z_GZIP_LEVEL, globalOptions.get(CVSPropertyKey.KEY_GLOBAL_Z_LEVEL));
        }
        globalOptionsMap.put(CVSGlobalOptionId.R_MAKE_NEW_FILES_READ_ONLY, client.isPreferenceReadOnlyModeSet());
        return globalOptionsMap;
    }

    private Component createComponent() {
        boolean sliderMin = true;
        int sliderMax = 9;
        this._globalOptionsLabel = new JLabel();
        this._onCommitLabel = new JLabel();
        this._runQuietlyCheckBox = new JCheckBox();
        this._doNotLogCommandsCheckBox = new JCheckBox();
        this._encryptCheckBox = new JCheckBox();
        this._setCompressionLevelCheckBox = new JCheckBox();
        this._compressionLevelSlider = new JSlider(1, 9, 9);
        this._keywordSubstitutionLabel = new JLabel();
        this._keywordSubstitutionComboBox = new JComboBox();
        this._useCommentTemplatesCheckBox = new JCheckBox();
        this._renameOnRemoveCheckBox = new JCheckBox();
        this._autoAddOnCommitCheckBox = new JCheckBox();
        this._showAdvancedControlsCheckBox = new JCheckBox();
        JPanel panel = new JPanel();
        LayoutBuilder layoutBuilder = new LayoutBuilder();
        Insets i = new Insets(2, 2, 2, 2);
        layoutBuilder.add((Component)this._showAdvancedControlsCheckBox, i, 4, false, true);
        layoutBuilder.nl();
        layoutBuilder.addVGap();
        layoutBuilder.nl();
        layoutBuilder.add((Component)this._globalOptionsLabel, i, 4, false, true);
        layoutBuilder.nl();
        layoutBuilder.addHGap();
        layoutBuilder.add((Component)this._runQuietlyCheckBox, i, 3, false, true);
        layoutBuilder.nl();
        layoutBuilder.addHGap();
        layoutBuilder.add((Component)this._doNotLogCommandsCheckBox, i, 3, false, true);
        layoutBuilder.nl();
        layoutBuilder.addHGap();
        layoutBuilder.add((Component)this._encryptCheckBox, i, 3, false, true);
        layoutBuilder.nl();
        layoutBuilder.addHGap();
        layoutBuilder.add((Component)this._setCompressionLevelCheckBox, i, 3, false, true);
        layoutBuilder.nl();
        layoutBuilder.addHGap();
        layoutBuilder.addHGap();
        layoutBuilder.add((Component)this._compressionLevelSlider, i, 1, false, false);
        layoutBuilder.addHFiller();
        layoutBuilder.nl();
        layoutBuilder.addVGap();
        layoutBuilder.nl();
        layoutBuilder.add((Component)this._keywordSubstitutionLabel, i, 4, false, true);
        layoutBuilder.nl();
        layoutBuilder.addHGap();
        layoutBuilder.add((Component)this._keywordSubstitutionComboBox, i, 2, false, false);
        layoutBuilder.addHFiller();
        layoutBuilder.nl();
        layoutBuilder.addVGap();
        layoutBuilder.nl();
        layoutBuilder.add((Component)this._onCommitLabel, i, 4, false, true);
        layoutBuilder.nl();
        layoutBuilder.addHGap();
        layoutBuilder.add((Component)this._useCommentTemplatesCheckBox, i, 3, false, true);
        layoutBuilder.nl();
        layoutBuilder.addHGap();
        layoutBuilder.add((Component)this._autoAddOnCommitCheckBox, i, 3, false, true);
        layoutBuilder.nl();
        layoutBuilder.addVGap();
        layoutBuilder.nl();
        layoutBuilder.add((Component)this._renameOnRemoveCheckBox, i, 4, false, true);
        layoutBuilder.nl();
        layoutBuilder.addToPanel((Container)panel);
        Hashtable<Integer, JLabel> tableLabels = new Hashtable<Integer, JLabel>(2);
        tableLabels.put(new Integer(1), new JLabel(CVSArb.getString(491)));
        tableLabels.put(new Integer(9), new JLabel(CVSArb.getString(401)));
        this._compressionLevelSlider.setPaintLabels(true);
        this._compressionLevelSlider.setPaintTicks(true);
        this._compressionLevelSlider.setMajorTickSpacing(8);
        this._compressionLevelSlider.setMinorTickSpacing(1);
        this._compressionLevelSlider.setSnapToTicks(true);
        this._compressionLevelSlider.setLabelTable(tableLabels);
        SortedComboBoxModel keywordSubstitutionComboBoxModel = new SortedComboBoxModel();
        keywordSubstitutionComboBoxModel.setComparator((Comparator)new 1());
        keywordSubstitutionComboBoxModel.addElement((Object)CVSKeywordSubtitutionMode.AUTOMATIC);
        keywordSubstitutionComboBoxModel.addElement((Object)CVSKeywordSubtitutionMode.KEYWORD_ONLY);
        keywordSubstitutionComboBoxModel.addElement((Object)CVSKeywordSubtitutionMode.KEYWORD_VALUE);
        keywordSubstitutionComboBoxModel.addElement((Object)CVSKeywordSubtitutionMode.KEYWORD_VALUE_LOCKER);
        keywordSubstitutionComboBoxModel.addElement((Object)CVSKeywordSubtitutionMode.OLD_CONTENTS);
        keywordSubstitutionComboBoxModel.addElement((Object)CVSKeywordSubtitutionMode.VALUE_ONLY);
        this._keywordSubstitutionComboBox.setModel(keywordSubstitutionComboBoxModel);
        this._keywordSubstitutionComboBox.setRenderer(new 2());
        this._keywordSubstitutionComboBox.setSelectedItem((Object)CVSKeywordSubtitutionMode.AUTOMATIC);
        ResourceUtils.resLabel((JLabel)this._globalOptionsLabel, (Component)this._globalOptionsLabel, (String)CVSArb.getString(68));
        ResourceUtils.resLabel((JLabel)this._onCommitLabel, (Component)this._onCommitLabel, (String)CVSArb.getString(283));
        ResourceUtils.resButton((AbstractButton)this._runQuietlyCheckBox, (String)CVSArb.getString(439));
        ResourceUtils.resButton((AbstractButton)this._doNotLogCommandsCheckBox, (String)CVSArb.getString(620));
        ResourceUtils.resButton((AbstractButton)this._encryptCheckBox, (String)CVSArb.getString(742));
        ResourceUtils.resButton((AbstractButton)this._setCompressionLevelCheckBox, (String)CVSArb.getString(451));
        ResourceUtils.resButton((AbstractButton)this._useCommentTemplatesCheckBox, (String)CVSArb.getString(8));
        ResourceUtils.resButton((AbstractButton)this._renameOnRemoveCheckBox, (String)CVSArb.getString(731));
        ResourceUtils.resButton((AbstractButton)this._autoAddOnCommitCheckBox, (String)CVSArb.getString(656));
        ResourceUtils.resButton((AbstractButton)this._showAdvancedControlsCheckBox, (String)CVSArb.getString(1));
        ResourceUtils.resLabel((JLabel)this._keywordSubstitutionLabel, (Component)this._keywordSubstitutionComboBox, (String)CVSArb.getString(13));
        this._encryptCheckBox.addActionListener(new 3());
        this._setCompressionLevelCheckBox.addActionListener(new 4());
        this.updateSlaveComponentsEnabled();
        this._showAdvancedControlsCheckBox.addActionListener(new 5());
        return panel;
    }

    private String convertKeywordSubstitutionToRenderedValue(Object o) {
        if (o == null) {
            return null;
        }
        if (o == CVSKeywordSubtitutionMode.AUTOMATIC) {
            o = CVSArb.getString(420);
        }
        if (o == CVSKeywordSubtitutionMode.KEYWORD_ONLY) {
            o = CVSArb.getString(149);
        }
        if (o == CVSKeywordSubtitutionMode.KEYWORD_VALUE) {
            o = CVSArb.getString(474);
        }
        if (o == CVSKeywordSubtitutionMode.KEYWORD_VALUE_LOCKER) {
            o = CVSArb.getString(728);
        }
        if (o == CVSKeywordSubtitutionMode.OLD_CONTENTS) {
            o = CVSArb.getString(16);
        }
        if (o == CVSKeywordSubtitutionMode.VALUE_ONLY) {
            o = CVSArb.getString(486);
        }
        return o.toString();
    }

    private void updateSlaveComponentsEnabled() {
        this.updateGlobalOptionComponentEnabled(this._runQuietlyCheckBox, CVSGlobalOptionId.Q_BE_QUIET);
        this.updateGlobalOptionComponentEnabled(this._doNotLogCommandsCheckBox, CVSGlobalOptionId.L_NO_HISTORY_LOGGING);
        this.updateGlobalOptionComponentEnabled(this._encryptCheckBox, CVSGlobalOptionId.X_ENCRYPT);
        this.updateGlobalOptionComponentEnabled(this._setCompressionLevelCheckBox, CVSGlobalOptionId.Z_SET_GZIP_LEVEL);
        this._compressionLevelSlider.setEnabled(this._setCompressionLevelCheckBox.isEnabled() && this._setCompressionLevelCheckBox.isSelected());
    }

    private void updateGlobalOptionComponentEnabled(AbstractButton component, CVSGlobalOptionId id) {
        component.setEnabled(this.isGlobalSupported(id));
        if (!component.isEnabled()) {
            component.setSelected(false);
        }
    }

    private boolean isGlobalSupported(CVSGlobalOptionId id) {
        return this._externalClientSelected || CVSInternalClientSupport.isSupportedGlobalOption(id);
    }

    static String mav$convertKeywordSubstitutionToRenderedValue(CVSCommandOptionsTraversable cVSCommandOptionsTraversable, Object object) {
        return cVSCommandOptionsTraversable.convertKeywordSubstitutionToRenderedValue(object);
    }

    static JCheckBox ra$_encryptCheckBox(CVSCommandOptionsTraversable cVSCommandOptionsTraversable) {
        return cVSCommandOptionsTraversable._encryptCheckBox;
    }

    static boolean ra$_encryptionWarningFlag(CVSCommandOptionsTraversable cVSCommandOptionsTraversable) {
        return cVSCommandOptionsTraversable._encryptionWarningFlag;
    }

    static Component ra$_component(CVSCommandOptionsTraversable cVSCommandOptionsTraversable) {
        return cVSCommandOptionsTraversable._component;
    }

    static void wa$_encryptionWarningFlag(CVSCommandOptionsTraversable cVSCommandOptionsTraversable, boolean bl) {
        cVSCommandOptionsTraversable._encryptionWarningFlag = bl;
    }

    static void mav$updateSlaveComponentsEnabled(CVSCommandOptionsTraversable cVSCommandOptionsTraversable) {
        cVSCommandOptionsTraversable.updateSlaveComponentsEnabled();
    }

    static JCheckBox ra$_showAdvancedControlsCheckBox(CVSCommandOptionsTraversable cVSCommandOptionsTraversable) {
        return cVSCommandOptionsTraversable._showAdvancedControlsCheckBox;
    }

    final class 1
    implements Comparator {
        public final int compare(Object o1, Object o2) {
            o1 = CVSCommandOptionsTraversable.mav$convertKeywordSubstitutionToRenderedValue(CVSCommandOptionsTraversable.this, o1);
            o2 = CVSCommandOptionsTraversable.mav$convertKeywordSubstitutionToRenderedValue(CVSCommandOptionsTraversable.this, o2);
            return o1.toString().compareTo(o2.toString());
        }
    }

    final class 2
    extends DefaultListCellRenderer {
        public final Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            value = CVSCommandOptionsTraversable.mav$convertKeywordSubstitutionToRenderedValue(CVSCommandOptionsTraversable.this, value);
            return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        }
    }

    final class 3
    implements ActionListener {
        public final void actionPerformed(ActionEvent e) {
            if (!CVSCommandOptionsTraversable.ra$_encryptCheckBox(CVSCommandOptionsTraversable.this).isSelected()) {
                return;
            }
            if (CVSCommandOptionsTraversable.ra$_encryptionWarningFlag(CVSCommandOptionsTraversable.this)) {
                return;
            }
            MessageDialog.information((Component)CVSCommandOptionsTraversable.ra$_component(CVSCommandOptionsTraversable.this), (Object)CVSArb.getString(80), (String)CVSArb.getString(537), null);
            CVSCommandOptionsTraversable.wa$_encryptionWarningFlag(CVSCommandOptionsTraversable.this, true);
        }
    }

    final class 4
    implements ActionListener {
        public final void actionPerformed(ActionEvent e) {
            CVSCommandOptionsTraversable.mav$updateSlaveComponentsEnabled(CVSCommandOptionsTraversable.this);
        }
    }

    final class 5
    implements ActionListener {
        public final void actionPerformed(ActionEvent e) {
            if (CVSCommandOptionsTraversable.ra$_showAdvancedControlsCheckBox(CVSCommandOptionsTraversable.this).isSelected() && !MessageDialog.optionalConfirm((String)"CVS.AdvancedControlsModeConfirm", null, (String)CVSArb.getString(579), (String)CVSArb.getString(371), null)) {
                CVSCommandOptionsTraversable.ra$_showAdvancedControlsCheckBox(CVSCommandOptionsTraversable.this).setSelected(false);
            }
        }
    }
}

