/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs;

import java.awt.Component;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import oracle.ide.Context;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controller.IdeAction;
import oracle.ide.model.Dirtyable;
import oracle.ide.model.Locatable;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.util.Assert;
import oracle.jdeveloper.vcs.properties.PropertiesCommand;
import oracle.jdeveloper.vcs.spi.VCSContextMenuListener;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdeveloper.vcs.util.VCSContextUtils;
import oracle.jdeveloper.vcs.util.VCSMenuUtils;
import oracle.jdevimpl.vcs.cvs.CVSAbstractCommand;
import oracle.jdevimpl.vcs.cvs.CVSClient;
import oracle.jdevimpl.vcs.cvs.CVSCommandConstants;
import oracle.jdevimpl.vcs.cvs.CVSFileStatus;
import oracle.jdevimpl.vcs.cvs.CVSFolderOperationUtil;
import oracle.jdevimpl.vcs.cvs.CVSLoginCache;
import oracle.jdevimpl.vcs.cvs.CVSMergeEditor;
import oracle.jdevimpl.vcs.cvs.CVSRootCache;
import oracle.jdevimpl.vcs.cvs.client.CVSRootString;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionElement;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionListAPI;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionListData;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionNodes;

class CVSContextMenuListener
extends VCSContextMenuListener {
    CVSContextMenuListener() {
        super(CVSClient.getInstance().getId());
    }

    protected Component[] getContextMenuItems(Context context) {
        int singleCmdId;
        if (context.getElement() != null && context.getElement() instanceof CVSConnectionElement) {
            return null;
        }
        ArrayList<JMenuItem> menuItems = new ArrayList<JMenuItem>();
        Command dynamicCommand = this.getDynamicCommand(context);
        CVSConnectionListAPI connectionList = CVSConnectionNodes.getConnectionListAPI();
        ArrayList cmdIds = new ArrayList();
        JMenu contextMenu = null;
        if (((CVSConnectionListData)connectionList).getConnectionCount() > 0) {
            contextMenu = this.createVersioningSubmenu(context, cmdIds);
        }
        if (cmdIds.size() <= 0) {
            contextMenu = null;
        }
        if (cmdIds.size() == 1 && (singleCmdId = ((Integer)cmdIds.iterator().next()).intValue()) != PropertiesCommand.PROPERTIES_CMD_ID) {
            if (dynamicCommand == null || dynamicCommand.getId() == singleCmdId) {
                contextMenu = null;
            }
            if (dynamicCommand == null) {
                dynamicCommand = this.createCommand(IdeAction.find((int)singleCmdId).getCommand(), context);
            }
        }
        if (dynamicCommand != null) {
            menuItems.add(VCSMenuUtils.createMenuItem((int)dynamicCommand.getId(), (float)0.1f));
        }
        if (contextMenu != null) {
            menuItems.add(contextMenu);
        }
        VCSMenuUtils.addCompareSubmenu(menuItems, (Context)context);
        return menuItems.toArray(new Component[0]);
    }

    private Command getDynamicCommand(Context context) {
        boolean dirty;
        CVSConnectionListAPI connectionList;
        if (context.getView() instanceof CVSMergeEditor) {
            return null;
        }
        Command dynamicCommand = this.createCommand("oracle.jdevimpl.vcs.cvs.op.CVSOperationInheritConnection", context);
        if (dynamicCommand != null) {
            return dynamicCommand;
        }
        Workspace workspace = CVSFolderOperationUtil.getContextWorkspace(context);
        Project project = null;
        if (workspace != null) {
            if (this.getStatus((Locatable)workspace) == CVSFileStatus.STATUS_CONFLICTS) {
                return this.createCommand("oracle.jdevimpl.vcs.cvs.op.CVSOperationMerge", context);
            }
            if (this.isWorkspaceEmpty(workspace)) {
                return this.createCommand("oracle.jdevimpl.vcs.cvs.op.CVSOperationCheckout", context);
            }
            URL[] urls = CVSFolderOperationUtil.getWorkspaceFolderURLs(workspace);
            if (this.getRootForURLs(urls) == null) {
                return this.createCommand("oracle.jdevimpl.vcs.cvs.op.CVSOperationImport", context);
            }
        }
        if (workspace == null) {
            project = CVSFolderOperationUtil.getContextProject(context);
        }
        if (project != null) {
            if (this.getStatus((Locatable)project) == CVSFileStatus.STATUS_CONFLICTS) {
                return this.createCommand("oracle.jdevimpl.vcs.cvs.op.CVSOperationMerge", context);
            }
            if (this.isProjectEmpty(project)) {
                return this.createCommand("oracle.jdevimpl.vcs.cvs.op.CVSOperationCheckout", context);
            }
            URL[] urls = CVSFolderOperationUtil.getProjectFolderURLs(project);
            if (this.getRootForURLs(urls) == null) {
                return this.createCommand("oracle.jdevimpl.vcs.cvs.op.CVSOperationImport", context);
            }
        }
        if (((CVSConnectionListData)(connectionList = CVSConnectionNodes.getConnectionListAPI())).getConnectionCount() <= 0) {
            return null;
        }
        if (workspace != null) {
            return this.createCommand("oracle.jdevimpl.vcs.cvs.op.CVSOperationUpdateWorkspace", context);
        }
        if (project != null) {
            return this.createCommand("oracle.jdevimpl.vcs.cvs.op.CVSOperationUpdateProject", context);
        }
        Locatable[] locatables = VCSContextUtils.getContextLocatables((Context)context, (URLFilter)CVSClient.getInstance().getURLFilter());
        if (locatables.length != 1) {
            return null;
        }
        String commandName = null;
        VCSStatus status = this.getStatus(locatables[0]);
        boolean bl = dirty = locatables[0] instanceof Dirtyable && ((Dirtyable)locatables[0]).isDirty();
        if (status == CVSFileStatus.STATUS_SANDBOX || !dirty && status == CVSFileStatus.STATUS_UNMODIFIED_READWRITE) {
            commandName = "oracle.jdevimpl.vcs.cvs.op.CVSOperationUpdate";
        }
        if (status == CVSFileStatus.STATUS_UNADDED) {
            commandName = "oracle.jdevimpl.vcs.cvs.op.CVSOperationAdd";
        }
        if (status == CVSFileStatus.STATUS_CONFLICTS) {
            commandName = "oracle.jdevimpl.vcs.cvs.op.CVSOperationMerge";
        }
        if (status == CVSFileStatus.STATUS_LOCALLY_CHANGED || status == CVSFileStatus.STATUS_REMOVED || status == CVSFileStatus.STATUS_ADDED || dirty && status == CVSFileStatus.STATUS_UNMODIFIED_READWRITE) {
            commandName = "oracle.jdevimpl.vcs.cvs.op.CVSOperationCommit";
        }
        if (status == CVSFileStatus.STATUS_UNMODIFIED_READONLY) {
            commandName = "oracle.jdevimpl.vcs.cvs.op.CVSOperationEdit";
        }
        if (commandName == null) {
            return null;
        }
        return this.createCommand(commandName, context);
    }

    private VCSStatus getStatus(Locatable locatable) {
        try {
            VCSStatus vCSStatus = CVSClient.getInstance().getStatusCache().get(locatable.getURL());
            return vCSStatus;
        }
        catch (Exception e) {
            Assert.printStackTrace((Throwable)e);
            VCSStatus vCSStatus = null;
            return vCSStatus;
        }
    }

    private Command createCommand(String commandName, Context context) {
        CVSAbstractCommand command = (CVSAbstractCommand)CommandProcessor.createCommand((String)commandName, (Context)context);
        return command.isAvailable() ? command : null;
    }

    private boolean isProjectEmpty(Project project) {
        return false;
    }

    private boolean isWorkspaceEmpty(Workspace workspace) {
        return workspace.getListOfChildren().isEmpty();
    }

    private String getRootForURLs(URL[] urls) {
        try {
            int i = 0;
            while (i < urls.length) {
                URL url = URLFileSystem.isDirectoryPath((URL)urls[i]) ? urls[i] : URLFileSystem.getParent((URL)urls[i]);
                CVSRootString root = CVSRootCache.getInstance().getRoot(url);
                if (root != null) {
                    String string = root.toString();
                    return string;
                }
                ++i;
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return null;
    }

    private JMenu createVersioningSubmenu(Context context, Collection cmdIds) {
        JMenu menu = VCSMenuUtils.createVersioningSubmenu();
        float section = 1.0f;
        this.addDynamicMenuItem(menu, CVSCommandConstants.OPERATION_LOGIN_CMD_ID, section, context, cmdIds);
        if (!CVSLoginCache.getInstance().isLoggedIn()) {
            return menu;
        }
        this.addDynamicMenuItem(menu, CVSCommandConstants.OPERATION_UPDATE_PROJECT_CMD_ID, section += 1.0f, context, cmdIds);
        this.addDynamicMenuItem(menu, CVSCommandConstants.OPERATION_UPDATE_WORKSPACE_CMD_ID, section, context, cmdIds);
        this.addDynamicMenuItem(menu, CVSCommandConstants.OPERATION_UPDATE_CMD_ID, section, context, cmdIds);
        this.addDynamicMenuItem(menu, CVSCommandConstants.OPERATION_COMMIT_PROJECT_CMD_ID, section, context, cmdIds);
        this.addDynamicMenuItem(menu, CVSCommandConstants.OPERATION_COMMIT_WORKSPACE_CMD_ID, section, context, cmdIds);
        this.addDynamicMenuItem(menu, CVSCommandConstants.OPERATION_COMMIT_CMD_ID, section, context, cmdIds);
        this.addDynamicMenuItem(menu, CVSCommandConstants.OPERATION_ADD_CMD_ID, section, context, cmdIds);
        this.addDynamicMenuItem(menu, CVSCommandConstants.OPERATION_ADD_BINARY_CMD_ID, section, context, cmdIds);
        this.addDynamicMenuItem(menu, CVSCommandConstants.OPERATION_REMOVE_CMD_ID, section, context, cmdIds);
        this.addDynamicMenuItem(menu, CVSCommandConstants.OPERATION_EDIT_CMD_ID, section, context, cmdIds);
        this.addDynamicMenuItem(menu, CVSCommandConstants.OPERATION_UNEDIT_CMD_ID, section, context, cmdIds);
        this.addDynamicMenuItem(menu, CVSCommandConstants.OPERATION_UNDO_CHANGES_CMD_ID, section, context, cmdIds);
        this.addDynamicMenuItem(menu, CVSCommandConstants.OPERATION_WATCH_CMD_ID, section, context, cmdIds);
        this.addDynamicMenuItem(menu, CVSCommandConstants.OPERATION_CREATE_BRANCH_CMD_ID, section += 1.0f, context, cmdIds);
        this.addDynamicMenuItem(menu, CVSCommandConstants.OPERATION_MERGE_BRANCH_CMD_ID, section, context, cmdIds);
        this.addDynamicMenuItem(menu, CVSCommandConstants.OPERATION_SWITCH_BRANCH_CMD_ID, section, context, cmdIds);
        this.addDynamicMenuItem(menu, CVSCommandConstants.OPERATION_ASSIGN_PROJECT_TAG_CMD_ID, section += 1.0f, context, cmdIds);
        this.addDynamicMenuItem(menu, CVSCommandConstants.OPERATION_ASSIGN_WORKSPACE_TAG_CMD_ID, section, context, cmdIds);
        this.addDynamicMenuItem(menu, CVSCommandConstants.OPERATION_ASSIGN_TAG_CMD_ID, section, context, cmdIds);
        this.addDynamicMenuItem(menu, CVSCommandConstants.OPERATION_LOG_CMD_ID, section += 1.0f, context, cmdIds);
        this.addDynamicMenuItem(menu, PropertiesCommand.PROPERTIES_CMD_ID, section += 1.0f, context, cmdIds);
        return menu;
    }

    private void addDynamicMenuItem(JMenu menu, int cmdId, float section, Context context, Collection cmdIds) {
        if (VCSMenuUtils.addDynamicMenuItem((JMenu)menu, (int)cmdId, (float)section, (Context)context) != null) {
            cmdIds.add(new Integer(cmdId));
        }
    }
}

