/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs;

import oracle.ide.explorer.IconOverlay;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.util.Assert;
import oracle.ide.util.Enum;
import oracle.jdeveloper.vcs.changelist.ChangeListStatus;
import oracle.jdeveloper.vcs.icons.VCSIconArb;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdeveloper.vcs.util.VCSDefaultUtils;
import oracle.jdevimpl.vcs.cvs.resource.CVSArb;

public abstract class CVSFileStatus
implements VCSStatus,
ChangeListStatus {
    public static final CVSFileStatus STATUS_LOCALLY_CHANGED = new LazyStatus(true, 636);
    public static final CVSFileStatus STATUS_REMOVED = new LazyStatus(false, 456);
    public static final CVSFileStatus STATUS_ADDED = new LazyStatus(true, 309);
    public static final CVSFileStatus STATUS_UNMODIFIED_READWRITE = new LazyStatus(true, 628);
    public static final CVSFileStatus STATUS_UNMODIFIED_READONLY = new LazyStatus(true, 242);
    public static final CVSFileStatus STATUS_CONFLICTS = new LazyStatus(true, 268);
    public static final CVSFileStatus STATUS_UNADDED = new LazyStatus(false, 205);
    public static final CVSFileStatus STATUS_SANDBOX = new LazyStatus(true, 194);
    public static final VCSStatus STATUS_NOT_UNDER_CVS = VCSDefaultUtils.createUnrecognizedStatus();
    public static final VCSStatus STATUS_ADMINISTRATIVE = VCSDefaultUtils.createUnrecognizedStatus();

    private CVSFileStatus() {
    }

    public abstract String getLabel();

    static void setScheme(Scheme scheme) {
        if (scheme == Scheme.TORTOISE) {
            ((LazyStatus)STATUS_LOCALLY_CHANGED).initializeIconKey(460);
            ((LazyStatus)STATUS_REMOVED).initializeIconKey(Integer.MIN_VALUE);
            ((LazyStatus)STATUS_ADDED).initializeIconKey(360);
            ((LazyStatus)STATUS_UNMODIFIED_READWRITE).initializeIconKey(168);
            ((LazyStatus)STATUS_UNMODIFIED_READONLY).initializeIconKey(400);
            ((LazyStatus)STATUS_CONFLICTS).initializeIconKey(93);
            ((LazyStatus)STATUS_UNADDED).initializeIconKey(412);
            ((LazyStatus)STATUS_SANDBOX).initializeIconKey(Integer.MIN_VALUE);
            return;
        }
        if (scheme == Scheme.WINDOWS) {
            ((LazyStatus)STATUS_LOCALLY_CHANGED).initializeIconKey(239);
            ((LazyStatus)STATUS_REMOVED).initializeIconKey(483);
            ((LazyStatus)STATUS_ADDED).initializeIconKey(209);
            ((LazyStatus)STATUS_UNMODIFIED_READWRITE).initializeIconKey(228);
            ((LazyStatus)STATUS_UNMODIFIED_READONLY).initializeIconKey(228);
            ((LazyStatus)STATUS_CONFLICTS).initializeIconKey(540);
            ((LazyStatus)STATUS_UNADDED).initializeIconKey(120);
            ((LazyStatus)STATUS_SANDBOX).initializeIconKey(Integer.MIN_VALUE);
            return;
        }
        if (scheme == Scheme.JDEVELOPER) {
            ((LazyStatus)STATUS_LOCALLY_CHANGED).initializeIconKey(VCSIconArb.getInstance(), 6);
            ((LazyStatus)STATUS_REMOVED).initializeIconKey(VCSIconArb.getInstance(), 7);
            ((LazyStatus)STATUS_ADDED).initializeIconKey(VCSIconArb.getInstance(), 9);
            ((LazyStatus)STATUS_UNMODIFIED_READWRITE).initializeIconKey(79);
            ((LazyStatus)STATUS_UNMODIFIED_READONLY).initializeIconKey(VCSIconArb.getInstance(), 3);
            ((LazyStatus)STATUS_CONFLICTS).initializeIconKey(VCSIconArb.getInstance(), 16);
            ((LazyStatus)STATUS_UNADDED).initializeIconKey(VCSIconArb.getInstance(), 5);
            ((LazyStatus)STATUS_SANDBOX).initializeIconKey(392);
            return;
        }
        throw new IllegalArgumentException();
    }

    CVSFileStatus(1 var1_1) {
        this();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Scheme
    extends Enum {
        public static final Scheme JDEVELOPER = new Scheme("JDEVELOPER");
        public static final Scheme TORTOISE = new Scheme("TORTOISE");
        public static final Scheme WINDOWS = new Scheme("WINDOWS");
        private static final Scheme[] PRIVATE_VALUES = new Scheme[]{JDEVELOPER, TORTOISE, WINDOWS};
        private static int _nextOrdinal = 0;

        private Scheme(String name) {
            super(name, _nextOrdinal++);
        }

        public static final Scheme valueOf(String name) {
            return (Scheme)Enum.valueOf((Enum[])PRIVATE_VALUES, (String)name);
        }

        public static final Scheme[] values() {
            return (Scheme[])PRIVATE_VALUES.clone();
        }
    }

    private static class LazyStatus
    extends CVSFileStatus {
        public static final int STATE_UNVERSIONED = 1;
        public static final int STATE_VERSIONED = 2;
        public static final int STATE_OTHER = 3;
        private ArrayResourceBundle _bundle;
        private static final int NULL_ICON_KEY = Integer.MIN_VALUE;
        private final int _state;
        private final int _labelKey;
        private int _iconKey;
        private IconOverlay _overlay;

        private void $init$() {
            this._iconKey = -1;
        }

        public LazyStatus(boolean versioned, int labelKey) {
            super(null);
            this.$init$();
            this._state = versioned ? 2 : 1;
            this._labelKey = labelKey;
        }

        public void initializeIconKey(int iconKey) {
            this._iconKey = iconKey;
            this._overlay = null;
        }

        public void initializeIconKey(ArrayResourceBundle bundle, int iconKey) {
            this.initializeIconKey(iconKey);
            this._bundle = bundle;
        }

        public String getChangeListLabel() {
            return this.getLabel();
        }

        public boolean isChangeListCellHighlighted() {
            return this.equals(STATUS_CONFLICTS);
        }

        public String getLabel() {
            return CVSArb.getString(this._labelKey);
        }

        public boolean isVersioned() {
            return this._state == 2;
        }

        public boolean isCandidate() {
            return this._state == 1;
        }

        public IconOverlay getOverlay() {
            if (this._iconKey == -1) {
                Assert.printStackTrace((Throwable)new IllegalStateException());
                CVSFileStatus.setScheme(Scheme.JDEVELOPER);
            }
            if (this._overlay != null) {
                return this._overlay;
            }
            this._overlay = this._bundle == null ? new IconOverlay(this._iconKey == Integer.MIN_VALUE ? null : CVSArb.getIcon(this._iconKey), null, this.getLabel()) : new IconOverlay(this._iconKey == Integer.MIN_VALUE ? null : this._bundle.getIconImpl(this._iconKey), null, this.getLabel());
            return this._overlay;
        }
    }

    public final class 1 {
    }
}

