/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs;

import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import oracle.ide.config.DocumentExtensions;
import oracle.ide.model.ContentType;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.jdeveloper.vcs.util.VCSProcessUtils;
import oracle.jdeveloper.vcs.util.VCSURLFilters;
import oracle.jdevimpl.vcs.cvs.CVSClient;
import oracle.jdevimpl.vcs.cvs.CVSInternalClientSupport;
import oracle.jdevimpl.vcs.cvs.CVSUtil;
import oracle.jdevimpl.vcs.cvs.runner.CVSProcess;
import oracle.jdevimpl.vcs.cvs.runner.CVSProcessStreamMonitor;
import oracle.jdevimpl.vcs.cvs.runner.CVSRunner;
import oracle.jdevimpl.vcs.cvs.runner.CVSRunnerFactory;

public class CVSFileSystemAPI {
    private CVSFileSystemAPI() {
    }

    public static final boolean executeRemoveDirectory(URL dirUrl) throws Exception {
        try {
            boolean bl = CVSFileSystemAPI.executeRemoveImpl(dirUrl, null);
            return bl;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            CVSFileSystemAPI.directoryFileStateChanged(dirUrl);
        }
    }

    public static final boolean executeRemoveRegularFile(URL regularFileUrl) throws Exception {
        File regularFile = new File(URLFileSystem.getPlatformPathName((URL)regularFileUrl));
        if (regularFile.exists() && !regularFile.delete()) {
            return false;
        }
        try {
            boolean bl = CVSFileSystemAPI.executeRemoveImpl(URLFileSystem.getParent((URL)regularFileUrl), URLFileSystem.getFileName((URL)regularFileUrl));
            return bl;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            CVSFileSystemAPI.regularFileStateChanged(regularFileUrl);
            EventQueue.invokeLater(new 1());
        }
    }

    public static final boolean executeRemoveImpl(URL dirUrl, String fileName) throws Exception {
        CVSRunner runner = CVSRunnerFactory.getInstance().createRunner();
        runner.setDirURL(dirUrl);
        runner.setCommand("remove");
        runner.getParameters().setFile(fileName);
        runner.getParameters().setQuiet(false);
        runner.exec();
        return runner.getExitCode() != null && runner.getExitCode() == 0;
    }

    public static final boolean executeCommitDirectory(URL dirUrl) throws Exception {
        try {
            boolean bl = CVSFileSystemAPI.executeCommitImpl(dirUrl, null);
            return bl;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            CVSFileSystemAPI.directoryFileStateChanged(dirUrl);
        }
    }

    public static final boolean executeCommitRegularFile(URL regularFileUrl) throws Exception {
        try {
            boolean bl = CVSFileSystemAPI.executeCommitImpl(URLFileSystem.getParent((URL)regularFileUrl), URLFileSystem.getFileName((URL)regularFileUrl));
            return bl;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            CVSFileSystemAPI.regularFileStateChanged(regularFileUrl);
        }
    }

    public static final boolean executeCommitImpl(URL dirUrl, String fileName) throws Exception {
        CVSRunner runner = CVSRunnerFactory.getInstance().createRunner();
        runner.setDirURL(dirUrl);
        runner.setCommand("commit");
        runner.getParameters().setOptions(Arrays.asList("-m", "*** empty log message ***"));
        runner.getParameters().setFile(fileName);
        runner.getParameters().setQuiet(false);
        runner.exec();
        return runner.getExitCode() != null && runner.getExitCode() == 0;
    }

    public static final boolean executeReleaseDirectory(URL dirUrl) throws Exception {
        try {
            boolean bl = CVSFileSystemAPI.executeReleaseImpl(dirUrl, ".");
            return bl;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            CVSFileSystemAPI.directoryFileStateChanged(dirUrl);
        }
    }

    public static final boolean executeReleaseImpl(URL dirUrl, String fileName) throws Exception {
        CVSRunner runner = CVSRunnerFactory.getInstance().createRunner();
        runner.setDirURL(dirUrl);
        runner.setCommand("release");
        runner.getParameters().setOptions(Collections.singleton("-d"));
        runner.getParameters().setFile(fileName);
        runner.getParameters().setQuiet(false);
        runner.addOutputMonitor(new 2("Are you sure"));
        runner.exec();
        return runner.getExitCode() != null && runner.getExitCode() == 0;
    }

    public static final boolean executeAddDirectory(URL url) throws Exception {
        try {
            boolean bl = CVSFileSystemAPI.executeAddImpl(URLFileSystem.getParent((URL)url), URLFileSystem.getFileName((URL)url), null);
            return bl;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            CVSFileSystemAPI.directoryFileStateChanged(url);
        }
    }

    public static final boolean executeAddRegularFile(URL url) throws Exception {
        try {
            boolean bl = CVSFileSystemAPI.executeAddImpl(URLFileSystem.getParent((URL)url), URLFileSystem.getFileName((URL)url), DocumentExtensions.findContentTypeFromExtension((String)URLFileSystem.getSuffix((URL)url)));
            return bl;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            CVSFileSystemAPI.regularFileStateChanged(url);
            EventQueue.invokeLater(new 3());
        }
    }

    public static final boolean executeAddImpl(URL dirUrl, String fileName, ContentType contentType) throws Exception {
        CVSRunner runner = CVSRunnerFactory.getInstance().createRunner();
        Collection<Object> options = Collections.EMPTY_SET;
        if (contentType == ContentType.BINARY) {
            options = Arrays.asList("-k", "b");
        }
        if (contentType == ContentType.TEXT) {
            String kOption = CVSUtil.getKeywordSubtitutionOption();
            options = kOption != null ? Collections.singleton("-k" + kOption) : Collections.EMPTY_SET;
        }
        runner.setDirURL(dirUrl);
        runner.setCommand("add");
        runner.getParameters().setOptions(options);
        runner.getParameters().setFile(fileName);
        runner.getParameters().setQuiet(false);
        runner.exec();
        return runner.getExitCode() != null && runner.getExitCode() == 0;
    }

    public static final boolean executeEditRegularFile(URL regularFileUrl) throws Exception {
        try {
            boolean bl = CVSFileSystemAPI.executeEditImpl(URLFileSystem.getParent((URL)regularFileUrl), URLFileSystem.getFileName((URL)regularFileUrl));
            return bl;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            CVSFileSystemAPI.regularFileStateChanged(regularFileUrl);
        }
    }

    public static final boolean executeEditImpl(URL dirUrl, String fileName) throws Exception {
        if (CVSClient.getInstance().isUsingInternalClient() && !CVSInternalClientSupport.isSupportedCommand("edit")) {
            return false;
        }
        CVSRunner runner = CVSRunnerFactory.getInstance().createRunner();
        runner.setDirURL(dirUrl);
        runner.setCommand("edit");
        runner.getParameters().setFile(fileName);
        runner.getParameters().setQuiet(false);
        runner.exec();
        return runner.getExitCode() != null && runner.getExitCode() == 0;
    }

    public static final boolean executeUneditRegularFile(URL regularFileUrl) throws Exception {
        try {
            boolean bl = CVSFileSystemAPI.executeUneditImpl(URLFileSystem.getParent((URL)regularFileUrl), URLFileSystem.getFileName((URL)regularFileUrl));
            return bl;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            CVSFileSystemAPI.regularFileStateChanged(regularFileUrl);
        }
    }

    public static final boolean executeUneditImpl(URL dirUrl, String fileName) throws Exception {
        CVSRunner runner = CVSRunnerFactory.getInstance().createRunner();
        runner.setDirURL(dirUrl);
        runner.setCommand("unedit");
        runner.getParameters().setOptions(Collections.singleton("-l"));
        runner.getParameters().setFile(fileName);
        runner.getParameters().setQuiet(false);
        runner.addOutputMonitor(new 4("revert changes?"));
        runner.exec();
        return runner.getExitCode() != null && runner.getExitCode() == 0;
    }

    private static final void directoryFileStateChanged(URL dirUrl) {
        CVSUtil.clearPerformanceCaches();
        URLFilter filter = VCSURLFilters.createBaseURLContentsFilter((URL[])new URL[]{dirUrl});
        CVSClient.getInstance().getStatusCache().clear(filter);
    }

    private static final void regularFileStateChanged(URL regularFileUrl) {
        CVSUtil.clearPerformanceCaches();
        CVSClient.getInstance().getStatusCache().clear(regularFileUrl);
    }

    private static final void sendProcessInputData(CVSProcess process, String inputData) throws IOException {
        process.waitForRedirectOutput();
        VCSProcessUtils.sendInputData((Process)process.getProcess(), (String)inputData);
        process.log(inputData + '\n');
    }

    static void maS$sendProcessInputData(CVSProcess cVSProcess, String string) {
        CVSFileSystemAPI.sendProcessInputData(cVSProcess, string);
    }

    static final class 1
    implements Runnable {
        public void run() {
            CVSClient.invokePendingChanges();
        }
    }

    static final class 2
    extends CVSProcessStreamMonitor {
        protected final void patternMatched(CVSProcess process) throws IOException {
            CVSFileSystemAPI.maS$sendProcessInputData(process, "y");
        }

        public 2(String string) {
            super(string);
        }
    }

    static final class 3
    implements Runnable {
        public void run() {
            CVSClient.invokePendingChanges();
        }
    }

    static final class 4
    extends CVSProcessStreamMonitor {
        protected final void patternMatched(CVSProcess process) throws Exception {
            CVSFileSystemAPI.maS$sendProcessInputData(process, "y");
        }

        public 4(String string) {
            super(string);
        }
    }
}

