/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import oracle.ide.Ide;
import oracle.ide.net.DefaultURLFilter;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemHelper;
import oracle.ide.net.URLFilter;
import oracle.ide.util.Assert;
import oracle.ide.vcs.VCSManager;
import oracle.jdeveloper.vcs.spi.VCSExtension;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdeveloper.vcs.spi.VCSURLFileSystemHelper;
import oracle.jdeveloper.vcs.util.VCSFileSystemUtils;
import oracle.jdevimpl.vcs.cvs.CVSClient;
import oracle.jdevimpl.vcs.cvs.CVSEntriesCache;
import oracle.jdevimpl.vcs.cvs.CVSFileStatus;
import oracle.jdevimpl.vcs.cvs.CVSFileSystemAPI;
import oracle.jdevimpl.vcs.cvs.CVSInternalClientSupport;
import oracle.jdevimpl.vcs.cvs.CVSUtil;
import oracle.jdevimpl.vcs.cvs.client.CVSEntriesFile;
import oracle.jdevimpl.vcs.cvs.client.CVSEntry;
import oracle.jdevimpl.vcs.cvs.resource.CVSArb;

public class CVSFileURLFileSystemHelper
extends VCSURLFileSystemHelper {
    private static final String CVSADM = "CVS";
    private static final URLFilter _adminFilter = new AdminFilter();
    private static final Collection _arrestedUrls = new ArrayList();

    public CVSFileURLFileSystemHelper(URLFileSystemHelper helper) {
        super(helper, (VCSExtension)CVSClient.getInstance());
    }

    protected void invokeAndPushEventQueue(Runnable r) {
        r.run();
    }

    public URL[] list(URL url) {
        return super.list(url, _adminFilter);
    }

    public URLFileSystem.FileInfo[] ls(URL url) {
        return super.ls(url, _adminFilter);
    }

    protected boolean deleteImpl(URL url) {
        this.debug("deleteImpl( " + url + " )");
        if (!this.isOperableURL(url)) {
            return super.deleteImpl(url);
        }
        return this._delete(url);
    }

    protected boolean renameToImpl(URL oldUrl, URL newUrl) {
        this.debug("renameToImpl( " + oldUrl + "," + newUrl + " )");
        if (!this.isOperableURL(oldUrl)) {
            return super.renameToImpl(oldUrl, newUrl);
        }
        return this._renameTo(oldUrl, newUrl);
    }

    protected boolean setReadWrite(URL url) {
        this.debug("setReadWrite( " + url + " )");
        if (!this.isAutoCheckoutsSet(url)) {
            return super.setReadWrite(url);
        }
        if (CVSClient.getInstance().isUsingInternalClient() && !CVSInternalClientSupport.isSupportedCommand("edit")) {
            return false;
        }
        if (!this.isOperableURL(url)) {
            return super.setReadWrite(url);
        }
        return this._setReadWrite(url);
    }

    private boolean _delete(URL url) {
        this.debug("_delete( " + url + " )");
        if (this.isDirectory(url)) {
            return this._deleteDirectory(url);
        }
        return this._deleteRegularFile(url);
    }

    private boolean _deleteDirectory(URL url) {
        if (this.list(url).length > 0) {
            return false;
        }
        try {
            Iterator itr = CVSEntriesCache.getInstance().getEntries(url).iterator();
            while (itr.hasNext()) {
                if (!((CVSEntry)itr.next()).isRemoved()) continue;
                boolean bl = false;
                return bl;
            }
        }
        catch (IOException ioe) {
            Assert.printStackTrace((Throwable)ioe);
            boolean bl = false;
            return bl;
        }
        if (!this.deleteAdminDirectory(url)) {
            return false;
        }
        return super.deleteImpl(url);
    }

    private boolean _deleteRegularFile(URL url) {
        if (!super.deleteImpl(url)) {
            return false;
        }
        Ide.getStatusBar().setText(CVSArb.format(570, this.getPlatformPathName(url)));
        this.invokeAndPushEventQueue(new 1(this, this, url));
        this.clearStatusBarText();
        return true;
    }

    private boolean _renameTo(URL oldUrl, URL newUrl) {
        this.debug("_renameTo( " + oldUrl + "," + newUrl + " )");
        if (this.isDirectory(oldUrl)) {
            return this._renameToDirectory(oldUrl, newUrl);
        }
        return this._renameToRegularFile(oldUrl, newUrl);
    }

    private boolean _renameToDirectory(URL oldUrl, URL newUrl) {
        return false;
    }

    private boolean _renameToRegularFile(URL oldUrl, URL newUrl) {
        VCSStatus status;
        try {
            status = CVSClient.getInstance().getStatusCache().get(newUrl);
        }
        catch (Exception e) {
            Assert.printStackTrace((Throwable)e);
            boolean bl = false;
            return bl;
        }
        if (status == CVSFileStatus.STATUS_REMOVED) {
            try {
                this.resetEntriesStateFlag(newUrl);
            }
            catch (IOException ioe) {
                Assert.printStackTrace((Throwable)ioe);
                boolean bl = false;
                return bl;
            }
        }
        if (!super.renameToImpl(oldUrl, newUrl)) {
            return false;
        }
        Ide.getStatusBar().setText(CVSArb.format(570, this.getPlatformPathName(oldUrl)));
        this.invokeAndPushEventQueue(new 2(this, this, oldUrl));
        this.clearStatusBarText();
        if (!this.addDirectory(this.getParent(newUrl))) {
            return true;
        }
        Ide.getStatusBar().setText(CVSArb.format(326, this.getPlatformPathName(newUrl)));
        this.invokeAndPushEventQueue(new 3(this, this, newUrl));
        this.clearStatusBarText();
        return true;
    }

    private void resetEntriesStateFlag(URL url) throws IOException {
        this.debug("resetEntriesStateFlag( " + url + " )");
        CVSEntriesFile entriesFile = new CVSEntriesFile(this.getParent(url));
        Collection<CVSEntry> entries = entriesFile.getEntries();
        CVSEntry entry = CVSEntriesFile.findEntry(entries, url);
        if (entry == null) {
            Assert.printStackTrace((Throwable)new IllegalStateException());
            return;
        }
        this.debug("Entry (bef): " + entry.toString());
        entries.remove(entry);
        entry = new CVSEntry(null, entry.isDirectory(), entry.getName(), null, entry.getRevision(), entry.getTimestamp(), entry.getConflictFlag(), entry.getConflict(), entry.getOptions(), entry.getTagFlag(), entry.getTagOrDate());
        entries.add(entry);
        this.debug("Entry (aft): " + entry.toString());
        entriesFile.writeEntries(entries);
        CVSEntriesCache.getInstance().clear();
        CVSClient.getInstance().getStatusCache().clear(url);
    }

    private boolean _setReadWrite(URL url) {
        this.debug("_setReadWrite( " + url + " )");
        if (this.isDirectory(url)) {
            return this._setReadWriteDirectory(url);
        }
        return this._setReadWriteRegularFile(url);
    }

    private boolean _setReadWriteDirectory(URL url) {
        return false;
    }

    private boolean _setReadWriteRegularFile(URL url) {
        super.setReadWrite(url);
        Ide.getStatusBar().setText(CVSArb.format(299, this.getPlatformPathName(url)));
        try {
            if (!CVSClient.getInstance().setReadWrite(url)) {
                boolean bl = false;
                return bl;
            }
        }
        catch (Exception e) {
            Assert.printStackTrace((Throwable)e);
            boolean bl = false;
            return bl;
        }
        this.clearStatusBarText();
        return !this.isReadOnly(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isOperableURL(URL url) {
        Collection collection = _arrestedUrls;
        synchronized (collection) {
            Iterator itr = _arrestedUrls.iterator();
            while (itr.hasNext()) {
                if (!VCSFileSystemUtils.isBaseURLFor((URL)((KeyedURL)itr.next()).getURL(), (URL)url)) continue;
                boolean bl = false;
                return bl;
            }
        }
        if (!CVSUtil.isOpenSessionFile(url)) {
            return false;
        }
        if (!CVSFileURLFileSystemHelper.checkForCVS()) {
            return false;
        }
        return VCSManager.getVCSManager().isVersioned(url);
    }

    private void clearStatusBarText() {
        Ide.getStatusBar().setText("");
    }

    private boolean addDirectory(URL url) {
        if (url == null) {
            return false;
        }
        URL parentSandboxUrl = CVSUtil.locateParentSandbox(url);
        if (parentSandboxUrl == null) {
            return false;
        }
        if (this.equals(url, parentSandboxUrl)) {
            return true;
        }
        if (!this.addDirectory(this.getParent(url))) {
            return false;
        }
        Ide.getStatusBar().setText(CVSArb.format(716, this.getPlatformPathName(url)));
        this.invokeAndPushEventQueue(new 4(this, this, url));
        this.clearStatusBarText();
        return CVSUtil.isUnderCVS(url);
    }

    private boolean deleteAdminDirectory(URL url) {
        URL adminDirUrl = URLFactory.newURL((URL)url, (String)CVSADM);
        URL[] urls = this.list(adminDirUrl);
        int i = 0;
        while (urls != null && i < urls.length) {
            if (!super.deleteImpl(urls[i])) {
                return false;
            }
            ++i;
        }
        return super.deleteImpl(adminDirUrl);
    }

    private void debug(String s) {
        if (Boolean.getBoolean("jdev.cvs.debugfilesystem")) {
            Assert.println((String)s);
        }
    }

    static final boolean checkForCVS() {
        CVSClient client = CVSClient.getInstance();
        client.verifyClientState();
        return client.isClientAvailable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void arrestCommands(Object key, URL url) {
        Collection collection = _arrestedUrls;
        synchronized (collection) {
            _arrestedUrls.add(new KeyedURL(key, url));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void resumeCommands(Object key, URL url) {
        Collection collection = _arrestedUrls;
        synchronized (collection) {
            _arrestedUrls.remove(new KeyedURL(key, url));
        }
    }

    final class 1
    extends ExceptionRunnable {
        private final /* synthetic */ URL v$url;
        final /* synthetic */ CVSFileURLFileSystemHelper this$0;

        protected final void runImpl() throws Exception {
            if (!CVSFileSystemAPI.executeRemoveRegularFile(this.v$url)) {
                return;
            }
        }

        public 1(CVSFileURLFileSystemHelper cVSFileURLFileSystemHelper, CVSFileURLFileSystemHelper cVSFileURLFileSystemHelper2, URL uRL) {
            this.v$url = uRL;
            this.this$0 = cVSFileURLFileSystemHelper;
            super((1)null);
        }
    }

    final class 2
    extends ExceptionRunnable {
        private final /* synthetic */ URL v$oldUrl;
        final /* synthetic */ CVSFileURLFileSystemHelper this$0;

        protected final void runImpl() throws Exception {
            if (!CVSFileSystemAPI.executeRemoveRegularFile(this.v$oldUrl)) {
                return;
            }
        }

        public 2(CVSFileURLFileSystemHelper cVSFileURLFileSystemHelper, CVSFileURLFileSystemHelper cVSFileURLFileSystemHelper2, URL uRL) {
            this.v$oldUrl = uRL;
            this.this$0 = cVSFileURLFileSystemHelper;
            super((2)null);
        }
    }

    final class 3
    extends ExceptionRunnable {
        private final /* synthetic */ URL v$newUrl;
        final /* synthetic */ CVSFileURLFileSystemHelper this$0;

        protected final void runImpl() throws Exception {
            if (!CVSFileSystemAPI.executeAddRegularFile(this.v$newUrl)) {
                return;
            }
        }

        public 3(CVSFileURLFileSystemHelper cVSFileURLFileSystemHelper, CVSFileURLFileSystemHelper cVSFileURLFileSystemHelper2, URL uRL) {
            this.v$newUrl = uRL;
            this.this$0 = cVSFileURLFileSystemHelper;
            super((3)null);
        }
    }

    final class 4
    extends ExceptionRunnable {
        private final /* synthetic */ URL v$url;
        final /* synthetic */ CVSFileURLFileSystemHelper this$0;

        protected final void runImpl() throws Exception {
            if (!CVSFileSystemAPI.executeAddDirectory(this.v$url)) {
                return;
            }
        }

        public 4(CVSFileURLFileSystemHelper cVSFileURLFileSystemHelper, CVSFileURLFileSystemHelper cVSFileURLFileSystemHelper2, URL uRL) {
            this.v$url = uRL;
            this.this$0 = cVSFileURLFileSystemHelper;
            super((4)null);
        }
    }

    private static class KeyedURL {
        private final Object _key;
        private final URL _url;

        KeyedURL(Object key, URL url) {
            this._key = key;
            this._url = url;
        }

        public Object getKey() {
            return this._key;
        }

        public URL getURL() {
            return this._url;
        }

        public boolean equals(Object other) {
            if (!(other instanceof KeyedURL)) {
                return false;
            }
            KeyedURL otherKeyedUrl = (KeyedURL)other;
            return otherKeyedUrl._key.equals(this._key) && otherKeyedUrl._url.equals(this._url);
        }
    }

    private abstract class ExceptionRunnable
    implements Runnable {
        public void run() {
            try {
                this.runImpl();
            }
            catch (Exception e) {
                Assert.printStackTrace((Throwable)e);
            }
        }

        protected abstract void runImpl() throws Exception;

        private ExceptionRunnable() {
        }

        ExceptionRunnable(4 var2_2) {
            this();
        }

        ExceptionRunnable(2 var2_2) {
            this();
        }

        ExceptionRunnable(3 var2_2) {
            this();
        }

        ExceptionRunnable(1 var2_2) {
            this();
        }
    }

    private static class AdminFilter
    extends DefaultURLFilter {
        AdminFilter() {
            super(null);
        }

        public boolean accept(URL url) {
            if (!"file".equals(url.getProtocol())) {
                return true;
            }
            if (!URLFileSystem.isDirectoryPath((URL)url)) {
                return true;
            }
            return !URLFileSystem.getName((URL)url).equals(CVSFileURLFileSystemHelper.CVSADM) || !CVSUtil.isUnderCVS(URLFileSystem.getParent((URL)url));
        }
    }
}

