/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import oracle.ide.Context;
import oracle.ide.model.Locatable;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.vcs.util.VCSContextUtils;
import oracle.jdevimpl.vcs.cvs.CVSClient;

final class CVSFolderOperationUtil {
    private CVSFolderOperationUtil() {
    }

    static final Workspace getContextWorkspace(Context context) {
        return CVSFolderOperationUtil.getContextWorkspace(CVSFolderOperationUtil.getContextLocatables(context));
    }

    static final Workspace getContextWorkspace(Locatable[] locatables) {
        return locatables.length == 1 && locatables[0] instanceof Workspace ? (Workspace)locatables[0] : null;
    }

    static final Project getContextProject(Context context) {
        return CVSFolderOperationUtil.getContextProject(CVSFolderOperationUtil.getContextLocatables(context));
    }

    static final Project getContextProject(Locatable[] locatables) {
        ArrayList<Locatable> projects = new ArrayList<Locatable>();
        int i = 0;
        while (i < locatables.length) {
            if (locatables[i] instanceof Project) {
                projects.add(locatables[i]);
            }
            ++i;
        }
        return projects.size() == 1 ? (Project)projects.iterator().next() : null;
    }

    static final URL[] getWorkspaceFolderURLs(Workspace workspace) {
        return new URL[]{URLFileSystem.getParent((URL)workspace.getURL())};
    }

    static final URL[] getProjectFolderURLs(Project project) {
        return CVSFolderOperationUtil.getCandidateProjectSourcePathURLs(project);
    }

    static final URL[] getProjectSourcePathURLs(Project project) {
        LinkedHashSet<URL> baseDirectoryUrls = new LinkedHashSet<URL>();
        baseDirectoryUrls.add(URLFileSystem.getParent((URL)project.getURL()));
        baseDirectoryUrls.addAll(ProjectContent.getInstance((PropertyStorage)project).getAllContents().getAllRootDirs().asList());
        return baseDirectoryUrls.toArray(new URL[0]);
    }

    private static final Locatable[] getContextLocatables(Context context) {
        return VCSContextUtils.getContextLocatables((Context)context, (URLFilter)CVSClient.getInstance().getURLFilter());
    }

    private static final URL[] getCandidateProjectSourcePathURLs(Project project) {
        if (project == null) {
            return new URL[0];
        }
        LinkedHashSet<URL> urls = new LinkedHashSet<URL>();
        urls.addAll(Arrays.asList(CVSFolderOperationUtil.getProjectSourcePathURLs(project)));
        return urls.toArray(new URL[0]);
    }
}

