/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs;

import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import java.text.Collator;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import oracle.ide.controls.SortedComboBoxModel;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Assert;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.columnlayout.LayoutBuilder;
import oracle.javatools.controls.nicetable.NiceTable;
import oracle.javatools.controls.nicetable.NiceTableModel;
import oracle.jdeveloper.vcs.spi.VCSPropertyTraversable;
import oracle.jdeveloper.vcs.util.VCSOperatingSystem;
import oracle.jdevimpl.vcs.cvs.CVSClient;
import oracle.jdevimpl.vcs.cvs.CVSClientInfo;
import oracle.jdevimpl.vcs.cvs.CVSClientVerification;
import oracle.jdevimpl.vcs.cvs.CVSFileStatus;
import oracle.jdevimpl.vcs.cvs.CVSGlobalOptionId;
import oracle.jdevimpl.vcs.cvs.CVSInternalClientSupport;
import oracle.jdevimpl.vcs.cvs.CVSPropertyKey;
import oracle.jdevimpl.vcs.cvs.control.CVSFilePanel;
import oracle.jdevimpl.vcs.cvs.resource.CVSArb;

public class CVSGeneralTraversable
extends VCSPropertyTraversable {
    private Component _ui;
    private JLabel _clientLabel;
    private JRadioButton _integralClientRadioButton;
    private JRadioButton _externalClientRadioButton;
    private JLabel _pathDirectionsLabel;
    private JRadioButton _nameOnSystemPathRadioButton;
    private JTextField _nameTextField;
    private JRadioButton _environmentPathRadioButton;
    private EnvironmentPathTable _environmentPathTable;
    private JRadioButton _otherPathRadioButton;
    private CVSFilePanel _otherPathFilePanel;
    private JLabel _overlaySchemeLabel;
    private JComboBox _overlaySchemeComboBox;
    private JCheckBox _runInEditModeCheckBox;
    private static Boolean _defaultPropertyExternalClient = null;

    public CVSGeneralTraversable() {
        this.setHelpID("f1_cvspreferencesmain_html");
    }

    public static final Map createDefaultProperties() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (_defaultPropertyExternalClient == null) {
            _defaultPropertyExternalClient = CVSPropertyKey.DEF_PROPERTY_CVS_EXTERNAL_CLIENT;
            if (CVSClient.getInstance().getGeneralPropertyData() == null) {
                CVSClientInfo clientInfo = null;
                try {
                    clientInfo = CVSClientVerification.verifyExecutableVersion("cvs");
                    _defaultPropertyExternalClient = clientInfo != null && (clientInfo.isCVSNT() || !VCSOperatingSystem.isWindows());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (_defaultPropertyExternalClient == Boolean.FALSE) {
                    Assert.printHeader((String)"  CVS: internal client");
                } else {
                    Assert.printHeader((String)("  CVS: " + clientInfo.getVersionInfoString()));
                }
            }
        }
        properties.put("cvs_external_client", _defaultPropertyExternalClient);
        properties.put("cvs_path", "cvs");
        properties.put("overlay_scheme", CVSPropertyKey.DEFAULT_PROPERTY_CVS_OVERLAY_SCHEME);
        properties.put("run_in_edit_mode", CVSPropertyKey.DEFAULT_PROPERTY_RUN_IN_EDIT_MODE);
        return properties;
    }

    public Component getComponent() {
        return this.getPropertyPage();
    }

    protected String getDataKey() {
        return "cvs_system_properties";
    }

    protected Component getPropertyPage() {
        if (this._ui == null) {
            this._ui = this.createComponent();
        }
        return this._ui;
    }

    protected void setProperties(Map properties) {
        String executablePath;
        Boolean externalClient = (Boolean)properties.get("cvs_external_client");
        if (externalClient == null) {
            externalClient = CVSPropertyKey.DEF_PROPERTY_CVS_EXTERNAL_CLIENT;
        }
        if ((executablePath = (String)properties.get("cvs_path")) == null) {
            executablePath = "cvs";
        }
        this._integralClientRadioButton.setSelected(externalClient ^ true);
        this._externalClientRadioButton.setSelected(externalClient);
        this.setExecutablePath(new File(executablePath));
        String overlayScheme = (String)properties.get("overlay_scheme");
        CVSFileStatus.Scheme overlayScheme0 = CVSFileStatus.Scheme.valueOf(overlayScheme != null ? overlayScheme : CVSPropertyKey.DEFAULT_PROPERTY_CVS_OVERLAY_SCHEME);
        this._overlaySchemeComboBox.setSelectedItem((Object)overlayScheme0);
        Boolean runInEditMode = (Boolean)properties.get("run_in_edit_mode");
        this._runInEditModeCheckBox.setSelected(runInEditMode != null && runInEditMode != false);
        this.updateSlaveComponentsEnabled();
    }

    private void setExecutablePath(File executableFile) {
        if (!executableFile.isAbsolute()) {
            this._nameOnSystemPathRadioButton.setSelected(true);
            this._nameTextField.setText(executableFile.getName());
            return;
        }
        if (this._environmentPathTable.containsPath(executableFile.getPath())) {
            this._environmentPathRadioButton.setSelected(true);
            this._environmentPathTable.setSelectedPath(executableFile.getPath());
            return;
        }
        this._otherPathRadioButton.setSelected(true);
        this._otherPathFilePanel.setURL(URLFactory.newFileURL((String)executableFile.getPath()));
    }

    protected Map getProperties() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("cvs_external_client", new Boolean(this._externalClientRadioButton.isSelected()));
        properties.put("cvs_path", this.getExecutablePath());
        CVSFileStatus.Scheme overlayScheme = (CVSFileStatus.Scheme)((Object)this._overlaySchemeComboBox.getSelectedItem());
        String overlayScheme0 = overlayScheme != null ? overlayScheme.name() : CVSPropertyKey.DEFAULT_PROPERTY_CVS_OVERLAY_SCHEME;
        properties.put("overlay_scheme", overlayScheme0);
        properties.put("run_in_edit_mode", this._runInEditModeCheckBox.isSelected());
        return properties;
    }

    private String getExecutablePath() {
        if (this._nameOnSystemPathRadioButton.isSelected()) {
            return this._nameTextField.getText();
        }
        if (this._environmentPathRadioButton.isSelected()) {
            return this._environmentPathTable.getSelectedPath();
        }
        return URLFileSystem.getPlatformPathName((URL)this._otherPathFilePanel.getURL());
    }

    protected void validateProperties() throws TraversalException {
        if (this._integralClientRadioButton.isSelected() && !this.isForkEnabled()) {
            return;
        }
        if (this._nameOnSystemPathRadioButton.isSelected()) {
            String executablePath = this._nameTextField.getText();
            if (executablePath.equals("") || new File(executablePath).getParentFile() != null) {
                throw new TraversalException(CVSArb.getString(422));
            }
            return;
        }
        if (this._environmentPathRadioButton.isSelected()) {
            String executablePath = this._environmentPathTable.getSelectedPath();
            if (executablePath == null || !new File(executablePath).isAbsolute()) {
                throw new TraversalException(CVSArb.getString(436));
            }
            return;
        }
        String executablePath = this._otherPathFilePanel.getPath();
        File executableFile = new File(executablePath);
        if (executablePath.equals("") || !executableFile.isAbsolute() || executableFile.isDirectory()) {
            throw new TraversalException(CVSArb.getString(163));
        }
    }

    private Component createComponent() {
        this._clientLabel = new JLabel();
        this._integralClientRadioButton = new JRadioButton();
        this._externalClientRadioButton = new JRadioButton();
        this._pathDirectionsLabel = new JLabel();
        this._nameOnSystemPathRadioButton = new JRadioButton();
        this._nameTextField = new JTextField();
        this._environmentPathRadioButton = new JRadioButton();
        this._environmentPathTable = new EnvironmentPathTable(null);
        this._otherPathRadioButton = new JRadioButton();
        this._otherPathFilePanel = new CVSFilePanel();
        this._overlaySchemeLabel = new JLabel();
        this._overlaySchemeComboBox = new JComboBox();
        this._runInEditModeCheckBox = new JCheckBox();
        JPanel panel = new JPanel();
        LayoutBuilder layoutBuilder = new LayoutBuilder();
        Insets insets = new Insets(2, 2, 2, 2);
        layoutBuilder.add((Component)this._clientLabel, insets, 5, false, true);
        layoutBuilder.nl();
        layoutBuilder.addHGap();
        layoutBuilder.add((Component)this._integralClientRadioButton, insets, 4, false, true);
        layoutBuilder.nl();
        layoutBuilder.addHGap();
        layoutBuilder.add((Component)this._externalClientRadioButton, insets, 4, false, true);
        layoutBuilder.nl();
        layoutBuilder.addHGap();
        layoutBuilder.addHGap();
        layoutBuilder.add((Component)this._pathDirectionsLabel, insets, 3, false, true);
        layoutBuilder.nl();
        layoutBuilder.addHGap();
        layoutBuilder.addHGap();
        layoutBuilder.add((Component)this._nameOnSystemPathRadioButton, insets, 3, false, true);
        layoutBuilder.nl();
        layoutBuilder.addHGap();
        layoutBuilder.addHGap();
        layoutBuilder.addHGap();
        layoutBuilder.add((Component)this._nameTextField, insets, 1, false, false);
        layoutBuilder.addHFiller();
        layoutBuilder.nl();
        layoutBuilder.addHGap();
        layoutBuilder.addHGap();
        layoutBuilder.add((Component)this._environmentPathRadioButton, insets, 3, false, true);
        layoutBuilder.nl();
        layoutBuilder.addHGap();
        layoutBuilder.addHGap();
        layoutBuilder.addHGap();
        layoutBuilder.add((Component)new JScrollPane((Component)((Object)this._environmentPathTable)), insets, 2, true, true);
        layoutBuilder.nl();
        layoutBuilder.addHGap();
        layoutBuilder.addHGap();
        layoutBuilder.add((Component)this._otherPathRadioButton, insets, 3, false, true);
        layoutBuilder.nl();
        layoutBuilder.addHGap();
        layoutBuilder.addHGap();
        layoutBuilder.addHGap();
        layoutBuilder.add((Component)((Object)this._otherPathFilePanel), insets, 2, false, true);
        layoutBuilder.nl();
        layoutBuilder.addHGap();
        layoutBuilder.add((Component)this._runInEditModeCheckBox, insets, 4, false, true);
        layoutBuilder.nl();
        layoutBuilder.addVGap();
        layoutBuilder.nl();
        layoutBuilder.add((Component)this._overlaySchemeLabel, insets, 5, false, true);
        layoutBuilder.nl();
        Box box = Box.createHorizontalBox();
        box.add(this._overlaySchemeComboBox);
        box.add(Box.createHorizontalGlue());
        layoutBuilder.addHGap();
        layoutBuilder.add((Component)box, insets, 3, false, true);
        layoutBuilder.addHFiller();
        layoutBuilder.nl();
        layoutBuilder.addToPanel((Container)panel);
        ResourceUtils.resLabel((JLabel)this._clientLabel, (Component)this._clientLabel, (String)CVSArb.getString(714));
        ResourceUtils.resButton((AbstractButton)this._integralClientRadioButton, (String)CVSArb.format(393, IdeUtil.getProgramName()));
        ResourceUtils.resButton((AbstractButton)this._externalClientRadioButton, (String)CVSArb.getString(223));
        ResourceUtils.resLabel((JLabel)this._pathDirectionsLabel, (Component)this._pathDirectionsLabel, (String)CVSArb.getString(670));
        ResourceUtils.resButton((AbstractButton)this._nameOnSystemPathRadioButton, (String)CVSArb.getString(541));
        ResourceUtils.resButton((AbstractButton)this._environmentPathRadioButton, (String)CVSArb.getString(264));
        ResourceUtils.resButton((AbstractButton)this._otherPathRadioButton, (String)CVSArb.getString(659));
        ResourceUtils.resLabel((JLabel)this._overlaySchemeLabel, (Component)this._overlaySchemeComboBox, (String)CVSArb.getString(510));
        ResourceUtils.resButton((AbstractButton)this._runInEditModeCheckBox, (String)CVSArb.getString(135));
        this._pathDirectionsLabel.setFont(new Font("Dialog", 0, 11));
        ButtonGroup bg = new ButtonGroup();
        bg.add(this._integralClientRadioButton);
        bg.add(this._externalClientRadioButton);
        bg = new ButtonGroup();
        bg.add(this._nameOnSystemPathRadioButton);
        bg.add(this._environmentPathRadioButton);
        bg.add(this._otherPathRadioButton);
        bg = null;
        this._nameTextField.setColumns(20);
        this._otherPathFilePanel.setDialogType(1);
        this._otherPathFilePanel.setChooseFolders(false);
        this._otherPathFilePanel.setURLFilter(new 1());
        EnvironmentPathTableModel model = new EnvironmentPathTableModel(null);
        model.addColumn(CVSArb.getString(129));
        model.addColumn(CVSArb.getString(43));
        CVSClientInfo[] systemPathClientInfo = CVSClientVerification.searchSystemPath();
        int i = 0;
        while (i < systemPathClientInfo.length) {
            String versionInfoString = systemPathClientInfo[i].getVersionInfoString();
            model.addRow(new Object[]{systemPathClientInfo[i].getPath(), versionInfoString != null ? versionInfoString : "?"});
            ++i;
        }
        this._environmentPathTable.installModel(model);
        2 l = new 2();
        this._integralClientRadioButton.addActionListener(l);
        this._externalClientRadioButton.addActionListener(l);
        this._nameOnSystemPathRadioButton.addActionListener(l);
        this._environmentPathRadioButton.addActionListener(l);
        this._otherPathRadioButton.addActionListener(l);
        this._integralClientRadioButton.setSelected(true);
        this._nameOnSystemPathRadioButton.setSelected(true);
        this._nameTextField.setText(new File("cvs").getName());
        this._otherPathFilePanel.setURL(URLFactory.newFileURL((String)System.getProperty("user.home")));
        SortedComboBoxModel overlaySchemeComboBoxModel = new SortedComboBoxModel();
        CVSFileStatus.Scheme[] overlaySchemes = CVSFileStatus.Scheme.values();
        int i2 = 0;
        while (i2 < overlaySchemes.length) {
            overlaySchemeComboBoxModel.addElement((Object)overlaySchemes[i2]);
            ++i2;
        }
        this._overlaySchemeComboBox.setModel(overlaySchemeComboBoxModel);
        this._overlaySchemeComboBox.setRenderer(new 3());
        this.updateSlaveComponentsEnabled();
        return panel;
    }

    private void updateSlaveComponentsEnabled() {
        boolean externalClient = this._externalClientRadioButton.isSelected() || this.isForkEnabled();
        this._pathDirectionsLabel.setEnabled(externalClient);
        this._nameOnSystemPathRadioButton.setEnabled(externalClient);
        this._nameTextField.setEnabled(externalClient && this._nameOnSystemPathRadioButton.isSelected());
        this._environmentPathRadioButton.setEnabled(externalClient);
        this._environmentPathTable.setEnabled(externalClient && this._environmentPathRadioButton.isSelected());
        this._otherPathRadioButton.setEnabled(externalClient);
        this._otherPathFilePanel.setEnabled(externalClient && this._otherPathRadioButton.isSelected());
        this._runInEditModeCheckBox.setEnabled(externalClient || CVSInternalClientSupport.isSupportedGlobalOption(CVSGlobalOptionId.R_MAKE_NEW_FILES_READ_ONLY));
        if (!this._runInEditModeCheckBox.isEnabled()) {
            this._runInEditModeCheckBox.setSelected(false);
        }
    }

    private boolean isForkEnabled() {
        return Boolean.getBoolean("jdev.cvs.enablefork");
    }

    static void mav$updateSlaveComponentsEnabled(CVSGeneralTraversable cVSGeneralTraversable) {
        cVSGeneralTraversable.updateSlaveComponentsEnabled();
    }

    final class 1
    implements URLFilter {
        private final String WIN32_EXECUTABLE_SUFFIX;

        private void $init$() {
            this.WIN32_EXECUTABLE_SUFFIX = ".exe";
        }

        public final String toString() {
            StringBuffer descriptionBuffer = new StringBuffer(CVSArb.getString(185));
            descriptionBuffer.append(" (*, *");
            descriptionBuffer.append(".exe");
            descriptionBuffer.append(")");
            return descriptionBuffer.toString();
        }

        public final boolean accept(URL url) {
            String suffix = URLFileSystem.getSuffix((URL)url);
            return suffix == null || suffix.equals("") || suffix.equals(".exe");
        }

        public 1() {
            this.$init$();
        }
    }

    final class 2
    implements ActionListener {
        public final void actionPerformed(ActionEvent e) {
            CVSGeneralTraversable.mav$updateSlaveComponentsEnabled(CVSGeneralTraversable.this);
        }
    }

    final class 3
    extends BasicComboBoxRenderer {
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value == CVSFileStatus.Scheme.JDEVELOPER) {
                value = CVSArb.getString(654);
            }
            if (value == CVSFileStatus.Scheme.TORTOISE) {
                value = CVSArb.getString(40);
            }
            if (value == CVSFileStatus.Scheme.WINDOWS) {
                value = CVSArb.getString(126);
            }
            return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        }
    }

    private class EnvironmentPathTable
    extends NiceTable {
        private void $init$() {
            this.setSelectionMode(0);
        }

        public boolean isCellEditable(int row, int column) {
            return false;
        }

        public boolean containsPath(String path) {
            int i = this.rowIndexOfPath(path);
            return i >= 0 && i < this.getRowCount();
        }

        public void setSelectedPath(String path) {
            int i = this.rowIndexOfPath(path);
            if (i < 0 || i >= this.getRowCount()) {
                return;
            }
            this.setSelectedRow(i);
        }

        public String getSelectedPath() {
            int i = this.getSelectedRow();
            if (i < 0 || i >= this.getRowCount()) {
                return null;
            }
            return (String)this.getValueAt(i, 0);
        }

        public void setSelectedRow(int i) {
            if (i < 0 || i >= this.getRowCount()) {
                return;
            }
            this.setRowSelectionInterval(i, i);
            this.scrollToSelection();
        }

        public void installModel(TableModel model) {
            this.setModel(model);
            this.setSorted(true);
            this.getTableHeader().setReorderingAllowed(false);
            int i = 0;
            while (i < this.getColumnCount()) {
                this.getColumnModel().getColumn(i).setHeaderRenderer(this.getTableHeader().getDefaultRenderer());
                ++i;
            }
            this.setAutoResizeMode(0);
            this.autoSizeColumnsToFit();
            ((DefaultTableModel)this.getBaseModel()).fireTableDataChanged();
            this.setSortColumn(0, true);
            if (model.getRowCount() > 0) {
                this.setSelectedRow(0);
            }
        }

        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            this.getTableHeader().validate();
            this.getTableHeader().repaint();
        }

        private int rowIndexOfPath(String path) {
            File searchPathFile = new File(path);
            int i = 0;
            while (i < this.getRowCount()) {
                File currentPathFile = new File((String)this.getValueAt(i, 0));
                if (searchPathFile.equals(currentPathFile)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        private EnvironmentPathTable() {
            this.$init$();
        }

        EnvironmentPathTable(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class EnvironmentPathTableModel
    extends DefaultTableModel
    implements NiceTableModel {
        public int getColumnAlignment(int column) {
            return 2;
        }

        public Comparator getColumnSortComparator(int column) {
            return Collator.getInstance();
        }

        private EnvironmentPathTableModel() {
        }

        EnvironmentPathTableModel(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

