/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import oracle.ide.Ide;
import oracle.ide.config.GlobalIgnoreList;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.PatternFilter;
import oracle.javatools.util.Pair;
import oracle.jdeveloper.vcs.util.VCSFileSystemUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CVSIgnorePatternList {
    public static final String FILENAME = ".cvsignore";
    private final ArrayList<String> _ignoreList;

    private void $init$() {
        this._ignoreList = new ArrayList();
    }

    public CVSIgnorePatternList() {
        this.$init$();
    }

    public CVSIgnorePatternList(String patternListSpec) {
        this.$init$();
        StringTokenizer tokenizer = new StringTokenizer(patternListSpec);
        while (tokenizer.hasMoreTokens()) {
            this._ignoreList.add(tokenizer.nextToken());
        }
    }

    public static final CVSIgnorePatternList load(URL directoryUrl) throws IOException {
        URL cvsignoreUrl = URLFactory.newURL((URL)directoryUrl, (String)FILENAME);
        if (!URLFileSystem.exists((URL)cvsignoreUrl) || URLFileSystem.isDirectory((URL)cvsignoreUrl)) {
            return new CVSIgnorePatternList();
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(URLFileSystem.openInputStream((URL)URLFactory.newURL((URL)directoryUrl, (String)FILENAME))));
        try {
            String line;
            StringBuffer fileBuffer = new StringBuffer();
            while ((line = in.readLine()) != null) {
                fileBuffer.append(line);
                fileBuffer.append('\n');
            }
            CVSIgnorePatternList cVSIgnorePatternList = new CVSIgnorePatternList(fileBuffer.toString());
            return cVSIgnorePatternList;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            in.close();
        }
    }

    public void add(String pattern) {
        this._ignoreList.add(pattern);
    }

    public void addAll(CVSIgnorePatternList otherList) {
        this._ignoreList.addAll(otherList._ignoreList);
    }

    public void remove(String pattern) {
        this._ignoreList.remove(pattern);
    }

    public String[] match(URL url) {
        ArrayList<String> matches = new ArrayList<String>();
        String name = URLFileSystem.getFileName((URL)url);
        for (String ignorePattern : this._ignoreList) {
            if (!name.matches(this.createRegExFromWildcard(ignorePattern))) continue;
            matches.add(ignorePattern);
        }
        return matches.toArray(new String[0]);
    }

    public String[] get() {
        return this._ignoreList.toArray(new String[0]);
    }

    public boolean isIgnored(URL url) {
        String name = URLFileSystem.getFileName((URL)url);
        for (String ignorePattern : this._ignoreList) {
            if (!name.matches(this.createRegExFromWildcard(ignorePattern))) continue;
            return true;
        }
        return false;
    }

    public void save(URL directoryUrl) throws IOException {
        Collections.sort(this._ignoreList, Collator.getInstance());
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter(URLFileSystem.openOutputStream((URL)URLFactory.newURL((URL)directoryUrl, (String)FILENAME))));
        try {
            for (String ignorePattern : this._ignoreList) {
                out.write(ignorePattern);
                out.newLine();
            }
        }
        finally {
            out.close();
        }
    }

    public static final void filterIgnored(Collection<URL> urls) throws IOException {
        Iterator<URL> itr = urls.iterator();
        while (itr.hasNext()) {
            URL url = itr.next();
            if (!GlobalIgnoreList.isGloballyIgnored((URL)url)) continue;
            itr.remove();
        }
        CVSIgnorePatternList userIgnorePatternList = CVSIgnorePatternList.load(URLFactory.newDirURL((String)System.getProperty("user.home")));
        for (Map.Entry entry : VCSFileSystemUtils.organizeURLsByParent((URL[])urls.toArray(new URL[0])).entrySet()) {
            URL directoryUrl = (URL)entry.getKey();
            CVSIgnorePatternList ignorePatternList = CVSIgnorePatternList.load(directoryUrl);
            ignorePatternList.addAll(userIgnorePatternList);
            for (URL url : (Collection)entry.getValue()) {
                if (!ignorePatternList.isIgnored(url)) continue;
                urls.remove(url);
            }
        }
    }

    public static final void removeIgnorePatterns(Collection<URL> urls) throws IOException {
        boolean globalIgnoreListChanged = false;
        for (URL url : urls) {
            PatternFilter filter = GlobalIgnoreList.getPatternFilters().findMatchingFilter(url.getPath());
            if (filter == null || filter.isInclude()) continue;
            GlobalIgnoreList ignoreList = (GlobalIgnoreList)Ide.getSettings().getData("global-ignore-list");
            ArrayList pairList = new ArrayList(ignoreList.getList());
            for (Pair pair : pairList) {
                if (!pair.getFirst().equals(filter.getPattern())) continue;
                globalIgnoreListChanged = globalIgnoreListChanged || (Boolean)pair.getSecond() != false;
                pair.setSecond((Object)Boolean.FALSE);
            }
        }
        URL userHomeUrl = URLFactory.newDirURL((String)System.getProperty("user.home"));
        CVSIgnorePatternList userIgnorePatternList = CVSIgnorePatternList.load(userHomeUrl);
        CVSIgnorePatternList.removeIgnorePatterns(urls, userHomeUrl, userIgnorePatternList);
        for (Map.Entry entry : VCSFileSystemUtils.organizeURLsByParent((URL[])urls.toArray(new URL[0])).entrySet()) {
            URL directoryUrl = (URL)entry.getKey();
            CVSIgnorePatternList ignorePatternList = CVSIgnorePatternList.load(directoryUrl);
            CVSIgnorePatternList.removeIgnorePatterns(urls, directoryUrl, ignorePatternList);
        }
        if (globalIgnoreListChanged) {
            GlobalIgnoreList globalIgnoreList = (GlobalIgnoreList)Ide.getSettings().getData("global-ignore-list");
            globalIgnoreList.setList(globalIgnoreList.getList());
            ((GlobalIgnoreList)Ide.getSettings().getData("global-ignore-list")).fireChangeEvent();
        }
    }

    private static final void removeIgnorePatterns(Collection<URL> urls, URL directoryUrl, CVSIgnorePatternList ignorePatternList) throws IOException {
        boolean changed = false;
        for (URL url : urls) {
            String[] stringArray = ignorePatternList.match(url);
            int n = 0;
            while (n < stringArray.length) {
                String match = stringArray[n];
                ignorePatternList.remove(match);
                changed = true;
                ++n;
            }
        }
        if (changed) {
            ignorePatternList.save(directoryUrl);
        }
    }

    private String createRegExFromWildcard(String wildcard) {
        StringBuffer patternBuffer = new StringBuffer();
        patternBuffer.append("\\Q");
        int i = 0;
        while (i < wildcard.length()) {
            char c = wildcard.charAt(i);
            if (c != '*') {
                patternBuffer.append(c);
            } else {
                patternBuffer.append("\\E");
                patternBuffer.append(".*");
                patternBuffer.append("\\Q");
            }
            ++i;
        }
        patternBuffer.append("\\E");
        return patternBuffer.toString();
    }
}

