/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.Collator;
import java.text.MessageFormat;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Assert;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.columnlayout.LayoutBuilder;
import oracle.javatools.controls.nicetable.NiceTable;
import oracle.javatools.controls.nicetable.NiceTableModel;
import oracle.jdeveloper.vcs.spi.VCSPropertyTraversable;
import oracle.jdevimpl.vcs.cvs.CVSKeywordSubtitutionMode;
import oracle.jdevimpl.vcs.cvs.CVSUtil;
import oracle.jdevimpl.vcs.cvs.resource.CVSArb;

public class CVSLabelDecorationsTraversable
extends VCSPropertyTraversable {
    private static final String VARIABLE_CONTENT = CVSLabelDecorationsTraversable.createSubstitutionString("content");
    private static final String VARIABLE_HOST = CVSLabelDecorationsTraversable.createSubstitutionString("host");
    private static final String VARIABLE_KEYWORD = CVSLabelDecorationsTraversable.createSubstitutionString("keyword");
    private static final String VARIABLE_METHOD = CVSLabelDecorationsTraversable.createSubstitutionString("method");
    private static final String VARIABLE_REPOSITORY = CVSLabelDecorationsTraversable.createSubstitutionString("repository");
    private static final String VARIABLE_REVISION = CVSLabelDecorationsTraversable.createSubstitutionString("revision");
    private static final String VARIABLE_ROOT = CVSLabelDecorationsTraversable.createSubstitutionString("root");
    private static final String VARIABLE_STATUS = CVSLabelDecorationsTraversable.createSubstitutionString("status");
    private static final String VARIABLE_TAG = CVSLabelDecorationsTraversable.createSubstitutionString("tag");
    private static final String VARIABLE_USER = CVSLabelDecorationsTraversable.createSubstitutionString("user");
    private static final String DEFAULT_FILE_FORMAT = VARIABLE_REVISION + ' ' + VARIABLE_TAG + ' ' + VARIABLE_CONTENT;
    private static final String DEFAULT_FOLDER_FORMAT = VARIABLE_TAG;
    private static final String DEFAULT_PROJECT_FORMAT = VARIABLE_TAG + " [" + VARIABLE_HOST + ']';
    private static final String DEFAULT_TOOLTIP_FORMAT = "CVS: " + VARIABLE_REVISION + " - " + VARIABLE_STATUS;
    private static final String EXAMPLE_STATUS = CVSArb.getString(636);
    private static final String[] EXAMPLE_FILE_FORMAT_ARGUMENTS = new String[]{CVSArb.getString(160), "host.acme.com", CVSUtil.prefixKeywordOption(CVSUtil.getKeywordSubtitutionOption(CVSKeywordSubtitutionMode.KEYWORD_VALUE)), "pserver", "Project/src", "1.64", "/cvspublic", EXAMPLE_STATUS, "v2_3", "fred"};
    private static final String[] EXAMPLE_FOLDER_FORMAT_ARGUMENTS = (String[])EXAMPLE_FILE_FORMAT_ARGUMENTS.clone();
    private Component _component;
    private JLabel _fileFormatLabel;
    private JTextField _fileFormatTextField;
    private JButton _fileAddVariableButton;
    private JLabel _fileExampleLabel;
    private JTextField _fileExampleTextField;
    private JLabel _folderFormatLabel;
    private JTextField _folderFormatTextField;
    private JButton _folderAddVariableButton;
    private JLabel _folderExampleLabel;
    private JTextField _folderExampleTextField;
    private JLabel _projectFormatLabel;
    private JTextField _projectFormatTextField;
    private JButton _projectAddVariableButton;
    private JLabel _projectExampleLabel;
    private JTextField _projectExampleTextField;
    private JLabel _tooltipFormatLabel;
    private JTextField _tooltipFormatTextField;
    private JButton _tooltipAddVariableButton;
    private JLabel _tooltipExampleLabel;
    private JTextField _tooltipExampleTextField;
    private JButton _restoreDefaultsButton;
    private JLabel _variablesDirectionsLabel;
    private JLabel _variablesLabel;
    private VariablesTable _variablesTable;
    private JScrollPane _variablesScrollPane;

    private static final String createSubstitutionString(String s) {
        return MessageFormat.format("$'{'{0}'}'", s);
    }

    static {
        CVSLabelDecorationsTraversable.EXAMPLE_FOLDER_FORMAT_ARGUMENTS[0] = null;
        CVSLabelDecorationsTraversable.EXAMPLE_FOLDER_FORMAT_ARGUMENTS[2] = null;
        CVSLabelDecorationsTraversable.EXAMPLE_FOLDER_FORMAT_ARGUMENTS[5] = null;
        CVSLabelDecorationsTraversable.EXAMPLE_FOLDER_FORMAT_ARGUMENTS[7] = null;
    }

    public CVSLabelDecorationsTraversable() {
        this.setHelpID("f1_cvspreferenceslabeldecorations_html");
    }

    public static final Map createDefaultProperties() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("decoration_file_format", DEFAULT_FILE_FORMAT);
        properties.put("decoration_folder_format", DEFAULT_FOLDER_FORMAT);
        properties.put("decoration_project_format", DEFAULT_PROJECT_FORMAT);
        properties.put("decoration_tooltip_format", DEFAULT_TOOLTIP_FORMAT);
        return properties;
    }

    protected String getDataKey() {
        return "cvs_label_decorations";
    }

    protected Component layoutPropertyPage(Component propertyPage) {
        return propertyPage;
    }

    protected Component getPropertyPage() {
        if (this._component == null) {
            this.createComponent();
        }
        return this._component;
    }

    protected void setProperties(Map m) {
        String tooltipFormat;
        String projectFormat;
        String folderFormat;
        String fileFormat = (String)m.get("decoration_file_format");
        if (fileFormat != null) {
            this._fileFormatTextField.setText(fileFormat);
        }
        if ((folderFormat = (String)m.get("decoration_folder_format")) != null) {
            this._folderFormatTextField.setText(folderFormat);
        }
        if ((projectFormat = (String)m.get("decoration_project_format")) != null) {
            this._projectFormatTextField.setText(projectFormat);
        }
        if ((tooltipFormat = (String)m.get("decoration_tooltip_format")) != null) {
            this._tooltipFormatTextField.setText(tooltipFormat);
        }
    }

    protected Map getProperties() {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("decoration_file_format", this._fileFormatTextField.getText());
        m.put("decoration_folder_format", this._folderFormatTextField.getText());
        m.put("decoration_project_format", this._projectFormatTextField.getText());
        m.put("decoration_tooltip_format", this._tooltipFormatTextField.getText());
        return m;
    }

    protected void validateProperties() throws TraversalException {
    }

    private Component createComponent() {
        JPanel panel = new JPanel();
        this._fileFormatLabel = new JLabel();
        this._fileFormatTextField = new JTextField();
        this._fileAddVariableButton = new JButton();
        this._fileExampleLabel = new JLabel();
        this._fileExampleTextField = new JTextField();
        this._folderFormatLabel = new JLabel();
        this._folderFormatTextField = new JTextField();
        this._folderAddVariableButton = new JButton();
        this._folderExampleLabel = new JLabel();
        this._folderExampleTextField = new JTextField();
        this._projectFormatLabel = new JLabel();
        this._projectFormatTextField = new JTextField();
        this._projectAddVariableButton = new JButton();
        this._projectExampleLabel = new JLabel();
        this._projectExampleTextField = new JTextField();
        this._tooltipFormatLabel = new JLabel();
        this._tooltipFormatTextField = new JTextField();
        this._tooltipAddVariableButton = new JButton();
        this._tooltipExampleLabel = new JLabel();
        this._tooltipExampleTextField = new JTextField();
        this._restoreDefaultsButton = new JButton();
        this._variablesDirectionsLabel = new JLabel();
        this._variablesLabel = new JLabel();
        this._variablesTable = new VariablesTable(null);
        this._variablesScrollPane = new JScrollPane((Component)((Object)this._variablesTable));
        ResourceUtils.resLabel((JLabel)this._fileFormatLabel, (Component)this._fileFormatTextField, (String)CVSArb.getString(94));
        ResourceUtils.resButton((AbstractButton)this._fileAddVariableButton, (String)CVSArb.getString(424));
        ResourceUtils.resLabel((JLabel)this._fileExampleLabel, (Component)this._fileExampleTextField, (String)CVSArb.getString(108));
        ResourceUtils.resLabel((JLabel)this._folderFormatLabel, (Component)this._folderFormatTextField, (String)CVSArb.getString(15));
        ResourceUtils.resButton((AbstractButton)this._folderAddVariableButton, (String)CVSArb.getString(424));
        ResourceUtils.resLabel((JLabel)this._folderExampleLabel, (Component)this._folderExampleTextField, (String)CVSArb.getString(108));
        ResourceUtils.resLabel((JLabel)this._projectFormatLabel, (Component)this._projectFormatTextField, (String)CVSArb.getString(187));
        ResourceUtils.resButton((AbstractButton)this._projectAddVariableButton, (String)CVSArb.getString(424));
        ResourceUtils.resLabel((JLabel)this._projectExampleLabel, (Component)this._projectExampleTextField, (String)CVSArb.getString(108));
        ResourceUtils.resLabel((JLabel)this._tooltipFormatLabel, (Component)this._tooltipFormatTextField, (String)CVSArb.getString(7));
        ResourceUtils.resButton((AbstractButton)this._tooltipAddVariableButton, (String)CVSArb.getString(424));
        ResourceUtils.resLabel((JLabel)this._tooltipExampleLabel, (Component)this._tooltipExampleTextField, (String)CVSArb.getString(108));
        ResourceUtils.resButton((AbstractButton)this._restoreDefaultsButton, (String)CVSArb.getString(733));
        ResourceUtils.resLabel((JLabel)this._variablesDirectionsLabel, (Component)this._variablesDirectionsLabel, (String)CVSArb.getString(425));
        ResourceUtils.resLabel((JLabel)this._variablesLabel, (Component)((Object)this._variablesTable), (String)CVSArb.getString(121));
        this._variablesDirectionsLabel.setFont(new Font("Dialog", 0, 11));
        VariablesTableModel model = new VariablesTableModel(null);
        model.addColumn(CVSArb.getString(398));
        model.addColumn(CVSArb.getString(254));
        model.addRow(new Object[]{VARIABLE_CONTENT, CVSArb.getString(396)});
        model.addRow(new Object[]{VARIABLE_HOST, CVSArb.getString(225)});
        model.addRow(new Object[]{VARIABLE_KEYWORD, CVSArb.getString(95)});
        model.addRow(new Object[]{VARIABLE_METHOD, CVSArb.getString(630)});
        model.addRow(new Object[]{VARIABLE_REPOSITORY, CVSArb.getString(469)});
        model.addRow(new Object[]{VARIABLE_REVISION, CVSArb.getString(610)});
        model.addRow(new Object[]{VARIABLE_ROOT, CVSArb.getString(227)});
        model.addRow(new Object[]{VARIABLE_STATUS, CVSArb.getString(624)});
        model.addRow(new Object[]{VARIABLE_TAG, CVSArb.getString(632)});
        model.addRow(new Object[]{VARIABLE_USER, CVSArb.getString(599)});
        this._variablesTable.installModel(model);
        this._fileAddVariableButton.setIcon(CVSArb.getIcon(204));
        this._folderAddVariableButton.setIcon(CVSArb.getIcon(204));
        this._projectAddVariableButton.setIcon(CVSArb.getIcon(204));
        this._tooltipAddVariableButton.setIcon(CVSArb.getIcon(204));
        LayoutBuilder layoutBuilder = new LayoutBuilder();
        Insets insets = new Insets(2, 2, 2, 2);
        layoutBuilder.add((Component)this._fileFormatLabel, insets, 1, false, false);
        layoutBuilder.addHGap();
        layoutBuilder.add((Component)this._fileFormatTextField, insets, 1, false, true);
        layoutBuilder.add((Component)this._fileAddVariableButton, insets, 1, false, false);
        layoutBuilder.nl();
        layoutBuilder.add((Component)this._fileExampleLabel, insets, 1, false, false);
        layoutBuilder.addHGap();
        layoutBuilder.add((Component)this._fileExampleTextField, insets, 1, false, true);
        layoutBuilder.add(Box.createGlue(), insets, 1, false, false);
        layoutBuilder.nl();
        layoutBuilder.add((Component)this._folderFormatLabel, insets, 1, false, false);
        layoutBuilder.addHGap();
        layoutBuilder.add((Component)this._folderFormatTextField, insets, 1, false, true);
        layoutBuilder.add((Component)this._folderAddVariableButton, insets, 1, false, false);
        layoutBuilder.nl();
        layoutBuilder.add((Component)this._folderExampleLabel, insets, 1, false, false);
        layoutBuilder.addHGap();
        layoutBuilder.add((Component)this._folderExampleTextField, insets, 1, false, true);
        layoutBuilder.add(Box.createGlue(), insets, 1, false, false);
        layoutBuilder.nl();
        layoutBuilder.add((Component)this._projectFormatLabel, insets, 1, false, false);
        layoutBuilder.addHGap();
        layoutBuilder.add((Component)this._projectFormatTextField, insets, 1, false, true);
        layoutBuilder.add((Component)this._projectAddVariableButton, insets, 1, false, false);
        layoutBuilder.nl();
        layoutBuilder.add((Component)this._projectExampleLabel, insets, 1, false, false);
        layoutBuilder.addHGap();
        layoutBuilder.add((Component)this._projectExampleTextField, insets, 1, false, true);
        layoutBuilder.add(Box.createGlue(), insets, 1, false, false);
        layoutBuilder.nl();
        layoutBuilder.add((Component)this._tooltipFormatLabel, insets, 1, false, false);
        layoutBuilder.addHGap();
        layoutBuilder.add((Component)this._tooltipFormatTextField, insets, 1, false, true);
        layoutBuilder.add((Component)this._tooltipAddVariableButton, insets, 1, false, false);
        layoutBuilder.nl();
        layoutBuilder.add((Component)this._tooltipExampleLabel, insets, 1, false, false);
        layoutBuilder.addHGap();
        layoutBuilder.add((Component)this._tooltipExampleTextField, insets, 1, false, true);
        layoutBuilder.add(Box.createGlue(), insets, 1, false, false);
        layoutBuilder.nl();
        layoutBuilder.add(Box.createGlue(), insets, 1, false, false);
        layoutBuilder.addHGap();
        layoutBuilder.add(Box.createGlue(), insets, 1, false, true);
        layoutBuilder.add((Component)this._restoreDefaultsButton, insets, 1, false, false);
        layoutBuilder.nl();
        layoutBuilder.add((Component)this._variablesDirectionsLabel, insets, 3, false, true);
        layoutBuilder.nl();
        layoutBuilder.add((Component)this._variablesLabel, insets, 4, false, true);
        layoutBuilder.nl();
        layoutBuilder.add((Component)this._variablesScrollPane, insets, 4, true, true);
        layoutBuilder.nl();
        layoutBuilder.addToPanel((Container)panel);
        this._fileExampleTextField.setEditable(false);
        this._folderExampleTextField.setEditable(false);
        this._projectExampleTextField.setEditable(false);
        this._tooltipExampleTextField.setEditable(false);
        this._variablesTable.setSelectedRow(0);
        this._variablesTable.getSelectionModel().addListSelectionListener(new 1());
        this.updateAddVariableButtonsEnabled();
        this._restoreDefaultsButton.addActionListener(new 2());
        this.restoreDefaults();
        3 formatTextFieldListener = new 3();
        this.updateExampleTextFields();
        this._fileFormatTextField.getDocument().addDocumentListener(formatTextFieldListener);
        this._folderFormatTextField.getDocument().addDocumentListener(formatTextFieldListener);
        this._projectFormatTextField.getDocument().addDocumentListener(formatTextFieldListener);
        this._tooltipFormatTextField.getDocument().addDocumentListener(formatTextFieldListener);
        this._fileAddVariableButton.addActionListener(new AddVariableActionListener(this._fileFormatTextField));
        this._folderAddVariableButton.addActionListener(new AddVariableActionListener(this._folderFormatTextField));
        this._projectAddVariableButton.addActionListener(new AddVariableActionListener(this._projectFormatTextField));
        this._tooltipAddVariableButton.addActionListener(new AddVariableActionListener(this._tooltipFormatTextField));
        Dimension d = this._restoreDefaultsButton.getPreferredSize();
        this._restoreDefaultsButton.setPreferredSize(new Dimension(Math.max(d.width, this._fileAddVariableButton.getPreferredSize().width), d.height));
        this._component = panel;
        return this._component;
    }

    private void updateAddVariableButtonsEnabled() {
        boolean enabled = this._variablesTable.getSelectedVariable() != null;
        this._fileAddVariableButton.setEnabled(enabled);
        this._folderAddVariableButton.setEnabled(enabled);
        this._projectAddVariableButton.setEnabled(enabled);
        this._tooltipAddVariableButton.setEnabled(enabled);
    }

    private void updateExampleTextFields() {
        this._fileExampleTextField.setText(this._createDecorationLabel(this._fileFormatTextField.getText(), EXAMPLE_FILE_FORMAT_ARGUMENTS));
        this._folderExampleTextField.setText(this._createDecorationLabel(this._folderFormatTextField.getText(), EXAMPLE_FOLDER_FORMAT_ARGUMENTS));
        this._projectExampleTextField.setText(this._createDecorationLabel(this._projectFormatTextField.getText(), EXAMPLE_FILE_FORMAT_ARGUMENTS));
        this._tooltipExampleTextField.setText(this._createDecorationLabel(this._tooltipFormatTextField.getText(), EXAMPLE_FILE_FORMAT_ARGUMENTS));
    }

    private String _createDecorationLabel(String format, String[] arguments) {
        return CVSLabelDecorationsTraversable.createDecorationLabel(format, arguments);
    }

    private void restoreDefaults() {
        this._fileFormatTextField.setText(DEFAULT_FILE_FORMAT);
        this._folderFormatTextField.setText(DEFAULT_FOLDER_FORMAT);
        this._projectFormatTextField.setText(DEFAULT_PROJECT_FORMAT);
        this._tooltipFormatTextField.setText(DEFAULT_TOOLTIP_FORMAT);
    }

    public static final String createDecorationLabel(String format, String[] arguments) {
        arguments = (String[])arguments.clone();
        int i = 0;
        while (i < arguments.length) {
            if (arguments[i] == null) {
                arguments[i] = "";
            }
            ++i;
        }
        int i2 = 0;
        format = format.replaceAll(CVSLabelDecorationsTraversable.escapeSubstitutionChars(VARIABLE_CONTENT), arguments[i2++]);
        format = format.replaceAll(CVSLabelDecorationsTraversable.escapeSubstitutionChars(VARIABLE_HOST), arguments[i2++]);
        format = format.replaceAll(CVSLabelDecorationsTraversable.escapeSubstitutionChars(VARIABLE_KEYWORD), arguments[i2++]);
        format = format.replaceAll(CVSLabelDecorationsTraversable.escapeSubstitutionChars(VARIABLE_METHOD), arguments[i2++]);
        format = format.replaceAll(CVSLabelDecorationsTraversable.escapeSubstitutionChars(VARIABLE_REPOSITORY), arguments[i2++]);
        format = format.replaceAll(CVSLabelDecorationsTraversable.escapeSubstitutionChars(VARIABLE_REVISION), arguments[i2++]);
        format = format.replaceAll(CVSLabelDecorationsTraversable.escapeSubstitutionChars(VARIABLE_ROOT), arguments[i2++]);
        format = format.replaceAll(CVSLabelDecorationsTraversable.escapeSubstitutionChars(VARIABLE_STATUS), arguments[i2++]);
        format = format.replaceAll(CVSLabelDecorationsTraversable.escapeSubstitutionChars(VARIABLE_TAG), arguments[i2++]);
        format = format.replaceAll(CVSLabelDecorationsTraversable.escapeSubstitutionChars(VARIABLE_USER), arguments[i2++]);
        format = format.replaceAll("\\s{2,}", " ");
        return format.trim();
    }

    private static final String escapeSubstitutionChars(String s) {
        s = s.replaceAll("\\x7b", "[\\\\x7b]");
        s = s.replaceAll("\\x7d", "[\\\\x7d]");
        s = s.replaceAll("\\x24", "[\\\\x24]");
        return s;
    }

    static VariablesTable ra$_variablesTable(CVSLabelDecorationsTraversable cVSLabelDecorationsTraversable) {
        return cVSLabelDecorationsTraversable._variablesTable;
    }

    static void mav$updateAddVariableButtonsEnabled(CVSLabelDecorationsTraversable cVSLabelDecorationsTraversable) {
        cVSLabelDecorationsTraversable.updateAddVariableButtonsEnabled();
    }

    static void mav$restoreDefaults(CVSLabelDecorationsTraversable cVSLabelDecorationsTraversable) {
        cVSLabelDecorationsTraversable.restoreDefaults();
    }

    static void mav$updateExampleTextFields(CVSLabelDecorationsTraversable cVSLabelDecorationsTraversable) {
        cVSLabelDecorationsTraversable.updateExampleTextFields();
    }

    final class 1
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent e) {
            CVSLabelDecorationsTraversable.mav$updateAddVariableButtonsEnabled(CVSLabelDecorationsTraversable.this);
        }
    }

    final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            CVSLabelDecorationsTraversable.mav$restoreDefaults(CVSLabelDecorationsTraversable.this);
        }
    }

    final class 3
    implements DocumentListener {
        public void changedUpdate(DocumentEvent e) {
            this.documentUpdate(e);
        }

        public void insertUpdate(DocumentEvent e) {
            this.documentUpdate(e);
        }

        public void removeUpdate(DocumentEvent e) {
            this.documentUpdate(e);
        }

        private void documentUpdate(DocumentEvent e) {
            CVSLabelDecorationsTraversable.mav$updateExampleTextFields(CVSLabelDecorationsTraversable.this);
        }
    }

    private class VariablesTable
    extends NiceTable {
        private void $init$() {
            this.setSelectionMode(0);
        }

        public boolean isCellEditable(int row, int column) {
            return false;
        }

        public String getSelectedVariable() {
            int i = this.getSelectedRow();
            if (i < 0 || i >= this.getRowCount()) {
                return null;
            }
            return (String)this.getValueAt(i, 0);
        }

        public void setSelectedRow(int i) {
            if (i < 0 || i >= this.getRowCount()) {
                return;
            }
            this.setRowSelectionInterval(i, i);
            this.scrollToSelection();
        }

        public void installModel(TableModel model) {
            this.setModel(model);
            this.setSorted(true);
            this.getTableHeader().setReorderingAllowed(false);
            int i = 0;
            while (i < this.getColumnCount()) {
                this.getColumnModel().getColumn(i).setHeaderRenderer(this.getTableHeader().getDefaultRenderer());
                ++i;
            }
            this.setAutoResizeMode(0);
            this.autoSizeColumnsToFit();
            ((DefaultTableModel)this.getBaseModel()).fireTableDataChanged();
            this.setSortColumn(0, true);
            if (model.getRowCount() > 0) {
                this.setSelectedRow(0);
            }
        }

        private VariablesTable() {
            this.$init$();
        }

        VariablesTable(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class VariablesTableModel
    extends DefaultTableModel
    implements NiceTableModel {
        public int getColumnAlignment(int column) {
            return 2;
        }

        public Comparator getColumnSortComparator(int column) {
            return Collator.getInstance();
        }

        private VariablesTableModel() {
        }

        VariablesTableModel(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class AddVariableActionListener
    implements ActionListener {
        private final JTextField _formatTextField;

        AddVariableActionListener(JTextField formatTextField) {
            this._formatTextField = formatTextField;
        }

        public void actionPerformed(ActionEvent e) {
            String variable = CVSLabelDecorationsTraversable.ra$_variablesTable(CVSLabelDecorationsTraversable.this).getSelectedVariable();
            if (variable == null) {
                return;
            }
            try {
                Document document = this._formatTextField.getDocument();
                document.insertString(document.getLength(), variable, null);
            }
            catch (BadLocationException ble) {
                Assert.printStackTrace((Throwable)ble);
            }
        }
    }
}

