/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs;

import java.awt.EventQueue;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.cmd.FileOpenHistory;
import oracle.ide.cmd.NewWorkspaceCommand;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.ContentSet;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.model.ProjectMigrator;
import oracle.ide.model.ProjectVersion;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.ide.model.Workspaces;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Assert;
import oracle.ide.util.IdeUtil;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.compiler.BuildSystemConfiguration;
import oracle.jdeveloper.model.ApplicationContent;
import oracle.jdeveloper.model.JavaProject;
import oracle.jdeveloper.model.PathsConfiguration;
import oracle.jdeveloper.vcs.spi.VCSFileEventSender;
import oracle.jdeveloper.vcs.spi.VCSNewProjectPanel;
import oracle.jdevimpl.compiler.CompilerOptionManager;
import oracle.jdevimpl.vcs.cvs.CVSNewFilesWatcher;
import oracle.jdevimpl.vcs.cvs.CVSUtil;
import oracle.jdevimpl.vcs.cvs.control.CVSSimpleChoiceDialog;
import oracle.jdevimpl.vcs.cvs.resource.CVSArb;
import oracle.jdevimpl.vcs.cvs.util.CVSAdminPropertyKey;
import oracle.jdevimpl.vcs.util.FileHandler;

public final class CVSNewFilesHandler
extends FileHandler
implements CVSAdminPropertyKey {
    private CVSNewFilesHandler() {
    }

    public static final void handleNewFiles(Context context, CVSNewFilesWatcher watcher, URL checkoutDirectoryUrl, String moduleName) {
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new 1(context, watcher, checkoutDirectoryUrl, moduleName));
            return;
        }
        try {
            CVSNewFilesHandler._handleNewFiles(context, watcher, checkoutDirectoryUrl, moduleName);
        }
        catch (Exception e) {
            Assert.printStackTrace((Throwable)e);
        }
    }

    private static final void _handleNewFiles(Context context, CVSNewFilesWatcher watcher, URL checkoutDirectoryUrl, String moduleName) throws Exception {
        Assert.precondition((boolean)watcher.isReady());
        VCSFileEventSender.fireFileStructureChanged((URL[])watcher.getNewRegularURLs().toArray(new URL[0]));
        if (watcher.hasNewWorkspaceURLs()) {
            CVSNewFilesHandler.openWorkspaces((Context)context, (Collection)watcher.getNewWorkspaceURLs());
            return;
        }
        if (!watcher.hasNewProjectURLs() && !watcher.hasNewRegularURLs()) {
            return;
        }
        Workspace activeWorkspace = CVSNewFilesHandler.determineActiveWorkspace(context);
        if (activeWorkspace == null) {
            IdeUtil.invokeAfterRepaint((Runnable)new 2(context, checkoutDirectoryUrl, moduleName, watcher));
            return;
        }
        CVSNewFilesHandler.handleNewFiles0(context, watcher, checkoutDirectoryUrl, moduleName, activeWorkspace);
    }

    private static final void handleNewFiles0(Context context, CVSNewFilesWatcher watcher, URL checkoutDirectoryUrl, String moduleName, Workspace activeWorkspace) throws Exception {
        CVSSimpleChoiceDialog choiceDialog;
        if (activeWorkspace == null) {
            Assert.printStackTrace((Throwable)new IllegalStateException());
            return;
        }
        if (watcher.hasNewProjectURLs()) {
            CVSNewFilesHandler.openProjectsInWorkspace(context, activeWorkspace, watcher.getNewProjectURLs());
            return;
        }
        Collection urls = watcher.getNewRegularURLs();
        ArrayList<String> choices = new ArrayList<String>();
        choices.add(CVSArb.getString(317));
        choices.add(CVSArb.getString(526));
        choices.add(CVSArb.getString(327));
        choices.add(CVSArb.getString(356));
        Project activeProject = CVSNewFilesHandler.determineActiveProject((Context)context);
        if (activeProject != null) {
            ContentSet contentSet = ProjectContent.getInstance((PropertyStorage)activeProject).getContentSet(PathsConfiguration.JAVA_CONTENT_SET_KEY);
            Assert.check((contentSet != null ? 1 : 0) != 0);
            URL newProjectDirectoryUrl = CVSNewFilesHandler.getNewProjectDirectory(urls);
            Assert.check((newProjectDirectoryUrl != null ? 1 : 0) != 0);
            if (contentSet.canHaveMember(newProjectDirectoryUrl)) {
                return;
            }
        }
        if (activeProject == null) {
            choices.remove(CVSArb.getString(317));
        }
        if (!(choiceDialog = new CVSSimpleChoiceDialog(CVSArb.getString(52), CVSArb.getString(85), choices.toArray(new String[0]), null)).show()) {
            return;
        }
        if (choices.indexOf(CVSArb.getString(317)) == choiceDialog.getChoice()) {
            URL newProjectDirectoryUrl = CVSNewFilesHandler.getNewProjectDirectory(urls);
            ContentSet contentSet = ProjectContent.getInstance((PropertyStorage)activeProject).getContentSet(PathsConfiguration.JAVA_CONTENT_SET_KEY);
            contentSet.getURLPath().add(newProjectDirectoryUrl);
            UpdateMessage.fireStructureChanged((Subject)activeProject);
        }
        if (choices.indexOf(CVSArb.getString(526)) == choiceDialog.getChoice()) {
            URL newProjectDirectoryUrl = CVSNewFilesHandler.getNewProjectDirectory(urls);
            URL projectUrl = VCSNewProjectPanel.getProjectURL((URL)newProjectDirectoryUrl, (String)CVSNewFilesHandler.convertToFileName((String)moduleName), (String)CVSArb.getString(476), (String)CVSArb.getString(240));
            if (projectUrl == null) {
                return;
            }
            Project defaultProject = Ide.getDefaultProject();
            Project project = defaultProject != null ? (Project)NodeFactory.clone((Node)defaultProject, (URL)projectUrl) : (Project)NodeFactory.findOrCreate(Project.class, (URL)projectUrl);
            project.applyBatchChanges((Runnable)new 3(project, activeWorkspace));
            NodeFactory.recache((URL)projectUrl, (URL)projectUrl, (Node)project);
            activeWorkspace.add((Element)project, true);
            ContentSet contentSet = ProjectContent.getInstance((PropertyStorage)project).getContentSet(PathsConfiguration.JAVA_CONTENT_SET_KEY);
            contentSet.getURLPath().setEntries(new URL[0]);
            contentSet.getURLPath().add(newProjectDirectoryUrl);
            project.save();
            UpdateMessage.fireStructureChanged((Subject)project);
            CVSNewFilesHandler.selectNavigatorTNode((Context)context, (Element)project);
        }
        if (choices.indexOf(CVSArb.getString(327)) == choiceDialog.getChoice()) {
            IdeUtil.invokeAfterRepaint((Runnable)new 4(urls));
        }
    }

    private static final URL createWorkspaceURL(URL checkoutDirectoryUrl, String moduleName) {
        String workspaceName = CVSNewFilesHandler.convertToFileName((String)moduleName);
        URL workspaceUrl = URLFactory.newURL((URL)checkoutDirectoryUrl, (String)(workspaceName + ".jws"));
        int i = 2;
        while (URLFileSystem.exists((URL)workspaceUrl)) {
            workspaceUrl = URLFactory.newURL((URL)checkoutDirectoryUrl, (String)(workspaceName + Integer.toString(i++) + ".jws"));
        }
        return workspaceUrl;
    }

    private static final void openProjectsInWorkspace(Context context, Workspace workspace, Collection projects) throws IllegalAccessException, InstantiationException {
        for (URL url : projects) {
            if (NodeFactory.find((URL)url) != null) {
                new IllegalStateException("CVS: node exists for project " + url).printStackTrace();
            }
            NodeFactory.uncache((URL)url);
            Node node = NodeFactory.findOrCreate((URL)url);
            if (node == null || !(node instanceof Project) || workspace.containsChild((Element)node) || !CVSNewFilesHandler.migrateSystemFile((Node)node)) continue;
            workspace.add((Element)node, true);
            FileOpenHistory.getInstance().updateProjectHistory(node.getURL());
            CVSNewFilesHandler.selectNavigatorTNode((Context)context, (Element)node);
        }
    }

    private static final Workspace determineActiveWorkspace(Context context) {
        Workspace contextWorkspace = context.getWorkspace();
        if (contextWorkspace == null) {
            contextWorkspace = Ide.getActiveWorkspace();
        }
        Workspaces workspaces = Ide.getWorkspaces();
        Iterator itr = workspaces.getChildren();
        while (itr.hasNext()) {
            Object o = itr.next();
            if (!(o instanceof Workspace) || contextWorkspace != null && o != contextWorkspace) continue;
            return (Workspace)o;
        }
        return null;
    }

    protected static final URL getNewProjectDirectory(Collection urls) {
        if (urls.size() <= 0) {
            return null;
        }
        URL url = (URL)urls.iterator().next();
        URL directoryUrl = null;
        while ((url = URLFileSystem.getParent((URL)url)) != null && CVSUtil.isUnderCVS(url)) {
            directoryUrl = url;
        }
        return directoryUrl;
    }

    static URL maS$createWorkspaceURL(URL uRL, String string) {
        return CVSNewFilesHandler.createWorkspaceURL(uRL, string);
    }

    static void maS$handleNewFiles0(Context context, CVSNewFilesWatcher cVSNewFilesWatcher, URL uRL, String string, Workspace workspace) {
        CVSNewFilesHandler.handleNewFiles0(context, cVSNewFilesWatcher, uRL, string, workspace);
    }

    static final class 1
    implements Runnable {
        private final /* synthetic */ Context v$context;
        private final /* synthetic */ CVSNewFilesWatcher v$watcher;
        private final /* synthetic */ URL v$checkoutDirectoryUrl;
        private final /* synthetic */ String v$moduleName;

        public void run() {
            CVSNewFilesHandler.handleNewFiles(this.v$context, this.v$watcher, this.v$checkoutDirectoryUrl, this.v$moduleName);
        }

        public 1(Context context, CVSNewFilesWatcher cVSNewFilesWatcher, URL uRL, String string) {
            this.v$moduleName = string;
            this.v$checkoutDirectoryUrl = uRL;
            this.v$watcher = cVSNewFilesWatcher;
            this.v$context = context;
        }
    }

    static final class 2
    implements Runnable {
        private final /* synthetic */ Context v$context;
        private final /* synthetic */ URL v$checkoutDirectoryUrl;
        private final /* synthetic */ String v$moduleName;
        private final /* synthetic */ CVSNewFilesWatcher v$watcher;

        public void run() {
            try {
                Workspace workspace = NewWorkspaceCommand.createEmptyWorkspace((Context)this.v$context, (URL)CVSNewFilesHandler.maS$createWorkspaceURL(this.v$checkoutDirectoryUrl, this.v$moduleName));
                Ide.getWorkspaces().setWorkDirectory(this.v$checkoutDirectoryUrl);
                CVSNewFilesHandler.maS$handleNewFiles0(this.v$context, this.v$watcher, this.v$checkoutDirectoryUrl, this.v$moduleName, workspace);
            }
            catch (Exception e) {
                Assert.printStackTrace((Throwable)e);
            }
        }

        public 2(Context context, URL uRL, String string, CVSNewFilesWatcher cVSNewFilesWatcher) {
            this.v$watcher = cVSNewFilesWatcher;
            this.v$moduleName = string;
            this.v$checkoutDirectoryUrl = uRL;
            this.v$context = context;
        }
    }

    static final class 3
    implements Runnable {
        private final /* synthetic */ Project v$project;
        private final /* synthetic */ Workspace v$activeWorkspace;

        public void run() {
            CompilerOptionManager optionManager = CompilerOptionManager.getInstance((PropertyStorage)this.v$project);
            optionManager.setToDefaultOptions();
            BuildSystemConfiguration buildConfig = BuildSystemConfiguration.getInstance((PropertyStorage)this.v$project);
            if (buildConfig != null) {
                buildConfig.setCurrentEncoding(IdeUtil.getIdeEncoding());
            }
            ProjectContent.initializeContentSets((Project)this.v$project);
            ProjectVersion.initializeVersions((PropertyStorage)this.v$project, (String)ProjectMigrator.MIGRATOR_NAME);
            ApplicationContent content = ApplicationContent.getInstance((Workspace)this.v$activeWorkspace);
            String pkgName = content.getAppPackagePrefix();
            pkgName = pkgName != null ? pkgName : "";
            this.v$project.getProperties().putString("defaultPackage", pkgName);
            JavaProject.getInstance((Project)this.v$project).setMostRecentPackage(pkgName);
        }

        public 3(Project project, Workspace workspace) {
            this.v$activeWorkspace = workspace;
            this.v$project = project;
        }
    }

    static final class 4
    implements Runnable {
        private final /* synthetic */ Collection v$urls;

        public void run() {
            for (URL url : this.v$urls) {
                String suffix = URLFileSystem.getSuffix((URL)url);
                if (suffix.equals(".jpr") || suffix.equals(".jws")) continue;
                try {
                    EditorManager.getEditorManager().openDefaultEditorInFrame(url);
                }
                catch (Exception e) {
                    Assert.printStackTrace((Throwable)e);
                }
            }
        }

        public 4(Collection collection) {
            this.v$urls = collection;
        }
    }
}

