/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Assert;
import oracle.jdevimpl.vcs.cvs.util.CVSListFilesUtil;

public class CVSNewFilesWatcher {
    private final URL _directoryUrl;
    private Collection _snapshots;
    private Collection _newWorkspaces;
    private Collection _newProjects;
    private Collection _newRegulars;

    public CVSNewFilesWatcher(URL directoryUrl) {
        Assert.precondition((boolean)URLFileSystem.isDirectory((URL)directoryUrl));
        this._directoryUrl = directoryUrl;
        this._snapshots = new ArrayList();
        this._newWorkspaces = new ArrayList();
        this._newProjects = new ArrayList();
        this._newRegulars = new ArrayList();
    }

    public URL getURL() {
        return this._directoryUrl;
    }

    public void takeSnapshotOne() {
        this._snapshots.add(this.createSnapshot(this._directoryUrl));
    }

    public void takeSnapshotTwo() {
        this._snapshots.add(this.createSnapshot(this._directoryUrl));
        if (this._snapshots.size() < 2) {
            throw new IllegalStateException();
        }
        Iterator itr = this._snapshots.iterator();
        this._snapshots = null;
        this.handleSnapshots(itr.next(), itr.next());
    }

    public boolean isReady() {
        return this._snapshots == null;
    }

    public boolean hasNewURLs() {
        return this._newWorkspaces.size() > 0 || this._newProjects.size() > 0 || this._newRegulars.size() > 0;
    }

    public boolean hasNewWorkspaceURLs() {
        return this._newWorkspaces.size() > 0;
    }

    public boolean hasNewProjectURLs() {
        return this._newProjects.size() > 0;
    }

    public boolean hasNewRegularURLs() {
        return this._newRegulars.size() > 0;
    }

    public Collection getNewURLs() {
        ArrayList all = new ArrayList();
        all.addAll(this._newWorkspaces);
        all.addAll(this._newProjects);
        all.addAll(this._newRegulars);
        return all;
    }

    public Collection getNewWorkspaceURLs() {
        return this._newWorkspaces;
    }

    public Collection getNewProjectURLs() {
        return this._newProjects;
    }

    public Collection getNewRegularURLs() {
        return this._newRegulars;
    }

    public String toString() {
        StringBuffer toStringBuffer = new StringBuffer();
        toStringBuffer.append("directory=" + URLFileSystem.getPlatformPathName((URL)this._directoryUrl));
        toStringBuffer.append(',');
        toStringBuffer.append("workspace URLs=" + this._newWorkspaces);
        toStringBuffer.append(',');
        toStringBuffer.append("project URLs=" + this._newProjects);
        toStringBuffer.append(',');
        toStringBuffer.append("regular URLs=" + this._newProjects);
        return toStringBuffer.toString();
    }

    protected Object createSnapshot(URL directoryUrl) {
        return CVSListFilesUtil.listFiles(directoryUrl, 5);
    }

    protected void handleSnapshots(Object snapshotOne, Object snapshotTwo) {
        Collection urls = (Collection)snapshotTwo;
        urls.removeAll((Collection)snapshotOne);
        this.organizeNewURLs(urls);
    }

    protected void organizeNewURLs(Collection urls) {
        Iterator itr = urls.iterator();
        while (itr.hasNext()) {
            this.organizeNewURL((URL)itr.next());
        }
    }

    protected void organizeNewURL(URL url) {
        String name = URLFileSystem.getFileName((URL)url);
        if (name.endsWith(".jpr")) {
            this._newProjects.add(url);
            return;
        }
        if (name.endsWith(".jws")) {
            this._newWorkspaces.add(url);
            return;
        }
        this._newRegulars.add(url);
    }
}

