/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Icon;
import oracle.ide.config.DocumentExtensions;
import oracle.ide.explorer.IconOverlay;
import oracle.ide.model.ContentType;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Assert;
import oracle.jdeveloper.vcs.spi.VCSOverlayItemProducer;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdeveloper.vcs.spi.VCSStatusCache;
import oracle.jdevimpl.vcs.cvs.CVSClient;
import oracle.jdevimpl.vcs.cvs.CVSFileStatus;
import oracle.jdevimpl.vcs.cvs.CVSIgnorePatternList;
import oracle.jdevimpl.vcs.cvs.CVSKeywordSubtitutionMode;
import oracle.jdevimpl.vcs.cvs.CVSLabelDecorationsTraversable;
import oracle.jdevimpl.vcs.cvs.CVSStatusCache;
import oracle.jdevimpl.vcs.cvs.CVSUtil;
import oracle.jdevimpl.vcs.cvs.client.CVSEntry;
import oracle.jdevimpl.vcs.cvs.client.CVSRootString;
import oracle.jdevimpl.vcs.cvs.resource.CVSArb;
import oracle.ocvs.OCVSDirectory;

class CVSOverlayItemProducer
extends VCSOverlayItemProducer {
    private static String LOCAL_HOST;
    private boolean _useIcons;
    private boolean _useLabels;

    private void $init$() {
        this._useIcons = true;
        this._useLabels = true;
    }

    CVSOverlayItemProducer(CVSStatusCache statusCache) {
        super((VCSStatusCache)statusCache);
        this.$init$();
    }

    void setUseIcons(boolean useIcons) {
        this._useIcons = useIcons;
    }

    void setUseLabels(boolean useLabels) {
        this._useLabels = useLabels;
    }

    public URL[] getCompositeElementURLs(URL[] urls) {
        if (!this.containsRegularFiles(urls)) {
            return urls;
        }
        ArrayList<URL> urls0 = new ArrayList<URL>(Arrays.asList(urls));
        Iterator itr = urls0.iterator();
        while (itr.hasNext()) {
            if (!URLFileSystem.isDirectoryPath((URL)((URL)itr.next()))) continue;
            itr.remove();
        }
        return urls;
    }

    private boolean containsRegularFiles(URL[] urls) {
        int i = 0;
        while (i < urls.length) {
            if (!URLFileSystem.isDirectoryPath((URL)urls[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected IconOverlay[] produceOverlays(URL[] urls, VCSStatus[] statuses) throws Exception {
        ArrayList<URL> filteredUrls = new ArrayList<URL>(Arrays.asList(urls));
        CVSIgnorePatternList.filterIgnored(filteredUrls);
        IconOverlay[] iconOverlays = new IconOverlay[urls.length];
        int i = 0;
        while (i < urls.length) {
            iconOverlays[i] = filteredUrls.contains(urls[i]) ? this._produceOverlay(urls[i], statuses[i]) : null;
            ++i;
        }
        return iconOverlays;
    }

    private IconOverlay _produceOverlay(URL url, VCSStatus status) throws Exception {
        String toolTipTextFormat;
        Icon decorationIcon;
        if (status.getOverlay() == null || !this._useIcons && !this._useLabels) {
            return null;
        }
        Icon icon = decorationIcon = this._useIcons ? status.getOverlay().getIcon() : null;
        if (!this._useLabels) {
            return new IconOverlay(decorationIcon, null, null);
        }
        if (!status.isVersioned() && !status.isCandidate()) {
            return new IconOverlay(decorationIcon, null, null);
        }
        Map properies = CVSClient.getInstance().getProperties();
        String shortLabelFormat = null;
        if (shortLabelFormat == null && URLFileSystem.isDirectoryPath((URL)url)) {
            shortLabelFormat = (String)properies.get("decoration_folder_format");
        }
        if (shortLabelFormat == null && URLFileSystem.getSuffix((URL)url).equals(".jpr")) {
            shortLabelFormat = (String)properies.get("decoration_project_format");
        }
        if (shortLabelFormat == null) {
            shortLabelFormat = (String)properies.get("decoration_file_format");
        }
        if ((toolTipTextFormat = null) == null) {
            toolTipTextFormat = (String)properies.get("decoration_tooltip_format");
        }
        if (shortLabelFormat == null && toolTipTextFormat == null) {
            return new IconOverlay(decorationIcon, null, null);
        }
        URL sandboxUrl = CVSUtil.locateParentSandbox(url);
        if (sandboxUrl == null) {
            return new IconOverlay(decorationIcon, null, null);
        }
        CVSRootString rootString = CVSUtil.readAdminRoot(sandboxUrl);
        CVSEntry entry = CVSStatusCache.locateEntry(url);
        String options = entry != null ? entry.getOptions() : null;
        String[] arguments = new String[10];
        int i = 0;
        arguments[i++] = this.constructContentDecoration(url, status, options);
        arguments[i++] = rootString != null ? (rootString.getServerLocation() != null ? rootString.getServerLocation() : CVSOverlayItemProducer.getLocalHost()) : null;
        arguments[i++] = this.constructKeywordDecoration(url, status, options);
        arguments[i++] = rootString != null ? rootString.getAccessMethod() : null;
        arguments[i++] = this.readRepository(url);
        arguments[i++] = entry != null ? entry.getRevision() : null;
        arguments[i++] = rootString != null ? rootString.getRepository() : null;
        arguments[i++] = status instanceof CVSFileStatus ? ((CVSFileStatus)status).getLabel() : null;
        arguments[i++] = URLFileSystem.isDirectoryPath((URL)url) ? this.readDirectoryTag(url) : (entry != null ? entry.getTagOrDate() : null);
        arguments[i++] = rootString != null ? rootString.getUserName() : null;
        String decorationShortLabel = status.getOverlay().getShortLabel();
        if (shortLabelFormat != null) {
            decorationShortLabel = CVSLabelDecorationsTraversable.createDecorationLabel(shortLabelFormat, arguments);
        }
        if (decorationShortLabel != null && decorationShortLabel.length() > 0) {
            decorationShortLabel = ' ' + decorationShortLabel;
        }
        String decorationToolTipText = status.getOverlay().getToolTipText();
        if (toolTipTextFormat != null) {
            decorationToolTipText = CVSLabelDecorationsTraversable.createDecorationLabel(toolTipTextFormat, arguments);
        }
        return new IconOverlay(decorationIcon, decorationShortLabel, decorationToolTipText);
    }

    private String constructContentDecoration(URL url, VCSStatus status, String options) {
        ContentType contentType;
        if (options != null && options.equals(CVSUtil.prefixKeywordOption("b"))) {
            return CVSArb.getString(160);
        }
        if (status.isCandidate() && (contentType = DocumentExtensions.findContentTypeFromExtension((String)URLFileSystem.getSuffix((URL)url))) == ContentType.BINARY) {
            return CVSArb.getString(160);
        }
        return CVSArb.getString(211);
    }

    private String constructKeywordDecoration(URL url, VCSStatus status, String options) {
        if (options != null && options.equals(CVSUtil.prefixKeywordOption("b"))) {
            return null;
        }
        if (status.isCandidate()) {
            ContentType contentType = DocumentExtensions.findContentTypeFromExtension((String)URLFileSystem.getSuffix((URL)url));
            if (contentType == ContentType.BINARY) {
                return null;
            }
            String kOption = CVSUtil.getKeywordSubtitutionOption();
            if (kOption != null) {
                options = CVSUtil.prefixKeywordOption(kOption);
            }
        }
        if (options == null) {
            options = CVSUtil.prefixKeywordOption(CVSUtil.getKeywordSubtitutionOption(CVSKeywordSubtitutionMode.KEYWORD_VALUE));
        }
        return options;
    }

    private String readRepository(URL url) throws IOException {
        return new OCVSDirectory(new File(URLFileSystem.getPlatformPathName((URL)(URLFileSystem.isDirectoryPath((URL)url) ? url : URLFileSystem.getParent((URL)url))))).readRepository();
    }

    private String readDirectoryTag(URL directoryUrl) throws IOException {
        String tagSpec = new OCVSDirectory(new File(URLFileSystem.getPlatformPathName((URL)directoryUrl))).readTagSpec();
        return tagSpec != null && tagSpec.length() > 0 ? tagSpec.substring(1) : null;
    }

    private static final synchronized String getLocalHost() {
        if (LOCAL_HOST != null) {
            return LOCAL_HOST;
        }
        try {
            LOCAL_HOST = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException uhe) {
            Assert.printStackTrace((Throwable)uhe);
            LOCAL_HOST = "localhost";
        }
        return LOCAL_HOST;
    }
}

