/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.io.BufferedReader;
import java.io.StringReader;
import java.net.URL;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import oracle.ide.controls.OverlayIcon;
import oracle.ide.explorer.IconOverlay;
import oracle.ide.model.Displayable;
import oracle.ide.model.Element;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Assert;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.columnlayout.LayoutBuilder;
import oracle.javatools.controls.nicetable.NiceTable;
import oracle.javatools.controls.nicetable.NiceTableModel;
import oracle.jdeveloper.vcs.properties.PropertiesPanel;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdevimpl.vcs.cvs.CVSClient;
import oracle.jdevimpl.vcs.cvs.resource.CVSArb;
import oracle.jdevimpl.vcs.cvs.runner.CVSRunner;
import oracle.jdevimpl.vcs.cvs.runner.CVSRunnerFactory;
import oracle.jdevimpl.vcs.util.AccessibleLabel;

public class CVSPropertiesPanel
extends PropertiesPanel {
    private Element _element;
    private URL _url;
    private Component _component;
    private JLabel _statusLabel;
    private JLabel _workingRevisionLabel;
    private JLabel _repositoryRevisionLabel;
    private JLabel _rcsFileLabel;
    private JLabel _stickyTagLabel;
    private JLabel _stickyDateLabel;
    private JLabel _stickyOptionsLabel;
    private JLabel _existingTagsLabel;
    private JLabel _statusValueLabel;
    private JTextField _workingRevisionTextField;
    private JTextField _repositoryRevisionTextField;
    private JTextField _rcsFileTextField;
    private JTextField _stickyTagTextField;
    private JTextField _stickyDateTextField;
    private JTextField _stickyOptionsTextField;
    private ExistingTagsTable _existingTagsTable;
    private JScrollPane _existingTagsTableScrollPane;
    private CVSRunner _runner;
    private StatusData _statusData;

    private void $init$() {
        this._runner = CVSRunnerFactory.getInstance().createRunner();
    }

    public CVSPropertiesPanel(Element element, URL url) {
        this.$init$();
        this._element = element;
        this._url = url;
    }

    public Component getComponent() {
        if (this._component != null) {
            return this._component;
        }
        boolean isDirectory = URLFileSystem.isDirectory((URL)this._url);
        this.createComponents(this._url, isDirectory);
        this.resComponents(this._url, isDirectory);
        this.initializeComponents(this._url, isDirectory);
        LayoutBuilder layoutBuilder = this.layoutComponents(this._url, isDirectory);
        JPanel panel = new JPanel();
        layoutBuilder.addToPanel((Container)panel);
        Box box = Box.createVerticalBox();
        box.add(panel);
        box.add(Box.createHorizontalStrut(350));
        this._component = box;
        this.populatePropertyComponents(this._url);
        return this._component;
    }

    public void stopWorkerThreads() {
        CVSRunner runner = this._runner;
        if (runner == null) {
            return;
        }
        Process process = runner.getRunProcess().getProcess();
        if (process == null) {
            return;
        }
        new 1(this, process).start();
    }

    private void createComponents(URL url, boolean isDirectory) {
        this._statusLabel = new JLabel();
        this._workingRevisionLabel = new JLabel();
        this._repositoryRevisionLabel = new JLabel();
        this._rcsFileLabel = new JLabel();
        this._stickyTagLabel = new JLabel();
        this._stickyDateLabel = new JLabel();
        this._stickyOptionsLabel = new JLabel();
        this._existingTagsLabel = new JLabel();
        this._statusValueLabel = new AccessibleLabel();
        this._workingRevisionTextField = new JTextField();
        this._repositoryRevisionTextField = new JTextField();
        this._rcsFileTextField = new JTextField();
        this._stickyTagTextField = new JTextField();
        this._stickyDateTextField = new JTextField();
        this._stickyOptionsTextField = new JTextField();
        this._existingTagsTable = new ExistingTagsTable(null);
        this._existingTagsTableScrollPane = new JScrollPane((Component)((Object)this._existingTagsTable));
    }

    private void resComponents(URL url, boolean isDirectory) {
        ResourceUtils.resLabel((JLabel)this._statusLabel, (Component)this._statusValueLabel, (String)CVSArb.getString(112));
        ResourceUtils.resLabel((JLabel)this._workingRevisionLabel, (Component)this._workingRevisionTextField, (String)CVSArb.getString(99));
        ResourceUtils.resLabel((JLabel)this._repositoryRevisionLabel, (Component)this._repositoryRevisionTextField, (String)CVSArb.getString(633));
        ResourceUtils.resLabel((JLabel)this._rcsFileLabel, (Component)this._rcsFileTextField, (String)CVSArb.getString(329));
        ResourceUtils.resLabel((JLabel)this._stickyTagLabel, (Component)this._stickyTagTextField, (String)CVSArb.getString(438));
        ResourceUtils.resLabel((JLabel)this._stickyDateLabel, (Component)this._stickyDateTextField, (String)CVSArb.getString(648));
        ResourceUtils.resLabel((JLabel)this._stickyOptionsLabel, (Component)this._stickyOptionsTextField, (String)CVSArb.getString(387));
        ResourceUtils.resLabel((JLabel)this._existingTagsLabel, (Component)((Object)this._existingTagsTable), (String)CVSArb.getString(258));
    }

    private void initializeComponents(URL url, boolean isDirectory) {
        this.initializePropertyComponents(this._workingRevisionLabel, this._workingRevisionTextField);
        this.initializePropertyComponents(this._repositoryRevisionLabel, this._repositoryRevisionTextField);
        this.initializePropertyComponents(this._rcsFileLabel, this._rcsFileTextField);
        this.initializePropertyComponents(this._stickyTagLabel, this._stickyTagTextField);
        this.initializePropertyComponents(this._stickyDateLabel, this._stickyDateTextField);
        this.initializePropertyComponents(this._stickyOptionsLabel, this._stickyOptionsTextField);
        this._existingTagsTableScrollPane.setPreferredSize(new Dimension(this._existingTagsTable.getPreferredSize().width, this.calculateExistingTagsTableHeight(4)));
    }

    private int calculateExistingTagsTableHeight(int rows) {
        ExistingTagsTableModel dummyExistingTagsTableModel = new ExistingTagsTableModel(null);
        dummyExistingTagsTableModel.addColumn(CVSArb.getString(147));
        ExistingTagsTable dummyExistingTagsTable = new ExistingTagsTable(null);
        dummyExistingTagsTable.installModel(dummyExistingTagsTableModel);
        int height = 0;
        height += dummyExistingTagsTable.getTableHeader().getPreferredSize().height;
        height += this._existingTagsTable.getRowHeight() * rows;
        height += this._existingTagsTable.getIntercellSpacing().height * 2 * rows;
        height += this._existingTagsTable.getInsets().top;
        height += this._existingTagsTable.getInsets().bottom;
        height += this._existingTagsTableScrollPane.getInsets().top;
        return height += this._existingTagsTableScrollPane.getInsets().bottom;
    }

    private LayoutBuilder layoutComponents(URL url, boolean isDirectory) {
        LayoutBuilder layoutBuilder = new LayoutBuilder();
        Insets i = new Insets(2, 2, 2, 2);
        layoutBuilder.add((Component)this._statusLabel, i, 1, false, false);
        layoutBuilder.addHGap();
        layoutBuilder.add((Component)this._statusValueLabel, i, 1, false, true);
        layoutBuilder.nl();
        layoutBuilder.addVGap(8);
        layoutBuilder.nl();
        layoutBuilder.add((Component)this._workingRevisionLabel, i, 1, false, false);
        layoutBuilder.addHGap();
        layoutBuilder.add((Component)this._workingRevisionTextField, i, 1, false, true);
        layoutBuilder.nl();
        layoutBuilder.addVGap(8);
        layoutBuilder.nl();
        layoutBuilder.add((Component)this._repositoryRevisionLabel, i, 1, false, false);
        layoutBuilder.addHGap();
        layoutBuilder.add((Component)this._repositoryRevisionTextField, i, 1, false, true);
        layoutBuilder.nl();
        layoutBuilder.addVGap(8);
        layoutBuilder.nl();
        layoutBuilder.add((Component)this._rcsFileLabel, i, 1, false, false);
        layoutBuilder.addHGap();
        layoutBuilder.add((Component)this._rcsFileTextField, i, 1, false, true);
        layoutBuilder.nl();
        layoutBuilder.addVGap(8);
        layoutBuilder.nl();
        layoutBuilder.add((Component)this._stickyTagLabel, i, 1, false, false);
        layoutBuilder.addHGap();
        layoutBuilder.add((Component)this._stickyTagTextField, i, 1, false, true);
        layoutBuilder.nl();
        layoutBuilder.addVGap(8);
        layoutBuilder.nl();
        layoutBuilder.add((Component)this._stickyDateLabel, i, 1, false, false);
        layoutBuilder.addHGap();
        layoutBuilder.add((Component)this._stickyDateTextField, i, 1, false, true);
        layoutBuilder.nl();
        layoutBuilder.addVGap(8);
        layoutBuilder.nl();
        layoutBuilder.add((Component)this._stickyOptionsLabel, i, 1, false, false);
        layoutBuilder.addHGap();
        layoutBuilder.add((Component)this._stickyOptionsTextField, i, 1, false, true);
        layoutBuilder.nl();
        layoutBuilder.addVGap(8);
        layoutBuilder.nl();
        layoutBuilder.add((Component)this._existingTagsLabel, i, 3, false, true);
        layoutBuilder.nl();
        layoutBuilder.add((Component)this._existingTagsTableScrollPane, i, 3, false, true);
        layoutBuilder.nl();
        return layoutBuilder;
    }

    private void initializePropertyComponents(JLabel label, JComponent propertyComponent) {
        if (propertyComponent instanceof JTextComponent) {
            JTextComponent textComponent = (JTextComponent)propertyComponent;
            textComponent.setBorder(BorderFactory.createEmptyBorder());
            textComponent.setBackground(UIManager.getColor("control"));
            textComponent.setEditable(false);
        }
        if (label == null) {
            return;
        }
        int height = Math.max(label.getPreferredSize().height, propertyComponent.getPreferredSize().height);
        label.setPreferredSize(new Dimension(label.getPreferredSize().width, height));
        propertyComponent.setPreferredSize(new Dimension(propertyComponent.getPreferredSize().width, height));
    }

    private void populatePropertyComponents(URL url) {
        this._statusData = new StatusData(null);
        String busyText = CVSArb.getString(685);
        StatusData.wa$_status(this._statusData, "");
        StatusData.wa$_workingRevision(this._statusData, busyText);
        StatusData.wa$_repositoryRevision(this._statusData, busyText);
        StatusData.wa$_rcsFile(this._statusData, busyText);
        StatusData.wa$_stickyTag(this._statusData, busyText);
        StatusData.wa$_stickyDate(this._statusData, busyText);
        StatusData.wa$_stickyOptions(this._statusData, busyText);
        this.setAsynchronousValueComponentsEnabled(false);
        this.updateAsynchronousValueComponents(url);
        new Thread((Runnable)new AsynchronousValueWorker(url), "CVS Properties (Asynchronous)").start();
    }

    private void updateAsynchronousValueComponents(URL url) {
        EventQueue.invokeLater(new 2(this, url));
    }

    private void _updateAsynchronousValueComponents(URL url) {
        if (StatusData.ra$_status(this._statusData) != null) {
            this._statusValueLabel.setIcon(this.getStatusIcon(url));
            this._statusValueLabel.setText(StatusData.ra$_status(this._statusData));
            this._statusValueLabel.getAccessibleContext().setAccessibleDescription(StatusData.ra$_status(this._statusData));
        }
        if (StatusData.ra$_workingRevision(this._statusData) != null) {
            this._workingRevisionTextField.setText(StatusData.ra$_workingRevision(this._statusData));
        }
        if (StatusData.ra$_repositoryRevision(this._statusData) != null) {
            this._repositoryRevisionTextField.setText(StatusData.ra$_repositoryRevision(this._statusData));
        }
        if (StatusData.ra$_rcsFile(this._statusData) != null) {
            this._rcsFileTextField.setText(StatusData.ra$_rcsFile(this._statusData));
        }
        if (StatusData.ra$_stickyTag(this._statusData) != null) {
            this._stickyTagTextField.setText(StatusData.ra$_stickyTag(this._statusData));
        }
        if (StatusData.ra$_stickyDate(this._statusData) != null) {
            this._stickyDateTextField.setText(StatusData.ra$_stickyDate(this._statusData));
        }
        if (StatusData.ra$_stickyOptions(this._statusData) != null) {
            this._stickyOptionsTextField.setText(StatusData.ra$_stickyOptions(this._statusData));
        }
        if (StatusData.ra$_existingTags(this._statusData) == null) {
            return;
        }
        ExistingTagsTableModel existingTagsTableModel = new ExistingTagsTableModel(null);
        existingTagsTableModel.addColumn(CVSArb.getString(147));
        existingTagsTableModel.addColumn(CVSArb.getString(503));
        existingTagsTableModel.addColumn(CVSArb.getString(498));
        for (TagData tagData : StatusData.ra$_existingTags(this._statusData)) {
            existingTagsTableModel.addRow(new Object[]{TagData.ra$_name(tagData), TagData.ra$_type(tagData), TagData.ra$_revision(tagData)});
        }
        this._existingTagsTable.installModel(existingTagsTableModel);
    }

    private void setAsynchronousValueComponentsEnabled(boolean enabled) {
        EventQueue.invokeLater(new 3(this, enabled));
    }

    private void _setAsynchronousValueComponentsEnabled(boolean enabled) {
        this._workingRevisionTextField.setEnabled(enabled);
        this._repositoryRevisionTextField.setEnabled(enabled);
        this._rcsFileTextField.setEnabled(enabled);
        this._stickyTagTextField.setEnabled(enabled);
        this._stickyDateTextField.setEnabled(enabled);
        this._stickyOptionsTextField.setEnabled(enabled);
        this._existingTagsTable.setEnabled(enabled);
    }

    private Icon getStatusIcon(URL url) {
        Icon icon = this._element instanceof Displayable ? ((Displayable)this._element).getIcon() : null;
        Icon overlayIcon = null;
        try {
            VCSStatus status = CVSClient.getInstance().getStatusCache().get(url);
            IconOverlay overlay = status.getOverlay();
            if (overlay != null) {
                overlayIcon = overlay.getDisplayable().getIcon();
            }
        }
        catch (Exception e) {
            Assert.printStackTrace((Throwable)e);
        }
        if (overlayIcon == null) {
            return icon;
        }
        if (icon == null) {
            return overlayIcon;
        }
        return new OverlayIcon(icon, overlayIcon);
    }

    static StatusData ra$_statusData(CVSPropertiesPanel cVSPropertiesPanel) {
        return cVSPropertiesPanel._statusData;
    }

    static CVSRunner ra$_runner(CVSPropertiesPanel cVSPropertiesPanel) {
        return cVSPropertiesPanel._runner;
    }

    static void wa$_runner(CVSPropertiesPanel cVSPropertiesPanel, CVSRunner cVSRunner) {
        cVSPropertiesPanel._runner = cVSRunner;
    }

    static void mav$updateAsynchronousValueComponents(CVSPropertiesPanel cVSPropertiesPanel, URL uRL) {
        cVSPropertiesPanel.updateAsynchronousValueComponents(uRL);
    }

    static void mav$setAsynchronousValueComponentsEnabled(CVSPropertiesPanel cVSPropertiesPanel, boolean bl) {
        cVSPropertiesPanel.setAsynchronousValueComponentsEnabled(bl);
    }

    static void wa$_statusData(CVSPropertiesPanel cVSPropertiesPanel, StatusData statusData) {
        cVSPropertiesPanel._statusData = statusData;
    }

    static void mav$_setAsynchronousValueComponentsEnabled(CVSPropertiesPanel cVSPropertiesPanel, boolean bl) {
        cVSPropertiesPanel._setAsynchronousValueComponentsEnabled(bl);
    }

    static void mav$_updateAsynchronousValueComponents(CVSPropertiesPanel cVSPropertiesPanel, URL uRL) {
        cVSPropertiesPanel._updateAsynchronousValueComponents(uRL);
    }

    final class 1
    extends Thread {
        private final /* synthetic */ Process v$process;
        final /* synthetic */ CVSPropertiesPanel this$0;

        public void run() {
            try {
                this.v$process.destroy();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public 1(CVSPropertiesPanel cVSPropertiesPanel, Process process) {
            this.v$process = process;
            this.this$0 = cVSPropertiesPanel;
        }
    }

    final class 2
    implements Runnable {
        private final /* synthetic */ URL v$url;
        final /* synthetic */ CVSPropertiesPanel this$0;

        public void run() {
            CVSPropertiesPanel.mav$_updateAsynchronousValueComponents(this.this$0, this.v$url);
        }

        public 2(CVSPropertiesPanel cVSPropertiesPanel, URL uRL) {
            this.v$url = uRL;
            this.this$0 = cVSPropertiesPanel;
        }
    }

    final class 3
    implements Runnable {
        private final /* synthetic */ boolean v$enabled;
        final /* synthetic */ CVSPropertiesPanel this$0;

        public void run() {
            CVSPropertiesPanel.mav$_setAsynchronousValueComponentsEnabled(this.this$0, this.v$enabled);
        }

        public 3(CVSPropertiesPanel cVSPropertiesPanel, boolean bl) {
            this.v$enabled = bl;
            this.this$0 = cVSPropertiesPanel;
        }
    }

    private class ExistingTagsTable
    extends NiceTable {
        private void $init$() {
            this.setSelectionMode(0);
        }

        public boolean isCellEditable(int row, int column) {
            return false;
        }

        public void installModel(TableModel model) {
            this.setModel(model);
            this.setSorted(true);
            this.getTableHeader().setReorderingAllowed(false);
            int i = 0;
            while (i < this.getColumnCount()) {
                this.getColumnModel().getColumn(i).setHeaderRenderer(this.getTableHeader().getDefaultRenderer());
                ++i;
            }
            this.setAutoResizeMode(0);
            this.autoSizeColumnsToFit();
            ((DefaultTableModel)this.getBaseModel()).fireTableDataChanged();
            this.setSortColumn(0, true);
            if (model.getRowCount() > 0) {
                this.setSelectedRow(0);
            }
        }

        public void setSelectedRow(int i) {
            if (i < 0 || i >= this.getRowCount()) {
                return;
            }
            this.setRowSelectionInterval(i, i);
            this.scrollToSelection();
        }

        private ExistingTagsTable() {
            this.$init$();
        }

        ExistingTagsTable(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class ExistingTagsTableModel
    extends DefaultTableModel
    implements NiceTableModel {
        public int getColumnAlignment(int column) {
            return 2;
        }

        public Comparator getColumnSortComparator(int column) {
            return Collator.getInstance();
        }

        private ExistingTagsTableModel() {
        }

        ExistingTagsTableModel(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class AsynchronousValueWorker
    implements Runnable {
        private final URL _regularFileUrl;

        AsynchronousValueWorker(URL regularFileUrl) {
            this._regularFileUrl = regularFileUrl;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            this.getRunner().setDirURL(URLFileSystem.getParent((URL)this._regularFileUrl));
            this.getRunner().setCommand("status");
            this.getRunner().getParameters().setOptions(Collections.singleton("-v"));
            this.getRunner().getParameters().setFile(URLFileSystem.getFileName((URL)this._regularFileUrl));
            this.getRunner().getParameters().setQuiet(true);
            try {
                try {
                    this.getRunner().exec();
                    StringBuffer regexpBuffer = new StringBuffer();
                    this.appendRegexpPropertySubstring("Status:", regexpBuffer);
                    this.appendRegexpPropertySubstring("Working revision:", regexpBuffer);
                    this.appendRegexpPropertySubstring("Repository revision:", regexpBuffer);
                    regexpBuffer.append("(\\t([^\\t\\n\\r\\f]+))?");
                    this.appendRegexpPropertySubstring("Sticky Tag:", regexpBuffer);
                    this.appendRegexpPropertySubstring("Sticky Date:", regexpBuffer);
                    this.appendRegexpPropertySubstring("Sticky Options:", regexpBuffer);
                    regexpBuffer.append("[^E]+");
                    regexpBuffer.append("(Existing Tags:\\s+(.+))?");
                    Pattern pattern = Pattern.compile(regexpBuffer.toString(), 32);
                    Matcher matcher = pattern.matcher(CVSPropertiesPanel.ra$_runner(CVSPropertiesPanel.this).getOutputText());
                    if (!matcher.matches()) {
                        Assert.println((String)"Failed to parse CVS status information for properties dialog...");
                        Assert.println((String)"Output:");
                        Assert.println((String)CVSPropertiesPanel.ra$_runner(CVSPropertiesPanel.this).getOutputText());
                        Assert.println((String)"Errors:");
                        Assert.println((String)CVSPropertiesPanel.ra$_runner(CVSPropertiesPanel.this).getErrorText());
                        return;
                    }
                    CVSPropertiesPanel.wa$_statusData(CVSPropertiesPanel.this, new StatusData(null));
                    StatusData.wa$_status(this.getStatusData(), this.getMatcherGroup(matcher, 1));
                    StatusData.wa$_workingRevision(this.getStatusData(), this.getMatcherGroup(matcher, 2));
                    StatusData.wa$_repositoryRevision(this.getStatusData(), this.getMatcherGroup(matcher, 3));
                    StatusData.wa$_rcsFile(this.getStatusData(), this.getMatcherGroup(matcher, 5));
                    StatusData.wa$_stickyTag(this.getStatusData(), this.getMatcherGroup(matcher, 6));
                    StatusData.wa$_stickyDate(this.getStatusData(), this.getMatcherGroup(matcher, 7));
                    StatusData.wa$_stickyOptions(this.getStatusData(), this.getMatcherGroup(matcher, 8));
                    StatusData.wa$_existingTags(this.getStatusData(), new ArrayList());
                    if (matcher.groupCount() < 10) {
                    }
                    if (matcher.group(10) == null) {
                    }
                    String existingTagsString = this.getMatcherGroup(matcher, 10);
                    BufferedReader bufferedReader = new BufferedReader(new StringReader(existingTagsString));
                    pattern = Pattern.compile("([^\\s]+)\\s+\\(([^:]+):\\s([^\\)]+)\\)");
                    while (true) {
                        String line;
                        if ((line = bufferedReader.readLine()) == null) {
                            return;
                        }
                        if ((line = line.trim()).equals("") || !(matcher = pattern.matcher(line)).matches()) continue;
                        TagData tagData = new TagData(null);
                        TagData.wa$_name(tagData, this.getMatcherGroup(matcher, 1));
                        TagData.wa$_type(tagData, this.getMatcherGroup(matcher, 2));
                        TagData.wa$_revision(tagData, this.getMatcherGroup(matcher, 3));
                        StatusData.ra$_existingTags(this.getStatusData()).add(tagData);
                    }
                }
                finally {
                    CVSClient.getInstance().getStatusCache().clear(this._regularFileUrl);
                    CVSPropertiesPanel.wa$_runner(CVSPropertiesPanel.this, null);
                    CVSPropertiesPanel.mav$updateAsynchronousValueComponents(CVSPropertiesPanel.this, this._regularFileUrl);
                    CVSPropertiesPanel.mav$setAsynchronousValueComponentsEnabled(CVSPropertiesPanel.this, true);
                }
            }
            catch (Exception e) {
                Assert.printStackTrace((Throwable)e);
                return;
            }
        }

        private CVSRunner getRunner() {
            return CVSPropertiesPanel.ra$_runner(CVSPropertiesPanel.this);
        }

        private StatusData getStatusData() {
            return CVSPropertiesPanel.ra$_statusData(CVSPropertiesPanel.this);
        }

        private void appendRegexpPropertySubstring(String propertyString, StringBuffer regexpBuffer) {
            regexpBuffer.append(".*");
            regexpBuffer.append(propertyString);
            regexpBuffer.append("\\s+([^\\t\\n\\r\\f]+)");
        }

        private String getMatcherGroup(Matcher matcher, int i) {
            if (matcher.groupCount() < i) {
                return null;
            }
            String group = matcher.group(i);
            return group != null ? group.trim() : "";
        }
    }

    private static class StatusData {
        private String _status;
        private String _workingRevision;
        private String _repositoryRevision;
        private String _rcsFile;
        private String _stickyTag;
        private String _stickyDate;
        private String _stickyOptions;
        private Collection _existingTags;

        private StatusData() {
        }

        static String ra$_status(StatusData statusData) {
            return statusData._status;
        }

        static String ra$_workingRevision(StatusData statusData) {
            return statusData._workingRevision;
        }

        static String ra$_repositoryRevision(StatusData statusData) {
            return statusData._repositoryRevision;
        }

        static String ra$_rcsFile(StatusData statusData) {
            return statusData._rcsFile;
        }

        static String ra$_stickyTag(StatusData statusData) {
            return statusData._stickyTag;
        }

        static String ra$_stickyDate(StatusData statusData) {
            return statusData._stickyDate;
        }

        static String ra$_stickyOptions(StatusData statusData) {
            return statusData._stickyOptions;
        }

        static Collection ra$_existingTags(StatusData statusData) {
            return statusData._existingTags;
        }

        StatusData(1 var1_1) {
            this();
        }

        static void wa$_status(StatusData statusData, String string) {
            statusData._status = string;
        }

        static void wa$_workingRevision(StatusData statusData, String string) {
            statusData._workingRevision = string;
        }

        static void wa$_repositoryRevision(StatusData statusData, String string) {
            statusData._repositoryRevision = string;
        }

        static void wa$_rcsFile(StatusData statusData, String string) {
            statusData._rcsFile = string;
        }

        static void wa$_stickyTag(StatusData statusData, String string) {
            statusData._stickyTag = string;
        }

        static void wa$_stickyDate(StatusData statusData, String string) {
            statusData._stickyDate = string;
        }

        static void wa$_stickyOptions(StatusData statusData, String string) {
            statusData._stickyOptions = string;
        }

        static void wa$_existingTags(StatusData statusData, Collection collection) {
            statusData._existingTags = collection;
        }

        public final class 1 {
        }
    }

    private static class TagData {
        private String _name;
        private String _type;
        private String _revision;

        private TagData() {
        }

        static String ra$_name(TagData tagData) {
            return tagData._name;
        }

        static String ra$_type(TagData tagData) {
            return tagData._type;
        }

        static String ra$_revision(TagData tagData) {
            return tagData._revision;
        }

        TagData(1 var1_1) {
            this();
        }

        static void wa$_name(TagData tagData, String string) {
            tagData._name = string;
        }

        static void wa$_type(TagData tagData, String string) {
            tagData._type = string;
        }

        static void wa$_revision(TagData tagData, String string) {
            tagData._revision = string;
        }

        public final class 1 {
        }
    }
}

