/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs;

import java.io.IOException;
import java.net.URL;
import java.util.List;
import oracle.ide.net.URLFileSystem;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdeveloper.vcs.spi.VCSStatusCache;
import oracle.jdevimpl.vcs.cvs.CVSClient;
import oracle.jdevimpl.vcs.cvs.CVSEntriesCache;
import oracle.jdevimpl.vcs.cvs.CVSFileStatus;
import oracle.jdevimpl.vcs.cvs.CVSRootCache;
import oracle.jdevimpl.vcs.cvs.CVSUtil;
import oracle.jdevimpl.vcs.cvs.client.CVSEntry;
import oracle.jdevimpl.vcs.cvs.client.CVSRootString;
import oracle.jdevimpl.vcs.cvs.login.CVSLogin;
import oracle.jdevimpl.vcs.cvs.util.CVSUniversalTimestamp;

class CVSStatusCache
extends VCSStatusCache {
    protected final void getImpl(URL[] urls, VCSStatus[] statuses) throws Exception {
        int i = 0;
        while (i < urls.length) {
            statuses[i] = this._getImpl(urls[i]);
            ++i;
        }
    }

    private VCSStatus _getImpl(URL url) throws Exception {
        URL directoryUrl;
        boolean controlled;
        CVSClient client = CVSClient.getInstance();
        if (client == null) {
            return CVSFileStatus.STATUS_NOT_UNDER_CVS;
        }
        if (!client.isClientAvailable()) {
            return CVSFileStatus.STATUS_NOT_UNDER_CVS;
        }
        if (!client.getURLFilter().accept(url)) {
            return CVSFileStatus.STATUS_NOT_UNDER_CVS;
        }
        URL parent = URLFileSystem.getParent((URL)url);
        if (URLFileSystem.getFileName((URL)parent).equals("CVS")) {
            return CVSFileStatus.STATUS_ADMINISTRATIVE;
        }
        URL sandbox = CVSUtil.locateParentSandbox(url);
        boolean bl = controlled = sandbox != null;
        if (!controlled) {
            return CVSFileStatus.STATUS_NOT_UNDER_CVS;
        }
        CVSRootString root = CVSRootCache.getInstance().getRoot(sandbox);
        if (root == null || !CVSUtil.hasRootConnection(root)) {
            return CVSFileStatus.STATUS_NOT_UNDER_CVS;
        }
        if (!CVSLogin.getMethod(sandbox).isLoggedIn(sandbox)) {
            return CVSFileStatus.STATUS_NOT_UNDER_CVS;
        }
        boolean isDirectory = URLFileSystem.isDirectoryPath((URL)url);
        URL uRL = directoryUrl = isDirectory ? url : parent;
        if (isDirectory && !URLFileSystem.exists((URL)url)) {
            return CVSFileStatus.STATUS_NOT_UNDER_CVS;
        }
        if (!URLFileSystem.equals((URL)directoryUrl, (URL)sandbox)) {
            return CVSFileStatus.STATUS_UNADDED;
        }
        if (isDirectory) {
            return CVSFileStatus.STATUS_SANDBOX;
        }
        CVSEntry entry = CVSStatusCache.locateEntry(url);
        if (entry == null) {
            return CVSFileStatus.STATUS_UNADDED;
        }
        if (entry.isDirectory() != isDirectory) {
            return CVSFileStatus.STATUS_NOT_UNDER_CVS;
        }
        if (entry.isRemoved()) {
            return CVSFileStatus.STATUS_REMOVED;
        }
        if (!URLFileSystem.exists((URL)url)) {
            return CVSFileStatus.STATUS_NOT_UNDER_CVS;
        }
        if (entry.hasConflicts()) {
            return CVSFileStatus.STATUS_CONFLICTS;
        }
        if (entry.isAdded()) {
            return CVSFileStatus.STATUS_ADDED;
        }
        if (!CVSUniversalTimestamp.createTimestamp(url).equals(new CVSUniversalTimestamp(entry.getTimestamp()))) {
            return CVSFileStatus.STATUS_LOCALLY_CHANGED;
        }
        return URLFileSystem.isReadOnly((URL)url) ? CVSFileStatus.STATUS_UNMODIFIED_READONLY : CVSFileStatus.STATUS_UNMODIFIED_READWRITE;
    }

    public static final CVSEntry locateEntry(URL url) throws IOException {
        List entries = CVSEntriesCache.getInstance().getEntries(URLFileSystem.getParent((URL)url));
        return entries != null ? CVSEntriesCache.findEntry(entries, url) : null;
    }

    CVSStatusCache() {
    }
}

