/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.ItemSelectable;
import java.awt.Window;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.util.Assert;
import oracle.jdeveloper.vcs.spi.VCSCancelException;
import oracle.jdeveloper.vcs.spi.VCSException;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdeveloper.vcs.util.VCSCommandUtils;
import oracle.jdeveloper.vcs.util.VCSContextUtils;
import oracle.jdeveloper.vcs.util.VCSFileSystemUtils;
import oracle.jdeveloper.vcs.util.VCSModelUtils;
import oracle.jdeveloper.vcs.util.VCSTextFileUtils;
import oracle.jdeveloper.vcs.util.VCSURLFilters;
import oracle.jdevimpl.vcs.cvs.CVSClient;
import oracle.jdevimpl.vcs.cvs.CVSEntriesCache;
import oracle.jdevimpl.vcs.cvs.CVSFileStatus;
import oracle.jdevimpl.vcs.cvs.CVSKeywordSubtitutionMode;
import oracle.jdevimpl.vcs.cvs.CVSLoginCache;
import oracle.jdevimpl.vcs.cvs.CVSRootCache;
import oracle.jdevimpl.vcs.cvs.client.CVSEntry;
import oracle.jdevimpl.vcs.cvs.client.CVSRootString;
import oracle.jdevimpl.vcs.cvs.error.CVSOperationException;
import oracle.jdevimpl.vcs.cvs.login.CVSLogin;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionData;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionListAPI;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionListData;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionNodes;
import oracle.jdevimpl.vcs.cvs.resource.CVSArb;
import oracle.jdevimpl.vcs.cvs.util.CVSListFilesUtil;
import oracle.jdevimpl.vcs.cvs.util.CVSMessageDialog;
import oracle.jdevimpl.vcs.cvs.wiz.connect.CVSConnectWizard;
import oracle.jdevimpl.vcs.cvs.wiz.framework.CVSWizardCancelException;
import oracle.jdevimpl.vcs.cvs.wiz.framework.CVSWizardRunner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CVSUtil {
    public static final String CVS_MESSAGE_PREFIX = "cvs client> ";
    public static final String CVS_CLIENT_MESSAGE_PREFIX = "cvs client: ";
    public static final String CVS_CLIENT_INPUT_PREFIX = "<<< ";
    public static final String KEYWORD_OPTION_BINARY = "b";
    public static final URL FILESYSTEM_ROOT;

    static {
        URL url = URLFactory.newFileURL((String)System.getProperty("user.home"));
        while (URLFileSystem.getParent((URL)url) != null) {
            url = URLFileSystem.getParent((URL)url);
        }
        FILESYSTEM_ROOT = url;
    }

    private CVSUtil() {
    }

    public static final String readRepository(URL parent) throws IOException {
        return CVSUtil.readStringFile(URLFactory.newURL((URL)parent, (String)"CVS/Repository"));
    }

    public static final String readStringFile(URL url) throws IOException {
        BufferedReader in = new BufferedReader(new InputStreamReader(URLFileSystem.openInputStream((URL)url)));
        try {
            String string = in.readLine();
            return string;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            in.close();
        }
    }

    public static final String removeTrailingFileSeparators(String path) {
        while (!path.equals(File.separator) && path.endsWith(File.separator)) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    public static final String prefixKeywordOption(String kOption) {
        return "-k" + kOption;
    }

    public static final boolean isUnderCVS(URL directoryUrl) {
        if (directoryUrl == null) {
            return false;
        }
        if (!CVSClient.PROTOCOL_URL_FILTER.accept(directoryUrl)) {
            return false;
        }
        try {
            CVSRootString rootstr = CVSRootCache.getInstance().getRoot(directoryUrl);
            boolean bl = rootstr != null && !rootstr.toString().equals("");
            return bl;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            boolean bl = false;
            return bl;
        }
    }

    public static final CVSRootString readAdminRoot(URL directoryUrl) throws IOException {
        if (directoryUrl == null) {
            return null;
        }
        if (!CVSClient.getInstance().getURLFilter().accept(directoryUrl)) {
            return null;
        }
        CVSRootString rootstr = CVSRootCache.getInstance().getRoot(directoryUrl);
        return !rootstr.toString().equals("") ? rootstr : null;
    }

    public static final URL locateParentSandbox(URL url) {
        URL parentUrl;
        if (url == null) {
            return null;
        }
        if (!CVSClient.getInstance().getURLFilter().accept(url)) {
            return null;
        }
        if (URLFileSystem.isDirectoryPath((URL)url) && CVSUtil.isUnderCVS(url)) {
            return url;
        }
        while ((parentUrl = URLFileSystem.getParent((URL)url)) != null && !parentUrl.equals(url)) {
            url = parentUrl;
            if (!CVSUtil.isUnderCVS(url)) continue;
            return url;
        }
        return null;
    }

    public static final boolean isOpenSessionFile(URL url) {
        if (url == null) {
            return false;
        }
        URL parent = CVSUtil.locateParentSandbox(url);
        if (parent == null) {
            return false;
        }
        return CVSUtil.isOpenSessionSandbox(parent);
    }

    public static final boolean isOpenSessionSandbox(URL sandbox) {
        if (sandbox == null) {
            return false;
        }
        if (!CVSClient.getInstance().getURLFilter().accept(sandbox)) {
            return false;
        }
        if (!URLFileSystem.exists((URL)sandbox)) {
            return false;
        }
        if (!URLFileSystem.isDirectory((URL)sandbox)) {
            Assert.printStackTrace((Throwable)new IllegalArgumentException());
        }
        CVSRootString root = null;
        try {
            root = CVSRootCache.getInstance().getRoot(sandbox);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            boolean bl = false;
            return bl;
        }
        if (root == null) {
            return false;
        }
        return CVSUtil.hasRootConnection(root) && CVSLogin.getMethod(sandbox).isLoggedIn(sandbox);
    }

    public static final boolean hasRootConnection(CVSRootString root) {
        return CVSUtil.getRootConnection(root) != null;
    }

    public static final CVSConnectionData getRootConnection(CVSRootString root) {
        if (root == null) {
            return null;
        }
        CVSConnectionListAPI list = CVSConnectionNodes.getConnectionListAPI();
        if (list == null) {
            return null;
        }
        String name = ((CVSConnectionListData)list).getRootConnection(root.toString());
        if (name == null) {
            return null;
        }
        return ((CVSConnectionListData)list).getConnectionAPI(name);
    }

    public static final Pattern createRSHProgramRE() {
        return Pattern.compile("^rsh$|^rsh\\.exe$", 2);
    }

    public static final Pattern createSSHProgramRE() {
        return Pattern.compile("^ssh\\d*$|^ssh\\d*\\.exe$", 2);
    }

    public static final void clearPerformanceCaches() {
        CVSRootCache.getInstance().clear();
        CVSEntriesCache.getInstance().clear();
        CVSLoginCache.getInstance().clear();
    }

    public static final void deleteFiles(boolean recursive, Comparator<URL> comparator, URL ... urls) throws Exception {
        URL[] uRLArray = urls;
        int n = 0;
        while (n < uRLArray.length) {
            URL url = uRLArray[n];
            if (URLFileSystem.isDirectoryPath((URL)url)) {
                CVSUtil.deleteDirectoryContents(url, recursive, comparator);
            } else {
                CVSUtil.deleteFile(url);
            }
            ++n;
        }
    }

    public static final void deleteDirectoryContents(URL dir, boolean recursive, Comparator<URL> comparator) throws Exception {
        if (!URLFileSystem.isDirectory((URL)dir)) {
            Assert.printStackTrace((Throwable)new IllegalArgumentException());
        }
        CVSRootCache.getInstance().clear();
        int options = 1;
        if (recursive) {
            options |= 4;
        }
        List<URL> urls = CVSListFilesUtil.listFiles(dir, options);
        if (comparator != null) {
            Collections.sort(urls, comparator);
        }
        for (URL url : urls) {
            CVSUtil.deleteFile(url);
        }
    }

    public static final void deleteFile(URL url) throws Exception {
        VCSStatus status;
        if (!URLFileSystem.exists((URL)url)) {
            return;
        }
        if (URLFileSystem.isDirectory((URL)url)) {
            Assert.printStackTrace((Throwable)new IllegalArgumentException());
        }
        if (!(status = CVSClient.getInstance().getStatusCache().get(new URL[]{url})[0]).isVersioned() || status == CVSFileStatus.STATUS_ADDED) {
            return;
        }
        if (!new File(URLFileSystem.getPlatformPathName((URL)url)).delete()) {
            throw new CVSOperationException(CVSArb.getString(297));
        }
    }

    public static final boolean isValidBranchName(String s) {
        return CVSUtil.hasWhitespace(s) ^ true;
    }

    public static final boolean hasWhitespace(String s) {
        if (s.equals("")) {
            return true;
        }
        String illegal = " \t\n\f\r";
        int i = 0;
        while (i < " \t\n\f\r".length()) {
            if (s.indexOf(" \t\n\f\r".charAt(i)) >= 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static final JEWTDialog createJEWTDialog(Component parent, Component ui, String title, int buttons) {
        JEWTDialog dialog;
        Window window = CVSUtil.getParentWindow(parent);
        if (window instanceof Dialog) {
            dialog = new JEWTDialog((Dialog)window, title, buttons);
        } else {
            Frame frame = window instanceof Frame ? (Frame)window : JOptionPane.getFrameForComponent(parent);
            dialog = new JEWTDialog(frame, title, buttons);
        }
        dialog.setContent(ui);
        dialog.setCenterOver((Component)window);
        dialog.setResizable(true);
        return dialog;
    }

    public static final void checkCreateConnection(Context context) throws VCSException {
        if (CVSConnectionNodes.getConnectionListAPI().getConnectionCount() <= 0) {
            String message = CVSArb.getString(164);
            String title = CVSArb.getString(482);
            if (!CVSMessageDialog.confirm((Component)Ide.getMainWindow(), message, title, null)) {
                throw new VCSCancelException();
            }
            try {
                CVSWizardRunner.runWizard(new CVSConnectWizard(), context);
            }
            catch (CVSWizardCancelException wce) {
                throw new VCSCancelException();
            }
        }
    }

    public static final Component findTraversableComponent(Component c) {
        if (c.isFocusable() && c.isEnabled() && (c instanceof ItemSelectable || c instanceof Scrollable)) {
            return c;
        }
        if (!(c instanceof Container)) {
            return null;
        }
        Container container = (Container)c;
        int n = container.getComponentCount();
        int i = 0;
        while (i < n) {
            c = CVSUtil.findTraversableComponent(container.getComponent(i));
            if (c != null) {
                return c;
            }
            ++i;
        }
        return null;
    }

    public static final String[] getCVSWrappers() {
        String[] extensions = VCSModelUtils.listBinaryExtensions();
        ArrayList<String> wrappers = new ArrayList<String>();
        int i = 0;
        while (i < extensions.length) {
            wrappers.add("-W");
            StringBuffer wrapperBuffer = new StringBuffer();
            wrapperBuffer.append('*');
            wrapperBuffer.append(extensions[i]);
            wrapperBuffer.append(" -k 'b'");
            wrappers.add(wrapperBuffer.toString());
            ++i;
        }
        String keywordSubtitutionOption = CVSUtil.getKeywordSubtitutionOption();
        if (keywordSubtitutionOption != null) {
            wrappers.add("-W");
            wrappers.add("* -k" + keywordSubtitutionOption);
        }
        return wrappers.toArray(new String[0]);
    }

    public static final String getKeywordSubtitutionOption() {
        String keywordSubstitutionMode = (String)CVSClient.getInstance().getProperties().get("keyword_substitution_mode");
        if (keywordSubstitutionMode == null) {
            return null;
        }
        return CVSUtil.getKeywordSubtitutionOption(CVSKeywordSubtitutionMode.valueOf(keywordSubstitutionMode));
    }

    public static final String getKeywordSubtitutionOption(CVSKeywordSubtitutionMode keywordSubstitutionMode) {
        if (keywordSubstitutionMode == CVSKeywordSubtitutionMode.AUTOMATIC) {
            return null;
        }
        if (keywordSubstitutionMode == CVSKeywordSubtitutionMode.KEYWORD_ONLY) {
            return "k";
        }
        if (keywordSubstitutionMode == CVSKeywordSubtitutionMode.KEYWORD_VALUE) {
            return "kv";
        }
        if (keywordSubstitutionMode == CVSKeywordSubtitutionMode.KEYWORD_VALUE_LOCKER) {
            return "kvl";
        }
        if (keywordSubstitutionMode == CVSKeywordSubtitutionMode.OLD_CONTENTS) {
            return "o";
        }
        if (keywordSubstitutionMode == CVSKeywordSubtitutionMode.VALUE_ONLY) {
            return "v";
        }
        return null;
    }

    public static final boolean saveDirtyNodes(Collection nodes) throws Exception {
        nodes = new ArrayList(nodes);
        Locatable[] locatables = VCSModelUtils.getValidLocatables((Object[])nodes.toArray(), null);
        VCSStatus[] statuses = CVSClient.getInstance().getStatusCache().get(VCSModelUtils.convertNodesToURLs((Locatable[])locatables));
        int i = 0;
        while (i < statuses.length) {
            if (statuses[i] == CVSFileStatus.STATUS_REMOVED) {
                nodes.remove(locatables[i]);
            }
            ++i;
        }
        return VCSCommandUtils.saveDirtyNodes((Locatable[])nodes.toArray(new Locatable[0]));
    }

    public static final boolean saveDirtyNodesSilently(Collection nodes) throws Exception {
        return VCSCommandUtils.saveDirtyNodesSilently((Locatable[])nodes.toArray(new Locatable[0]));
    }

    public static final URL getContextDirectoryURL(Context context) {
        return CVSUtil.getContextDirectoryURL(context, null);
    }

    public static final URL getContextDirectoryURL(Context context, URL defaultUrl) {
        if (defaultUrl == null) {
            defaultUrl = CVSUtil.getWorkDirectoryURL();
        }
        if (context == null) {
            return defaultUrl;
        }
        if (VCSModelUtils.findCachedProjects().length <= 0) {
            return defaultUrl;
        }
        Locatable[] locatables = VCSContextUtils.getContextLocatables((Context)context, (URLFilter)CVSClient.getInstance().getURLFilter());
        if (locatables.length <= 0) {
            return defaultUrl;
        }
        URL[] contextUrls = VCSModelUtils.convertNodesToURLs((Locatable[])locatables);
        ArrayList<URL> contextDirectoryUrls = new ArrayList<URL>();
        int i = 0;
        while (i < contextUrls.length) {
            URL contextDirectoryUrl;
            URL contextUrl = locatables[i].getURL();
            URL uRL = contextDirectoryUrl = URLFileSystem.isDirectoryPath((URL)contextUrl) || URLFileSystem.isDirectory((URL)contextUrl) ? contextUrl : URLFileSystem.getParent((URL)contextUrl);
            if (URLFileSystem.exists((URL)contextDirectoryUrl)) {
                contextDirectoryUrls.add(contextDirectoryUrl);
            }
            ++i;
        }
        URL[] coalescedUrls = VCSFileSystemUtils.coalesceURLs((URL[])contextDirectoryUrls.toArray(new URL[0]));
        return coalescedUrls.length > 0 ? coalescedUrls[0] : defaultUrl;
    }

    public static final URL getWorkDirectoryURL() {
        return URLFactory.newDirURL((String)Ide.getWorkDirectory());
    }

    public static final String createCommentsTemplate(Collection nodes) {
        if (!((Boolean)CVSClient.getInstance().getProperties().get("property_use_comment_templates")).booleanValue()) {
            return null;
        }
        return CVSUtil.readCommentsTemplate(nodes);
    }

    public static final String readCommentsTemplate(Collection nodes) {
        Iterator itr = nodes.iterator();
        if (!itr.hasNext()) {
            return null;
        }
        URL url = VCSModelUtils.getLocatableURL(itr.next());
        if (url == null) {
            return null;
        }
        if (!URLFileSystem.isDirectoryPath((URL)url)) {
            url = URLFileSystem.getParent((URL)url);
        }
        if (url == null) {
            return null;
        }
        url = URLFactory.newDirURL((URL)url, (String)"CVS");
        url = URLFactory.newURL((URL)url, (String)"Template");
        try {
            String string = VCSTextFileUtils.readTextFile((URL)url);
            return string;
        }
        catch (IOException ioe) {
            Assert.printStackTrace((Throwable)ioe);
            String string = null;
            return string;
        }
    }

    public static String getSandboxRevision(URL url) throws IOException {
        CVSEntry entry;
        URL parent = URLFileSystem.getParent((URL)url);
        URL dir = parent != null ? parent : url;
        List entries = CVSEntriesCache.getInstance().getEntries(dir);
        if (entries != null && (entry = CVSEntriesCache.findEntry(entries, url)) != null) {
            return entry.getRevision();
        }
        return null;
    }

    public static final Node[] getCachedBaseURLNodes(URL[] baseUrls) {
        return VCSModelUtils.findCachedNodes((URLFilter)VCSURLFilters.createBaseURLContentsFilter((URL[])baseUrls));
    }

    public static final void writeFileBytes(URL url, byte[] bytes) throws IOException {
        FileOutputStream fos = new FileOutputStream(URLFileSystem.getPlatformPathName((URL)url));
        fos.write(bytes);
        fos.close();
    }

    static final Object getByURL(Map m, URL url) {
        for (Map.Entry entry : m.entrySet()) {
            if (!URLFileSystem.equals((URL)((URL)entry.getKey()), (URL)url)) continue;
            return entry.getValue();
        }
        return null;
    }

    private static final Window getParentWindow(Component comp) {
        if (comp == null) {
            return Ide.getMainWindow();
        }
        return comp instanceof Window ? (Window)comp : SwingUtilities.getWindowAncestor(comp);
    }
}

