/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs;

import java.awt.Component;
import java.awt.Container;
import java.util.HashMap;
import java.util.Map;
import oracle.ide.panels.TraversalException;
import oracle.jdeveloper.vcs.spi.VCSPropertyTraversable;
import oracle.jdevimpl.vcs.cvs.CVSPropertyKey;
import oracle.jdevimpl.vcs.cvs.CVSResourcePicker;
import oracle.jdevimpl.vcs.cvs.ui.CVSVersionToolsTraversableUI;

public class CVSVersionToolsTraversable
extends VCSPropertyTraversable
implements CVSPropertyKey {
    private static final int TIMEOUT_SCALE_MINUTES = 1;
    private static final int TIMEOUT_SCALE_HOURS = 2;
    private CVSVersionToolsTraversableUI _customizerUI;

    public CVSVersionToolsTraversable() {
        this.setHelpID("f1_cvspreferencesversiontools_html");
    }

    public static final Map createDefaultProperties() {
        HashMap properties = new HashMap();
        return properties;
    }

    protected String getDataKey() {
        return "cvs_version_tool_properties";
    }

    protected Component getPropertyPage() {
        if (this._customizerUI == null) {
            this.createComponent();
        }
        return this._customizerUI;
    }

    protected void setProperties(Map m) {
        Integer mergeEditor;
        String value = (String)m.get("changelist_commit_dialog");
        if (value == null) {
            value = "changelist_commit_dialog_comments";
        }
        this._customizerUI.getCommitDialogAlways().setSelected("changelist_commit_dialog_always".equals(value));
        this._customizerUI.getCommitDialogComments().setSelected("changelist_commit_dialog_comments".equals(value));
        this._customizerUI.getCommitDialogNever().setSelected("changelist_commit_dialog_never".equals(value));
        Integer timer = (Integer)m.get("changelist_timer");
        if (timer == null) {
            timer = CVSPropertyKey.DEF_PROPERTY_CHANGELIST_TIMER;
        }
        int seconds = timer;
        int scale = this.calculateTimeoutScale(seconds);
        this._customizerUI.getIncomingChangesTimerQuantity().setNumber((Number)new Integer(this.calculateTimeoutQuantity(seconds, scale)));
        if (scale == 2) {
            this._customizerUI.getIncomingChangesTimerHours().setSelected(true);
        }
        if (scale == 1) {
            this._customizerUI.getIncomingChangesTimerMinutes().setSelected(true);
        }
        if ((mergeEditor = (Integer)m.get("mergeEditor")) != null) {
            this._customizerUI.setMergeEditor(mergeEditor);
        }
    }

    protected Map getProperties() {
        Integer quantity;
        HashMap<String, Object> m = new HashMap<String, Object>();
        String value = this._customizerUI.getCommitDialogAlways().isSelected() ? "changelist_commit_dialog_always" : (this._customizerUI.getCommitDialogNever().isSelected() ? "changelist_commit_dialog_never" : "changelist_commit_dialog_comments");
        m.put("changelist_commit_dialog", value);
        int scale = 1;
        if (this._customizerUI.getIncomingChangesTimerHours().isSelected()) {
            scale = 2;
        }
        Integer quantity0 = (quantity = (Integer)this._customizerUI.getIncomingChangesTimerQuantity().getNumber()) != null ? new Integer(this.calculateTimeoutSeconds(quantity, scale)) : CVSPropertyKey.DEF_PROPERTY_CHANGELIST_TIMER;
        m.put("changelist_timer", quantity0);
        m.put("mergeEditor", this._customizerUI.getMergeEditor());
        return m;
    }

    protected void validateProperties() throws TraversalException {
    }

    private Component createComponent() {
        this._customizerUI = new CVSVersionToolsTraversableUI();
        this._customizerUI.getIncomingChangesTimerQuantity().setColumns(10);
        this._customizerUI.getIncomingChangesTimerQuantity().setDecimal(true);
        this._customizerUI.getIncomingChangesTimerQuantity().setSigned(false);
        this._customizerUI.getIncomingChangesTimerQuantity().setDataType(Integer.class);
        CVSResourcePicker.getPicker(this).start((Container)this._customizerUI);
        return this._customizerUI;
    }

    private int calculateTimeoutScale(int seconds) {
        if (seconds > 0 && seconds % 3600 == 0) {
            return 2;
        }
        return 1;
    }

    private int calculateTimeoutQuantity(int seconds, int scale) {
        if (scale == 2) {
            return seconds / 3600;
        }
        return seconds / 60;
    }

    private int calculateTimeoutSeconds(int quantity, int scale) {
        if (scale == 2) {
            return quantity * 3600;
        }
        return quantity * 60;
    }
}

