/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.client;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.jdevimpl.vcs.cvs.client.CVSAccessPServer;
import oracle.jdevimpl.vcs.cvs.client.CVSRootString;
import oracle.jdevimpl.vcs.cvs.util.CVSEnvironmentVars;

class CVSAccessPServerGeneric
extends CVSAccessPServer {
    private static final Object _passlock = new Object();

    protected CVSAccessPServerGeneric() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deletePassFileRoot(String root) throws Exception {
        CVSRootString rootstr = new CVSRootString(root);
        Object object = _passlock;
        synchronized (object) {
            String s;
            URL pass_url = URLFactory.newFileURL((String)this.getPassfilePath());
            if (!URLFileSystem.exists((URL)pass_url)) {
                return;
            }
            BufferedReader in = new BufferedReader(new FileReader(URLFileSystem.getPlatformPathName((URL)pass_url)));
            ArrayList<String> lines = new ArrayList<String>();
            while ((s = in.readLine()) != null) {
                lines.add(s);
            }
            in.close();
            BufferedWriter out = new BufferedWriter(new FileWriter(URLFileSystem.getPlatformPathName((URL)pass_url)));
            Iterator itr = lines.iterator();
            while (itr.hasNext()) {
                String entry = itr.next().toString();
                if (new CVSRootString(this.parseEntryRoot(entry)).equals(rootstr)) continue;
                out.write(entry);
                out.newLine();
            }
            out.close();
        }
    }

    public boolean searchPassFileRoot(String root) throws Exception {
        return this.readPassFileRoot(root) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writePassFileRoot(String root, String spw) throws Exception {
        CVSRootString rootstr = new CVSRootString(root);
        Object object = _passlock;
        synchronized (object) {
            RandomAccessFile pass = new RandomAccessFile(this.getPassfilePath(), "rw");
            if (this.findPassFilePassword(root, pass) == null) {
                pass.seek(pass.length());
                pass.writeBytes(rootstr.canonicalize().toString() + this.getFieldDelimiter() + spw + '\n');
            }
            pass.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readPassFileRoot(String root) throws Exception {
        Object object = _passlock;
        synchronized (object) {
            URL pass_url = URLFactory.newFileURL((String)this.getPassfilePath());
            if (!URLFileSystem.exists((URL)pass_url)) {
                String string = null;
                return string;
            }
            RandomAccessFile pass = new RandomAccessFile(this.getPassfilePath(), "r");
            String spw = this.findPassFilePassword(root, pass);
            pass.close();
            String string = spw;
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deletePassFile() throws Exception {
        Object object = _passlock;
        synchronized (object) {
            URL pass_url = URLFactory.newFileURL((String)this.getPassfilePath());
            if (URLFileSystem.isDirectory((URL)pass_url)) {
                return;
            }
            URLFileSystem.delete((URL)pass_url);
        }
    }

    protected String getPassfilePath() {
        String passfile = CVSEnvironmentVars.getInstance().getVariable("CVS_PASSFILE");
        if (passfile != null) {
            return passfile;
        }
        StringBuffer sb = new StringBuffer();
        String home = URLFileSystem.getPlatformPathName((URL)URLFactory.newDirURL((String)System.getProperty("user.home")));
        sb.append(home);
        if (!home.endsWith(File.separator)) {
            sb.append(File.separator);
        }
        sb.append(".cvspass");
        return sb.toString();
    }

    protected char getFieldDelimiter() {
        return ' ';
    }

    private String findPassFilePassword(String root, RandomAccessFile pass) {
        CVSRootString rootstr = new CVSRootString(root);
        try {
            String s;
            do {
                if ((s = pass.readLine()) != null) continue;
                String string = null;
                return string;
            } while (!new CVSRootString(this.parseEntryRoot(s)).equals(rootstr));
            int n = root.length() + 1;
            String string = s.length() <= n ? "" : s.substring(n);
            return string;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return null;
        }
    }

    private String parseEntryRoot(String entry) {
        int i = entry.indexOf(this.getFieldDelimiter());
        if (i == 0) {
            return "";
        }
        return i > 0 ? entry.substring(0, i) : entry;
    }
}

