/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.client;

import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.jdeveloper.vcs.util.VCSOperatingSystem;

public class CVSClientUtils {
    private CVSClientUtils() {
    }

    public static final File createLocalRepositoryFile(String repository) {
        repository = CVSClientUtils.canonicalizeRepository(repository);
        File f = new File(repository);
        if (!VCSOperatingSystem.isWindows() || f.isAbsolute()) {
            return f.exists() ? f : null;
        }
        File[] rootArray = File.listRoots();
        int i = 0;
        while (i < rootArray.length) {
            String rootPath = rootArray[i].getAbsolutePath();
            if (!rootPath.toUpperCase().startsWith("A:") && (f = new File(rootArray[i], repository)).exists()) {
                return f;
            }
            ++i;
        }
        return null;
    }

    private static final String canonicalizeRepository(String repository) {
        Pattern pattern;
        Matcher matcher;
        repository = repository.replace('\\', '/');
        if (VCSOperatingSystem.isWindows() && (matcher = (pattern = Pattern.compile("/?(\\w)(/{2,})(.*)")).matcher(repository)).matches()) {
            repository = matcher.group(1) + ":" + File.separator + matcher.group(3);
        }
        repository = repository.replace('/', File.separatorChar);
        return repository;
    }
}

