/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.client;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Assert;
import oracle.jdevimpl.vcs.cvs.client.CVSEntry;
import oracle.jdevimpl.vcs.cvs.util.CVSFileConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CVSEntriesFile {
    public static final String ENTRIES_RELATIVE_PATH = "CVS" + CVSFileConstants.separatorChar + "Entries";
    public static final String ENTRIES_DOT_OLD_RELATIVE_PATH = "CVS" + CVSFileConstants.separatorChar + "Entries.Old";
    public static final String ENTRIES_DOT_ARCHIVE_RELATIVE_PATH = "CVS" + CVSFileConstants.separatorChar + "Entries.Archive";
    private final URL _entriesUrl;

    public CVSEntriesFile(URL dir) {
        this(dir, ENTRIES_RELATIVE_PATH);
    }

    public CVSEntriesFile(URL dir, String relativePath) {
        this._entriesUrl = URLFactory.newURL((URL)dir, (String)relativePath);
    }

    public Collection<CVSEntry> getEntries() throws IOException {
        if (Boolean.getBoolean("jdev.cvs.debugcachedfiles")) {
            Assert.println((String)("CVS: reading file " + this._entriesUrl));
        }
        if (!URLFileSystem.exists((URL)this._entriesUrl)) {
            return Collections.emptySet();
        }
        BufferedReader in = new BufferedReader(new FileReader(URLFileSystem.getPlatformPathName((URL)this._entriesUrl)));
        ArrayList<CVSEntry> entries = new ArrayList<CVSEntry>();
        try {
            String line;
            while ((line = in.readLine()) != null) {
                CVSEntry entry = CVSEntry.parseEntrySpec(line);
                if (entry == null) continue;
                entries.add(entry);
            }
            ArrayList<CVSEntry> arrayList = entries;
            return arrayList;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            in.close();
        }
    }

    public void writeEntries(Collection<CVSEntry> entries) throws IOException {
        BufferedWriter bw = new BufferedWriter(new FileWriter(URLFileSystem.getPlatformPathName((URL)this._entriesUrl)));
        try {
            Iterator<CVSEntry> itr = entries.iterator();
            while (itr.hasNext()) {
                bw.write(itr.next().toString());
                bw.newLine();
            }
        }
        finally {
            bw.close();
        }
    }

    public static final CVSEntry findEntry(Collection entries, URL file) {
        if (entries == null) {
            return null;
        }
        for (CVSEntry entry : entries) {
            String name = entry.getName();
            if (!URLFileSystem.getFileName((URL)file).equals(name)) continue;
            return entry;
        }
        return null;
    }
}

