/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.client;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CVSEntry {
    private static final Pattern ENTRY_RE = Pattern.compile("/([^/]*)/(0|-)?([^/]*)/([^/+]*)((\\+)?([^/]*))/([^/]*)/(T|D)?((.*))");
    private final String _entrySpec;
    private final boolean _isDirectory;
    private final Map _fields;
    private static final Integer NAME = new Integer(0);
    private static final Integer SFLAG = new Integer(1);
    private static final Integer REVISION = new Integer(2);
    private static final Integer TIMESTAMP = new Integer(3);
    private static final Integer CFLAG = new Integer(4);
    private static final Integer CONFLICT = new Integer(5);
    private static final Integer OPTIONS = new Integer(6);
    private static final Integer TFLAG = new Integer(7);
    private static final Integer TAGDATE = new Integer(8);

    public CVSEntry(boolean isDirectory, String name, String sflag, String revision, String timestamp, String cflag, String conflict, String options, String tflag, String tagdate) {
        this(null, isDirectory, name, sflag, revision, timestamp, cflag, conflict, options, tflag, tagdate);
    }

    public CVSEntry(String entrySpec, boolean isDirectory, String name, String sflag, String revision, String timestamp, String cflag, String conflict, String options, String tflag, String tagdate) {
        this._entrySpec = entrySpec;
        this._isDirectory = isDirectory;
        this._fields = new HashMap();
        if (name != null && !name.equals("")) {
            this._fields.put(NAME, name);
        }
        if (sflag != null && !sflag.equals("")) {
            this._fields.put(SFLAG, sflag);
        }
        if (revision != null && !revision.equals("")) {
            this._fields.put(REVISION, revision);
        }
        if (timestamp != null && !timestamp.equals("")) {
            this._fields.put(TIMESTAMP, timestamp);
        }
        if (cflag != null && !cflag.equals("")) {
            this._fields.put(CFLAG, cflag);
        }
        if (conflict != null && !conflict.equals("")) {
            this._fields.put(CONFLICT, conflict);
        }
        if (options != null && !options.equals("")) {
            this._fields.put(OPTIONS, options);
        }
        if (tflag != null && !tflag.equals("")) {
            this._fields.put(TFLAG, tflag);
        }
        if (tagdate != null && !tagdate.equals("")) {
            this._fields.put(TAGDATE, tagdate);
        }
    }

    public boolean isDirectory() {
        return this._isDirectory;
    }

    public final String getName() {
        return (String)this._fields.get(NAME);
    }

    public final String getStateFlag() {
        return (String)this._fields.get(SFLAG);
    }

    public final String getRevision() {
        return (String)this._fields.get(REVISION);
    }

    public final String getTimestamp() {
        return (String)this._fields.get(TIMESTAMP);
    }

    public final String getConflictFlag() {
        return (String)this._fields.get(CFLAG);
    }

    public final String getConflict() {
        return (String)this._fields.get(CONFLICT);
    }

    public final String getOptions() {
        return (String)this._fields.get(OPTIONS);
    }

    public final String getTagFlag() {
        return (String)this._fields.get(TFLAG);
    }

    public final String getTagOrDate() {
        return (String)this._fields.get(TAGDATE);
    }

    public final boolean isAdded() {
        return this.getStateFlag() != null && this.getStateFlag().equals("0");
    }

    public final boolean isRemoved() {
        return this.getStateFlag() != null && this.getStateFlag().equals("-");
    }

    public final boolean hasConflicts() {
        return this.getConflictFlag() != null;
    }

    public final boolean hasStickyTag() {
        return this.getTagFlag() != null && this.getTagFlag().equals("T");
    }

    public final boolean hasStickyDate() {
        return this.getTagFlag() != null && this.getTagFlag().equals("D");
    }

    public final String toString() {
        if (this._entrySpec != null) {
            return this._entrySpec;
        }
        StringBuffer sb = new StringBuffer();
        if (this._isDirectory) {
            sb.append('D');
        }
        sb.append('/');
        sb.append(this.getName());
        sb.append('/');
        if (this.getStateFlag() != null) {
            sb.append(this.getStateFlag());
        }
        if (this.getRevision() != null) {
            sb.append(this.getRevision());
        }
        sb.append('/');
        if (this.getTimestamp() != null) {
            sb.append(this.getTimestamp());
        }
        if (this.getConflictFlag() != null) {
            sb.append(this.getConflictFlag());
            if (this.getConflict() != null) {
                sb.append(this.getConflict());
            }
        }
        sb.append('/');
        if (this.getOptions() != null) {
            sb.append(this.getOptions());
        }
        sb.append('/');
        if (this.getTagFlag() != null) {
            sb.append(this.getTagFlag());
        }
        if (this.getTagOrDate() != null) {
            sb.append(this.getTagOrDate());
        }
        return sb.toString();
    }

    public static final CVSEntry parseEntrySpec(String entrySpec) {
        Matcher matcher;
        boolean isDirectory = false;
        String entrySpec0 = entrySpec;
        if (entrySpec.startsWith("D")) {
            isDirectory = true;
            entrySpec0 = entrySpec.substring(1);
        }
        if (!(matcher = ENTRY_RE.matcher(entrySpec0)).find()) {
            return null;
        }
        return new CVSEntry(entrySpec, isDirectory, matcher.group(1), matcher.group(2), matcher.group(3), matcher.group(4), matcher.group(6), matcher.group(7), matcher.group(8), matcher.group(9), matcher.group(10));
    }
}

