/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.client;

import java.text.ParseException;
import java.util.Map;
import oracle.jdevimpl.vcs.cvs.client.CVSRootString;
import oracle.ocvs.OCVSPServerRoot;
import oracle.ocvs.OCVSRoot;

public class CVSRootConversion {
    private CVSRootConversion() {
    }

    public static final OCVSRoot convertExtensionToClientRootPServer(CVSRootString rootString) throws ParseException {
        Map fieldMap = rootString.getRootSpecifier().getMethodSpecifier().getFieldMap();
        String proxy = CVSRootConversion.getRootPServerProxy(fieldMap);
        String proxyPort = null;
        if (proxy != null) {
            proxyPort = Integer.toString(CVSRootConversion.getRootPServerProxyPort(fieldMap));
        }
        return OCVSRoot.parseRootSpec((String)new OCVSPServerRoot(null, rootString.getUserName(), rootString.getServerLocation(), rootString.getPort(), rootString.getRepository(), proxy, proxyPort).toString());
    }

    public static final OCVSRoot convertExtensionToClientRootLocal(CVSRootString rootString) throws ParseException {
        return OCVSRoot.parseRootSpec((String)new OCVSRoot(null, "fork", null, null, rootString.getRepository()).toString());
    }

    private static final String getRootPServerProxy(Map fieldMap) {
        if (fieldMap == null) {
            return null;
        }
        return (String)fieldMap.get("proxy");
    }

    private static final int getRootPServerProxyPort(Map fieldMap) {
        if (fieldMap == null) {
            return -1;
        }
        String proxyPort = null;
        try {
            if (proxyPort == null) {
                proxyPort = (String)fieldMap.get("proxyport");
            }
            if (proxyPort == null) {
                proxyPort = (String)fieldMap.get("proxy_port");
            }
            if (proxyPort != null) {
                int n = Integer.parseInt(proxyPort);
                return n;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return 3128;
    }
}

