/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.client;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.jdevimpl.vcs.cvs.client.CVSMethodSpecifier;

public class CVSRootSpecifier {
    private static final String RE_METHOD = "[^:]+";
    private static final String RE_USER = "[^:@]+";
    private static final String RE_PASSWORD = "[^@]+";
    public static final String RE_HOSTNAME = "[^:/]+";
    public static final String RE_PORT = "([\\d]+)(:)?";
    public static final String RE_REPOSITORY = "([^:]:/|/|[^:]:\\\\).*";
    private final String _rootSpec;
    private CVSMethodSpecifier _method;
    private String _user;
    private transient String _password;
    private String _hostname;
    private String _port;
    private boolean _hasPortColon;
    private String _pathToRepository;

    private CVSRootSpecifier(String rootSpec, CVSMethodSpecifier method, String user, String password, String hostname, String port, boolean hasPortColon, String pathToRepository) {
        this._rootSpec = rootSpec;
        this._method = method;
        this._user = user;
        this._password = password;
        this._hostname = hostname;
        this._port = port;
        this._hasPortColon = hasPortColon;
        this._pathToRepository = pathToRepository;
    }

    public CVSMethodSpecifier getMethodSpecifier() {
        return this._method;
    }

    public String getMethod() {
        return this._method != null ? this._method.getMethod() : null;
    }

    public String getUser() {
        return this._user;
    }

    public String getPassword() {
        return this._password;
    }

    public String getHost() {
        return this._hostname;
    }

    public String getPort() {
        return this._port;
    }

    public boolean hasPortColon() {
        return this._hasPortColon;
    }

    public String getRepository() {
        return this._pathToRepository;
    }

    public boolean equals(Object other) {
        return other instanceof CVSRootSpecifier && ((CVSRootSpecifier)other)._rootSpec.equals(this._rootSpec);
    }

    public String toString() {
        return this._rootSpec;
    }

    public static final CVSRootSpecifier parseRootSpec(String rootSpec) {
        Pattern pattern = Pattern.compile(":([^:#;/]+)((?:[#;][^:/]+=(?:'[^']*'|[^:/]*))*)((?::|/??).*)");
        Matcher matcher = pattern.matcher(rootSpec);
        CVSMethodSpecifier methodSpec = null;
        String rootRemainder = null;
        if (matcher.matches()) {
            String methodSpecString = matcher.group(1);
            if (matcher.group(2) != null) {
                methodSpecString = methodSpecString + matcher.group(2);
            }
            methodSpec = CVSMethodSpecifier.parseMethodSpec(methodSpecString);
            rootRemainder = matcher.group(3);
        } else {
            StringBuffer regexpBuffer = new StringBuffer();
            regexpBuffer.append(":(");
            regexpBuffer.append(RE_METHOD);
            regexpBuffer.append(")(:.*)");
            pattern = Pattern.compile(regexpBuffer.toString());
            matcher = pattern.matcher(rootSpec);
            if (matcher.matches()) {
                methodSpec = CVSMethodSpecifier.parseMethodSpec(matcher.group(1));
                rootRemainder = matcher.group(2);
            }
        }
        if (methodSpec == null || rootRemainder == null) {
            return new CVSRootSpecifier(rootSpec, null, null, null, null, null, false, null);
        }
        if (methodSpec.getMethod().equals("local") || methodSpec.getMethod().equals("fork")) {
            StringBuffer regexpBuffer = new StringBuffer();
            regexpBuffer.append(":(");
            regexpBuffer.append(RE_REPOSITORY);
            regexpBuffer.append(")");
            pattern = Pattern.compile(regexpBuffer.toString());
            matcher = pattern.matcher(rootRemainder);
            if (!matcher.matches()) {
                return new CVSRootSpecifier(rootSpec, null, null, null, null, null, false, null);
            }
            return new CVSRootSpecifier(rootSpec, methodSpec, null, null, null, null, false, matcher.group(1));
        }
        StringBuffer regexpBuffer = new StringBuffer();
        regexpBuffer.append(":((");
        regexpBuffer.append(RE_USER);
        regexpBuffer.append(")?(:(");
        regexpBuffer.append(RE_PASSWORD);
        regexpBuffer.append("))?@)?(");
        regexpBuffer.append(RE_HOSTNAME);
        regexpBuffer.append(")?(:(");
        regexpBuffer.append(RE_PORT);
        regexpBuffer.append(")?)?(");
        regexpBuffer.append(RE_REPOSITORY);
        regexpBuffer.append(")");
        pattern = Pattern.compile(regexpBuffer.toString());
        matcher = pattern.matcher(rootRemainder);
        if (!matcher.matches()) {
            return new CVSRootSpecifier(rootSpec, null, null, null, null, null, false, null);
        }
        return new CVSRootSpecifier(rootSpec, methodSpec, matcher.group(2), matcher.group(4), matcher.group(5), matcher.group(8), matcher.group(9) != null, matcher.group(10));
    }

    public static final CVSRootSpecifier createRootSpec(String method, String user, String password, String hostname, String port, String pathToRepository) {
        return CVSRootSpecifier.createRootSpec(method, user, password, hostname, port, false, pathToRepository);
    }

    public static final CVSRootSpecifier createRootSpec(String method, String user, String password, String hostname, String port, boolean usePortColon, String pathToRepository) {
        return CVSRootSpecifier.createRootSpec(CVSMethodSpecifier.createMethodSpec(method, null, null), user, password, hostname, port, usePortColon, pathToRepository);
    }

    public static final CVSRootSpecifier createRootSpec(CVSMethodSpecifier method, String user, String password, String hostname, String port, boolean usePortColon, String pathToRepository) {
        boolean hasPort;
        if (method == null) {
            return new CVSRootSpecifier("", null, null, null, null, null, false, null);
        }
        StringBuffer sb = new StringBuffer();
        sb.append(':');
        sb.append(method.toString());
        sb.append(':');
        boolean hasUser = user != null;
        boolean hasPassword = password != null;
        boolean bl = hasPort = port != null;
        if (hasUser) {
            sb.append(user);
        }
        if (hasPassword) {
            sb.append(':');
            sb.append(password);
        }
        if (hasUser || hasPassword) {
            sb.append('@');
        }
        if (hostname != null) {
            sb.append(hostname);
        }
        if (hasPort || sb.charAt(sb.length() - 1) != ':') {
            sb.append(':');
        }
        if (hasPort) {
            sb.append(port);
            if (usePortColon) {
                sb.append(':');
            }
        }
        if (pathToRepository != null) {
            sb.append(pathToRepository);
        }
        String rootSpec = sb.toString();
        return new CVSRootSpecifier(rootSpec, method, user, password, hostname, port, usePortColon, pathToRepository);
    }
}

